/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.visuals.swing.JobPropertiesPanel;
import com.sas.scheduler.visuals.swing.JobSelectionPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;

public class AddJobPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private ActionListener m_jobPropertiesListener = null;
    private JobSelectionPanel m_pnljobSelection;
    private JButton m_btnProperties;
    private Frame m_frame;
    private FlowInfo m_flow;
    private ArrayList m_addedJobs;

    public AddJobPanel(Frame frame, FlowInfo flow, List jobList) {
        this.m_frame = frame;
        this.m_flow = flow;
        this.__initialize(jobList, true);
    }

    public AddJobPanel(Frame frame, FlowInfo flow, List jobList, boolean allowViewProperties) {
        this.m_frame = frame;
        this.m_flow = flow;
        this.__initialize(jobList, allowViewProperties);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        this.m_pnljobSelection = null;
        this.m_btnProperties = null;
        this.m_flow = null;
        this.m_frame = null;
    }

    private void __initialize(List jobList, boolean allowViewProperties) {
        this.m_pnljobSelection = new JobSelectionPanel(this.m_frame, jobList);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnljobSelection, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (allowViewProperties) {
            String propertiesString = m_bundle.getString("AddJobPanel.JobProperties.txt");
            this.m_btnProperties = new JButton(Util.getLabelWithoutMnemonic((String)propertiesString));
            this.m_btnProperties.setMnemonic(Util.getDisplayedMnemonic((String)propertiesString));
            this.m_btnProperties.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)propertiesString));
            this.m_btnProperties.setToolTipText(m_bundle.getString("AddJobPanel.JobProperties.ToolTip.txt"));
            this.m_btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddJobPanel.this.btnPropertiesOnclicked();
                }
            });
            this.add((Component)this.m_btnProperties, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        }
    }

    public List getAddedJobs() {
        return this.m_addedJobs;
    }

    @Override
    public boolean moveDataToView() {
        this.setListeningForChanges(true);
        return this.m_pnljobSelection.moveDataToView();
    }

    @Override
    public boolean moveViewToData() {
        this.m_addedJobs = new ArrayList<DisplayInfo>(this.m_pnljobSelection.getSelectedJobList());
        if (this.m_addedJobs.size() == 0) {
            return false;
        }
        List existingJobs = this.m_flow.getJobs();
        return existingJobs.addAll(this.m_addedJobs);
    }

    @Override
    public boolean validateData() {
        return this.m_pnljobSelection.validateData();
    }

    public void setPropertiesListener(ActionListener actL) {
        this.m_jobPropertiesListener = actL;
    }

    private void btnPropertiesOnclicked() {
        DisplayInfo info = this.m_pnljobSelection.getSelectedJob();
        String title = MessageFormat.format(m_bundle.getString("AddJobPanel.JobProperties.Title.fmt"), info.getName());
        if (this.m_jobPropertiesListener != null) {
            try {
                this.m_jobPropertiesListener.actionPerformed(new ActionEvent(info, 1001, null));
            }
            catch (RuntimeException rte) {
                String message = rte.getLocalizedMessage();
                if (message == null || message.length() == 0) {
                    message = rte.toString();
                }
                MessageUtil.displayMessage(this.m_frame, message, title, 1, -1);
            }
        } else if (info instanceof JobInfo) {
            JobInfo jinfo = (JobInfo)info;
            JobPropertiesPanel panel = new JobPropertiesPanel(jinfo);
            StandardDialog dlg = new StandardDialog(this.m_frame, title, true);
            dlg.setMainPanel(panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_job_properties");
            dlg.makeVisible();
        } else {
            String message = m_bundle.getString("AddJobPanel.JobProperties.NotAvailable.txt");
            MessageUtil.displayMessage(this.m_frame, message, title, 1, -1);
        }
    }

    static {
        String strClassName = AddJobPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

