/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.attachments.client;

import com.sas.svcs.dav.client.ContentDTO;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;

public class Attachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private String uuid;
    private String name;
    private String description;
    private String type;
    private String docType;
    private String objectId;
    private long objectType;
    private String url;
    private ContentDTO content;
    private String creator;
    private Date createdOn;

    @Deprecated
    public Attachment() {
        this.content = new ContentDTO();
    }

    @Deprecated
    public Attachment(String name, long objectId, long objectType, String url) {
        this(name, String.valueOf(objectId), objectType, url);
    }

    public Attachment(String name, String objectId, long objectType, String url) {
        this.setName(name);
        this.setObjectId(objectId);
        this.setObjectType(objectType);
        this.content = new ContentDTO();
        this.setUrl(url);
    }

    public ContentDTO getContentItem() {
        return this.content;
    }

    public void setContentItem(ContentDTO item) {
        this.content = item;
    }

    public void setContents(Object o) {
        if (o instanceof byte[]) {
            this.content.setContents((byte[])o);
        } else if (o instanceof InputStream) {
            this.content.setContentsAsInputStream((InputStream)o);
        } else if (o instanceof String) {
            this.content.setContentsAsString((String)o);
        } else if (o instanceof Serializable) {
            this.content.setContentsAsSerializable((Serializable)o);
        } else {
            throw new IllegalArgumentException("setContents was called with an invalid type; use  byte[], InputStream, String, or Serializable; was " + o + ".");
        }
    }

    public void setContentsType(String type) {
        this.content.setType(type);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
        this.content.setDocType(docType);
    }

    @Deprecated
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        if (null == name || "".equals(name)) {
            throw new IllegalArgumentException("Attachment name must not be non-blank");
        }
        this.name = name.trim();
    }

    public String getObjectId() {
        return this.objectId;
    }

    @Deprecated
    public final void setObjectId(long objectId) {
        this.objectId = String.valueOf(objectId);
    }

    public final void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public long getObjectType() {
        return this.objectType;
    }

    public final void setObjectType(long objectType) {
        this.objectType = objectType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public final void setUrl(String url) {
        if (null == url || "".equals(url.trim())) {
            throw new IllegalArgumentException("Attachment requires a non-blank attachment url");
        }
        this.url = url.trim();
        int lastSlashIndex = url.lastIndexOf(47);
        String file = url;
        if (lastSlashIndex >= 0) {
            String path = url.substring(0, lastSlashIndex);
            file = url.substring(lastSlashIndex + 1);
            this.content.setPath(path);
        }
        this.content.setFileName(file);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String toString() {
        int stringLength = 256;
        StringBuilder sb = new StringBuilder(256).append("Attachment: ").append(" id=").append(this.getId()).append(", uuid=").append(this.getUuid()).append(", name=").append(this.getName()).append(", desc=").append(this.getDescription()).append(", type=").append(this.getType()).append(", docType=").append(this.getDocType()).append(", objectId=").append(this.getObjectId()).append(", objectType=").append(this.getObjectType()).append(", url=").append(this.getUrl()).append(", creator=").append(this.getCreator()).append(", createdOn=").append(this.getCreatedOn());
        return sb.toString();
    }
}

