/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowSource;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFUTFConverter;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JFXMLFileSource
implements JFFlowSource {
    private Document m_document = null;
    private Exception m_exception = null;

    JFXMLFileSource(String string) throws IOException {
        File file = new File(string);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        int n = (int)file.length();
        char[] cArray = new char[n];
        inputStreamReader.read(cArray, 0, n);
        String string2 = JFUTFConverter.fromUnicodeEscape(new String(cArray));
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            documentBuilder.setEntityResolver(new ResolveDTD());
            InputSource inputSource = new InputSource(new StringReader(string2));
            inputSource.setSystemId("com.platform.LSFJobFlow.api");
            this.m_document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            this.m_document = null;
            this.m_exception = sAXException;
            inputStreamReader.close();
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.m_document = null;
            this.m_exception = parserConfigurationException;
            inputStreamReader.close();
            return;
        }
        inputStreamReader.close();
    }

    @Override
    public JFFlow createFlow() throws JFException {
        if (this.m_document == null) {
            throw new JFException(JFResource.getString("DEFN_FILE_DEFN_DOC") + ": " + this.m_exception.getMessage());
        }
        Element element = this.m_document.getDocumentElement();
        JFXMLSource jFXMLSource = new JFXMLSource(element);
        return jFXMLSource.createFlow();
    }

    class ResolveDTD
    implements EntityResolver {
        ResolveDTD() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            if (string2.endsWith("JobFlowDef30.dtd")) {
                InputStream inputStream = this.getClass().getResourceAsStream("JobFlowDef30.dtd");
                return new InputSource(inputStream);
            }
            return null;
        }
    }
}

