/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDateTimeParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JFTime {
    public static final String UTC_TIME_ZONE = "GMT";
    private Date m_time;
    private String m_serverTimeZone;
    private String m_serverTime;

    public JFTime(String string) {
        this.init(string);
    }

    public JFTime(Date date) {
        this.m_time = date;
        this.m_serverTimeZone = TimeZone.getDefault().getID();
    }

    public JFTime(Node node) {
        if (!(node instanceof Element)) {
            return;
        }
        Element element = (Element)node;
        if (!"time".equals(element.getTagName())) {
            return;
        }
        this.init(element.getFirstChild().getNodeValue());
    }

    public String getTimeString() {
        if (this.m_time == null) {
            return "";
        }
        int n = JFConfigManager.getTimeZoneFlag();
        TimeZone timeZone = null;
        timeZone = n == 0 ? TimeZone.getTimeZone(JFTime.getClientTimeZone()) : (n == 2 ? TimeZone.getTimeZone(UTC_TIME_ZONE) : TimeZone.getTimeZone(this.m_serverTimeZone));
        return JFDateTimeParser.format(this.m_time, timeZone);
    }

    public String getTimeStringOnServer() {
        if (this.m_serverTime == null) {
            this.m_serverTime = JFDateTimeParser.format(this.m_time, TimeZone.getTimeZone(this.m_serverTimeZone));
        }
        return this.m_serverTime;
    }

    public Date getTime() {
        return this.m_time;
    }

    public static String getClientTimeZone() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'GMT'Z", new Locale("en"));
        Date date = new Date();
        String string = simpleDateFormat.format(date);
        if (string.length() == 8) {
            string = string.substring(0, 6) + ":" + string.substring(6);
        }
        return string;
    }

    private void init(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(64);
        if (n <= 0) {
            return;
        }
        String string2 = string.substring(0, n);
        try {
            long l = Long.parseLong(string2);
            this.m_time = new Date(l * 1000L);
            this.m_serverTimeZone = string.substring(n + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

