/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFInvalidTemplateException;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTemplateDef;
import com.platform.LSFJobFlow.api.JFTemplateManager;
import com.platform.LSFJobFlow.api.JFTemplateParameter;
import com.platform.LSFJobFlow.api.JFTemplateParameterDef;
import com.platform.LSFJobFlow.api.JFTemplateParameterDefList;
import com.platform.LSFJobFlow.api.JFTemplateParameterList;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JFTemplateData
implements Cloneable {
    private String m_name;
    private String m_version;
    private int m_execType;
    private String m_execTypeStr;
    private String m_execAction;
    private JFTemplateParameterList m_execParams;
    private JFTemplateParameterList m_subParams;
    private JFTemplateDef m_def;

    JFTemplateData(Element element) throws JFInvalidTemplateException {
        if (element == null) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_DATA_INVALID") + ": " + JFResource.getString("TEMPLAET_EMPTY_DEFINITION"));
        }
        if (!element.getTagName().equals("TemplateData")) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_DATA_INVALID") + ": " + JFResource.getString("TEMPLAET_NOT_TEMPLATEDATA"));
        }
        if (!element.hasAttribute("TemplateName")) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_DATA_INVALID") + ": " + JFResource.getString("TEMPLAET_TEMPLATENAME_NULL"));
        }
        this.m_name = element.getAttribute("TemplateName");
        this.m_version = element.getAttribute("Version");
        NodeList nodeList = element.getChildNodes();
        Node node = null;
        String string = null;
        Element element2 = null;
        for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            string = node.getNodeName();
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            if (string.equals("Execution")) {
                this.m_execTypeStr = element2.getAttribute("Type");
                if (this.m_execTypeStr == null || this.m_execTypeStr.length() <= 0) {
                    throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_DATA_INVALID") + ": " + JFResource.getString("TEMPLAET_TYPE_NOT_DEFINED"));
                }
                this.m_execType = this.m_execTypeStr.equals("lsf") ? 0 : (this.m_execTypeStr.equals("script") ? 3 : (this.m_execTypeStr.equals("oracle") ? 1 : (this.m_execTypeStr.equals("zos") ? 2 : 4)));
                this.m_execAction = element2.getAttribute("Action");
                this.m_execParams = new JFTemplateParameterList(element2.getElementsByTagName("Param"));
                continue;
            }
            if (!string.equals("Submission")) continue;
            this.m_subParams = new JFTemplateParameterList(element2.getElementsByTagName("Param"));
        }
    }

    public JFTemplateData() {
        this.m_execParams = new JFTemplateParameterList();
        this.m_subParams = new JFTemplateParameterList();
    }

    public JFTemplateData(JFTemplateDef jFTemplateDef) {
        if (jFTemplateDef == null) {
            throw new NullPointerException("Parameter <templateDf> is null");
        }
        this.m_name = jFTemplateDef.getName();
        this.m_version = jFTemplateDef.getVersion();
        this.m_execAction = jFTemplateDef.getExecutionAction();
        this.m_execType = jFTemplateDef.getExecutionType();
        this.m_execTypeStr = jFTemplateDef.getExecutionTypeString();
        this.m_execParams = new JFTemplateParameterList();
        this.m_subParams = new JFTemplateParameterList();
        this.setupParameters(this.m_execParams, jFTemplateDef.getExecutionParams());
        this.setupParameters(this.m_subParams, jFTemplateDef.getSubmissionParams());
    }

    private void setupParameters(JFTemplateParameterList jFTemplateParameterList, JFTemplateParameterDefList jFTemplateParameterDefList) {
        JFTemplateParameterDef[] jFTemplateParameterDefArray = jFTemplateParameterDefList.getParameters();
        if (jFTemplateParameterDefArray == null || jFTemplateParameterDefArray.length <= 0) {
            return;
        }
        JFTemplateParameter jFTemplateParameter = null;
        for (int i = 0; i < jFTemplateParameterDefArray.length; ++i) {
            if (jFTemplateParameterDefArray[i] == null || jFTemplateParameterDefArray[i].getDefaultValue() == null) continue;
            String[] stringArray = new String[]{jFTemplateParameterDefArray[i].getDefaultValue()};
            jFTemplateParameter = new JFTemplateParameter(jFTemplateParameterDefArray[i].getName(), jFTemplateParameterDefArray[i].getCaption(), stringArray);
            jFTemplateParameter.setDef(jFTemplateParameterDefArray[i]);
            jFTemplateParameterList.addParameter(jFTemplateParameter);
        }
    }

    JFTemplateData(String string, String string2) throws JFInvalidTemplateException {
        this.m_name = string;
        if (this.m_name == null) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_DATA_INVALID") + ": " + JFResource.getString("TEMPLAET_TEMPLATENAME_NULL"));
        }
        this.m_version = string2;
        if (this.m_version == null) {
            this.m_version = "";
        }
        this.m_execParams = new JFTemplateParameterList();
        this.m_subParams = new JFTemplateParameterList();
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public String getTemplateName() {
        return this.m_name;
    }

    public void setTemplateName(String string) {
        this.m_name = string;
    }

    public int getExecutionType() {
        return this.m_execType;
    }

    public void setExecutionType(int n) {
        this.m_execType = n;
    }

    public String getExecutionTypeString() {
        return this.m_execTypeStr;
    }

    public void setExecutionTypeString(String string) {
        this.m_execTypeStr = string;
    }

    public String getExecutionAction() {
        return this.m_execAction;
    }

    public void setExecutionAction(String string) {
        this.m_execAction = string;
    }

    public JFTemplateParameterList getExecutionParameters() {
        return this.m_execParams;
    }

    public JFTemplateParameterList getSubmissionParameters() {
        return this.m_subParams;
    }

    public void setExecutionParameters(JFTemplateParameterList jFTemplateParameterList) {
        this.m_execParams = jFTemplateParameterList;
        if (this.m_def != null) {
            this.m_execParams.setDefList(this.m_def.getExecutionParams());
        }
    }

    public void setSubmissionParameters(JFTemplateParameterList jFTemplateParameterList) {
        this.m_subParams = jFTemplateParameterList;
        if (this.m_def != null) {
            this.m_subParams.setDefList(this.m_def.getSubmissionParams());
        }
    }

    public JFTemplateDef getTemplateDefinition() {
        if (this.m_def == null) {
            this.m_def = JFTemplateManager.getInstance().getTemplate(this.m_name);
            if (this.m_def != null) {
                this.m_execParams.setDefList(this.m_def.getExecutionParams());
                this.m_subParams.setDefList(this.m_def.getSubmissionParams());
            }
        }
        return this.m_def;
    }

    public void setTemplateDefinition(JFTemplateDef jFTemplateDef) {
        if (jFTemplateDef != null) {
            this.setupParameters(this.m_execParams, jFTemplateDef.getExecutionParams());
            this.setupParameters(this.m_subParams, jFTemplateDef.getSubmissionParams());
        }
    }

    public boolean hasAllRequiredSubmissionParams() {
        if (this.m_def == null || this.m_subParams == null) {
            return false;
        }
        JFTemplateParameterDefList jFTemplateParameterDefList = this.m_def.getSubmissionParams();
        Set set = jFTemplateParameterDefList.getRequiredParameterNames();
        Set set2 = this.m_subParams.getParameterNames();
        return set != null && set2 != null && set2.containsAll(set);
    }

    private String toXML(JFTemplateParameterList jFTemplateParameterList) {
        StringBuffer stringBuffer = new StringBuffer();
        JFTemplateParameter[] jFTemplateParameterArray = jFTemplateParameterList.getParameters();
        if (jFTemplateParameterArray == null || jFTemplateParameterArray.length <= 0) {
            return "";
        }
        String string = null;
        for (int i = 0; i < jFTemplateParameterArray.length; ++i) {
            String[] stringArray = jFTemplateParameterArray[i].getUserInput();
            stringBuffer.append("        <Param Name=\"").append(jFTemplateParameterArray[i].getName()).append("\"");
            string = jFTemplateParameterArray[i].getCaption();
            if (string != null && string.length() > 0) {
                stringBuffer.append("  Caption=\"").append(string).append("\"");
            }
            if (stringArray.length == 1) {
                stringBuffer.append(" Input=\"").append(JFXMLSource.convertToXMLAttrString(stringArray[0])).append("\"/>\n");
                continue;
            }
            stringBuffer.append(">\n");
            for (int j = 0; j < stringArray.length; ++j) {
                stringBuffer.append("            <Repeat Input=\"").append(JFXMLSource.convertToXMLAttrString(stringArray[j])).append("\"/>\n");
            }
            stringBuffer.append("        </Param>\n");
        }
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TemplateData TemplateName=\"").append(this.m_name).append("\" Version=\"").append(this.m_version).append("\">\n");
        stringBuffer.append("    <Execution Type=\"").append(this.m_execTypeStr).append("\" Action=\"").append(this.m_execAction).append("\">\n");
        stringBuffer.append(this.toXML(this.m_execParams));
        stringBuffer.append("    </Execution>\n");
        stringBuffer.append("    <Submission>\n");
        stringBuffer.append(this.toXML(this.m_subParams));
        stringBuffer.append("    </Submission>\n");
        stringBuffer.append("</TemplateData>");
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            JFTemplateData jFTemplateData = (JFTemplateData)super.clone();
            jFTemplateData.m_execParams = (JFTemplateParameterList)this.m_execParams.clone();
            jFTemplateData.m_subParams = (JFTemplateParameterList)this.m_subParams.clone();
            return jFTemplateData;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

