/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEncryptionINF;
import com.platform.LSFJobFlow.api.JFEncryptor;
import com.platform.LSFJobFlow.api.JFException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class JFSecurityUtils {
    private static JFEncryptionINF m_encryption = null;
    private static String m_KRBFilePath = null;
    private static final byte[] key = new byte[]{112, 8, 8, 113, 16, 8, -110, 18, 32, -105, 6, 32, -103, 3, 35, -1};

    private JFSecurityUtils() {
    }

    private static String getKRBFileCachePath() {
        int n;
        Runtime runtime = Runtime.getRuntime();
        String string = "";
        char[] cArray = new char[256];
        try {
            Process process = runtime.exec("klist");
            process.waitFor();
            n = process.exitValue();
            if (n != 0) {
                JFDebug.println("KRB DEBUG: klist exits with error code " + n);
                return "";
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            bufferedReader.read(cArray, 0, 256);
            bufferedReader.close();
            string = String.valueOf(cArray, 0, 256);
        }
        catch (IOException iOException) {
            return "";
        }
        catch (Exception exception) {
            JFDebug.println("KRB DEBUG: Could not get klist, msg:" + exception.toString());
            return "";
        }
        if (string == null || string.length() < 1) {
            JFDebug.println("KRB DEBUG: No ticket cache found in klist output.");
            return "";
        }
        int n2 = -1;
        n = "Ticket cache:".length();
        n2 = string.indexOf("Ticket cache:");
        if (n2 < 0) {
            n2 = string.indexOf("Credentials cache:");
            n = "Credentials cache:".length();
        }
        if (n2 < 0) {
            JFDebug.println("KRB DEBUG: Cannot locate the Kerberos FILE credential cache.");
            return "";
        }
        int n3 = string.indexOf(":", n);
        if (n3 < 0) {
            JFDebug.println("KRB DEBUG: Cannot locate the Kerberos FILE credential cache.");
            return "";
        }
        String string2 = string.substring(n3 + 1, string.indexOf(10)).trim();
        if (string2.isEmpty()) {
            JFDebug.println("KRB DEBUG: Cannot locate the Kerberos FILE credential cache.");
            return "";
        }
        JFDebug.println("KRB DEBUG: ticket cache:" + string2);
        return string2;
    }

    public static synchronized String getKRBCache() {
        if (JFConfigManager.isExternalLogin()) {
            return null;
        }
        if (m_KRBFilePath == null || m_KRBFilePath == "") {
            return null;
        }
        if (m_encryption == null) {
            return null;
        }
        try {
            File file = new File(m_KRBFilePath);
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file.length() <= 0L) {
                return null;
            }
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray, 0, byArray.length);
            String string = Arrays.toString(byArray).substring(1).replace("]", "").replace(" ", "");
            return m_encryption.marshallChannel(string.getBytes());
        }
        catch (JFException jFException) {
            JFDebug.println("KRB DEBUG: Failed to encrypt user TGT");
            return null;
        }
        catch (Exception exception) {
            JFDebug.println("KRB DEBUG: Exception occurred trying to obtain KRB info: " + exception.toString());
            return null;
        }
    }

    static {
        String string = System.getProperty("os.name");
        if (!JFConfigManager.isExternalLogin() && string != null && !string.startsWith("Windows")) {
            m_KRBFilePath = JFSecurityUtils.getKRBFileCachePath();
            try {
                m_encryption = JFEncryptor.getEncryptor(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

