/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFMethodInvoker;
import com.platform.LSFJobFlow.api.JFPseudoManualJobInstance;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFServiceProxy;
import com.platform.LSFJobFlow.api.JFVarsInfo;
import com.platform.LSFJobFlow.api.JFVersion;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JFJobManager {
    private static final int JOB_SUCCESS = 0;
    private static final int JOB_PERMISSION_DENIED = 100;
    private static final int JOB_SYSERR = 102;
    private static final int JOB_FAIL = 103;
    private static final int JOB_FLOW_NOT_ACTIVE = 104;
    private static final int JOB_FLOW_STILL_ACTIVE = 105;
    private static final int JOB_FLOW_RUNNING_JOB = 109;
    private static final int JOB_KILL_LOCAL_WINDOWS = 111;
    private static final int JOB_NOT_FOUND = 2025;
    private static final int SETJOBCOMPLETE_JOBDONE = 2026;
    private static final int JOB_NOT_EXIT = 2016;
    private static final int JOB_NOT_EXEC = 2028;
    private static final int FLOW_STILL_ACTIVE = 2014;
    private static final int FLOW_RERUN_DELAY = 106;
    private static final int JOB_ON_HOLD = 107;
    private static final int JOB_ON_HOLD2 = 2031;
    private static final int JOB_FLOW_NOT_FOUND = 108;
    private static final int EXCLUSIVE_FLOW_RUNNING = 110;
    private static final int JOB_ALREADY_RUNNING = 2033;
    private static final int JOB_NOT_WAITING = 2100;
    private static final int JOBS_NOT_WAITING = 2101;
    private static final int JOB_NOT_HOLD = 2102;
    private static final int JOBS_NOT_HOLD = 2103;
    private static final int HOLD_INVALID_JOB_TYPE = 2104;
    private static final int JOB_FLOW_BEING_CLEANEDUP = 2063;
    private static final int JOB_NOT_FINISHED = 2064;
    private JFServiceProxy m_jobServiceInvoker = new JFServiceProxy("JFJobService");
    private JFServiceProxy m_instanceManagerInvoker = new JFServiceProxy("JFInstanceManager");
    private JFServiceProxy manualInvoker = new JFServiceProxy("JFManual");
    static final int MANUAL_ERR_NO_ERROR = 0;
    static final int MANUAL_ERR_INSTANCE_NOT_FOUND = 1;
    static final int MANUAL_ERR_JOB_NOT_FOUND = 2;
    static final int MANUAL_ERR_EXCEPTION = 3;
    static final int MANUAL_ERR_PERMISSION_DENIED = 4;
    static final int MANUAL_ERR_INSTANCE_SUSPENDED = 5;
    static final int MANUAL_ERR_JOB_NOT_RUNNING = 6;
    static final int MANUAL_ERR_INVALID_USERNAME = 7;
    static final int MANUAL_ERR_INVALID_EXITCODE = 8;

    public void completeManualJob(String string, String string2) throws JFException, IOException {
        this.completeManualJob(string, string2, 0);
    }

    public void completeManualJob(String string, String string2, int n) throws JFException, IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        long l = 0L;
        String string3 = null;
        try {
            l = Long.parseLong(stringTokenizer.nextToken());
            string3 = stringTokenizer.nextToken("").substring(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException(JFResource.getString("MANUAL_ACK_MANUAL_JOB") + JFResource.getString("MANUAL_ERR_INVALID_ID"));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("MANUAL_ACK_MANUAL_JOB") + JFResource.getString("MANUAL_ERR_INVALID_JOBNAME"));
        }
        if (string3 == null) {
            throw new JFException(JFResource.getString("MANUAL_ACK_MANUAL_JOB") + JFResource.getString("MANUAL_ERR_INVALID_JOBNAME"));
        }
        if (n < 0 || n > 255) {
            throw new JFException(JFResource.getString("MANUAL_ACK_MANUAL_JOB") + JFResource.getString("MANUAL_ERR_INVALID_EXITCODE"));
        }
        if (n != 0) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Exit_Code_Manual_Job"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.manualInvoker, "JF_AckManualJob");
        jFMethodInvoker.inParams.addParam("flowid", l);
        jFMethodInvoker.inParams.addParam("name", string3);
        jFMethodInvoker.inParams.addParam("description", string2);
        jFMethodInvoker.inParams.addParam("exitcode", n);
        jFMethodInvoker.invoke();
        int n2 = jFMethodInvoker.outParams.getParamInt("return");
        if (n2 != 0) {
            throw new JFException(JFResource.getString("MANUAL_ACK_MANUAL_JOB") + this.manualErrorToString(n2));
        }
    }

    public JFPseudoManualJobInstance[] getPseudoManualJobs(JFFilter jFFilter) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.manualInvoker, "JF_GetManualJobs");
        if (jFFilter != null) {
            String string = null;
            if (jFFilter.getUser() != null) {
                string = jFFilter.getUser();
            }
            if (string != null) {
                jFMethodInvoker.inParams.addParam("userName", string);
            }
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("MANUAL_GET_MANUAL_JOBS") + this.manualErrorToString(n));
        }
        return jFMethodInvoker.outParams.getParamManualJobs("manualJobs");
    }

    public JFPseudoManualJobInstance[] getPseudoManualJobs() throws JFException, IOException {
        return this.getPseudoManualJobs(null);
    }

    public void runJob(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_RunJobInstance");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
        }
    }

    public void runJobArray(String string, boolean bl) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Job_array_control"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_RunJobArrayInstance");
        jFMethodInvoker.inParams.addParam("Name", string);
        jFMethodInvoker.inParams.addParam("RunExitedElements", bl);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
        }
    }

    public void killJob(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_KillJobInstance");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
        }
    }

    public void killJobArray(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_KillJobArrayInstance");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
        }
    }

    public void killFlowArray(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_KillFlowArrayInstance");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
        }
    }

    public void killSubflow(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_KillSubflowInstance");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
        }
    }

    public void setJobComplete(String string) throws JFException, IOException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        long l = 0L;
        String string2 = null;
        try {
            l = Long.parseLong(stringTokenizer.nextToken());
            object = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken("").substring(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException(JFResource.getString("JOB_INVALID_ID"));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("JOB_INVALID_NAME"));
        }
        if (string2 == null) {
            throw new JFException(JFResource.getString("JOB_INVALID_NAME"));
        }
        object = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_SetJobComplete");
        ((JFMethodInvoker)object).inParams.addParam("jobname", string2);
        ((JFMethodInvoker)object).inParams.addParam("flowid", l);
        ((JFMethodInvoker)object).invoke();
        int n = ((JFMethodInvoker)object).outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
        }
    }

    private void generateError(int n) throws JFException {
        switch (n) {
            case 0: {
                return;
            }
            case 100: {
                throw new JFException(JFResource.getString("JOB_CNTRL_PERMISSION"));
            }
            case 102: {
                throw new JFException(JFResource.getString("JOB_CNTRL_ERROR"));
            }
            case 111: {
                throw new JFException(JFResource.getString("JOB_LOCAL_WINDOW_KILL"));
            }
            case 104: {
                throw new JFException(JFResource.getString("JOB_FLOW_NOT_ACTIVE"));
            }
            case 110: {
                throw new JFException(JFResource.getString("JOB_CNTRL_EXCLUSIVE_FLOW_RUNNING"));
            }
            case 105: {
                throw new JFException(JFResource.getString("JOB_FLOW_STILL_ACTIVE"));
            }
            case 2063: {
                throw new JFException(JFResource.getString("JOB_FLOW_BEING_CLEANEDUP"));
            }
            case 109: {
                throw new JFException(JFResource.getString("JOB_FLOW_RUNNING_JOB"));
            }
            case 108: {
                throw new JFException(JFResource.getString("JFERROR_FLOW_NOTFOUND"));
            }
            case 103: {
                throw new JFException(JFResource.getString("JOB_CNTRL_FAIL"));
            }
            case 2025: {
                throw new JFException(JFResource.getString("JOB_NOT_FOUND"));
            }
            case 2026: {
                throw new JFException(JFResource.getString("SETJOBCOMPLETE_JOBDONE"));
            }
            case 2016: {
                throw new JFException(JFResource.getString("JOB_NOT_EXIT"));
            }
            case 2028: {
                throw new JFException(JFResource.getString("JOB_NOT_EXEC"));
            }
            case 2014: {
                throw new JFException(JFResource.getString("JOB_FLOW_STILL_ACTIVE"));
            }
            case 106: {
                throw new JFException(JFResource.getString("JOB_FLOW_RERUN_DELAY"));
            }
            case 107: {
                throw new JFException(JFResource.getString("JOB_ON_HOLD"));
            }
            case 2064: {
                throw new JFException(JFResource.getString("JOB_NOT_FINISHED"));
            }
            case 2031: {
                throw new JFException(JFResource.getString("JOB_ON_HOLD"));
            }
            case 2033: {
                throw new JFException(JFResource.getString("JOB_ALREADY_RUNNING"));
            }
            case 2100: {
                throw new JFException(JFResource.getString("JOB_NOT_WAITING"));
            }
            case 2101: {
                throw new JFException(JFResource.getString("JOBS_NOT_WAITING"));
            }
            case 2102: {
                throw new JFException(JFResource.getString("JOB_NOT_HOLD"));
            }
            case 2103: {
                throw new JFException(JFResource.getString("JOBS_NOT_HOLD"));
            }
            case 2104: {
                throw new JFException(JFResource.getString("HOLD_INVALID_JOB_TYPE"));
            }
        }
        throw new JFException(JFResource.getString("JOB_CNTRL_ERROR"));
    }

    private void generateError(int n, String string) throws JFException {
        if (string != null && string.length() != 0) {
            switch (n) {
                case 2101: 
                case 2103: {
                    throw new JFException(string);
                }
            }
            throw new JFException(JFResource.getString("JOB_CNTRL_ERROR"));
        }
        this.generateError(n);
    }

    private String manualErrorToString(int n) {
        switch (n) {
            case 0: {
                return JFResource.getString("MANUAL_ERR_NO_ERROR");
            }
            case 1: {
                return JFResource.getString("MANUAL_ERR_INSTANCE_NOT_FOUND");
            }
            case 2: {
                return JFResource.getString("MANUAL_ERR_JOB_NOT_FOUND");
            }
            case 3: {
                return JFResource.getString("MANUAL_ERR_EXCEPTION");
            }
            case 4: {
                return JFResource.getString("MANUAL_ERR_PERMISSION_DENIED");
            }
            case 5: {
                return JFResource.getString("MANUAL_ERR_INSTANCE_SUSPENDED");
            }
            case 6: {
                return JFResource.getString("MANUAL_ERR_JOB_NOT_RUNNING");
            }
            case 7: {
                return JFResource.getString("MANUAL_ERR_INVALID_USERNAME");
            }
            case 8: {
                return JFResource.getString("MANUAL_ERR_INVALID_EXITCODE");
            }
        }
        return "";
    }

    public JFVarsInfo getJobVarsInfo(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Display_Var_Info"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_GetJobVarsInfo");
        jFMethodInvoker.inParams.addParam("name", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            return null;
        }
        return jFMethodInvoker.outParams.getParamVarsInfo("varsInfo");
    }

    public JFVarsInfo getJobArrayVarsInfo(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Display_Var_Info"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_GetJobArrayVarsInfo");
        jFMethodInvoker.inParams.addParam("name", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
        }
        return jFMethodInvoker.outParams.getParamVarsInfo("varsInfo");
    }

    public void holdJob(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.2"), JFResource.getString("Hold_Job"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_HoldJob");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            String string2 = null;
            try {
                string2 = jFMethodInvoker.outParams.getParamString("errormessages");
            }
            catch (Exception exception) {
                string2 = null;
            }
            this.generateError(n, string2);
        }
    }

    public void setJobStartPoint(long l, String string, String string2) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Set_Unset_Starting_Point"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_instanceManagerInvoker, "JF_SetJobAsRerunStartingPoint");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("jobname", string);
        jFMethodInvoker.inParams.addParam("inallelements", false);
        if (string2 == null || string2.isEmpty()) {
            jFMethodInvoker.inParams.addParam("FAElementsListString", "");
        } else {
            jFMethodInvoker.inParams.addParam("FAElementsListString", string2);
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            String string3 = null;
            try {
                string3 = jFMethodInvoker.outParams.getParamString("errormessages");
            }
            catch (Exception exception) {
                string3 = null;
            }
            this.generateError(n, string3);
        }
    }

    public void setJobArrayStartPoint(long l, String string, String string2) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Set_Unset_Starting_Point"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_instanceManagerInvoker, "JF_SetJobArrayAsRerunStartingPoint");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("jobname", string);
        jFMethodInvoker.inParams.addParam("inallelements", true);
        jFMethodInvoker.inParams.addParam("runExitedElements", false);
        jFMethodInvoker.inParams.addParam("elementsListString", "");
        if (string2 == null || string2.isEmpty()) {
            jFMethodInvoker.inParams.addParam("FAElementsListString", "");
        } else {
            jFMethodInvoker.inParams.addParam("FAElementsListString", string2);
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            String string3 = null;
            try {
                string3 = jFMethodInvoker.outParams.getParamString("errormessages");
            }
            catch (Exception exception) {
                string3 = null;
            }
            this.generateError(n, string3);
        }
    }

    public void releaseJob(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.2"), JFResource.getString("Release_Job"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_ReleaseJob");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            String string2 = null;
            try {
                string2 = jFMethodInvoker.outParams.getParamString("errormessages");
            }
            catch (Exception exception) {
                string2 = null;
            }
            this.generateError(n, string2);
        }
    }

    public void holdJobArray(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.2"), JFResource.getString("Hold_Job"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_HoldJobArray");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            String string2 = null;
            try {
                string2 = jFMethodInvoker.outParams.getParamString("errormessages");
            }
            catch (Exception exception) {
                string2 = null;
            }
            this.generateError(n, string2);
        }
    }

    public void releaseJobArray(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOB_UNAME_NULL"));
        }
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.2"), JFResource.getString("Release_Job"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_jobServiceInvoker, "JF_ReleaseJobArray");
        jFMethodInvoker.inParams.addParam("JobName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            String string2 = null;
            try {
                string2 = jFMethodInvoker.outParams.getParamString("errormessages");
            }
            catch (Exception exception) {
                string2 = null;
            }
            this.generateError(n, string2);
        }
    }
}

