/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFResource;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JFJobEvent
extends JFEvent {
    public static final String EVENT_GENERATOR_TYPE_LSF = "lsf";
    public static final String EVENT_GENERATOR_TYPE_MANUAL = "manual";
    public static final String EVENT_GENERATOR_TYPE_LOCAL = "local";
    public static final String EVENT_GENERATOR_TYPE_OTHER_BATCH = "otherbatch";
    public static final int JOB_DONE = 0;
    public static final int JOB_END = 1;
    public static final int JOB_START = 2;
    public static final int JOB_EXIT = 3;
    public static final int JOB_SUBMITTED = 4;
    public static final int JOB_FAIL = 5;
    public static final String OP_LT = "<";
    public static final String OP_LTE = "<=";
    public static final String OP_EQ = "==";
    public static final String OP_GT = ">";
    public static final String OP_GTE = ">=";
    public static final String OP_NE = "!=";
    private int m_eventType = -1;
    private String m_eventParent = "";
    private String m_generatorType = "lsf";
    String m_jobName = "";
    JFJob m_jobRef = null;
    String m_comparisonOp = null;
    int[] m_comparisonValue = null;

    public JFJobEvent(String string, int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                throw new IllegalArgumentException(JFResource.getString("JOBEVENT_INIT_TYPE"));
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("JOBEVENT_INVALID_TYPE"));
            }
        }
        this.m_jobName = string;
        this.m_eventType = n;
        this.setProxy(true);
    }

    public JFJobEvent(String string, String string2, int n) {
        this(string, string2, new int[]{n});
    }

    public JFJobEvent(String string, String string2, int[] nArray) {
        if (string == null || string2 == null || nArray == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        this.m_jobName = string;
        this.m_eventType = 3;
        this.validateComparison(3, string2, nArray);
        this.m_comparisonOp = string2;
        this.m_comparisonValue = nArray;
        this.setProxy(true);
    }

    public JFJobEvent(JFJob jFJob, int n) {
        if (jFJob == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                throw new IllegalArgumentException(JFResource.getString("JOBEVENT_INIT_TYPE"));
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("JOBEVENT_INVALID_TYPE"));
            }
        }
        this.m_eventType = n;
        this.m_jobRef = jFJob;
        this.m_generatorType = this.m_jobRef.getExecutionType();
        if ("oracle".equals(this.m_generatorType) || "zos".equals(this.m_generatorType) || "script".equals(this.m_generatorType) || "submissionForm".equals(this.m_generatorType)) {
            this.m_generatorType = EVENT_GENERATOR_TYPE_LSF;
        }
        this.setProxy(false);
    }

    public JFJobEvent(JFJob jFJob, String string, int n) {
        this(jFJob, string, new int[]{n});
    }

    public JFJobEvent(JFJob jFJob, String string, int[] nArray) {
        if (jFJob == null || string == null || nArray == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        this.m_eventType = 3;
        this.validateComparison(3, string, nArray);
        this.m_jobRef = jFJob;
        this.m_generatorType = this.m_jobRef.getExecutionType();
        if ("oracle".equals(this.m_generatorType) || "zos".equals(this.m_generatorType) || "script".equals(this.m_generatorType) || "submissionForm".equals(this.m_generatorType)) {
            this.m_generatorType = EVENT_GENERATOR_TYPE_LSF;
        }
        this.m_comparisonOp = string;
        this.m_comparisonValue = nArray;
        this.setProxy(false);
    }

    @Override
    public boolean isProxy() {
        String string = this.getAttribute("IsProxy");
        return string != null && string.equals("Yes");
    }

    private void setProxy(boolean bl) {
        if (bl) {
            this.setAttribute("IsProxy", "Yes");
        } else {
            this.setAttribute("IsProxy", "No");
        }
    }

    public int getEventType() {
        return this.m_eventType;
    }

    public void setEventType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("JOBEVENT_INVALID_TYPE"));
            }
        }
        this.m_eventType = n;
    }

    public JFJob getEventJob() {
        if (this.m_jobRef == null) {
            String string = this.getJobName();
            String string2 = string.indexOf(":") != -1 ? string.substring(string.lastIndexOf(":") + 1, string.length()) : string;
            return new JFJob(string2, this.getEventGeneratorType());
        }
        return this.m_jobRef;
    }

    public void setEventJob(JFJob jFJob) {
        if (jFJob == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        this.m_jobRef = jFJob;
    }

    public String getComparisonOp() {
        if (this.m_eventType != 3) {
            throw new IllegalStateException(JFResource.getString("JOBEVENT_EXIT_REQD"));
        }
        return this.m_comparisonOp;
    }

    public void setComparisonOp(String string) {
        this.validateComparisonOp(string);
        if (this.m_comparisonValue != null) {
            try {
                this.validateComparison(this.m_eventType, string, this.m_comparisonValue);
            }
            catch (IllegalStateException illegalStateException) {
                throw new IllegalStateException(JFResource.getString("JOBEVENT_INVALID_COMPARISON"));
            }
        }
        this.m_comparisonOp = string;
    }

    public int getComparisonValue() {
        try {
            this.validateComparison(this.m_eventType, this.m_comparisonOp, this.m_comparisonValue);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException(JFResource.getString("JOBEVENT_INVALID_COMPARISON"));
        }
        return this.getComparisonValues()[0];
    }

    public int[] getComparisonValues() {
        if (this.m_eventType != 3) {
            throw new IllegalStateException(JFResource.getString("JOBEVENT_EXIT_REQD"));
        }
        return this.m_comparisonValue;
    }

    public void setComparisonValue(int n) {
        this.setComparisonValues(new int[]{n});
    }

    public void setComparisonValues(int[] nArray) {
        this.validateComparisonValue(nArray);
        if (this.m_comparisonOp != null) {
            try {
                this.validateComparison(this.m_eventType, this.m_comparisonOp, nArray);
            }
            catch (IllegalStateException illegalStateException) {
                throw new IllegalStateException(JFResource.getString("JOBEVENT_INVALID_COMPARISON"));
            }
        }
        this.m_comparisonValue = nArray;
    }

    public JFJobEvent() {
        this.setProxy(false);
    }

    @Override
    public String getEventGeneratorType() {
        return this.m_generatorType;
    }

    public void setEventGeneratorType(String string) {
        this.m_generatorType = this.m_jobRef != null ? this.m_jobRef.getExecutionType() : string;
        if ("oracle".equals(this.m_generatorType) || "zos".equals(this.m_generatorType) || "script".equals(this.m_generatorType) || "submissionForm".equals(this.m_generatorType)) {
            this.m_generatorType = EVENT_GENERATOR_TYPE_LSF;
        }
    }

    @Override
    public void initFromDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
        }
        try {
            int n = string.indexOf(40);
            int n2 = string.lastIndexOf(41);
            String string2 = string.substring(0, n);
            if (string2.equalsIgnoreCase("Done")) {
                this.m_eventType = 0;
            } else if (string2.equalsIgnoreCase("End")) {
                this.m_eventType = 1;
            } else if (string2.equalsIgnoreCase("Start")) {
                this.m_eventType = 2;
            } else if (string2.equalsIgnoreCase("Exit")) {
                this.m_eventType = 3;
            } else if (string2.equalsIgnoreCase("New")) {
                this.m_eventType = 4;
            } else if (string2.equalsIgnoreCase("Fail")) {
                this.m_eventType = 5;
            }
            String string3 = string.substring(n + 1, n2);
            switch (this.m_eventType) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    this.m_jobName = string3;
                    break;
                }
                case 3: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    this.m_jobName = stringTokenizer.nextToken().trim();
                    String string4 = stringTokenizer.nextToken().trim();
                    this.validateComparisonOp(string4);
                    int[] nArray = JFCommon.stringToIntegerArray(stringTokenizer.nextToken().trim());
                    this.validateComparison(3, string4, nArray);
                    this.m_comparisonOp = string4;
                    this.m_comparisonValue = nArray;
                    break;
                }
                default: {
                    throw new JFException(JFResource.getString("JOBEVENT_DEFN_TYPE", new Object[]{string2}));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException(JFResource.getString("JOBEVENT_DEFN_NAN"));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JFException(illegalArgumentException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new JFException(illegalStateException.getMessage());
        }
    }

    public void initFromCLIDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
        }
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n == -1 || n2 == -1 || n2 - n < 1) {
            throw new JFException(JFResource.getString("JOBEVENT_UNBALANCED_PAR"));
        }
        String string2 = string.substring(0, n).trim();
        if (string2.equalsIgnoreCase("Done")) {
            this.m_eventType = 0;
        } else if (string2.equalsIgnoreCase("End")) {
            this.m_eventType = 1;
        } else if (string2.equalsIgnoreCase("Start")) {
            this.m_eventType = 2;
        } else if (string2.equalsIgnoreCase("Exit")) {
            this.m_eventType = 3;
        } else if (string2.equalsIgnoreCase("Submitted")) {
            this.m_eventType = 4;
        } else if (string2.equalsIgnoreCase("Fail")) {
            this.m_eventType = 5;
        } else {
            throw new JFException(JFResource.getString("JOBEVENT_INVALID_TYPE"));
        }
        this.m_jobName = string.substring(n + 1, n2).trim();
        if (this.m_jobName.length() == 0) {
            throw new JFException(JFResource.getString("JOBEVENT_DEFN_NO_NAME"));
        }
        String string3 = string.substring(n2 + 1).trim();
        switch (this.m_eventType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (string3.length() <= 0) break;
                throw new JFException(JFResource.getString("JOBEVENT_EXIT_REQD"));
            }
            case 3: {
                int n3 = this.findFirstNotOf(string3, "!<>=");
                if (n3 == -1) {
                    throw new JFException(JFResource.getString("JOBEVENT_DEFN_NO_VALUE"));
                }
                try {
                    String string4 = string3.substring(0, n3).trim();
                    this.validateComparisonOp(string4);
                    int[] nArray = JFCommon.stringToIntegerArray(string3.substring(n3).trim());
                    this.validateComparison(3, string4, nArray);
                    this.m_comparisonOp = string4;
                    this.m_comparisonValue = nArray;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JFException(JFResource.getString("JOBEVENT_DEFN_NAN"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JFException(illegalArgumentException.getMessage());
                }
                catch (IllegalStateException illegalStateException) {
                    throw new JFException(illegalStateException.getMessage());
                }
            }
            default: {
                throw new JFException(JFResource.getString("JOBEVENT_INVALID_TYPE"));
            }
        }
        this.setProxy(true);
    }

    private int findFirstNotOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string2.indexOf(string.charAt(i)) != -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String generateDefinition() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.eventType());
        stringBuffer.append("(");
        stringBuffer.append(this.getFullWorkItemName());
        if (this.m_eventType == 3) {
            stringBuffer.append("," + this.m_comparisonOp + "," + JFCommon.integerArrayToString(this.m_comparisonValue));
        }
        stringBuffer.append(")");
        this.m_eventParent = "";
        return stringBuffer.toString();
    }

    @Override
    String getFullWorkItemName() {
        String string = "";
        if (!this.isProxy()) {
            string = string + this.m_eventParent;
        }
        string = string + this.getJobName();
        return string;
    }

    private String eventType() {
        switch (this.m_eventType) {
            case 0: {
                return "Done";
            }
            case 1: {
                return "End";
            }
            case 2: {
                return "Start";
            }
            case 3: {
                return "Exit";
            }
            case 4: {
                return "New";
            }
            case 5: {
                return "Fail";
            }
        }
        return "";
    }

    private String eventTypeDesc() {
        switch (this.m_eventType) {
            case 0: {
                return "Completes successfully";
            }
            case 1: {
                return "Ends with any exit code";
            }
            case 2: {
                return "Starts";
            }
            case 4: {
                return "New";
            }
            case 3: {
                return "Ends with exit code ";
            }
            case 5: {
                return "Fail";
            }
        }
        return "";
    }

    private String opDesc() {
        if (this.m_comparisonOp.equals(OP_LT)) {
            return "less than ";
        }
        if (this.m_comparisonOp.equals(OP_LTE)) {
            return "less than or equal to ";
        }
        if (this.m_comparisonOp.equals(OP_EQ)) {
            return "equal to ";
        }
        if (this.m_comparisonOp.equals(OP_GT)) {
            return "greater than ";
        }
        if (this.m_comparisonOp.equals(OP_GTE)) {
            return "greater than or equal to ";
        }
        if (this.m_comparisonOp.equals(OP_NE)) {
            return "not equal to ";
        }
        return "";
    }

    public String getJobName() {
        if (this.isProxy()) {
            return this.m_jobName;
        }
        if (this.m_jobRef != null) {
            return this.m_jobRef.getName();
        }
        return this.m_jobName;
    }

    public void setJobName(String string) {
        if (this.isProxy()) {
            this.m_jobName = string;
        } else {
            if (this.m_jobRef != null) {
                this.m_jobRef.setName(string);
            }
            this.m_jobName = string;
        }
    }

    @Override
    void setParentName(String string) {
        if (!string.equals("")) {
            this.m_eventParent = string + ":";
        }
    }

    @Override
    public String toString() {
        return this.getJobName() + " " + this.getExpression();
    }

    @Override
    public String getExpression() {
        String string = "";
        switch (this.m_eventType) {
            case 0: {
                string = "Succeeds";
                break;
            }
            case 1: {
                string = "Ends";
                break;
            }
            case 2: {
                string = "Starts";
                break;
            }
            case 4: {
                string = "Submitted";
                break;
            }
            case 3: {
                string = "Exit code " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp);
                if (this.m_comparisonValue == null) break;
                for (int i = 0; i < this.m_comparisonValue.length; ++i) {
                    string = string + " " + this.m_comparisonValue[i];
                }
                break;
            }
            case 5: {
                string = "Fails";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getTooltip(String string, String string2) {
        String string3 = "";
        switch (this.m_eventType) {
            case 0: {
                string3 = "If " + string + " succeeds then " + string2;
                break;
            }
            case 1: {
                string3 = "If " + string + " ends then " + string2;
                break;
            }
            case 2: {
                string3 = "If " + string + " starts then " + string2;
                break;
            }
            case 4: {
                string3 = "If " + string + " is submitted then " + string2;
                break;
            }
            case 3: {
                string3 = "If " + string + "'s exit code is " + this.opDesc() + JFCommon.integerArrayToString(this.m_comparisonValue) + " then " + string2;
                break;
            }
            case 5: {
                string3 = "If " + string + " fails then " + string2;
                break;
            }
            default: {
                string3 = "";
            }
        }
        return string3;
    }

    @Override
    public String getEventTypeDescription() {
        String string = this.eventTypeDesc();
        String string2 = "";
        String string3 = "";
        switch (this.m_eventType) {
            case 3: {
                string2 = string2 + this.opDesc();
                string3 = string3 + JFCommon.integerArrayToString(this.m_comparisonValue);
                break;
            }
        }
        Object[] objectArray = new Object[]{string, string2, string3};
        String string4 = JFResource.getString("EVENT_TYPE_DESCRIPTION");
        MessageFormat messageFormat = new MessageFormat(string4);
        return messageFormat.format(objectArray);
    }

    @Override
    public void setEventObject(Object object) {
        this.m_jobRef = (JFJob)object;
    }

    private void validateComparison(int n, String string, int[] nArray) {
        if (n != 3) {
            throw new IllegalStateException(JFResource.getString("JOBEVENT_EXIT_REQD"));
        }
        if (string == null || nArray == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        this.validateComparisonOp(string);
        boolean bl = string.equals(OP_EQ) || string.equals(OP_NE);
        try {
            this.validateComparisonValue(nArray);
        }
        catch (Exception exception) {
            if (bl) {
                throw new IllegalArgumentException(JFResource.getString("JOBEVENT_VALID_VALUES"));
            }
            throw new IllegalArgumentException(JFResource.getString("JOBEVENT_VALID_VALUE"));
        }
        if (nArray.length > 1 && !bl) {
            throw new IllegalStateException(JFResource.getString("JOBEVENT_VALID_VALUE"));
        }
    }

    private void validateComparisonOp(String string) {
        if (this.m_eventType != 3) {
            throw new IllegalStateException(JFResource.getString("JOBEVENT_EXIT_REQD"));
        }
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        if (!(string.equals(OP_LT) || string.equals(OP_LTE) || string.equals(OP_EQ) || string.equals(OP_GT) || string.equals(OP_GTE) || string.equals(OP_NE))) {
            throw new IllegalArgumentException(JFResource.getString("JOBEVENT_DEFN_INVALID_OP"));
        }
    }

    private void validateComparisonValue(int[] nArray) {
        if (this.m_eventType != 3) {
            throw new IllegalStateException(JFResource.getString("JOBEVENT_EXIT_REQD"));
        }
        if (nArray == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException(JFResource.getString("JOBEVENT_DEFN_NO_VALUE"));
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 255 && nArray[i] >= 0) continue;
            throw new IllegalArgumentException(JFResource.getString("JOBEVENT_VALID_VALUES"));
        }
    }
}

