/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFUser;
import org.w3c.dom.Node;

public class JFFlowVersion {
    private String m_version;
    private JFUser m_submissionUser;
    private JFTime m_submissionTime;
    private String m_comments;

    public JFFlowVersion() {
        this.m_version = "1.0";
        this.m_comments = "";
    }

    public JFFlowVersion(String string) {
        this.m_version = string;
        this.m_comments = "";
    }

    public String getVersion() {
        return this.m_version;
    }

    public JFUser getSubmissionUser() {
        return this.m_submissionUser;
    }

    public String getComments() {
        return this.m_comments;
    }

    public JFTime getSubmissionTime() {
        return this.m_submissionTime;
    }

    public int compareTo(JFFlowVersion jFFlowVersion) throws JFException {
        try {
            String string = jFFlowVersion.getVersion();
            int n = this.m_version.indexOf(".");
            int n2 = string.indexOf(".");
            int n3 = Integer.parseInt(this.m_version.substring(0, n));
            int n4 = Integer.parseInt(this.m_version.substring(n + 1, this.m_version.length()));
            int n5 = Integer.parseInt(string.substring(0, n2));
            int n6 = Integer.parseInt(string.substring(n2 + 1, string.length()));
            if (n3 > n5) {
                return 1;
            }
            if (n3 == n5 && n4 > n6) {
                return 1;
            }
            if (n3 == n5 && n4 == n6) {
                return 0;
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException("Failed to parse the version number:" + numberFormatException.getMessage());
        }
    }

    public void fromXML(Node node) throws JFException {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeName().equals("version")) {
                this.m_version = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("submissionUser") && node2.getFirstChild() != null) {
                this.m_submissionUser = new JFUser(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("submissionTime")) {
                this.m_submissionTime = new JFTime(node2.getFirstChild());
            }
            if (!node2.getNodeName().equals("comments")) continue;
            this.m_comments = node2.getFirstChild().getNodeValue();
        }
    }

    void setVersion(String string) {
        this.m_version = string;
    }

    void setSubmissionUser(JFUser jFUser) {
        this.m_submissionUser = jFUser;
    }

    void setComments(String string) {
        this.m_comments = string;
    }

    void setSubmissionTime(JFTime jFTime) {
        this.m_submissionTime = jFTime;
    }
}

