/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFUser;
import java.text.MessageFormat;

public class JFFlowEvent
extends JFEvent {
    public static final String EVENT_GENERATOR_TYPE = "flow";
    public static final int FLOW_DONE = 0;
    public static final int FLOW_END = 1;
    public static final int FLOW_EXIT = 2;
    public static final int FLOW_FAIL = 3;
    public static final int FLOW_NUMDONE = 10;
    public static final int FLOW_NUMEXIT = 11;
    public static final int FLOW_NUMEND = 12;
    public static final int FLOW_NUMSTART = 13;
    public static final String OP_LT = "<";
    public static final String OP_LTE = "<=";
    public static final String OP_EQ = "==";
    public static final String OP_GT = ">";
    public static final String OP_GTE = ">=";
    public static final String OP_NE = "!=";
    protected int m_eventType = -1;
    protected String m_eventParent = "";
    protected String m_flowName = "";
    JFFlow m_flowRef = null;
    protected String m_comparisonOp = null;
    protected int m_comparisonValue = 0;

    public JFFlowEvent(String string, int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                throw new IllegalArgumentException(JFResource.getString("FLOWEVENT_INIT_TYPE"));
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("FLOWEVENT_INVALID_TYPE"));
            }
        }
        this.m_flowName = string;
        this.m_eventType = n;
        this.setProxy(true);
    }

    public JFFlowEvent(String string, int n, String string2, int n2) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("FLOWEVENT_INVALID_TYPE"));
            }
        }
        this.m_flowName = string;
        this.m_eventType = n;
        this.m_comparisonOp = string2;
        this.m_comparisonValue = n2;
        this.setProxy(true);
        this.verifyValue();
    }

    protected void verifyValue() {
        switch (this.m_eventType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                if ((this.m_comparisonOp == OP_EQ || this.m_comparisonOp == OP_GTE) && this.m_comparisonValue < 1) {
                    throw new IllegalArgumentException(JFResource.getString("EVENT_DEFN_INVALID_VALUE"));
                }
                if (this.m_comparisonOp != OP_GT || this.m_comparisonValue >= 0) break;
                throw new IllegalArgumentException(JFResource.getString("EVENT_DEFN_INVALID_VALUE"));
            }
            default: {
                return;
            }
        }
    }

    public JFFlowEvent(JFFlow jFFlow, int n) {
        if (jFFlow == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                throw new IllegalArgumentException(JFResource.getString("FLOWEVENT_INIT_TYPE"));
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("FLOWEVENT_INVALID_TYPE"));
            }
        }
        this.m_eventType = n;
        this.m_flowRef = jFFlow;
        this.setProxy(false);
    }

    public JFFlowEvent(JFFlow jFFlow, int n, String string, int n2) {
        if (jFFlow == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("FLOWEVENT_INVALID_TYPE"));
            }
        }
        this.m_comparisonValue = n2;
        this.m_comparisonOp = string;
        this.m_eventType = n;
        this.m_flowRef = jFFlow;
        this.setProxy(false);
        this.verifyValue();
    }

    @Override
    public boolean isProxy() {
        String string = this.getAttribute("IsProxy");
        return string != null && string.equals("Yes");
    }

    protected void setProxy(boolean bl) {
        if (bl) {
            this.setAttribute("IsProxy", "Yes");
        } else {
            this.setAttribute("IsProxy", "No");
        }
    }

    public int getEventType() {
        return this.m_eventType;
    }

    public JFFlow getEventFlow() {
        return this.m_flowRef;
    }

    public String getComparisonOp() {
        switch (this.m_eventType) {
            case 0: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw new IllegalStateException(JFResource.getString("FLOWEVENT_REDUNDANT_OP"));
            }
        }
        return this.m_comparisonOp;
    }

    public int getComparisonValue() {
        switch (this.m_eventType) {
            case 0: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw new IllegalStateException(JFResource.getString("FLOWEVENT_REDUNDANT_OP"));
            }
        }
        return this.m_comparisonValue;
    }

    public JFFlowEvent() {
    }

    @Override
    public String getEventGeneratorType() {
        return EVENT_GENERATOR_TYPE;
    }

    @Override
    public void initFromDefinition(String string) throws JFException {
        String string2;
        String string3;
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
        }
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n == -1 || n2 == -1 || n2 - n <= 1) {
            throw new JFException(JFResource.getString("FLOWEVENT_DEFN_NO_NAME"));
        }
        String string4 = string.substring(0, n).trim();
        if (string4.equalsIgnoreCase("Done")) {
            this.m_eventType = 0;
        } else if (string4.equalsIgnoreCase("End")) {
            this.m_eventType = 1;
        } else if (string4.equalsIgnoreCase("Exit")) {
            this.m_eventType = 2;
        } else if (string4.equalsIgnoreCase("NumDone")) {
            this.m_eventType = 10;
        } else if (string4.equalsIgnoreCase("NumExit")) {
            this.m_eventType = 11;
        } else if (string4.equalsIgnoreCase("NumStart")) {
            this.m_eventType = 13;
        } else if (string4.equalsIgnoreCase("NumEnd")) {
            this.m_eventType = 12;
        } else if (string4.equalsIgnoreCase("Fail")) {
            this.m_eventType = 3;
        } else {
            throw new JFException(JFResource.getString("FLOWEVENT_INVALID_TYPE"));
        }
        this.m_flowName = string.substring(n + 1, n2).trim();
        if (this.m_flowName.length() == 0) {
            throw new JFException(JFResource.getString("FLOWEVENT_DEFN_NO_NAME"));
        }
        int n3 = this.m_flowName.indexOf(":");
        if (n3 > 0) {
            string3 = this.m_flowName.substring(0, n3);
            string2 = this.m_flowName.substring(n3);
            this.m_flowName = new JFUser(string3).toJSUserNamePreservingCase() + string2;
        }
        string3 = string.substring(n2 + 1).trim();
        switch (this.m_eventType) {
            case 1: {
                if (string3.length() <= 0) break;
                throw new JFException(JFResource.getString("FLOWEVENT_REDUNDANT_OP"));
            }
            case 0: 
            case 3: {
                int n4 = this.findFirstNotOf(string3, "!<>=");
                if (n4 == -1) break;
                this.m_comparisonOp = string3.substring(0, n4).trim();
                string2 = string3.substring(n4).trim();
                try {
                    this.m_comparisonValue = Integer.valueOf(string2);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JFException(JFResource.getString("FLOWEVENT_DEFN_NAN"));
                }
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                int n5 = this.findFirstNotOf(string3, "!<>=");
                if (n5 == -1) {
                    throw new JFException(JFResource.getString("FLOWEVENT_DEFN_NO_VALUE"));
                }
                this.m_comparisonOp = string3.substring(0, n5).trim();
                if (this.m_eventType == 2 ? !this.m_comparisonOp.equals(OP_LT) && !this.m_comparisonOp.equals(OP_LTE) && !this.m_comparisonOp.equals(OP_EQ) && !this.m_comparisonOp.equals(OP_GT) && !this.m_comparisonOp.equals(OP_GTE) && !this.m_comparisonOp.equals(OP_NE) : !this.m_comparisonOp.equals(OP_EQ) && !this.m_comparisonOp.equals(OP_GT) && !this.m_comparisonOp.equals(OP_GTE)) {
                    throw new JFException(JFResource.getString("FLOWEVENT_DEFN_INVALID_OP"));
                }
                string2 = string3.substring(n5).trim();
                try {
                    this.m_comparisonValue = Integer.valueOf(string2);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JFException(JFResource.getString("FLOWEVENT_DEFN_NAN"));
                }
            }
            default: {
                throw new JFException(JFResource.getString("FLOWEVENT_INVALID_TYPE"));
            }
        }
        this.verifyValue();
    }

    public void initFromCLIDefinition(String string) throws JFException {
        this.initFromDefinition(string);
        this.setProxy(true);
    }

    private int findFirstNotOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string2.indexOf(string.charAt(i)) != -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String generateDefinition() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.eventType());
        stringBuffer.append("(");
        stringBuffer.append(this.getFullWorkItemName());
        stringBuffer.append(")");
        switch (this.m_eventType) {
            case 0: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                if (this.m_comparisonOp == null) break;
                stringBuffer.append(this.m_comparisonOp + this.m_comparisonValue);
            }
        }
        this.m_eventParent = "";
        return stringBuffer.toString();
    }

    @Override
    String getFullWorkItemName() {
        String string = "";
        if (!this.isProxy()) {
            string = string + this.m_eventParent;
        }
        string = string + this.getFlowName();
        return string;
    }

    public String getAbsoluteFullFlowName() {
        String string = "";
        if (!this.isProxy()) {
            string = string + this.m_eventParent;
        }
        string = string + this.m_flowName;
        return string;
    }

    private String eventType() {
        switch (this.m_eventType) {
            case 0: {
                return "Done";
            }
            case 1: {
                return "End";
            }
            case 2: {
                return "Exit";
            }
            case 10: {
                return "NumDone";
            }
            case 11: {
                return "NumExit";
            }
            case 13: {
                return "NumStart";
            }
            case 12: {
                return "NumEnd";
            }
            case 3: {
                return "Fail";
            }
        }
        return "";
    }

    private String eventTypeDesc() {
        switch (this.m_eventType) {
            case 0: {
                return JFResource.getString("EVENT_DESC_FLOW_DONE");
            }
            case 1: {
                return JFResource.getString("EVENT_DESC_FLOW_END");
            }
            case 2: {
                return JFResource.getString("EVENT_DESC_FLOW_EXIT");
            }
            case 10: {
                return JFResource.getString("EVENT_DESC_FLOW_NUMDONE");
            }
            case 11: {
                return JFResource.getString("EVENT_DESC_FLOW_NUMEXIT");
            }
            case 12: {
                return JFResource.getString("EVENT_DESC_FLOW_NUMEND");
            }
            case 13: {
                return JFResource.getString("EVENT_DESC_FLOW_NUMSTART");
            }
            case 3: {
                return JFResource.getString("EVENT_DESC_FLOW_FAILS");
            }
        }
        return "";
    }

    private String opDesc() {
        if (this.m_comparisonOp != null) {
            if (this.m_comparisonOp.equals(OP_LT)) {
                return JFResource.getString("OP_DESC_LESS_THAN");
            }
            if (this.m_comparisonOp.equals(OP_LTE)) {
                return JFResource.getString("OP_DESC_LESS_THAN_OR_EQUAL_TO");
            }
            if (this.m_comparisonOp.equals(OP_EQ)) {
                return JFResource.getString("OP_DESC_EQUAL_TO");
            }
            if (this.m_comparisonOp.equals(OP_GT)) {
                return JFResource.getString("OP_DESC_GREATER_THAN");
            }
            if (this.m_comparisonOp.equals(OP_GTE)) {
                return JFResource.getString("OP_DESC_GREATER_THAN_OR_EQUAL_TO");
            }
            if (this.m_comparisonOp.equals(OP_NE)) {
                return JFResource.getString("OP_DESC_NOT_EQUAL_TO");
            }
        }
        return "";
    }

    public String getFlowName() {
        if (this.m_flowRef != null) {
            return this.m_flowRef.getName();
        }
        return this.m_flowName;
    }

    @Override
    void setParentName(String string) {
        if (string != null && !string.equals("")) {
            this.m_eventParent = string + ":";
        }
    }

    @Override
    public String toString() {
        return this.getFlowName() + " " + this.getExpression();
    }

    @Override
    public String getEventTypeDescription() {
        String string = this.eventTypeDesc();
        String string2 = "";
        String string3 = "";
        switch (this.m_eventType) {
            case 0: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string2 = string2 + this.opDesc();
                string3 = string3 + this.m_comparisonValue;
                break;
            }
        }
        Object[] objectArray = new Object[]{string, string2, string3};
        String string4 = JFResource.getString("EVENT_TYPE_DESCRIPTION");
        MessageFormat messageFormat = new MessageFormat(string4);
        return messageFormat.format(objectArray);
    }

    @Override
    public String getExpression() {
        String string = "";
        switch (this.m_eventType) {
            case 0: {
                if (this.m_comparisonOp == null) {
                    string = "Succeeds";
                    break;
                }
                string = "Succeeds (exit code " + this.m_comparisonOp + " " + this.m_comparisonValue + ")";
                break;
            }
            case 1: {
                string = "Ends";
                break;
            }
            case 2: {
                string = "Exit code " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 10: {
                string = "Succeeded jobs " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 11: {
                string = "Failed jobs " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 13: {
                string = "Started jobs " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 12: {
                string = "Ended jobs " + (this.m_comparisonOp == null ? "" : this.m_comparisonOp) + " " + this.m_comparisonValue;
                break;
            }
            case 3: {
                if (this.m_comparisonOp == null) {
                    string = "Fails";
                    break;
                }
                string = "Fails (exit code " + this.m_comparisonOp + " " + this.m_comparisonValue + ")";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getTooltip(String string, String string2) {
        String string3 = "";
        switch (this.m_eventType) {
            case 0: {
                if (this.m_comparisonOp == null) {
                    string3 = "If " + string + " succeeds then " + string2;
                    break;
                }
                string3 = "If " + string + " succeeds with exit code " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 1: {
                string3 = "If " + string + " ends then " + string2;
                break;
            }
            case 2: {
                string3 = "If " + string + " has exit code " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 10: {
                string3 = "If jobs succeeded in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 11: {
                string3 = "If jobs failed in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 13: {
                string3 = "If jobs started in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 12: {
                string3 = "If jobs ended in " + string + " is " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            case 3: {
                if (this.m_comparisonOp == null) {
                    string3 = "If " + string + " fails then " + string2;
                    break;
                }
                string3 = "If " + string + " fails with exit code " + this.opDesc() + " " + this.m_comparisonValue + " then " + string2;
                break;
            }
            default: {
                string3 = "";
            }
        }
        return string3;
    }
}

