/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFNoEncoderDecoderException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;

public class JFBase64Encoder {
    private static libType lib = libType.NONE;
    private static Object encoder = null;
    private static Object decoder = null;
    private static Method decode = null;
    private static Method encode = null;

    private static void initLib() {
        GenericDeclaration genericDeclaration;
        Class<?> clazz;
        if (lib == libType.NONE || lib == libType.FAIL) {
            try {
                clazz = Class.forName("sun.misc.BASE64Encoder");
                genericDeclaration = Class.forName("sun.misc.BASE64Decoder");
                encoder = clazz.newInstance();
                decoder = ((Class)genericDeclaration).newInstance();
                decode = decoder.getClass().getMethod("decodeBuffer", String.class);
                encode = encoder.getClass().getMethod("encode", byte[].class);
                lib = libType.SUNMISC;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (lib == libType.NONE || lib == libType.FAIL) {
            try {
                clazz = Class.forName("java.util.Base64");
                genericDeclaration = clazz.getDeclaredMethod("getDecoder", new Class[0]);
                Method method = clazz.getDeclaredMethod("getEncoder", new Class[0]);
                encoder = method.invoke(clazz, new Object[0]);
                decoder = ((Method)genericDeclaration).invoke(clazz, new Object[0]);
                decode = decoder.getClass().getMethod("decode", String.class);
                encode = encoder.getClass().getMethod("encodeToString", byte[].class);
                lib = libType.JAVAUTIL;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (lib == libType.NONE) {
            lib = libType.FAIL;
        }
    }

    public static String encode(byte[] byArray) throws JFNoEncoderDecoderException {
        if (lib == libType.NONE) {
            JFBase64Encoder.initLib();
        }
        switch (lib) {
            case JAVAUTIL: 
            case SUNMISC: {
                try {
                    String string = new String((String)encode.invoke(encoder, new Object[]{byArray}));
                    string = string.replaceAll("(\\r|\\n|\\r\\n)+", "");
                    return string;
                }
                catch (Exception exception) {
                    throw new JFNoEncoderDecoderException("Unable to call BASE64 encode API");
                }
            }
        }
        throw new JFNoEncoderDecoderException();
    }

    public static byte[] decode(String string) throws JFNoEncoderDecoderException {
        if (lib == libType.NONE) {
            JFBase64Encoder.initLib();
        }
        string = string.replaceAll("(\\r|\\n|\\r\\n)+", "");
        switch (lib) {
            case JAVAUTIL: 
            case SUNMISC: {
                try {
                    Object object = decode.invoke(decoder, string);
                    JFDebug.println(object.toString());
                    return (byte[])object;
                }
                catch (Exception exception) {
                    throw new JFNoEncoderDecoderException("Unable to call BASE64 decode API");
                }
            }
        }
        throw new JFNoEncoderDecoderException();
    }

    static enum libType {
        NONE,
        JAVAUTIL,
        SUNMISC,
        FAIL;

    }
}

