/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Iterator;

public abstract class CollectionFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private String prefix = "";
    private String suffix = "\t";

    public CollectionFormat() {
    }

    public CollectionFormat(String delimiter, String prefix, String suffix) {
        this();
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof Collection)) {
            throw new IllegalArgumentException("ArrayFormat only formats arrays...");
        }
        return this.format((Collection)obj, toAppendTo);
    }

    private StringBuffer format(Collection<?> obj, StringBuffer toAppendTo) {
        Iterator<?> it = obj.iterator();
        while (it.hasNext()) {
            toAppendTo.append(this.prefix);
            toAppendTo.append(it.next());
            if (!it.hasNext()) continue;
            toAppendTo.append(this.suffix);
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException("Parse is not supported for ArrayFormat.");
    }
}

