/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.exceptions;

import com.sas.svcs.exceptions.MutatedException;
import com.sas.svcs.exceptions.ThrowableFilter;
import com.sas.svcs.exceptions.ThrowableMutator;
import com.sas.svcs.exceptions.ThrowablePatternFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DefaultThrowableMutator
implements ThrowableMutator {
    ThrowableFilter filter;

    public DefaultThrowableMutator() {
        this.filter = new ThrowablePatternFilter();
    }

    public DefaultThrowableMutator(ThrowableFilter filter) {
        this.setThrowableFilter(filter);
    }

    public final void setThrowableFilter(ThrowableFilter filter) {
        this.filter = filter;
    }

    @Override
    public Throwable mutate(Throwable t) {
        Throwable throwable;
        ObjectOutputStream objOutStream = null;
        try {
            Throwable[] ta = ExceptionUtils.getThrowables((Throwable)t);
            HashMap<Throwable, Throwable> replacements = new HashMap<Throwable, Throwable>();
            for (Throwable t1 : ta) {
                if (!this.filter.accept(t1)) continue;
                String simpleName = t1.getClass().getSimpleName();
                String fullName = t1.getClass().getName();
                String message = t1.getMessage();
                String localizedMessage = t1.getLocalizedMessage();
                String mutatedMessage = localizedMessage;
                if (mutatedMessage == null) {
                    mutatedMessage = message;
                }
                mutatedMessage = "(" + fullName + ")" + (mutatedMessage == null ? "" : " " + mutatedMessage);
                MutatedException t2 = new MutatedException(mutatedMessage, t1.getCause());
                t2.setStackTrace(t1.getStackTrace());
                t2.sourceClassName = fullName;
                t2.sourceSimpleClassName = simpleName;
                t2.sourceMessage = message;
                t2.sourceLocalizedMessage = localizedMessage;
                replacements.put(t1, t2);
            }
            if (replacements.isEmpty()) {
                Throwable throwable2 = t;
                return throwable2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objOutStream = new MutatingObjectOutputStream(byteArrayOutputStream, replacements);
            objOutStream.writeObject(t);
            ByteArrayInputStream inStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objInStream = new ObjectInputStream(inStream);
            throwable = (Throwable)objInStream.readObject();
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable tx) {
            throw new IllegalStateException(tx);
        }
        finally {
            if (objOutStream != null) {
                try {
                    objOutStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return throwable;
    }

    private static class MutatingObjectOutputStream
    extends ObjectOutputStream {
        private final Map<Throwable, Throwable> exchange;

        public MutatingObjectOutputStream(OutputStream out, Map<Throwable, Throwable> exchange) throws IOException {
            super(out);
            this.enableReplaceObject(true);
            this.exchange = exchange;
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            Throwable t = this.exchange.get(obj);
            return t == null ? super.replaceObject(obj) : t;
        }
    }
}

