/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class NestedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private transient Throwable cause;
    private String message;
    private String stackTrace;

    public NestedRuntimeException() {
    }

    public NestedRuntimeException(String message, Throwable cause) {
        this.message = message;
        this.cause = cause;
    }

    public NestedRuntimeException(String message) {
        this.message = message;
    }

    public NestedRuntimeException(Throwable cause) {
        this.cause = cause;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        StringWriter sw = this.newStringWriter();
        PrintWriter pw = this.newPrintWriter(sw);
        this.printStackTrace(pw);
        s.writeObject(sw.toString());
    }

    private StringWriter newStringWriter() {
        return new StringWriter();
    }

    private PrintWriter newPrintWriter(Writer writer) {
        return new PrintWriter(writer);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.stackTrace = (String)s.readObject();
    }

    @Override
    public void printStackTrace() {
        if (null != this.message) {
            System.err.println(this.message);
        }
        if (null != this.stackTrace) {
            System.err.println(this.stackTrace);
        } else if (null != this.cause) {
            this.cause.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            if (null != this.message) {
                s.println(this.message);
            }
            if (null != this.stackTrace) {
                s.println(this.stackTrace);
            } else if (null != this.cause) {
                this.cause.printStackTrace(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            if (null != this.message) {
                s.println(this.message);
            }
            if (null != this.stackTrace) {
                s.println(this.stackTrace);
            } else if (null != this.cause) {
                this.cause.printStackTrace(s);
            }
        }
    }
}

