/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.aop.cache;

import com.sas.svcs.aop.cache.CacheClearMessage;
import com.sas.svcs.aop.cache.TenantAwareKeyGenerator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.util.StringUtils;

public class CacheInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LogManager.getLogger(CacheInterceptor.class);
    private static final String CACHE_DEBUG_FMT = "In cache named '%s', %s for method invocation on target '%s' with arguments: %s";
    private static final int DEFAULT_MAX_CACHE_SIZE = 500;
    private Map<Object, Object> cache;
    private String cacheName;
    protected KeyGenerator keyGenerator = new TenantAwareKeyGenerator();
    private boolean cacheNullValues;
    private int maxCacheSize = 500;
    private boolean enabled = true;

    public void setCacheName(String name) {
        this.cacheName = name;
    }

    public void setCacheNullValues(boolean value) {
        this.cacheNullValues = value;
    }

    public void setMaxCacheSize(int size) {
        if (size > 50) {
            this.maxCacheSize = size;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    Map<Object, Object> getCache() {
        if (null == this.cache) {
            this.cache = Collections.synchronizedMap(new LinkedHashMap<Object, Object>(this.maxCacheSize, 0.75f, true){
                private static final long serialVersionUID = 941L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<Object, Object> eldest) {
                    return this.size() > CacheInterceptor.this.maxCacheSize;
                }
            });
        }
        return this.cache;
    }

    private void logInvocationMessage(String action, String methodName, Object[] arguments) {
        ArrayList<String> argumentsStr = new ArrayList<String>(arguments.length);
        if (null != arguments) {
            for (Object argument : arguments) {
                if (null == argument) continue;
                argumentsStr.add(argument.toString());
            }
        }
        LOGGER.debug(String.format(CACHE_DEBUG_FMT, this.cacheName, action, methodName, StringUtils.collectionToCommaDelimitedString(argumentsStr)));
    }

    @Deprecated
    protected String getCacheKey(String targetName, String methodName, Object[] arguments) {
        return null;
    }

    protected Object getCacheKey(Object target, Method method, Object[] arguments) {
        return this.keyGenerator.generate(target, method, arguments);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.enabled) {
            return invocation.proceed();
        }
        String targetName = invocation.getMethod().toGenericString();
        Object[] arguments = invocation.getArguments();
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            this.logInvocationMessage("looking for method result in cache", targetName, arguments);
        }
        Object cacheKey = this.getCacheKey(null, invocation.getMethod(), arguments);
        if (debug) {
            this.logInvocationMessage("computed cache key '" + cacheKey + "'", targetName, arguments);
        }
        if (!this.validElement(cacheKey)) {
            Object element = invocation.proceed();
            if (null != element || this.cacheNullValues) {
                if (debug) {
                    this.logInvocationMessage("caching result", targetName, arguments);
                }
                this.saveElement(cacheKey, element);
            }
            return element;
        }
        if (debug) {
            this.logInvocationMessage("returning cached value", targetName, arguments);
        }
        return this.retrieveElement(cacheKey);
    }

    public boolean validElement(Object key) {
        return this.getCache().containsKey(key);
    }

    public void saveElement(Object key, Object element) {
        this.getCache().put(key, element);
    }

    public Object retrieveElement(Object key) {
        return this.getCache().get(key);
    }

    public void handleMessage(CacheClearMessage ccm) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saw cache clear message for cache named '" + ccm.getName() + "'");
        }
        if (ccm.getName().equals(this.cacheName)) {
            this.getCache().clear();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cleared cache for cache named '" + ccm.getName() + "'");
            }
        }
    }
}

