/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.aop.cache;

import com.sas.framework.annotation.Cacheable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class AnnotationDrivenCacheInterceptor {
    private static final Logger LOGGER = LogManager.getLogger(AnnotationDrivenCacheInterceptor.class);
    private final ConcurrentHashMap<String, Map<String, CacheEntry>> caches = new ConcurrentHashMap();
    private static final int MAX_CACHE_SIZE_DEFAULT = 500;
    private static final int SET_MAX_CACHE_SIZE = 50;
    private int maxCacheSize = 500;

    @Pointcut(value="@target(com.sas.framework.annotation.Cacheable)")
    public void typePointcut() {
    }

    @Pointcut(value="@annotation(com.sas.framework.annotation.Cacheable)")
    public void methodPointcut() {
    }

    public void setMaxCacheSize(int size) {
        if (size > 50) {
            this.maxCacheSize = size;
        }
    }

    @Around(value="typePointcut() || methodPointcut()")
    public Object invoke(ProceedingJoinPoint jp) throws Throwable {
        Object value;
        String cacheKey;
        Map<String, CacheEntry> cache;
        CacheEntry entry;
        boolean debug = LOGGER.isDebugEnabled();
        Object[] args = jp.getArgs();
        Class<?> clazz = jp.getTarget().getClass();
        String targetName = clazz.getName();
        MethodSignature signature = (MethodSignature)jp.getSignature();
        String methodName = signature.getName();
        if (debug) {
            LOGGER.debug("Checking for cached value: " + targetName + "." + methodName);
        }
        Cacheable c = this.getCacheableAnnotation(clazz, signature);
        String cacheName = c.cacheName();
        long timeout = c.timeout();
        boolean cacheNulls = c.cacheNulls();
        if (debug) {
            LOGGER.debug("Annotation details: name=" + cacheName + ", timeout=" + timeout + ", cacheNulls=" + cacheNulls);
        }
        if (null != (entry = (cache = this.getCache(cacheName)).get(cacheKey = this.getCacheKey(targetName, methodName, args))) && entry.isValid()) {
            if (debug) {
                LOGGER.debug("Returning found, cached value...");
            }
            return entry.value;
        }
        if (debug) {
            LOGGER.debug("No cached value found, executing target method...");
        }
        if (null == (value = jp.proceed()) && !cacheNulls) {
            return null;
        }
        if (debug) {
            LOGGER.debug("Saving value in cache for future calls...");
        }
        entry = new CacheEntry(value, timeout);
        cache.put(cacheKey, entry);
        return entry.value;
    }

    private Cacheable getCacheableAnnotation(Class<? extends Object> clazz, MethodSignature signature) {
        Cacheable c = (Cacheable)AnnotationUtils.findAnnotation((Method)signature.getMethod(), Cacheable.class);
        if (null == c) {
            c = (Cacheable)AnnotationUtils.findAnnotation(clazz, Cacheable.class);
        }
        if (null == c) {
            throw new IllegalStateException("AnnotationDrivenCacheInterceptor invoked on class without Cacheable annotation.");
        }
        return c;
    }

    private String getCacheKey(String targetName, String methodName, Object[] arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append(targetName).append(".").append(methodName);
        if (null != arguments && 0 != arguments.length) {
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(".").append(arguments[i]);
            }
        }
        return sb.toString();
    }

    private synchronized Map<String, CacheEntry> getCache(String name) {
        Map<String, CacheEntry> m = this.caches.get(name);
        if (null == m) {
            m = Collections.synchronizedMap(new LinkedHashMap<String, CacheEntry>(this.maxCacheSize, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
                    return this.size() > AnnotationDrivenCacheInterceptor.this.maxCacheSize;
                }
            });
            this.caches.put(name, m);
        }
        return m;
    }

    static class CacheEntry {
        Object value;
        long expirationTime;

        CacheEntry(Object value, long timeout) {
            this.value = value;
            this.expirationTime = -1L == timeout ? -1L : System.currentTimeMillis() + timeout;
        }

        boolean isValid() {
            return this.expirationTime == -1L || System.currentTimeMillis() < this.expirationTime;
        }
    }
}

