/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.cli.UpdateAllConfigurationGroupsMarker;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.exceptions.UserErrorException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class CommandExecutor {
    public static final String RUN_ON_MEMBER_CHANGE_NOT_PERSISTED = "Configuration change is not persisted because the command is executed on specific member.";
    public static final String SERVICE_NOT_RUNNING_CHANGE_NOT_PERSISTED = "Cluster configuration service is not running. Configuration change is not persisted.";
    private final Logger logger = LogService.getLogger();
    private final DistributedLockService cmsDlockService;

    public CommandExecutor(DistributedLockService cmsDlockService) {
        this.cmsDlockService = cmsDlockService;
    }

    public Object execute(GfshParseResult parseResult) {
        return this.execute(null, parseResult);
    }

    @VisibleForTesting
    public Object execute(Object command, GfshParseResult parseResult) {
        Object object;
        String userInput = parseResult.getUserInput();
        if (userInput != null) {
            this.logger.info("Executing command: " + ArgumentRedactor.redact((String)userInput));
        }
        boolean locked = this.lockCMS(command);
        try {
            Object result = this.invokeCommand(command, parseResult);
            if (result instanceof CommandResult) {
                result = ((CommandResult)result).getResultData();
            } else if (result instanceof Result) {
                Result customResult = (Result)result;
                result = new ResultModel();
                InfoResultModel info = ((ResultModel)result).addInfo();
                while (customResult.hasNextLine()) {
                    info.addLine(customResult.nextLine());
                }
                customResult.resetToFirstLine();
            }
            if (result == null) {
                object = ResultModel.createError("Command returned null: " + parseResult);
                return object;
            }
            object = result;
            return object;
        }
        catch (NotAuthorizedException e) {
            this.logger.error("Not authorized to execute \"" + parseResult + "\".", (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentException | IllegalStateException | UserErrorException e) {
            object = ResultModel.createError(e.getMessage());
            return object;
        }
        catch (EntityNotFoundException e) {
            if (e.isStatusOK()) {
                object = ResultModel.createInfo("Skipping: " + e.getMessage());
                return object;
            }
            object = ResultModel.createError(e.getMessage());
            return object;
        }
        catch (Exception e) {
            this.logger.error("Could not execute \"" + parseResult + "\".", (Throwable)e);
            object = ResultModel.createError("Error while processing command <" + parseResult + "> Reason : " + e.getMessage());
            return object;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw t;
        }
        finally {
            this.unlockCMS(locked);
        }
    }

    protected Object callInvokeMethod(Object command, GfshParseResult parseResult) {
        return ReflectionUtils.invokeMethod((Method)parseResult.getMethod(), (Object)command, (Object[])parseResult.getArguments());
    }

    protected Object invokeCommand(Object command, GfshParseResult parseResult) {
        if (command == null) {
            command = parseResult.getInstance();
        }
        Object result = this.callInvokeMethod(command, parseResult);
        if (!(command instanceof SingleGfshCommand)) {
            return result;
        }
        SingleGfshCommand gfshCommand = (SingleGfshCommand)command;
        ResultModel resultModel = (ResultModel)result;
        if (resultModel.getStatus() == Result.Status.ERROR) {
            return result;
        }
        InfoResultModel infoResultModel = resultModel.addInfo("info");
        InternalConfigurationPersistenceService ccService = (InternalConfigurationPersistenceService)gfshCommand.getConfigurationPersistenceService();
        if (ccService == null) {
            infoResultModel.addLine(SERVICE_NOT_RUNNING_CHANGE_NOT_PERSISTED);
            return resultModel;
        }
        if (parseResult.getParamValue("member") != null) {
            infoResultModel.addLine(RUN_ON_MEMBER_CHANGE_NOT_PERSISTED);
            return resultModel;
        }
        String groupInput = parseResult.getParamValueAsString("group");
        List<String> groupsToUpdate = !StringUtils.isBlank((CharSequence)groupInput) ? Arrays.asList(groupInput.split(",")) : (gfshCommand instanceof UpdateAllConfigurationGroupsMarker ? new ArrayList<String>(ccService.getGroups()) : Collections.singletonList("cluster"));
        for (String group : groupsToUpdate) {
            ccService.updateCacheConfig(group, cacheConfig -> {
                try {
                    if (gfshCommand.updateConfigForGroup(group, (CacheConfig)cacheConfig, resultModel.getConfigObject())) {
                        infoResultModel.addLine("Cluster configuration for group '" + group + "' is updated.");
                    } else {
                        infoResultModel.addLine("Cluster configuration for group '" + group + "' is not updated.");
                    }
                }
                catch (Exception e) {
                    String message = "Failed to update cluster configuration for " + group + ".";
                    this.logger.error(message, (Throwable)e);
                    infoResultModel.addLine(message + ". Reason: " + e.getMessage());
                    return null;
                }
                return cacheConfig;
            });
        }
        return resultModel;
    }

    @VisibleForTesting
    boolean lockCMS(Object command) {
        if (this.cmsDlockService == null) {
            return false;
        }
        if (!(command instanceof GfshCommand)) {
            return false;
        }
        GfshCommand gfshCommand = (GfshCommand)command;
        if (gfshCommand.getConfigurationPersistenceService() == null) {
            return false;
        }
        if (!gfshCommand.affectsClusterConfiguration()) {
            return false;
        }
        return this.cmsDlockService.lock((Object)"CMS_DLOCK_SERVICE", -1L, -1L);
    }

    @VisibleForTesting
    void unlockCMS(boolean locked) {
        if (locked) {
            this.cmsDlockService.unlock((Object)"CMS_DLOCK_SERVICE");
        }
    }
}

