/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.storedprocess;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.ResultContainer;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.StoredProcessDefinitionInterface;
import com.sas.prompts.storedprocess.RB;
import com.sas.prompts.storedprocess.StoredProcessMediator;
import com.sas.prompts.storedprocess.StoredProcessResultContainer;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.Execution2Interface;
import com.sas.services.storedprocess.ExecutionException;
import com.sas.services.storedprocess.ExecutionStatusListener2Interface;
import com.sas.services.storedprocess.OutputParameterInterface;
import com.sas.services.storedprocess.StoredProcess2Interface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.storedprocess.metadata.StoredProcessOptions;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import com.sas.util.UserInfoInterface;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;

public final class StoredProcessMediatorImpl
implements StoredProcessMediator {
    private CommonLoggerInterface logger;
    private LoggerFactoryInterface factory;
    private StoredProcessInterface smartObj = null;
    private StoredProcess2Interface sp = null;
    private Object locker;
    private StoredProcessDefinitionInterface spPrompt;
    private boolean destroyed = false;
    private SessionContextInterface sessionContext;
    private PromptValuesInterface promptValuesField;

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public StoredProcessDefinitionInterface getTargetPrompt() {
        return this.spPrompt;
    }

    StoredProcessMediatorImpl(@NotNull StoredProcessDefinitionInterface storedProcessPrompt) {
        this.spPrompt = storedProcessPrompt;
    }

    StoredProcessMediatorImpl(@NotNull SessionContextInterface sessionContext, @NotNull StoredProcessDefinitionInterface spDefinition) throws ServiceException, RemoteException, IllegalStateException {
        ValidateArg.notNull((Object)sessionContext, (String)"sessionContext");
        ValidateArg.notNull((Object)spDefinition, (String)"spDefinition");
        if (null == sessionContext.getUserContext()) {
            throw new IllegalStateException("Session Context does not contain a User Context");
        }
        this.spPrompt = spDefinition;
        this.factory = PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)sessionContext);
        PathUrl pUrl = PersistenceFactoryWithServices.newPathUrlFromString((UserContextInterface)sessionContext.getUserContext(), (String)spDefinition.getTargetURL());
        if (null == pUrl) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Mediator.no.pathurl.fmt", (Object)spDefinition.getTargetURL()));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("synchronous is:", Boolean.toString(spDefinition.isSynchronous()));
            this.getLogger().debug("createAlert is:", Boolean.toString(spDefinition.isCreateAlert()));
            this.getLogger().debug("Seeking this Stored Process:", pUrl.toString());
        }
        StoredProcessOptions options = new StoredProcessOptions();
        options.setSessionContextInterface(sessionContext);
        InformationServiceInterface infoService = UserContext.getInformationService();
        this.smartObj = (StoredProcessInterface)infoService.getObjectByPath(sessionContext.getUserContext(), pUrl);
        if (null == this.smartObj) {
            this.destroy();
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Mediator.sp.not.exist.fmt", (Object)pUrl.toString()));
        }
        this.sp = (StoredProcess2Interface)this.smartObj.newServiceObject(options);
        this.locker = sessionContext.lock(this.getClass().getName());
        this.sessionContext = sessionContext;
    }

    public static StoredProcessMediator newInstance(@NotNull SessionContextInterface sessionContext, @NotNull StoredProcessDefinitionInterface spDefinition) throws ServiceException, RemoteException, IllegalStateException {
        return new StoredProcessMediatorImpl(sessionContext, spDefinition);
    }

    @Override
    public synchronized ResultContainer execute(@NotNull PromptValuesInterface promptValues) throws RemoteException, ServiceException, PromptValueNotFoundException, InvalidPromptValueException {
        ValidateArg.notNull((Object)promptValues, (String)"promptValues");
        this.promptValuesField = promptValues;
        StoredProcessResultContainer outPut = new StoredProcessResultContainer(this);
        outPut.setLoggerFactory(this.factory);
        if (!this.destroyed) {
            try {
                this.getLogger().debug("execute() will attempt for: ", this.spPrompt.getPromptName());
                PromptDefinitionInterface[] defns = this.sp.getParameters();
                if (this.inputsMatch(defns, promptValues)) {
                    this.getLogger().debug("execute() will run for: ", this.spPrompt.getPromptName());
                    Execution2Interface e2i = this.sp.execute(this.spPrompt.isSynchronous(), (ExecutionStatusListener2Interface)outPut, this.spPrompt.isCreateAlert(), null);
                    outPut.setOutput(e2i);
                }
                this.getLogger().warn("execute(): " + RB.getStringResource("Mediator.no.parameter.match.txt"));
            }
            catch (ExecutionException e) {
                throw new ServiceException((Throwable)e);
            }
        } else {
            throw new ServiceException(RB.getStringResource("Mediator.destroyed.txt"));
        }
        return outPut;
    }

    @Override
    public void destroy() throws RemoteException {
        if (!this.destroyed) {
            if (null != this.sessionContext && !this.sessionContext.isDestroyPending()) {
                this.sessionContext.unlock(this.locker);
                this.sessionContext = null;
            }
            if (null != this.sp) {
                this.sp.destroy();
            }
            if (null != this.smartObj) {
                this.smartObj.destroy();
            }
            this.destroyed = true;
            this.getLogger().debug("destroy() was called.");
        }
    }

    boolean inputsMatch(PromptDefinitionInterface[] defns, PromptValuesInterface promptValues) throws PromptValueNotFoundException, RemoteException, InvalidPromptValueException {
        UserInfoInterface uii = this.spPrompt.getInputParameterMapping();
        for (PromptDefinitionInterface defn : defns) {
            if (!uii.contains(defn.getPromptName())) continue;
            String promptID = uii.get(defn.getPromptName());
            PromptDefinitionInterface prompt = PromptUtil.findPromptDefinitionByID((PromptValuesInterface)promptValues, (String)promptID);
            if (prompt != null) {
                this.getLogger().debug("inputsMatch(): Found the desired prompt in promptValues so get its value and set that on the stored process input.");
                this.getLogger().debug("Desired prompt name:", prompt.getPromptName());
                this.getLogger().debug("Input prompt name:", defn.getPromptName());
                PromptValuesInterface spPV = this.sp.getPromptValues();
                spPV.setPromptValue(defn, promptValues.getPromptValue(prompt));
            }
            return true;
        }
        return false;
    }

    void applyOutputs(List<OutputParameterInterface> params) throws InvalidPromptValueException {
        this.applyOutputs(params, this.promptValuesField);
    }

    void applyOutputs(List<OutputParameterInterface> params, PromptValuesInterface values) throws InvalidPromptValueException {
        if (this.promptValuesField != values) {
            this.promptValuesField = values;
        }
        if (!this.destroyed && !params.isEmpty()) {
            UserInfoInterface uii = this.spPrompt.getOutputParameterMapping();
            for (OutputParameterInterface param : params) {
                String paramName = param.getName();
                if (!uii.contains(paramName)) continue;
                String promptID = uii.get(paramName);
                PromptDefinitionInterface prompt = PromptUtil.findPromptDefinitionByID((PromptValuesInterface)this.promptValuesField, (String)promptID);
                if (prompt != null) {
                    this.getLogger().debug("Found the desired prompt in promptValues so set its value from the stored process output.");
                    this.getLogger().debug("Desired prompt name:", prompt.getPromptName());
                    this.getLogger().debug("OutputParameter name:", paramName);
                    this.promptValuesField.setPromptValue(prompt, param.getStringValue());
                    continue;
                }
                this.getLogger().info("applyOutputs()- Could not find this output parameter in the prompt values:", paramName);
            }
        }
    }

    void setPromptValue(int executionStatus) throws InvalidPromptValueException {
        this.promptValuesField.setPromptValue((PromptDefinitionInterface)this.spPrompt, (double)executionStatus);
    }

    private CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            if (null != this.factory) {
                this.logger = this.factory.makeNewLoggerInstance(this.getClass().getName());
            }
            this.logger = new Log4JFactory2().makeNewLoggerInstance(this.getClass().getName());
        }
        return this.logger;
    }
}

