/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.storedprocess;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StoredProcessType;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.definitions.MutableRequiredDefinitionInterface;
import com.sas.prompts.definitions.MutableStoredProcessDefinition;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.util.MapText;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.storedprocess.StoredProcess2Interface;
import com.sas.services.storedprocess.metadata.StoredProcess;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class StoredProcessDefinition
extends PromptDefinition
implements MutableStoredProcessDefinition,
MutableRequiredDefinitionInterface {
    private static final long serialVersionUID = 7081309339617974732L;
    private String targetURL = "";
    private MutableUserInfoInterface inputsMap = null;
    private MutableUserInfoInterface outputsMap;
    private boolean synchronous;
    private boolean required = false;
    private boolean createAlert = false;

    public StoredProcessDefinition() {
        super(null);
    }

    public StoredProcessDefinition(String promptName) {
        super(promptName);
        this.setSynchronous(true);
    }

    public boolean isCreateAlert() {
        return this.createAlert;
    }

    public void setCreateAlert(boolean createAlert) {
        this.createAlert = createAlert;
    }

    public DataTypeInterface getPromptDataType() {
        return new StoredProcessType();
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefinitionElementName() {
        return "StoredProcessDefinition";
    }

    public final String getTargetURL() {
        this.getLogger2().debug("targetURL is:", this.targetURL);
        return this.targetURL;
    }

    public final void setTargetURL(String targetURL) {
        ValidateArg.notNull((Object)targetURL, (String)"targetURL");
        this.getLogger2().debug("targetURL is:", targetURL);
        this.targetURL = PersistHelper.parseSBIPUrl((String)targetURL);
    }

    public void consumeAttributes(AttributesProvider provider) {
        Map map;
        PromptsReadingContext reader;
        super.consumeAttributes(provider);
        this.setTargetURL(PersistHelper.parseSBIPUrl((String)provider.consumeAttr("targetURL")));
        this.setSynchronous(provider.consumeBooleanAttr("synchronous", true));
        this.setCreateAlert(provider.consumeBooleanAttr("createAlert", false));
        this.setRequired(provider.consumeBooleanAttr("required", false));
        if (!"".equals(this.getTargetURL()) && null != (reader = provider.getReadingContext()) && null != (map = reader.getOptionsMap()) && map.containsKey("DESIGN_TIME") && map.containsKey("USER_CONTEXT")) {
            this.getLogger2().debug("Checking whether stored process is missing for ", this.getPromptName());
            UserContextInterface userContext = (UserContextInterface)map.get("USER_CONTEXT");
            try {
                PathUrl pUrl = PersistenceFactoryWithServices.newPathUrlFromString((UserContextInterface)userContext, (String)this.getTargetURL());
                if (null != pUrl) {
                    InformationServiceInterface infoService = UserContext.getInformationService();
                    MetadataInterface smartObj = infoService.getObjectByPath(userContext, pUrl);
                    if (null == smartObj) {
                        this.getLogger2().debug("The target stored process is missing!");
                        reader.addMissingResource((Object)this, (Object)this.getTargetURL());
                    } else if (smartObj instanceof StoredProcess) {
                        this.getLogger2().debug("This is design time so put the SP parameters into the options map.");
                        StoredProcess2Interface sp = (StoredProcess2Interface)((StoredProcess)smartObj).newServiceObject();
                        PromptDefinitionInterface[] array = sp.getParameters();
                        WeakHashMap params = null;
                        if (map.containsKey("STORED_PROCESS_PARAMETER_ARRAYS")) {
                            params = (WeakHashMap)map.get("STORED_PROCESS_PARAMETER_ARRAYS");
                        } else {
                            params = new WeakHashMap();
                            map.put("STORED_PROCESS_PARAMETER_ARRAYS", params);
                        }
                        params.put(this.getPromptID(), array);
                    }
                }
            }
            catch (ServiceException e) {
                reader.addMissingResource((Object)this, (Object)this.getTargetURL());
                this.getLogger2().error(e.getMessage());
            }
            catch (RemoteException e) {
                reader.addMissingResource((Object)this, (Object)this.getTargetURL());
                this.getLogger2().error(e.getMessage());
            }
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList outputList;
        Map map2;
        super.consumeRelatedObjects(roHolder);
        ArrayList inputList = roHolder.consumeObjects("Inputs");
        Map map = MapText.convertMapTextListToMap((List)inputList);
        if (map != null) {
            this.inputsMap = new UserInfo(map);
        }
        if ((map2 = MapText.convertMapTextListToMap((List)(outputList = roHolder.consumeObjects("Outputs")))) != null) {
            this.outputsMap = new UserInfo(map2);
        }
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        List list;
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"synchronous", (boolean)this.isSynchronous(), (boolean)true);
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.isRequired(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"createAlert", (boolean)this.isCreateAlert(), (boolean)false);
        if (!"".equals(this.getTargetURL())) {
            XmlUtil.setAttr((Element)element, (String)"targetURL", (String)("URL::" + this.getTargetURL()));
        }
        if (!"".equals(this.getTargetURL())) {
            MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("SBIP_URL", this.getTargetURL());
            md.setAdditionalInfo(info);
            md.setType("STORED_PROCESS");
            this.getLogger2().debug("Wrote a metadata descriptor for: ", this.getTargetURL());
            writingContext.addMetadataDescriptor(md);
        }
        if (null != (list = this.getUserInfoAsText(this.inputsMap)) && !list.isEmpty()) {
            this.getLogger2().debug("Writing Inputs.");
            StoredProcessDefinition.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"Inputs");
        }
        if (null != (list = this.getUserInfoAsText(this.outputsMap)) && !list.isEmpty()) {
            this.getLogger2().debug("Writing outputs.");
            StoredProcessDefinition.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"Outputs");
        }
    }

    public void setInputParameterMapping(UserInfoInterface input) {
        ValidateArg.notNull((Object)input, (String)"input");
        if (null == this.inputsMap) {
            this.inputsMap = new UserInfo();
        }
        if (!input.isEmpty()) {
            for (String key : input.getKeys()) {
                String text = input.get(key);
                this.inputsMap.put(key, text);
            }
        }
    }

    public UserInfoInterface getInputParameterMapping() {
        if (this.inputsMap == null) {
            this.inputsMap = new UserInfo();
        }
        if (this.inputsMap instanceof UserInfo) {
            try {
                return (UserInfoInterface)((UserInfo)this.inputsMap).clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return this.inputsMap;
    }

    public Collection<PromptDefinitionInterface> getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        if (this.inputsMap == null || this.inputsMap.isEmpty()) {
            return super.getDependentPrompts(locale, dynamicValueContext);
        }
        ValidateArg.notNull((Object)dynamicValueContext, (String)"dynamicValueContext");
        if (null == dynamicValueContext.getPromptGroup()) {
            this.getLogger2().warn("getDepdendentPrompts()- There is no prompt group within the dynamicValueContext.");
            return super.getDependentPrompts(locale, dynamicValueContext);
        }
        PromptGroupInterface group = dynamicValueContext.getPromptGroup();
        List definitions = group.getPromptDefinitions(true);
        ArrayList<PromptDefinitionInterface> retVal = new ArrayList<PromptDefinitionInterface>();
        List list = this.inputsMap.getKeys();
        for (String key : list) {
            String promptID = this.inputsMap.get(key);
            for (PromptDefinitionInterface p : definitions) {
                if (!p.getPromptID().equals(promptID)) continue;
                retVal.add(p);
                this.getLogger2().debug("getDepdendentPrompts() includes ", promptID);
            }
        }
        return retVal;
    }

    public void setOutputParameterMapping(UserInfoInterface output) {
        ValidateArg.notNull((Object)output, (String)"output");
        if (null == this.outputsMap) {
            this.outputsMap = new UserInfo();
        }
        if (!output.isEmpty()) {
            for (String key : output.getKeys()) {
                String text = output.get(key);
                this.outputsMap.put(key, text);
            }
        }
    }

    public UserInfoInterface getOutputParameterMapping() {
        if (this.outputsMap == null) {
            this.outputsMap = new UserInfo();
        }
        if (this.outputsMap instanceof UserInfo) {
            try {
                return (UserInfoInterface)((UserInfo)this.outputsMap).clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return this.outputsMap;
    }

    public final boolean isSynchronous() {
        return this.synchronous;
    }

    public final void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public Object clone() throws CloneNotSupportedException {
        StoredProcessDefinition clone = (StoredProcessDefinition)((Object)super.clone());
        if (null != this.outputsMap && this.outputsMap instanceof UserInfo) {
            clone.outputsMap = (MutableUserInfoInterface)((UserInfo)this.outputsMap).clone();
        }
        if (null != this.inputsMap && this.inputsMap instanceof UserInfo) {
            clone.inputsMap = (MutableUserInfoInterface)((UserInfo)this.inputsMap).clone();
        }
        return clone;
    }

    public String getVersion() {
        return "2.0";
    }
}

