/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.sticky;

import com.sas.prompts.PromptUserContextInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.sticky.RB;
import com.sas.services.ServiceException;
import com.sas.services.user.Profile;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.Strings;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;

public final class MetadataPromptUserContext
implements PromptUserContextInterface {
    private CommonLoggerInterface logger = null;
    private static final String RB_KEY = "MetadataPromptUserContext.";
    private ProfileInterface promptingProfile = null;
    private Map<String, String> values = new HashMap<String, String>();
    private static Locale locale = Locale.US;
    private String profileName;
    private static final String PROFILENAME = "SAS_Prompting";
    private static String userName = null;

    public MetadataPromptUserContext(@NotNull UserContextInterface userContext, @NotNull String profileName) throws BackingStoreException {
        ValidateArg.notNull((Object)userContext, (String)"userContext");
        ValidateArg.notNull((Object)profileName, (String)"profileName");
        this.logger = LoggerRepository2.getLogger((String)MetadataPromptUserContext.class.getName(), (LoggerFactoryInterface)new Log4JFactory2());
        this.profileName = profileName;
        this.load(userContext);
    }

    public boolean isStickyValueSet(@NotNull PromptDefinitionInterface promptDefinition) {
        return this.values.containsKey(promptDefinition.getPromptID()) && this.values.get(promptDefinition.getPromptID()) != null;
    }

    public Object getStickyValue(@NotNull PromptDefinitionInterface promptDefinition) {
        Object retVal = null;
        ValidateArg.notNull((Object)promptDefinition, (String)"promptDefinition");
        if (!promptDefinition.isStickyDefaultAllowed()) {
            throw new IllegalArgumentException(RB.getStringResource("MetadataPromptUserContext.noStickyValues.log"));
        }
        String x = this.values.get(promptDefinition.getPromptID());
        this.logger.debug("getStickyValue() for:", promptDefinition.getPromptID());
        if (null != x) {
            retVal = promptDefinition.getPromptDataType().coerceValue((Object)x, locale);
            this.logger.debug("getStickyValue() retVal:", promptDefinition.getPromptDataType().getValueAsString(retVal, locale));
        }
        return retVal;
    }

    public void clearStickyValue(@NotNull PromptDefinitionInterface promptDefinition) {
        this.values.put(promptDefinition.getPromptID(), null);
    }

    public String toString() {
        return "User name: " + userName + " profile name: " + this.profileName;
    }

    private void load(UserContextInterface userContext) throws BackingStoreException {
        block9: {
            try {
                userName = userContext.getName();
                ProfileInterface globalProfile = userContext.getProfile();
                if (globalProfile == null) break block9;
                try {
                    this.promptingProfile = globalProfile.getProfile(PROFILENAME);
                }
                catch (ServiceException e) {
                    this.promptingProfile = new Profile(PROFILENAME);
                    globalProfile.createSubprofile(this.promptingProfile);
                    globalProfile.addProfile(PROFILENAME, this.promptingProfile, true);
                    this.logger.debug("Made new SAS_Prompting profile.");
                }
                try {
                    Map map;
                    ProfileInterface pGroup = this.promptingProfile.getProfile(this.profileName);
                    if (pGroup != null && null != (map = pGroup.getAllAttributes(null)) && !map.isEmpty()) {
                        Collection coll = map.values();
                        Iterator collIter = coll.iterator();
                        for (String currentKey : map.keySet()) {
                            List value = (List)collIter.next();
                            this.values.put(currentKey, (String)value.get(0));
                        }
                        this.logger.debug("Loaded this many attributes:", Integer.toString(this.values.size()));
                    }
                }
                catch (ServiceException e) {
                    this.logger.debug("User does not have prompt group profile:", this.profileName);
                }
            }
            catch (ServiceException e) {
                this.logger.error(RB.getStringResource("MetadataPromptUserContext.noGlobalProfile.log"), (Throwable)e);
                throw new BackingStoreException(e.getMessage());
            }
            catch (RemoteException e) {
                this.logger.error(RB.getStringResource("MetadataPromptUserContext.noGlobalProfile.log"), (Throwable)e);
                throw new BackingStoreException(e.getMessage());
            }
        }
    }

    public void setStickyValue(@NotNull PromptDefinitionInterface promptDefinition, Object value) {
        ValidateArg.notNull((Object)promptDefinition, (String)"promptDefinition");
        if (null == promptDefinition.getPromptID()) {
            throw new IllegalArgumentException(RB.getStringResource("MetadataPromptUserContext.noDefinitionName.log"));
        }
        if (!promptDefinition.isStickyDefaultAllowed()) {
            throw new IllegalArgumentException(RB.getStringResource("MetadataPromptUserContext.noStickyValues.log"));
        }
        this.values.put(promptDefinition.getPromptID(), promptDefinition.getPromptDataType().getValueAsString(value, locale));
    }

    public boolean persist() throws BackingStoreException {
        if (this.values.isEmpty()) {
            this.logger.info(RB.getStringResource("MetadataPromptUserContext.noValuesToPersist.log"), this.profileName);
            return false;
        }
        ProfileInterface subProfile = null;
        try {
            try {
                subProfile = this.promptingProfile.getProfile(this.profileName);
            }
            catch (ServiceException e) {
                subProfile = this.createChildProfiles();
            }
            if (null != subProfile && !this.values.isEmpty()) {
                for (String currentKey : this.values.keySet()) {
                    subProfile.setAttribute(null, currentKey, this.values.get(currentKey));
                }
                subProfile.persist(null, true);
                this.logger.debug("persisted this many:", Integer.toString(this.values.size()));
            }
        }
        catch (RemoteException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BackingStoreException(e.getMessage());
        }
        catch (ServiceException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BackingStoreException(e.getMessage());
        }
        return true;
    }

    private ProfileInterface createChildProfiles() throws RemoteException, ServiceException {
        ProfileInterface parent = null;
        ProfileInterface subProfile = null;
        String[] array = Strings.split((String)this.profileName, null, (String)"/", null);
        for (int i = 0; i < array.length; ++i) {
            String name = array[i];
            if (i == 0) {
                parent = this.promptingProfile;
            }
            parent = subProfile = this.addProfile(parent, name);
        }
        return subProfile;
    }

    private ProfileInterface addProfile(ProfileInterface parent, String name) throws RemoteException, ServiceException {
        Profile subProfile = new Profile(name);
        try {
            subProfile = parent.getProfile(name);
        }
        catch (ServiceException e) {
            parent.createSubprofile((ProfileInterface)subProfile);
            parent.addProfile(name, (ProfileInterface)subProfile, true);
            this.logger.debug("persist(), made new profile for", name);
        }
        return subProfile;
    }

    public static boolean removeProfile(@NotNull UserContextInterface userContext, @NotNull String profileName) throws BackingStoreException {
        boolean retVal;
        block8: {
            ValidateArg.notNull((Object)profileName, (String)"profileName");
            ValidateArg.notNull((Object)userContext, (String)"userContext");
            retVal = false;
            try {
                CommonLoggerInterface logger = LoggerRepository2.getLogger((String)MetadataPromptUserContext.class.getName(), (LoggerFactoryInterface)new Log4JFactory2());
                ProfileInterface globalProfile = userContext.getProfile();
                ProfileInterface promptingProfile = null;
                if (globalProfile == null) break block8;
                try {
                    promptingProfile = globalProfile.getProfile(PROFILENAME);
                }
                catch (ServiceException e) {
                    logger.info(RB.getStringResource("MetadataPromptUserContext.noPromptProfile.log"));
                    return true;
                }
                ProfileInterface profile2Delete = null;
                try {
                    profile2Delete = promptingProfile.getProfile(profileName);
                }
                catch (ServiceException e) {
                    logger.info(RB.getStringResource("MetadataPromptUserContext.noPromptGroupProfile.log"), profileName);
                    return true;
                }
                try {
                    profile2Delete.deleteProfile(null);
                    logger.debug("Removed profile for ", profileName);
                    retVal = true;
                }
                catch (ServiceException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BackingStoreException(e);
                }
            }
            catch (RemoteException e) {
                throw new BackingStoreException(e.getMessage());
            }
        }
        return retVal;
    }
}

