/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.socket;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.socket.SocketConnection;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.generic.MessageConnectionServer;

public class SocketConnectionServer
implements MessageConnectionServer {
    private ServerSocket ss;
    private JMXServiceURL addr;
    private boolean wildcard;
    private Map env;
    private static final String DEFAULT_PROTOCOL = "jmxmp";
    private static final int DEFAULT_BACKLOG = 100;
    private final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SocketConnectionServer");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$ServerSocket;

    public SocketConnectionServer(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("constructor", "Constructs a SocketConnectionServer on " + jMXServiceURL);
        }
        if (jMXServiceURL == null) {
            throw new NullPointerException("Null address.");
        }
        if (!DEFAULT_PROTOCOL.equalsIgnoreCase(jMXServiceURL.getProtocol())) {
            throw new MalformedURLException("Unknown protocol: " + jMXServiceURL.getProtocol());
        }
        String string = null;
        if (map != null) {
            string = (String)map.get("jmx.remote.server.address.wildcard");
        }
        this.wildcard = string == null ? true : string.equalsIgnoreCase("true");
        this.addr = jMXServiceURL;
    }

    public void start(Map map) throws IOException {
        Object object;
        Class clazz;
        if (this.logger.traceOn()) {
            this.logger.trace("start", "Starts the server now.");
        }
        HashMap hashMap = new HashMap();
        if (this.env != null) {
            hashMap.putAll(this.env);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        int n = this.addr.getPort();
        String string = this.addr.getHost();
        if (string.equals("")) {
            string = InetAddress.getLocalHost().getHostName();
        }
        if (this.wildcard) {
            this.ss = new ServerSocket(0, 100, InetAddress.getByName(string));
            this.ss.close();
        }
        Object var5_5 = null;
        try {
            clazz = Class.forName("java.net.InetSocketAddress");
            if (this.wildcard) {
                object = clazz.getDeclaredConstructor(Integer.TYPE);
                var5_5 = ((Constructor)object).newInstance(new Integer(n));
            } else {
                object = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = SocketConnectionServer.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                var5_5 = ((Constructor)object).newInstance(string, new Integer(n));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (var5_5 != null && DefaultConfig.getServerReuseAddress(hashMap)) {
            try {
                clazz = class$java$net$ServerSocket == null ? (class$java$net$ServerSocket = SocketConnectionServer.class$("java.net.ServerSocket")) : class$java$net$ServerSocket;
                object = clazz.getMethod("setReuseAddress", Boolean.TYPE);
                Method method = clazz.getMethod("bind", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                this.ss = (ServerSocket)clazz.newInstance();
                ((Method)object).invoke((Object)this.ss, Boolean.TRUE);
                method.invoke((Object)this.ss, var5_5, new Integer(100));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Exception exception2;
                if (exception instanceof InvocationTargetException) {
                    object = ((InvocationTargetException)exception).getTargetException();
                    if (object instanceof IOException) {
                        throw (IOException)object;
                    }
                    if (object instanceof RuntimeException) {
                        throw (RuntimeException)object;
                    }
                    if (object instanceof Exception) {
                        exception2 = (Exception)object;
                    }
                }
                object = new IOException(exception2.toString());
                EnvHelp.initCause(object, exception2);
                throw object;
            }
        } else {
            this.ss = this.wildcard ? new ServerSocket(n, 100) : new ServerSocket(n, 100, InetAddress.getByName(string));
        }
        this.addr = new JMXServiceURL(DEFAULT_PROTOCOL, string, this.ss.getLocalPort());
        this.env = hashMap;
    }

    public MessageConnection accept() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("accept", "Waiting a new connection...");
        }
        SocketConnection socketConnection = new SocketConnection(this.ss.accept());
        return socketConnection;
    }

    public void stop() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("stop", "Stops the server now.");
        }
        if (this.ss != null) {
            this.ss.close();
        }
    }

    public JMXServiceURL getAddress() {
        return this.addr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

