/*
 * Decompiled with CFR 0.152.
 */
package MITI.summary;

import MITI.expression.converter.MIRRefExpressionPrinter;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIROperationNode;
import MITI.summary.SummaryExpression;
import java.util.TreeMap;

public class SummaryExpressionPrinter
extends MIRRefExpressionPrinter {
    TreeMap<MIRFeature, SummaryExpression> featureSummaries;
    boolean aggregation = false;

    public SummaryExpressionPrinter(TreeMap<MIRFeature, SummaryExpression> treeMap) {
        this.featureSummaries = treeMap;
    }

    @Override
    protected boolean handleElement() {
        return true;
    }

    @Override
    protected MIRRefExpressionPrinter getNewExpressionPrinter() {
        SummaryExpressionPrinter summaryExpressionPrinter = new SummaryExpressionPrinter(this.featureSummaries);
        summaryExpressionPrinter.followRefs = this.followRefs;
        return summaryExpressionPrinter;
    }

    @Override
    protected void merge(MIRRefExpressionPrinter mIRRefExpressionPrinter) {
        this.aggregation |= ((SummaryExpressionPrinter)mIRRefExpressionPrinter).aggregation;
        super.merge(mIRRefExpressionPrinter);
    }

    @Override
    protected String getElementName(MIRElement mIRElement) {
        SummaryExpression summaryExpression = this.featureSummaries.get(mIRElement);
        if (summaryExpression == null) {
            if (mIRElement.isInstanceOf((short)75)) {
                return mIRElement.getName();
            }
            return "NULL";
        }
        if (summaryExpression.isAggregated()) {
            this.setAggregation(true);
        }
        if (!summaryExpression.isPassThrough()) {
            this.setComplex();
            return "(" + summaryExpression.getExpression() + ")";
        }
        return summaryExpression.getExpression();
    }

    @Override
    protected void printExpression(MIRExpression mIRExpression) {
        this.aggregation = false;
        super.printExpression(mIRExpression);
    }

    @Override
    protected void printOperationNode(MIROperationNode mIROperationNode) {
        String string = mIROperationNode.getName();
        int n = mIROperationNode.getExpressionNodeCount();
        this.aggregation |= this.getFunctions().isAggregation(string, n);
        super.printOperationNode(mIROperationNode);
    }

    protected boolean isAggregation() {
        return this.aggregation;
    }

    protected void setAggregation(boolean bl) {
        this.aggregation = bl;
    }

    @Override
    protected void clearExpression() {
        super.clearExpression();
        this.aggregation = false;
    }
}

