/*
 * Decompiled with CFR 0.152.
 */
package com.platform.SASLogin;

import com.platform.LSF.security.EauthCredentials;
import com.platform.LSF.security.LSFUser;
import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFIncompatibleIOException;
import com.platform.LSFJobFlow.api.JFIncompatibleLoginException;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.SASLogin.ServerLoginException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class UsernamePasswordLogin
implements LoginModule {
    private static final String OS_TYPE = System.getProperty("os.name").toLowerCase();
    private boolean m_debug = false;
    private Subject m_subject = null;
    private static final String FAILED_LOGIN_MSG = JFResource.getString((String)"FAILED_LOGIN_MSG");

    protected UserPass getUsernamePassword() throws LoginException {
        return null;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (map2.containsKey("debug")) {
            this.m_debug = new Boolean((String)map2.get("debug"));
        }
        if (this.m_debug) {
            System.out.println("UsernamePassword initialize invoked");
        }
        this.m_subject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        EauthCredentials eauthCredentials;
        Object object;
        String string;
        UserPass userPass;
        if (this.m_debug) {
            System.out.println("UsernamePassword login invoked");
        }
        String string2 = null;
        String string3 = null;
        LSFUser lSFUser = null;
        if (this.m_subject.getPrincipals().isEmpty()) {
            userPass = this.getUsernamePassword();
            if (userPass == null || userPass.username == null || userPass.password == null) {
                throw new FailedLoginException(FAILED_LOGIN_MSG);
            }
            string = userPass.username;
            object = userPass.password;
            if (string.equals("")) {
                throw new FailedLoginException(FAILED_LOGIN_MSG);
            }
            int n = string.indexOf(92);
            if (n < 0) {
                string3 = string;
                string2 = null;
            } else {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            if (string3.indexOf(92) >= 0 || string3.indexOf(9) >= 0) {
                throw new FailedLoginException(FAILED_LOGIN_MSG);
            }
            if (OS_TYPE.indexOf("win") < 0 && string3.indexOf(32) >= 0) {
                throw new FailedLoginException(FAILED_LOGIN_MSG);
            }
            lSFUser = new LSFUser(string3, 0, 0, string2);
            try {
                eauthCredentials = new EauthCredentials(EauthCredentials.getEncryptedString((char[])object).getBytes());
                this.m_subject.getPrincipals().add((Principal)lSFUser);
                this.m_subject.getPublicCredentials().add(eauthCredentials);
                Arrays.fill((char[])object, '\u0000');
            }
            catch (Exception exception) {
                String string4 = exception.getMessage();
                if (this.m_debug) {
                    System.out.println("UsernamePassword Exception: " + string4);
                }
                if (string4.indexOf("ACCESS DENIED") < 0) {
                    throw new ServerLoginException(exception.getMessage());
                }
                throw new FailedLoginException(FAILED_LOGIN_MSG);
            }
        }
        try {
            userPass = new JFAdminManager();
            string = JFConfigManager.getServerVersion((boolean)true);
            if (string != null && string.compareTo("5.5") < 0) {
                boolean bl = userPass.Null();
                if (this.m_debug) {
                    System.out.println("UsernamePassword Null() returned " + bl);
                }
                if (!bl) {
                    throw new FailedLoginException();
                }
                return bl;
            }
            object = userPass.getJIDInfo();
            if (object == null) {
                throw new FailedLoginException();
            }
            String string5 = object.getServerName();
            if (string5 != null) {
                string5 = string5.toUpperCase();
                if (string2 != null && (string5.equalsIgnoreCase(string2) || string5.startsWith(string2.toUpperCase() + "."))) {
                    eauthCredentials = this.m_subject.getPrincipals();
                    eauthCredentials.remove(lSFUser);
                    eauthCredentials.add((Principal)new LSFUser(string3, 0, 0, "."));
                }
            }
            return true;
        }
        catch (JFIncompatibleIOException jFIncompatibleIOException) {
            throw new JFIncompatibleLoginException(jFIncompatibleIOException.getMessage());
        }
        catch (Exception exception) {
            string = exception.getMessage();
            if (this.m_debug) {
                System.out.println("UsernamePassword Exception: " + string);
            }
            if (string.indexOf("ACCESS DENIED") < 0) {
                throw new ServerLoginException(exception.getMessage());
            }
            throw new FailedLoginException(FAILED_LOGIN_MSG);
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.m_debug) {
            System.out.println("UsernamePassword commit invoked");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.m_debug) {
            System.out.println("UsernamePassword abort invoked");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.m_debug) {
            System.out.println("UsernamePassword logout invoked");
        }
        return true;
    }

    class UserPass {
        String username;
        char[] password;

        UserPass() {
        }
    }
}

