/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory;

import MITI.MIRException;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDate;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyElementTypeScope;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRType;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRObjectCache;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfilerOptions;
import MITI.sdk.profiles.impl.DataProvider;
import MITI.sdk.profiles.impl.MIRProfiler;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.AttributeValue;
import MITI.server.services.common.mir.Condition;
import MITI.server.services.common.mir.LinkIdentifier;
import MITI.server.services.common.mir.LinkPart;
import MITI.server.services.common.mir.LinkedObject;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.util.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MemoryDataProvider
implements DataProvider {
    private MIRObjectCache cache = null;
    private MIRProfilerOptions options = null;

    public MemoryDataProvider(MIRObjectCache mIRObjectCache) {
        this.cache = mIRObjectCache;
    }

    public void setOptions(MIRProfilerOptions mIRProfilerOptions) {
        this.options = mIRProfilerOptions;
    }

    @Override
    public ObjectDefinition get(ObjectIdentifier objectIdentifier, AttributeIdentifier[] attributeIdentifierArray) throws MIRException {
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        if (mIRObject == null) {
            return null;
        }
        ArrayList<AttributeValue> arrayList = new ArrayList<AttributeValue>();
        MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
        for (int n = 0; n < mIRMetaClass.getAttributeCount(); n = (int)((byte)(n + 1))) {
            AttributeValue attributeValue = this.buildAttributeValue(mIRObject, mIRMetaClass.getAttribute(n));
            if (attributeValue == null) continue;
            arrayList.add(attributeValue);
        }
        MIRPropertyType[] mIRPropertyTypeArray = this.getUdps(mIRObject);
        if (mIRPropertyTypeArray != null) {
            for (int i = 0; i < mIRPropertyTypeArray.length; ++i) {
                AttributeValue attributeValue = this.buildAttributeValue(mIRObject, mIRPropertyTypeArray[i]);
                if (attributeValue == null) continue;
                arrayList.add(attributeValue);
            }
        }
        if (attributeIdentifierArray != null) {
            for (AttributeIdentifier attributeIdentifier : attributeIdentifierArray) {
                AttributeValue attributeValue;
                if (attributeIdentifier.getLink() == null && !attributeIdentifier._isSpecialAttribute() || (attributeValue = this.buildAttributeValue(mIRObject, attributeIdentifier)) == null) continue;
                arrayList.add(attributeValue);
            }
        }
        ObjectDefinition objectDefinition = new ObjectDefinition(objectIdentifier, mIRObject.getElementType(), mIRObject.getName());
        objectDefinition.setAttributes(arrayList.toArray(new AttributeValue[arrayList.size()]));
        return objectDefinition;
    }

    @Override
    public ObjectDefinition[] list(ObjectIdentifier[] objectIdentifierArray, LinkIdentifier[] linkIdentifierArray, AttributeIdentifier[] attributeIdentifierArray) throws MIRException {
        ObjectDefinition[] objectDefinitionArray = new ObjectDefinition[objectIdentifierArray.length];
        for (int i = 0; i < objectIdentifierArray.length; ++i) {
            ObjectIdentifier objectIdentifier = objectIdentifierArray[i];
            objectDefinitionArray[i] = new ObjectDefinition(objectIdentifier, this.getObjectType(objectIdentifier));
            objectDefinitionArray[i].setLinks(this.list(objectIdentifier, linkIdentifierArray, attributeIdentifierArray));
        }
        return objectDefinitionArray;
    }

    @Override
    public LinkedObject[] list(ObjectDefinition objectDefinition, LinkIdentifier linkIdentifier, AttributeIdentifier attributeIdentifier) throws MIRException {
        LinkIdentifier[] linkIdentifierArray = new LinkIdentifier[]{linkIdentifier};
        AttributeIdentifier[] attributeIdentifierArray = null;
        if (attributeIdentifier != null) {
            attributeIdentifierArray = new AttributeIdentifier[]{attributeIdentifier};
        }
        return this.list((ObjectIdentifier)objectDefinition, linkIdentifierArray, attributeIdentifierArray);
    }

    @Override
    public LinkedObject[] list(ObjectIdentifier objectIdentifier, LinkIdentifier[] linkIdentifierArray, AttributeIdentifier[] attributeIdentifierArray) throws MIRException {
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        if (mIRObject == null || linkIdentifierArray == null || linkIdentifierArray.length == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (LinkIdentifier linkIdentifier : linkIdentifierArray) {
            Map<MIRObject, ArrayList<AttributeValue>> map;
            boolean bl = false;
            LinkIdentifier linkIdentifier2 = linkIdentifier;
            short s = -1;
            LinkPart[] linkPartArray = linkIdentifier.getAssociations();
            if (mIRObject.getElementType() == 157 && linkPartArray.length == 2 && linkPartArray[0].getAssociationType() == 893 && s != -1) {
                linkIdentifier2 = new LinkIdentifier();
                linkIdentifier2.setAssociations(new LinkPart[]{linkIdentifier.getAssociations()[0]});
                bl = true;
            }
            if ((map = this.getRemoteObjects(mIRObject, linkIdentifier2, attributeIdentifierArray)) == null) continue;
            for (MIRObject mIRObject2 : map.keySet()) {
                ObjectDefinition objectDefinition = this.cache.getObjectDefinition(mIRObject2);
                if (objectDefinition == null) continue;
                if (bl) {
                    objectDefinition.setModelId(objectDefinition.getObjectId());
                    objectDefinition.setObjectId(1);
                    objectDefinition.setObjectType(s);
                }
                HashSet<AttributeValue> hashSet = new HashSet<AttributeValue>();
                hashSet.addAll((Collection)map.get(mIRObject2));
                if (attributeIdentifierArray != null) {
                    for (AttributeIdentifier attributeIdentifier : attributeIdentifierArray) {
                        AttributeValue attributeValue;
                        if (hashSet.contains(attributeIdentifier) || (attributeValue = this.buildAttributeValue(mIRObject2, attributeIdentifier)) == null) continue;
                        hashSet.add(attributeValue);
                    }
                }
                if (hashSet.size() != 0) {
                    objectDefinition.setAttributes(hashSet.toArray(new AttributeValue[hashSet.size()]));
                }
                LinkedObject linkedObject = new LinkedObject();
                linkedObject.setObject(objectDefinition);
                linkedObject.setLinkIdentifier(linkIdentifier);
                arrayList.add(linkedObject);
            }
        }
        return arrayList.toArray(new LinkedObject[arrayList.size()]);
    }

    @Override
    public LinkedObject[] list(ObjectIdentifier objectIdentifier, short[] sArray, AttributeIdentifier[] attributeIdentifierArray) throws MIRException {
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        if (mIRObject == null || sArray == null || sArray.length == 0) {
            return null;
        }
        GetObjectByType getObjectByType = new GetObjectByType(mIRObject, sArray);
        mIRObject.depthTraversal(getObjectByType);
        MIRObject[] mIRObjectArray = getObjectByType.getResults();
        ArrayList<LinkedObject> arrayList = new ArrayList<LinkedObject>();
        for (MIRObject mIRObject2 : mIRObjectArray) {
            ObjectDefinition objectDefinition = this.cache.getObjectDefinition(mIRObject2);
            if (objectDefinition == null) continue;
            if (attributeIdentifierArray != null) {
                objectDefinition.setAttributes(this.buildAttributeValues(mIRObject2, attributeIdentifierArray));
            }
            LinkedObject linkedObject = new LinkedObject();
            linkedObject.setObject(objectDefinition);
            linkedObject.setLinkIdentifier(new LinkIdentifier(-1));
            arrayList.add(linkedObject);
        }
        return arrayList.toArray(new LinkedObject[arrayList.size()]);
    }

    @Override
    public LinkedObject[] getObjectPath(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2) throws MIRException {
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        if (mIRObject == null) {
            return null;
        }
        ArrayList<LinkedObject> arrayList = new ArrayList<LinkedObject>();
        while (mIRObject != null && mIRObject.getElementType() != 286) {
            ObjectDefinition objectDefinition = this.cache.getObjectDefinition(mIRObject);
            MIRMetaLink mIRMetaLink = null;
            MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
            for (int n = 0; n < mIRMetaClass.getLinkCount() && ((mIRMetaLink = mIRMetaClass.getLink(n)).getType() != 2 || mIRMetaLink.getCount(mIRObject) != 1); n = (int)((byte)(n + 1))) {
                mIRMetaLink = null;
            }
            LinkIdentifier linkIdentifier = new LinkIdentifier();
            LinkedObject linkedObject = new LinkedObject();
            linkedObject.setObject(objectDefinition);
            linkedObject.setLinkIdentifier(linkIdentifier);
            if (mIRMetaLink != null) {
                linkIdentifier.setAssociations(new LinkPart[]{new LinkPart(mIRMetaLink.getReverse().getID())});
                mIRObject = mIRMetaLink.getIterator((MIR_Object)mIRObject).next();
            } else {
                linkIdentifier.setAssociations(new LinkPart[]{new LinkPart(-3)});
                mIRObject = mIRObject.getParent();
            }
            arrayList.add(0, linkedObject);
        }
        return arrayList.toArray(new LinkedObject[arrayList.size()]);
    }

    private AttributeValue[] buildAttributeValues(MIRObject mIRObject, AttributeIdentifier[] attributeIdentifierArray) {
        if (mIRObject == null || attributeIdentifierArray == null || attributeIdentifierArray.length == 0) {
            return null;
        }
        ArrayList<AttributeValue> arrayList = new ArrayList<AttributeValue>();
        for (AttributeIdentifier attributeIdentifier : attributeIdentifierArray) {
            AttributeValue attributeValue = this.buildAttributeValue(mIRObject, attributeIdentifier);
            if (attributeValue == null) continue;
            arrayList.add(attributeValue);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new AttributeValue[arrayList.size()]);
    }

    private AttributeValue buildAttributeValue(MIRObject mIRObject, AttributeIdentifier attributeIdentifier) {
        Object object;
        if (mIRObject == null || attributeIdentifier == null) {
            return null;
        }
        MIRObject mIRObject2 = null;
        if (attributeIdentifier.getLink() != null) {
            object = this.getRemoteObjects(mIRObject, attributeIdentifier.getLink(), null);
            if (object != null && object.size() != 0) {
                mIRObject2 = object.keySet().iterator().next();
            }
        } else {
            mIRObject2 = mIRObject;
        }
        object = null;
        if (attributeIdentifier._isUdp()) {
            MIRPropertyType[] mIRPropertyTypeArray = this.getUdps(mIRObject2);
            if (mIRPropertyTypeArray == null) {
                return null;
            }
            for (int i = 0; i < mIRPropertyTypeArray.length; ++i) {
                MIRPropertyType mIRPropertyType = mIRPropertyTypeArray[i];
                if (!mIRPropertyType.getFullName().equals(attributeIdentifier.getName())) continue;
                object = this.buildAttributeValue(mIRObject2, mIRPropertyType);
                break;
            }
        } else if (attributeIdentifier.getType() == -2) {
            object = this.buildAttributeValue(mIRObject2, MIRMetaAttribute.getByAttributeType((short)106));
            if (object == null || ((AttributeValue)object).getValue().length() == 0) {
                object = this.buildAttributeValue(mIRObject2, MIRMetaAttribute.getByAttributeType((short)174));
            }
            if (object != null) {
                ((AttributeIdentifier)object).setType(attributeIdentifier.getType());
            }
        } else if (attributeIdentifier.getType() == 56) {
            if (mIRObject2 instanceof MIRType) {
                MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(attributeIdentifier.getType());
                object = new AttributeValue(mIRMetaAttribute.getID(), ((MIRType)mIRObject2).getNativeDataType());
                ((AttributeValue)object).setValueType(mIRMetaAttribute.getPhysicalType());
                ((AttributeValue)object).setPossibleValues(mIRMetaAttribute.getPossibleStringValues(false));
            }
        } else if (attributeIdentifier.getType() != -1) {
            MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(attributeIdentifier.getType());
            object = this.buildAttributeValue(mIRObject2, mIRMetaAttribute);
        } else {
            object = this.buildLinkValue(mIRObject2, attributeIdentifier);
        }
        if (object != null) {
            ((AttributeIdentifier)object).setLink(attributeIdentifier.getLink());
        }
        return object;
    }

    private AttributeValue buildLinkValue(MIRObject mIRObject, AttributeIdentifier attributeIdentifier) {
        if (attributeIdentifier == null || attributeIdentifier.getType() != -1 || attributeIdentifier.getName() != null) {
            return null;
        }
        AttributeValue attributeValue = new AttributeValue();
        attributeValue.setLink(attributeIdentifier.getLink());
        attributeValue.setValue(mIRObject == null ? "false" : "true");
        attributeValue.setValueType("java.lang.Boolean");
        return attributeValue;
    }

    private AttributeValue buildAttributeValue(MIRObject mIRObject, MIRMetaAttribute mIRMetaAttribute) {
        Object object;
        if (mIRObject == null || mIRMetaAttribute == null) {
            return null;
        }
        if (mIRObject.getMetaClass().getAttributeByID(mIRMetaAttribute.getID()) == null) {
            return null;
        }
        Object object2 = mIRMetaAttribute.get(mIRObject);
        if (object2 == null) {
            return null;
        }
        String string = null;
        byte by = mIRMetaAttribute.getType();
        string = by == 4 && object2 instanceof MIRDate && this.options != null && this.options.getDateFormat() != null ? (((MIRDate)(object = (MIRDate)object2)).isNull() ? "" : DateUtil.formatDate(((MIRDate)object).get().getTimeInMillis(), this.options.getDateFormat())) : mIRMetaAttribute.getValueToString(object2, false);
        object = new AttributeValue(mIRMetaAttribute.getID(), string);
        ((AttributeValue)object).setValueType(mIRMetaAttribute.getPhysicalType());
        ((AttributeValue)object).setPossibleValues(mIRMetaAttribute.getPossibleStringValues(false));
        return object;
    }

    private static MIRPropertyValue getPropertyValue(MIRElement mIRElement, MIRPropertyType mIRPropertyType) {
        Iterator<MIRPropertyValue> iterator = mIRElement.getPropertyValueIterator();
        while (iterator.hasNext()) {
            MIRPropertyValue mIRPropertyValue = iterator.next();
            if (mIRPropertyValue.getPropertyType() != mIRPropertyType) continue;
            return mIRPropertyValue;
        }
        return null;
    }

    private AttributeValue buildAttributeValue(MIRObject mIRObject, MIRPropertyType mIRPropertyType) {
        String string;
        if (mIRObject == null || mIRPropertyType == null || !(mIRObject instanceof MIRElement)) {
            return null;
        }
        MIRPropertyValue mIRPropertyValue = MemoryDataProvider.getPropertyValue((MIRElement)mIRObject, mIRPropertyType);
        if (mIRPropertyValue != null) {
            string = mIRPropertyValue.getValue();
        } else {
            if (mIRPropertyType.getUsage().contains(".OPTIONAL")) {
                return null;
            }
            string = mIRPropertyType.getInitialValue();
        }
        AttributeValue attributeValue = new AttributeValue(mIRPropertyType.getFullName(), string);
        String string2 = mIRPropertyType.getDataType();
        String string3 = String.class.getName();
        if (MIRBaseTypeList.isMIRString(string2)) {
            string3 = String.class.getName();
        } else if (MIRBaseTypeList.isMIRDate(string2)) {
            string3 = MIRDate.class.getName();
        } else if (string2.equals("SQL_BOOLEAN")) {
            string3 = Boolean.class.getName();
        } else if (string2.equals("SQL_TINYINT")) {
            string3 = Byte.class.getName();
        } else if (string2.equals("SQL_SMALLINT")) {
            string3 = Short.class.getName();
        } else if (string2.equals("SQL_INTEGER")) {
            string3 = Integer.class.getName();
        }
        attributeValue.setValueType(string3);
        attributeValue.setUdpDescription(mIRPropertyType.getDescription());
        if (mIRPropertyType.getTypeValueCount() != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<MIRTypeValue> iterator = mIRPropertyType.getTypeValueByPosition().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().getValue());
            }
            attributeValue.setPossibleValues(arrayList.toArray(new String[arrayList.size()]));
        }
        return attributeValue;
    }

    private Map<MIRObject, ArrayList<AttributeValue>> getRemoteObjects(MIRObject mIRObject, LinkIdentifier linkIdentifier, AttributeIdentifier[] attributeIdentifierArray) {
        int n;
        if (mIRObject == null || linkIdentifier == null) {
            return null;
        }
        TreeMap<MIRObject, ArrayList<AttributeValue>> treeMap = new TreeMap<MIRObject, ArrayList<AttributeValue>>();
        treeMap.put(mIRObject, new ArrayList());
        TreeMap treeMap2 = new TreeMap();
        ArrayList<AttributeIdentifier> arrayList = new ArrayList<AttributeIdentifier>();
        ArrayList<AttributeIdentifier> arrayList2 = new ArrayList<AttributeIdentifier>();
        if (attributeIdentifierArray != null) {
            AttributeIdentifier[] attributeIdentifierArray2 = attributeIdentifierArray;
            int n2 = attributeIdentifierArray2.length;
            for (n = 0; n < n2; ++n) {
                AttributeIdentifier attributeIdentifier = attributeIdentifierArray2[n];
                if (attributeIdentifier.getLink() == null) continue;
                arrayList.add(attributeIdentifier);
            }
        }
        for (int i = 0; i < linkIdentifier.getAssociations().length; ++i) {
            ArrayList<MIRObject> arrayList3;
            LinkPart linkPart = linkIdentifier.getAssociations()[i];
            if (treeMap.size() == 0) {
                return null;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                AttributeIdentifier attributeIdentifier = (AttributeIdentifier)arrayList.get(n);
                if (i >= attributeIdentifier.getLink().getAssociations().length || linkPart.getAssociationType() != attributeIdentifier.getLink().getAssociations()[i].getAssociationType()) continue;
                arrayList2.add(attributeIdentifier);
            }
            for (MIRObject mIRObject2 : treeMap.keySet()) {
                arrayList3 = this.getRemoteObjects(mIRObject2, linkPart);
                if (arrayList3 == null) continue;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    Cloneable cloneable = new ArrayList();
                    cloneable.addAll((Collection)treeMap.get(mIRObject2));
                    treeMap2.put(arrayList3.get(j), cloneable);
                }
            }
            for (int j = 0; j < arrayList2.size(); ++j) {
                arrayList3 = (AttributeIdentifier)arrayList2.get(j);
                AttributeIdentifier attributeIdentifier = new AttributeIdentifier();
                attributeIdentifier.setType(((AttributeIdentifier)((Object)arrayList3)).getType());
                attributeIdentifier.setName(((AttributeIdentifier)((Object)arrayList3)).getName());
                if (i != ((AttributeIdentifier)((Object)arrayList3)).getLink().getAssociations().length - 1 || linkPart.getAssociationType() != ((AttributeIdentifier)((Object)arrayList3)).getLink().getAssociations()[i].getAssociationType()) continue;
                for (Cloneable cloneable : treeMap2.keySet()) {
                    AttributeValue attributeValue = this.buildAttributeValue((MIRObject)cloneable, attributeIdentifier);
                    if (attributeValue == null) continue;
                    attributeValue.setLink(((AttributeIdentifier)((Object)arrayList3)).getLink());
                    ((ArrayList)treeMap2.get(cloneable)).add(attributeValue);
                }
            }
            treeMap.clear();
            treeMap.putAll(treeMap2);
            treeMap2.clear();
            arrayList.clear();
            arrayList.addAll(arrayList2);
            arrayList2.clear();
        }
        return treeMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<MIRObject> getRemoteObjects(MIRObject mIRObject, LinkPart linkPart) {
        MIRObject mIRObject2;
        Object object;
        Comparable<MIR_Object> comparable;
        if (mIRObject == null || linkPart == null) {
            return null;
        }
        ArrayList<Comparable<MIR_Object>> arrayList = new ArrayList<Comparable<MIR_Object>>();
        ArrayList<MIRObject> arrayList2 = new ArrayList<MIRObject>();
        if (linkPart.getAssociationType() == -2) {
            arrayList.add(mIRObject);
        } else if (linkPart.getAssociationType() == -3) {
            comparable = mIRObject.getParent();
            if (comparable == null) return null;
            arrayList.add(comparable);
        } else if (linkPart.getAssociationType() == -4) {
            arrayList.add(mIRObject.getRootModel());
        } else if (linkPart.getAssociationType() == -5) {
            comparable = mIRObject.getRootModel().getParent();
            if (comparable == null) {
                object = this.cache.getObjectIdentifier(mIRObject);
                ((ObjectIdentifier)object).setObjectId(((ObjectIdentifier)object).getModelId());
                ((ObjectIdentifier)object).setModelId(-1);
                comparable = this.cache.getMirObject((ObjectIdentifier)object);
            }
            if (comparable == null) return null;
            arrayList.add(comparable);
        } else if (linkPart.getAssociationType() == -7) {
            if (!(mIRObject instanceof MIRAssociationRole)) return null;
            arrayList.add(MemoryDataProvider.findReverseRole((MIRAssociationRole)mIRObject));
        } else {
            comparable = mIRObject.getMetaClass().getLinkByID(linkPart.getAssociationType());
            if (comparable == null) {
                return null;
            }
            object = ((MIRMetaLink)comparable).getIterator((MIR_Object)mIRObject);
            while (object.hasNext()) {
                mIRObject2 = (MIRObject)object.next();
                if (mIRObject.getRootModel() != mIRObject2.getRootModel() && !(mIRObject instanceof MIRContent) && !(mIRObject2 instanceof MIRContent)) continue;
                arrayList.add(mIRObject2);
            }
        }
        comparable = linkPart.getCondition();
        if (comparable != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                mIRObject2 = (MIRObject)arrayList.get(i);
                AttributeIdentifier[] attributeIdentifierArray = ((Condition)comparable).listAttributes();
                ArrayList<AttributeValue> arrayList3 = new ArrayList<AttributeValue>();
                for (AttributeIdentifier attributeIdentifier : attributeIdentifierArray) {
                    arrayList3.add(this.buildAttributeValue(mIRObject2, attributeIdentifier));
                }
                if (!((Condition)comparable).match(arrayList3.toArray(new AttributeValue[arrayList3.size()]))) continue;
                arrayList2.add(mIRObject2);
            }
            return arrayList2;
        } else {
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    private static MIRAssociationRole findReverseRole(MIRAssociationRole mIRAssociationRole) {
        for (MIRAssociationRole mIRAssociationRole2 : mIRAssociationRole.getAssociation().getAssociationRoles()) {
            if (mIRAssociationRole2 == mIRAssociationRole) continue;
            return mIRAssociationRole2;
        }
        return null;
    }

    private MIRPropertyElementTypeScope getUdpScope(MIRObject mIRObject) {
        if (mIRObject == null) {
            return null;
        }
        if (mIRObject.getElementType() == 70) {
            return null;
        }
        if (mIRObject.getParent() == null || mIRObject.getParent().getElementType() != 70) {
            Iterator<MIRPropertyElementTypeScope> iterator = null;
            MIRModel mIRModel = mIRObject.getRootModel();
            if (mIRModel != null) {
                iterator = mIRModel.getPropertyElementTypeScopeIterator();
            }
            if (iterator == null) {
                return null;
            }
            MIRPropertyElementTypeScope mIRPropertyElementTypeScope = null;
            while (iterator.hasNext() && (mIRPropertyElementTypeScope = iterator.next()).getScope() != mIRObject.getElementType()) {
                mIRPropertyElementTypeScope = null;
            }
            return mIRPropertyElementTypeScope;
        }
        return null;
    }

    private boolean checkDesignLevel(MIRModelObject mIRModelObject, MIRPropertyType mIRPropertyType) {
        if (mIRPropertyType.getDesignLevel() == 1 && mIRModelObject.getDesignLevel() == 2) {
            return false;
        }
        return mIRPropertyType.getDesignLevel() != 2 || mIRModelObject.getDesignLevel() != 1;
    }

    private MIRPropertyType[] getUdps(MIRObject mIRObject) {
        MIRPropertyElementTypeScope mIRPropertyElementTypeScope = this.getUdpScope(mIRObject);
        if (mIRPropertyElementTypeScope == null) {
            return null;
        }
        ArrayList<MIRPropertyType> arrayList = new ArrayList<MIRPropertyType>();
        Iterator<MIRPropertyType> iterator = mIRPropertyElementTypeScope.getPropertyTypeIterator();
        while (iterator.hasNext()) {
            MIRPropertyType mIRPropertyType = iterator.next();
            if (mIRObject.isInstanceOf((short)59) && !this.checkDesignLevel((MIRModelObject)mIRObject, mIRPropertyType)) continue;
            arrayList.add(mIRPropertyType);
        }
        return arrayList.toArray(new MIRPropertyType[arrayList.size()]);
    }

    @Override
    public ObjectDefinition getInternalContentId(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2) {
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        if (mIRObject != null && mIRObject instanceof MIRModel) {
            MIRContent mIRContent = ((MIRModel)mIRObject).getContent();
            return this.cache.getObjectDefinition(mIRContent);
        }
        return null;
    }

    @Override
    public ObjectDefinition getRoot(ObjectDefinition objectDefinition) {
        MIRObject mIRObject = this.cache.getMirObject(objectDefinition);
        MIRModel mIRModel = mIRObject.getRootModel();
        return this.cache.getObjectDefinition(mIRModel);
    }

    @Override
    public short getObjectType(ObjectIdentifier objectIdentifier) {
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        return mIRObject.getElementType();
    }

    @Override
    public ObjectDefinition getParent(ObjectDefinition objectDefinition) {
        MIRObject mIRObject = this.cache.getMirObject(objectDefinition);
        return this.cache.getObjectDefinition(mIRObject.getParent());
    }

    @Override
    public ObjectDefinition[] get(ObjectDefinition[] objectDefinitionArray, AttributeIdentifier[] attributeIdentifierArray) throws MIRException {
        ObjectDefinition[] objectDefinitionArray2 = new ObjectDefinition[objectDefinitionArray.length];
        for (int i = 0; i < objectDefinitionArray.length; ++i) {
            objectDefinitionArray2[i] = this.get(objectDefinitionArray[i], attributeIdentifierArray);
        }
        return objectDefinitionArray2;
    }

    public ObjectDefinition getObjectDefinition(MIRObject mIRObject) {
        return this.cache.getObjectDefinition(mIRObject);
    }

    @Override
    public String getAutoProfile(ObjectIdentifier objectIdentifier) throws MIRException {
        MIRProfile mIRProfile;
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        MIRModel mIRModel = mIRObject.getRootModel();
        MIRMetadataOrigin mIRMetadataOrigin = mIRModel.getMetadataOrigin();
        if (mIRMetadataOrigin != null && (mIRProfile = MIRProfiler.getProfile(mIRMetadataOrigin.getProfileId())) != null) {
            return mIRProfile.getName();
        }
        return "Meta Integration";
    }

    @Override
    public AttributeValue getAttributeValue(ObjectIdentifier objectIdentifier, AttributeIdentifier attributeIdentifier) throws MIRException {
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
        if (mIRObject == null) {
            return null;
        }
        AttributeValue attributeValue = this.buildAttributeValue(mIRObject, attributeIdentifier);
        return attributeValue;
    }

    public ObjectDefinition getUdpDefinition(ObjectIdentifier objectIdentifier, AttributeIdentifier attributeIdentifier) {
        if (attributeIdentifier._isUdp()) {
            MIRObject mIRObject = this.cache.getMirObject(objectIdentifier);
            MIRPropertyElementTypeScope mIRPropertyElementTypeScope = this.getUdpScope(mIRObject);
            if (mIRPropertyElementTypeScope == null) {
                return null;
            }
            Iterator<MIRPropertyType> iterator = mIRPropertyElementTypeScope.getPropertyTypeIterator();
            while (iterator.hasNext()) {
                MIRPropertyType mIRPropertyType = iterator.next();
                if (!mIRPropertyType.getFullName().equals(attributeIdentifier.getName())) continue;
                ObjectDefinition objectDefinition = this.getObjectDefinition(mIRPropertyType);
                return objectDefinition;
            }
        }
        return null;
    }

    private class GetObjectByType
    implements MIR_Object.MIRTraversalOperation {
        HashSet<Short> objectTypes = new HashSet();
        ArrayList<MIRObject> results = new ArrayList();
        private ObjectIdentifier root;

        public GetObjectByType(MIRObject mIRObject, short[] sArray) {
            this.root = MemoryDataProvider.this.cache.getObjectIdentifier(mIRObject);
            if (sArray != null) {
                for (short s : sArray) {
                    this.objectTypes.add(new Short(s));
                }
            }
        }

        @Override
        public boolean traverse(MIRObject mIRObject) {
            ObjectIdentifier objectIdentifier = MemoryDataProvider.this.cache.getObjectIdentifier(mIRObject);
            return objectIdentifier != null && objectIdentifier.getModelId() == this.root.getModelId();
        }

        @Override
        public void pre_process(MIRObject mIRObject, boolean bl) {
            if (this.objectTypes.contains(new Short(mIRObject.getElementType()))) {
                this.results.add(mIRObject);
            }
        }

        @Override
        public void post_process(MIRObject mIRObject) {
        }

        public MIRObject[] getResults() {
            return this.results.toArray(new MIRObject[this.results.size()]);
        }
    }
}

