/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles;

import MITI.MIRException;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIR_Object;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProfilePreProcessor {
    private Element root;
    private HashMap<String, Element> defines;
    private File rootFile;
    private HashSet<File> filesLoaded = new HashSet();

    public ProfilePreProcessor(File file, Element element) {
        this.rootFile = file;
        this.root = element;
    }

    public Element run() throws MIRException {
        Element element;
        ArrayList<Element> arrayList = this.getChildrenByTagName(this.root, "Include");
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element2 = arrayList.get(i);
            this.loadIncludedFile(element2, element2.getAttribute("fileName"));
        }
        this.defines = new HashMap();
        ArrayList<Element> arrayList2 = this.getChildrenByTagName(this.root, "Define");
        for (int i = 0; i < arrayList2.size(); ++i) {
            Element object2 = arrayList2.get(i);
            String string = object2.getAttribute("name");
            element = this.defines.get(string);
            if (element == null) {
                this.defines.put(string, object2);
                continue;
            }
            this.mergeElements(element, object2);
        }
        for (Element element2 : this.defines.values()) {
            this.expandEntity(element2);
        }
        Object object3 = null;
        ArrayList<Element> arrayList3 = this.getChildrenByTagName(this.root, "Entity");
        for (int i = 0; i < arrayList3.size(); ++i) {
            String string;
            element = arrayList3.get(i);
            this.expandEntity(element);
            short s = MIRElementType.getByName(element.getAttribute("class"));
            if (MIR_Object.isInstanceOf(s, (short)159)) {
                element.setAttribute("profileName", this.rootFile.getName().substring(0, this.rootFile.getName().length() - 4));
            }
            if ("Repository".equals(string = element.getAttribute("name"))) {
                object3 = string;
                continue;
            }
            if (object3 != null || s != 286) continue;
            object3 = string;
        }
        this.root.setAttribute("profileModel", (String)object3);
        return this.root;
    }

    private void mergeElements(Element element, Element element2) {
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            element.appendChild(node);
        }
    }

    protected void printChildren(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            System.out.println(element2.getTagName() + ": " + element2.getAttribute("name") + element2.getAttribute("path"));
        }
    }

    private void expandEntity(Element element) throws MIRException {
        Node node;
        Object object;
        Object object2;
        boolean bl;
        String string = element.getAttribute("includeClass");
        boolean bl2 = bl = string == null ? false : Boolean.parseBoolean(string);
        if (bl) {
            this.expandInclude(element.getAttribute("class"), element, this.getNextElement(element, element.getFirstChild()));
        }
        NodeList nodeList = element.getElementsByTagName("Include");
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            object2 = (Element)nodeList.item(i);
            object = object2.getAttribute("name");
            this.expandInclude((String)object, element, this.getNextElement(element, (Node)object2));
            element.removeChild((Node)object2);
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        object2 = new ArrayList();
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            node = object.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string2 = element2.getTagName();
            if (string2.equals("Property")) {
                arrayList.add(element2);
                continue;
            }
            if (string2.equals("Link")) {
                arrayList.add(element2);
                continue;
            }
            if (string2.equals("ReplaceProperty")) {
                this.replaceChild(element, arrayList, (ArrayList<Node>)object2, element2, "name");
                continue;
            }
            if (string2.equals("RemoveProperty")) {
                this.removeChild(element, arrayList, (ArrayList<Node>)object2, element2, "name");
                continue;
            }
            if (string2.equals("RemoveLink")) {
                this.removeChild(element, arrayList, (ArrayList<Node>)object2, element2, "path");
                continue;
            }
            if (string2.equals("MoveProperty")) {
                this.moveChild(element, arrayList, element2, "Property", "name");
                continue;
            }
            if (!string2.equals("MoveLink")) continue;
            this.moveChild(element, arrayList, element2, "Link", "path");
        }
        Iterator iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            node = (Node)iterator.next();
            element.removeChild(node);
        }
    }

    private void moveChild(Element element, ArrayList<Element> arrayList, Element element2, String string, String string2) {
        String string3 = element2.getAttribute(string2);
        String string4 = element2.getAttribute("position");
        int n = Integer.parseInt(string4);
        Element element3 = null;
        Element element4 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element && string3.equals(((Element)node).getAttribute(string2))) {
                element3 = (Element)node;
            }
            if (i != n) continue;
            element4 = (Element)node;
        }
        if (element3 != null) {
            element.insertBefore(element3, element4);
            arrayList.remove(element3);
            arrayList.add(n, element3);
        }
    }

    private void removeChild(Element element, ArrayList<Element> arrayList, ArrayList<Node> arrayList2, Element element2, String string) {
        String string2 = element2.getAttribute(string);
        String string3 = element2.getTagName().substring(new String("Remove").length());
        for (Element element3 : arrayList) {
            if (!string3.equals(element3.getTagName()) || !string2.equals(element3.getAttribute(string))) continue;
            arrayList2.add(element3);
            break;
        }
        arrayList2.add(element2);
    }

    private void replaceChild(Element element, ArrayList<Element> arrayList, ArrayList<Node> arrayList2, Element element2, String string) {
        String string2 = element2.getAttribute(string);
        String string3 = element2.getTagName().substring(new String("Replace").length());
        for (Element element3 : arrayList) {
            if (!string3.equals(element3.getTagName()) || !string2.equals(element3.getAttribute(string))) continue;
            NamedNodeMap namedNodeMap = element2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string4 = namedNodeMap.item(i).getNodeName();
                String string5 = namedNodeMap.item(i).getNodeValue();
                element3.setAttribute(string4, string5);
            }
        }
        arrayList2.add(element2);
    }

    private ArrayList<Element> getChildrenByTagName(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).getTagName().equals(string)) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    private void loadIncludedFile(Element element, String string) throws MIRException {
        try {
            File file = new File(this.rootFile.getParentFile(), string);
            if (this.filesLoaded.contains(file)) {
                return;
            }
            this.filesLoaded.add(file);
            Document document = this.createXMLDocument(file);
            Element element2 = document.getDocumentElement();
            NodeList nodeList = element2.getChildNodes();
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element3 = (Element)node;
                if (element3.getTagName().equals("Define")) {
                    this.loadDefine(element, element3);
                    continue;
                }
                if (element3.getTagName().equals("Entity")) {
                    this.loadEntity(element, element3);
                    continue;
                }
                if (!element3.getTagName().equals("Include")) continue;
                this.loadIncludedFile(element, element3.getAttribute("fileName"));
            }
        }
        catch (Exception exception) {
            throw new MIRException(exception);
        }
    }

    private void loadDefine(Element element, Element element2) {
        Node node = this.getNextElementByType(element, "Define");
        if (node == null) {
            node = this.getNextElementByType(element, "Entity");
        }
        Document document = element.getOwnerDocument();
        Node node2 = document.importNode(element2, true);
        this.addOrAppendChild(this.root, node2, node);
    }

    private void loadEntity(Element element, Element element2) {
        Node node = this.getNextElementByType(element, "Entity");
        Document document = element.getOwnerDocument();
        Node node2 = document.importNode(element2, true);
        this.addOrAppendChild(this.root, node2, node);
    }

    private void addOrAppendChild(Element element, Node node, Node node2) {
        if (node2 == null) {
            element.appendChild(node);
        } else {
            element.insertBefore(node, node2);
        }
    }

    protected Document createXMLDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    private void expandInclude(String string, Element element, Node node) throws MIRException {
        Element element2 = this.getDefine(string);
        if (element2 == null) {
            throw new MIRException("Include [" + string + "] not found for element [" + element.getAttribute("name") + "]");
        }
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            Element element3 = (Element)node2;
            String string2 = element3.getTagName();
            if (string2.equals("Include")) {
                this.expandInclude(element3.getAttribute("name"), element, node);
                continue;
            }
            Node node3 = element3.cloneNode(true);
            this.addOrAppendChild(element, node3, node);
        }
    }

    private Node getNextElement(Node node, Node node2) {
        if (node2 == null) {
            return node.getFirstChild();
        }
        Node node3 = null;
        while ((node3 = node2.getNextSibling()) != null) {
            if (node3 instanceof Element) {
                return node3;
            }
            node2 = node3;
        }
        return null;
    }

    private Node getNextElementByType(Node node, String string) {
        Node node2 = null;
        while ((node2 = node.getNextSibling()) != null) {
            Element element;
            if (node2 instanceof Element && (element = (Element)node2).getTagName().equals(string)) {
                return element;
            }
            node = node2;
        }
        return null;
    }

    private Element getDefine(String string) throws MIRException {
        if (string == null || string.length() == 0) {
            throw new MIRException("Include without a name");
        }
        return this.defines.get(string);
    }
}

