/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles;

import MITI.MIRException;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.LinkIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;

public class MIRProfileLinkList {
    private HashMap<MIRProfileLink, MIRProfileLink> links = null;

    public void addLink(MIRProfileLink mIRProfileLink) throws MIRException {
        if (this.links == null) {
            this.links = new HashMap();
        }
        this.links.put(mIRProfileLink, mIRProfileLink);
        mIRProfileLink.setPosition(this.links.size());
    }

    int getCount() {
        if (this.links == null) {
            return 0;
        }
        return this.links.size();
    }

    AttributeIdentifier[] getListAttributes(boolean bl) {
        if (this.links == null) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (MIRProfileLink mIRProfileLink : this.links.values()) {
            MIRProfileEntity[] mIRProfileEntityArray;
            AttributeIdentifier attributeIdentifier = mIRProfileLink.getOrderBy();
            if (attributeIdentifier != null) {
                hashSet.add(attributeIdentifier);
            }
            for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray = mIRProfileLink.getChildren()) {
                Object object;
                AttributeIdentifier[] attributeIdentifierArray;
                AttributeIdentifier[] attributeIdentifierArray2 = attributeIdentifierArray = bl ? mIRProfileEntity.getAttributes() : mIRProfileEntity.getConditionAttributes();
                if (attributeIdentifierArray != null) {
                    object = attributeIdentifierArray;
                    int n = ((AttributeIdentifier[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Object object2 = object[i];
                        hashSet.add(object2);
                    }
                }
                if ((object = mIRProfileEntity.getAttributeByName("Name")) == null || ((AttributeIdentifier)object).getId() == 174) continue;
                hashSet.add(object);
            }
        }
        return hashSet.toArray(new AttributeIdentifier[hashSet.size()]);
    }

    public MIRProfileLink[] getProfileLinks(LinkIdentifier linkIdentifier) {
        if (this.links == null) {
            return null;
        }
        ArrayList<MIRProfileLink> arrayList = new ArrayList<MIRProfileLink>();
        for (MIRProfileLink mIRProfileLink : this.links.keySet()) {
            if (!mIRProfileLink.getLinkIdentifier().equals(linkIdentifier)) continue;
            arrayList.add(mIRProfileLink);
        }
        return arrayList.toArray(new MIRProfileLink[arrayList.size()]);
    }

    public MIRProfileLink getProfileLink(LinkIdentifier linkIdentifier, MIRProfileEntity mIRProfileEntity) {
        if (this.links == null) {
            return null;
        }
        for (MIRProfileLink mIRProfileLink : this.links.keySet()) {
            if (!mIRProfileLink.getLinkIdentifier().equals(linkIdentifier) || !mIRProfileLink.containsChild(mIRProfileEntity)) continue;
            return mIRProfileLink;
        }
        return null;
    }

    MIRProfileLink[] getProfileLinks() {
        if (this.links == null) {
            return null;
        }
        TreeSet<MIRProfileLink> treeSet = new TreeSet<MIRProfileLink>(MIRProfileLink.getComparator());
        treeSet.addAll(this.links.values());
        return treeSet.toArray(new MIRProfileLink[treeSet.size()]);
    }

    LinkIdentifier[] getLinkIdentifiers() {
        if (this.links == null) {
            return null;
        }
        HashSet<LinkIdentifier> hashSet = new HashSet<LinkIdentifier>();
        for (MIRProfileLink mIRProfileLink : this.links.keySet()) {
            hashSet.add(mIRProfileLink.getLinkIdentifier());
        }
        return hashSet.toArray(new LinkIdentifier[hashSet.size()]);
    }

    boolean exists(MIRProfileLink mIRProfileLink) {
        if (this.links == null) {
            return false;
        }
        return this.links.get(mIRProfileLink) != null;
    }
}

