/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles;

import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.LinkIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class MIRProfileLink {
    private static Comparator<MIRProfileLink> linkComparator = new Comparator<MIRProfileLink>(){

        @Override
        public int compare(MIRProfileLink mIRProfileLink, MIRProfileLink mIRProfileLink2) {
            return mIRProfileLink.position - mIRProfileLink2.position;
        }
    };
    private MIRProfileEntity ownerEntity = null;
    private MIRProfileGroup ownerGroup = null;
    private LinkIdentifier id = null;
    private String roleName = null;
    private String groupName = null;
    private int position = 0;
    private AttributeIdentifier orderBy = null;
    private byte type = 0;
    private String[] supplierEntities = null;
    private MIRProfileEntity[] children;

    public static Comparator<MIRProfileLink> getComparator() {
        return linkComparator;
    }

    public LinkIdentifier getLinkIdentifier() {
        return this.id;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getPosition() {
        return this.position;
    }

    public String getPath() {
        return this.id.toMPath();
    }

    public boolean isDestinationUnary() {
        return this.id.unary();
    }

    public AttributeIdentifier getOrderBy() {
        return this.orderBy;
    }

    public final byte getType() {
        return this.type;
    }

    public final boolean isChildLinkType() {
        return 3 == this.type;
    }

    public MIRProfileEntity[] getAllChildren() {
        MIRMetaClass[] mIRMetaClassArray;
        ArrayList<MIRProfileEntity> arrayList = new ArrayList<MIRProfileEntity>();
        MIRMetaLink mIRMetaLink = MIRMetaLink.getByAssociationType(this.id.getAssociations()[this.id.getAssociations().length - 1].getAssociationType());
        for (MIRMetaClass mIRMetaClass : mIRMetaClassArray = this.getAllConcreteClasses(mIRMetaLink.getReverse().getOwner())) {
            MIRProfileEntity[] mIRProfileEntityArray = this.ownerEntity.getProfile().getProfileEntities(mIRMetaClass.getID());
            if (mIRProfileEntityArray == null) continue;
            for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray) {
                arrayList.add(mIRProfileEntity);
            }
        }
        MIRProfileEntity[] mIRProfileEntityArray = arrayList.toArray(new MIRProfileEntity[arrayList.size()]);
        return mIRProfileEntityArray;
    }

    public MIRProfileEntity[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        ArrayList<MIRProfileEntity> arrayList = new ArrayList<MIRProfileEntity>();
        if (this.supplierEntities != null && this.supplierEntities.length > 0) {
            for (String string : this.supplierEntities) {
                MIRProfileEntity mIRProfileEntity = this.ownerEntity.getProfile().getProfileEntity(string);
                if (mIRProfileEntity == null) continue;
                if (mIRProfileEntity.getCondition() == null) {
                    arrayList.add(mIRProfileEntity);
                    continue;
                }
                arrayList.add(0, mIRProfileEntity);
            }
        } else {
            MIRMetaClass[] mIRMetaClassArray;
            MIRMetaLink mIRMetaLink = MIRMetaLink.getByAssociationType(this.id.getAssociations()[this.id.getAssociations().length - 1].getAssociationType());
            for (MIRMetaClass mIRMetaClass : mIRMetaClassArray = this.getAllConcreteClasses(mIRMetaLink.getReverse().getOwner())) {
                MIRProfileEntity[] mIRProfileEntityArray = this.ownerEntity.getProfile().getProfileEntities(mIRMetaClass.getID());
                if (mIRProfileEntityArray == null) continue;
                for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray) {
                    arrayList.add(mIRProfileEntity);
                }
            }
        }
        this.children = arrayList.toArray(new MIRProfileEntity[arrayList.size()]);
        return this.children;
    }

    public MIRProfileLink(LinkIdentifier linkIdentifier, MIRProfileEntity mIRProfileEntity, MIRProfileGroup mIRProfileGroup, String string) {
        this.id = linkIdentifier;
        this.ownerEntity = mIRProfileEntity;
        this.ownerGroup = mIRProfileGroup;
        if (string != null && string.length() > 0) {
            this.supplierEntities = string.split(";");
        }
    }

    public MIRProfileEntity getOwner() {
        return this.ownerEntity;
    }

    public MIRProfileGroup getOwnerGroup() {
        return this.ownerGroup;
    }

    public String[] getSupplierEntities() {
        return this.supplierEntities;
    }

    public void setRoleName(String string) {
        if (string != null) {
            this.roleName = string;
        }
    }

    public void setGroupName(String string) {
        if (string != null) {
            this.groupName = string;
        }
    }

    void setPosition(int n) {
        this.position = n;
    }

    public void setType(boolean bl) {
        if (bl) {
            this.type = (byte)3;
        }
    }

    public void setOrderBy(AttributeIdentifier attributeIdentifier) {
        this.orderBy = attributeIdentifier;
    }

    private MIRMetaClass[] getAllConcreteClasses(MIRMetaClass mIRMetaClass) {
        ArrayList<MIRMetaClass> arrayList = new ArrayList<MIRMetaClass>();
        if (!mIRMetaClass.isAbstract()) {
            arrayList.add(mIRMetaClass);
        }
        for (int n = 0; n < mIRMetaClass.getChildCount(); n = (int)((byte)(n + 1))) {
            arrayList.addAll(Arrays.asList(this.getAllConcreteClasses(mIRMetaClass.getChild(n))));
        }
        return arrayList.toArray(new MIRMetaClass[arrayList.size()]);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        n = 31 * n + (this.ownerEntity == null ? 0 : this.ownerEntity.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MIRProfileLink mIRProfileLink = (MIRProfileLink)object;
        if (this.id == null ? mIRProfileLink.id != null : !this.id.equals(mIRProfileLink.id)) {
            return false;
        }
        if (this.ownerEntity == null ? mIRProfileLink.ownerEntity != null : !this.ownerEntity.equals(mIRProfileLink.ownerEntity)) {
            return false;
        }
        if (this.ownerGroup == null ? mIRProfileLink.ownerGroup != null : !this.ownerGroup.equals(mIRProfileLink.ownerGroup)) {
            return false;
        }
        return !(this.supplierEntities == null ? mIRProfileLink.supplierEntities != null : !Arrays.equals(this.supplierEntities, mIRProfileLink.supplierEntities));
    }

    public boolean containsChild(MIRProfileEntity mIRProfileEntity) {
        for (MIRProfileEntity mIRProfileEntity2 : this.children = this.getChildren()) {
            if (!mIRProfileEntity2.equals(mIRProfileEntity)) continue;
            return true;
        }
        return false;
    }
}

