/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles;

import MITI.MIRException;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.mpath.Parser;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.MIRProfileProperty;
import MITI.sdk.profiles.Validator.MIRValidUtils;
import MITI.sdk.profiles.impl.MIRProfileId;
import MITI.sdk.profiles.impl.MIRProfiler;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.Condition;
import MITI.server.services.common.mir.LinkIdentifier;
import MITI.server.services.common.mir.LinkPart;
import MITI.util.XmlUtil;
import MITI.util.log.MIRLogger;
import MITI.util.text.MessageLiteral;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class MIRProfile {
    private HashMap<String, MIRProfileEntity> entities = null;
    private HashMap<Integer, MIRProfileEntity> idToEntity = new HashMap();
    private ArrayList<TreeSet<MIRProfileEntity>> sortedEntitiesByType = null;
    private String name = null;
    private String path = null;
    public boolean isErrorsInProfile;
    public boolean isWarningsInProfile;
    private int profileId = 0;
    private MIRProfileEntity rootProfileEntity;
    static HashSet<String> ignoredProfilesForWarnings = new HashSet();

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public int getEntityCount() {
        if (this.entities == null) {
            return 0;
        }
        return this.entities.size();
    }

    public MIRProfileEntity[] getProfileEntities() {
        if (this.entities == null) {
            return null;
        }
        TreeSet<MIRProfileEntity> treeSet = new TreeSet<MIRProfileEntity>(MIRProfileEntity.getComparator());
        treeSet.addAll(this.entities.values());
        return treeSet.toArray(new MIRProfileEntity[treeSet.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MIRProfile load(File file) throws MIRException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            MIRProfile mIRProfile = new MIRProfile(fileInputStream);
            return mIRProfile;
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }

    public static MIRProfile load(InputStream inputStream) {
        return inputStream != null ? new MIRProfile(inputStream) : null;
    }

    private MIRProfile(InputStream inputStream) {
        try {
            DocumentBuilder documentBuilder = XmlUtil.getDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            this.loadProfile(document.getDocumentElement());
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void loadProfile(Element element) throws MIRException {
        Element element2;
        int n;
        this.name = element.getAttribute("name");
        PRFLR.LOADING_PROFILE.log(this.name);
        this.profileId = Integer.parseInt(element.getAttribute("id"));
        this.entities = new HashMap();
        NodeList nodeList = element.getElementsByTagName("Entity");
        for (n = 0; n < nodeList.getLength(); ++n) {
            element2 = (Element)nodeList.item(n);
            this.loadProfileEntity(element2, true);
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            element2 = (Element)nodeList.item(n);
            this.loadProfileGroupsAndLinks(element2);
        }
        String string = element.getAttribute("profileModel");
        this.rootProfileEntity = this.getProfileEntity(string);
        if (this.rootProfileEntity == null) {
            this.handleError(PRFLR.ROOT_ENTITY_DOES_NOT_EXIST.getMessage(string));
        }
        this.buildPaths();
    }

    private void buildPaths() throws MIRException {
        for (MIRProfileEntity mIRProfileEntity : this.entities.values()) {
            MIRProfileEntity[] mIRProfileEntityArray;
            int n;
            Object[] objectArray;
            MIRProfileLink[] mIRProfileLinkArray = mIRProfileEntity.getProfileLinks();
            if (mIRProfileLinkArray != null) {
                objectArray = mIRProfileLinkArray;
                int n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    Object object = objectArray[n];
                    if (!((MIRProfileLink)object).isChildLinkType()) continue;
                    mIRProfileEntityArray = ((MIRProfileLink)object).getChildren();
                    for (MIRProfileEntity mIRProfileEntity2 : mIRProfileEntityArray) {
                        mIRProfileEntity2.addParentLink((MIRProfileLink)object);
                    }
                }
            }
            if ((objectArray = mIRProfileEntity.getProfileGroups()) == null) continue;
            Object[] objectArray2 = objectArray;
            n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                mIRProfileEntityArray = objectArray2[i];
                mIRProfileLinkArray = mIRProfileEntityArray.getProfileLinks();
                if (mIRProfileLinkArray == null) continue;
                for (MIRProfileLink mIRProfileLink : mIRProfileLinkArray) {
                    MIRProfileEntity[] mIRProfileEntityArray2;
                    if (!mIRProfileLink.isChildLinkType()) continue;
                    for (MIRProfileEntity mIRProfileEntity3 : mIRProfileEntityArray2 = mIRProfileLink.getChildren()) {
                        mIRProfileEntity3.addParentLink(mIRProfileLink);
                    }
                }
            }
        }
    }

    private void loadProfileEntity(Element element, boolean bl) throws MIRException {
        MIRProfileEntity[] mIRProfileEntityArray;
        Object object;
        String string;
        Object object2;
        String string2 = element.getAttribute("name");
        if (string2 == null || string2.length() == 0) {
            this.handleError(element, "", "name", PRFLR.ERR_INVALID_ATTRIBUTE_ON_ENTITY);
            return;
        }
        if (this.getProfileEntity(string2) != null && !this.ignoredProfile()) {
            this.handleError(element, string2, "name", PRFLR.ERR_INVALID_ATTRIBUTE_ON_ENTITY_DUPLICATE);
            return;
        }
        String string3 = element.getAttribute("class");
        if (string3 == null || string3.length() == 0) {
            this.handleError(element, string2, "class", PRFLR.ERR_INVALID_ATTRIBUTE_ON_ENTITY);
            return;
        }
        MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(MIRElementType.getByName(string3));
        if (mIRMetaClass == null || mIRMetaClass.isAbstract()) {
            this.handleError(element, string2, "class", PRFLR.ERR_INVALID_ATTRIBUTE_ON_ENTITY);
            return;
        }
        int n = -1;
        int n2 = this.entities.size() + 1;
        n = MIRProfiler.isMetaIntegrationProfile(this.name) ? (int)mIRMetaClass.getID() : MIRProfileId.getId(this.profileId, ((String)(object2 = element.getAttribute("id"))).isEmpty() ? n2 : Integer.parseInt((String)object2));
        object2 = new MIRProfileEntity(string2, mIRMetaClass.getID(), this, n, n2);
        ((MIRProfileEntity)object2).setIcon(element.getAttribute("icon"));
        ((MIRProfileEntity)object2).setSearchGroup(element.getAttribute("searchGroup"));
        ((MIRProfileEntity)object2).setExcluded("true".equals(element.getAttribute("exclude")));
        if (mIRMetaClass.isSubClassOf((short)159)) {
            if (element.hasAttribute("profileName")) {
                ((MIRProfileEntity)object2).setContentProfile(element.getAttribute("profileName"));
            } else if (bl) {
                this.handleError(element, string2, "profileName", PRFLR.ERR_INVALID_ATTRIBUTE_ON_ENTITY);
            }
        }
        if ((string = element.getAttribute("condition")) != null && string.length() != 0) {
            object = Parser.parseCondition(((MIRProfileEntity)object2).getElementType(), string);
            if (object == null) {
                this.handleError(element, string2, "condition", PRFLR.ERR_INVALID_ATTRIBUTE_ON_ENTITY);
                return;
            }
            ((MIRProfileEntity)object2).setCondition((Condition)object);
        }
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            MIRProfileEntity[] mIRProfileEntityArray2;
            mIRProfileEntityArray = object.item(i);
            if (!(mIRProfileEntityArray instanceof Element) || !(mIRProfileEntityArray2 = (MIRProfileEntity[])mIRProfileEntityArray).getTagName().equals("Property")) continue;
            this.loadProfileAttribute((MIRProfileEntity)object2, (Element)mIRProfileEntityArray2);
        }
        if (((MIRProfileEntity)object2).getAttributeCount() == 0) {
            this.handleError(element, ((MIRProfileEntity)object2).getName(), "", PRFLR.ERR_MISSING_ATTR);
            return;
        }
        AttributeIdentifier attributeIdentifier = ((MIRProfileEntity)object2).getAttributeByName("Name");
        if (attributeIdentifier == null && !this.ignoredProfile()) {
            this.handleError(element, ((MIRProfileEntity)object2).getName(), "Name", PRFLR.ENTITY_NO_NAME_ATTRIBUTE);
            return;
        }
        if (!MIRValidUtils.isValidClass(((MIRProfileEntity)object2).getElementType()) && !this.ignoredProfile()) {
            this.handleWarning(element, ((MIRProfileEntity)object2).getName(), "class", PRFLR.ERR_INVALID_ATTRIBUTE_ON_ENTITY);
        }
        if ((mIRProfileEntityArray = this.getProfileEntities(mIRMetaClass.getElementType())) != null) {
            for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray) {
                if ((mIRProfileEntity.getCondition() != null || ((MIRProfileEntity)object2).getCondition() != null) && (mIRProfileEntity.getCondition() == null || !mIRProfileEntity.getCondition().equals(((MIRProfileEntity)object2).getCondition()))) continue;
                if (!this.ignoredProfile()) {
                    this.handleWarning(PRFLR.WARN_DUPLICATE_ENTITY_WITH_SAME_CONDITION.getMessage(((MIRProfileEntity)object2).getName(), mIRProfileEntity.getName()));
                }
                return;
            }
        }
        this.addProfileEntity((MIRProfileEntity)object2);
    }

    private void loadProfileGroupsAndLinks(Element element) throws MIRException {
        String string = element.getAttribute("name");
        if (string == null || string.length() == 0) {
            this.handleError(element, "", "name", PRFLR.ERR_INVALID_ATTRIBUTE_ON_ENTITY);
            return;
        }
        MIRProfileEntity mIRProfileEntity = this.getProfileEntity(string);
        if (mIRProfileEntity == null) {
            return;
        }
        int n = 0;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (element2.getTagName().equals("Link")) {
                object = this.loadProfileLink(mIRProfileEntity, null, element2);
                if (object == null) continue;
                ((MIRProfileLink)object).setPosition(n++);
                continue;
            }
            if (!element2.getTagName().equals("Group") || (object = this.loadProfileGroup(mIRProfileEntity, element2)) == null) continue;
            ((MIRProfileGroup)object).setPosition(n++);
        }
    }

    private boolean ignoredProfile() {
        return MIRProfiler.isMetaIntegrationProfile(this.getName()) || ignoredProfilesForWarnings.contains(this.getName());
    }

    private void loadProfileAttribute(MIRProfileEntity mIRProfileEntity, Element element) throws MIRException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("path");
        if (string2 == null || string2.length() == 0) {
            return;
        }
        AttributeIdentifier attributeIdentifier = Parser.parseAttribute(mIRProfileEntity.getElementType(), string2);
        if (attributeIdentifier == null) {
            this.handleError(element, mIRProfileEntity.getName(), string, PRFLR.ERR_INVALID_PATH_ON_ATTRIBUTE);
            return;
        }
        if (mIRProfileEntity.getProfileAttribute(attributeIdentifier) != null) {
            this.handleError(element, mIRProfileEntity.getName(), string, PRFLR.ERR_DUPLICATE_ATTR);
            return;
        }
        if (mIRProfileEntity.getAttributeByName(string) != null) {
            this.handleError(element, mIRProfileEntity.getName(), string, PRFLR.ERR_DUPLICATE_ATTR);
            return;
        }
        MIRProfileProperty mIRProfileProperty = new MIRProfileProperty(attributeIdentifier, mIRProfileEntity);
        mIRProfileProperty.setName(string);
    }

    private MIRProfileGroup loadProfileGroup(MIRProfileEntity mIRProfileEntity, Element element) throws MIRException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("icon");
        String string3 = element.getAttribute("showWhenHasChildren");
        boolean bl = false;
        if (string3 != null) {
            bl = Boolean.parseBoolean(string3);
        }
        if (mIRProfileEntity.getGroups() != null && mIRProfileEntity.getGroups().get(string) != null && !this.ignoredProfile()) {
            this.handleError(element, mIRProfileEntity.getName(), string, PRFLR.ERR_INVALID_GROUP);
        }
        MIRProfileGroup mIRProfileGroup = new MIRProfileGroup(mIRProfileEntity, string, string2, bl);
        int n = 0;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MIRProfileLink mIRProfileLink;
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).getTagName().equals("Link") || (mIRProfileLink = this.loadProfileLink(mIRProfileEntity, mIRProfileGroup, element2)) == null) continue;
            mIRProfileLink.setPosition(n++);
        }
        mIRProfileEntity.addGroup(mIRProfileGroup);
        return mIRProfileGroup;
    }

    private MIRProfileLink loadProfileLink(MIRProfileEntity mIRProfileEntity, MIRProfileGroup mIRProfileGroup, Element element) throws MIRException {
        Object object;
        HashSet<MIRMetaLink> hashSet;
        boolean bl;
        String string;
        String string2 = mIRProfileEntity.getName();
        if (mIRProfileGroup != null) {
            string2 = string2 + ":" + mIRProfileGroup.getName();
        }
        if ((string = element.getAttribute("roleName")).isEmpty()) {
            string = element.getAttribute("name");
        }
        String string3 = element.getAttribute("groupName");
        String string4 = element.getAttribute("path");
        String string5 = element.getAttribute("entities");
        String string6 = element.getAttribute("isAggregation");
        boolean bl2 = bl = string6 != null && string6.compareToIgnoreCase("true") == 0;
        if (string4 == null || string4.length() == 0) {
            hashSet = this.getMIRLinks(mIRProfileEntity, string5, bl);
            if (hashSet.size() == 1) {
                string4 = ((MIRMetaLink)hashSet.iterator().next()).getName();
                object = mIRProfileEntity.getName();
                if (mIRProfileGroup != null) {
                    object = (String)object + ":" + mIRProfileGroup.getName();
                }
            } else {
                if (hashSet.size() == 0) {
                    this.handleError(element, string2, "[" + string4 + "] to [" + string5 + "]", PRFLR.ERR_INVALID_LINK);
                } else {
                    this.isErrorsInProfile = true;
                    Object[] objectArray = new String[hashSet.size()];
                    int n = 0;
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        objectArray[n++] = ((MIRMetaLink)iterator.next()).getName();
                    }
                    PRFLR.ERR_MULTIPLE_LINKS_POSSIBLE.log(MIRLogger.getLogger(), string2, string5, Arrays.toString(objectArray));
                }
                return null;
            }
        }
        if ((hashSet = Parser.parseLink(mIRProfileEntity.getElementType(), string4)) == null) {
            this.handleError(element, string2, string4, PRFLR.ERR_INVALID_LINK);
            return null;
        }
        for (LinkPart linkPart : ((LinkIdentifier)((Object)hashSet)).getAssociations()) {
            if (linkPart.getAssociationType() >= 0 || linkPart.getAssociationType() == -2 || linkPart.getAssociationType() == -7) continue;
            this.handleError(element, string2, string4, PRFLR.ERR_INVALID_LINK);
        }
        object = new MIRProfileLink((LinkIdentifier)((Object)hashSet), mIRProfileEntity, mIRProfileGroup, string5);
        ((MIRProfileLink)object).setType(bl);
        if (mIRProfileGroup != null) {
            mIRProfileGroup.addLink((MIRProfileLink)object);
        } else {
            mIRProfileEntity.addLink((MIRProfileLink)object);
        }
        ((MIRProfileLink)object).setRoleName(string);
        ((MIRProfileLink)object).setGroupName(string3);
        String string7 = element.getAttribute("orderBy");
        if (string7 != null && string7.length() != 0) {
            AttributeIdentifier attributeIdentifier = null;
            attributeIdentifier = string7.startsWith("@") ? Parser.parseAttribute(((MIRProfileLink)object).getLinkIdentifier().destinationElementType(), string7) : Parser.parseAttribute(mIRProfileEntity.getElementType(), string7);
            if (attributeIdentifier == null) {
                this.handleError(element, string2, string7, PRFLR.ERR_INVALID_PATH_ON_ATTRIBUTE);
            }
            ((MIRProfileLink)object).setOrderBy(attributeIdentifier);
        }
        return object;
    }

    private HashSet<MIRMetaLink> getMIRLinks(MIRProfileEntity mIRProfileEntity, String string, boolean bl) {
        HashSet<MIRMetaLink> hashSet = new HashSet<MIRMetaLink>();
        short s = mIRProfileEntity.getElementType();
        HashSet<Short> hashSet2 = new HashSet<Short>();
        String[] stringArray = string.split(";");
        for (String string2 : stringArray) {
            MIRProfileEntity mIRProfileEntity2 = this.getProfileEntity(string2);
            if (mIRProfileEntity2 == null) continue;
            hashSet2.add(mIRProfileEntity2.getElementType());
        }
        Object object = null;
        MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(s);
        for (int n = 0; n < mIRMetaClass.getLinkCount(); n = (int)((byte)(n + 1))) {
            object = mIRMetaClass.getLink(n);
            if (((MIRMetaLink)object).getType() == 2 || ((MIRMetaLink)object).getType() == 3 && !bl || ((MIRMetaLink)object).getType() != 3 && bl) continue;
            boolean bl2 = true;
            for (Short s2 : hashSet2) {
                if (((MIRMetaLink)object).getDestinationMetaClass().isSuperClassOf(s2)) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            hashSet.add((MIRMetaLink)object);
        }
        return hashSet;
    }

    public short[] getAllObjectTypes() {
        MIRProfileEntity[] mIRProfileEntityArray = this.getProfileEntities();
        if (mIRProfileEntityArray == null) {
            return null;
        }
        short[] sArray = new short[mIRProfileEntityArray.length];
        for (int i = 0; i < mIRProfileEntityArray.length; ++i) {
            sArray[i] = mIRProfileEntityArray[i].getElementType();
        }
        return sArray;
    }

    public MIRProfileEntity[] getProfileEntities(short s) {
        if (this.entities == null || this.entities.isEmpty()) {
            return null;
        }
        TreeSet<MIRProfileEntity> treeSet = this.sortedEntitiesByType.get(s);
        if (treeSet != null) {
            int n = treeSet.size();
            MIRProfileEntity mIRProfileEntity = null;
            MIRProfileEntity[] mIRProfileEntityArray = new MIRProfileEntity[n];
            int n2 = 0;
            for (MIRProfileEntity mIRProfileEntity2 : treeSet) {
                if (mIRProfileEntity2.getCondition() == null && mIRProfileEntity == null) {
                    mIRProfileEntity = mIRProfileEntity2;
                    continue;
                }
                mIRProfileEntityArray[n2++] = mIRProfileEntity2;
            }
            if (mIRProfileEntity != null) {
                mIRProfileEntityArray[n2++] = mIRProfileEntity;
            }
            return mIRProfileEntityArray;
        }
        return new MIRProfileEntity[0];
    }

    public AttributeIdentifier[] getAttributes(short s, boolean bl) {
        MIRProfileEntity[] mIRProfileEntityArray = this.getProfileEntities(s);
        return this.getAttributes(mIRProfileEntityArray, bl);
    }

    public AttributeIdentifier[] getAttributes(MIRProfileEntity[] mIRProfileEntityArray, boolean bl) {
        if (mIRProfileEntityArray == null) {
            return null;
        }
        HashSet<AttributeIdentifier> hashSet = new HashSet<AttributeIdentifier>();
        for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray) {
            AttributeIdentifier attributeIdentifier;
            AttributeIdentifier[] attributeIdentifierArray;
            AttributeIdentifier[] attributeIdentifierArray2 = attributeIdentifierArray = bl ? mIRProfileEntity.getAttributes() : mIRProfileEntity.getConditionAttributes();
            if (attributeIdentifierArray != null) {
                hashSet.addAll(Arrays.asList(attributeIdentifierArray));
            }
            if ((attributeIdentifier = mIRProfileEntity.getAttributeByName("Name")) == null || attributeIdentifier.getId() == 174) continue;
            hashSet.add(attributeIdentifier);
        }
        return hashSet.toArray(new AttributeIdentifier[hashSet.size()]);
    }

    protected void handleException(Exception exception) {
        this.isErrorsInProfile = true;
        if (exception instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)exception;
            if (this.name != null) {
                PRFLR.ERR_SAX_PARSER_FILE.log(sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage(), this.name);
            } else {
                PRFLR.ERR_SAX_PARSER.log(sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
            }
        } else {
            PRFLR.ERR_IN_PROFILE.log(MIRLogger.getLogger(), exception, this.getName(), exception.getMessage());
        }
    }

    protected void handleWarning(String string) {
        this.isWarningsInProfile = true;
        PRFLR.WARN_IN_PROFILE.log(MIRLogger.getLogger(), this.getName(), string);
    }

    protected void handleWarning(Element element, String string, String string2, MessageLiteral messageLiteral) {
        this.isWarningsInProfile = true;
        String string3 = messageLiteral.getMessage(string2, string);
        PRFLR.WARN_IN_PROFILE.log(MIRLogger.getLogger(), this.getName(), string3);
    }

    protected void handleError(String string) {
        this.isErrorsInProfile = true;
        PRFLR.ERR_IN_PROFILE.log(MIRLogger.getLogger(), this.getName(), string);
    }

    protected void handleError(Element element, String string, String string2, MessageLiteral messageLiteral) {
        this.isErrorsInProfile = true;
        String string3 = messageLiteral.getMessage(string2, string);
        PRFLR.ERR_IN_PROFILE.log(MIRLogger.getLogger(), this.getName(), string3);
    }

    public void addProfileEntity(MIRProfileEntity mIRProfileEntity) {
        if (this.entities == null) {
            this.entities = new HashMap();
        }
        if (this.sortedEntitiesByType == null) {
            this.sortedEntitiesByType = new ArrayList(361);
            for (int i = 0; i < 361; ++i) {
                this.sortedEntitiesByType.add(null);
            }
        }
        if (this.getProfileEntity(mIRProfileEntity.getName()) == null) {
            TreeSet<MIRProfileEntity> treeSet;
            this.entities.put(mIRProfileEntity.getName().toLowerCase(), mIRProfileEntity);
            MIRProfileEntity mIRProfileEntity2 = this.idToEntity.get(mIRProfileEntity.getId());
            if (mIRProfileEntity2 == null || mIRProfileEntity2.getCondition() != null) {
                this.idToEntity.put(mIRProfileEntity.getId(), mIRProfileEntity);
            }
            if ((treeSet = this.sortedEntitiesByType.get(mIRProfileEntity.getElementType())) == null) {
                treeSet = new TreeSet<MIRProfileEntity>(MIRProfileEntity.getComparator());
                this.sortedEntitiesByType.set(mIRProfileEntity.getElementType(), treeSet);
            }
            treeSet.add(mIRProfileEntity);
        }
    }

    public boolean isErrorsInProfile() {
        return this.isErrorsInProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProfile(File file) {
        try (PrintStream printStream = null;){
            MIRProfileEntity[] mIRProfileEntityArray;
            printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printStream.println("<Profile name=\"" + this.name + "\" id=\"" + this.profileId + "\" profileModel=\"" + this.getRootProfileEntity().getName() + "\" xsi:noNamespaceSchemaLocation=\"profile.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray = this.getProfileEntities()) {
                MIRProfile.printProfileEntity(printStream, mIRProfileEntity);
            }
            printStream.println("</Profile>");
        }
    }

    public static void printProfileEntity(PrintStream printStream, MIRProfileEntity mIRProfileEntity) {
        MIRProfileGroup[] mIRProfileGroupArray;
        Object[] objectArray;
        printStream.print("\t<Entity name=\"" + mIRProfileEntity.getName() + "\" id=\"" + mIRProfileEntity.getId() + "\" class=\"" + MIRElementType.getName(mIRProfileEntity.getElementType()) + "\"");
        if (mIRProfileEntity.getContentProfile() != null) {
            printStream.print(" profileName=\"" + mIRProfileEntity.getContentProfile() + "\"");
        }
        if (mIRProfileEntity.getCondition() != null) {
            printStream.print(" condition=\"" + mIRProfileEntity.getCondition().toMPath() + "\"");
        }
        if (mIRProfileEntity.getIcon() != null) {
            printStream.print(" icon=\"" + mIRProfileEntity.getIcon() + "\"");
        }
        printStream.println(">");
        MIRProfileProperty[] mIRProfilePropertyArray = mIRProfileEntity.getProfileAttributes();
        if (mIRProfilePropertyArray != null) {
            objectArray = mIRProfilePropertyArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                MIRProfile.printProfileProperty(printStream, (MIRProfileProperty)object);
            }
        }
        if ((objectArray = mIRProfileEntity.getProfileLinks()) != null) {
            for (Object object : objectArray) {
                MIRProfile.printProfileLink(printStream, (MIRProfileLink)object, 2);
            }
        }
        if ((mIRProfileGroupArray = mIRProfileEntity.getProfileGroups()) != null) {
            for (MIRProfileGroup mIRProfileGroup : mIRProfileGroupArray) {
                MIRProfile.printProfileGroup(printStream, mIRProfileGroup);
            }
        }
        printStream.println("\t</Entity>");
    }

    private static void printProfileGroup(PrintStream printStream, MIRProfileGroup mIRProfileGroup) {
        String string = mIRProfileGroup.getIcon();
        if (string != null && string.length() > 0) {
            printStream.println("\t\t<Group name=\"" + mIRProfileGroup.getName() + "\" icon=\"" + string + "\">");
        } else {
            printStream.println("\t\t<Group name=\"" + mIRProfileGroup.getName() + "\">");
        }
        MIRProfileLink[] mIRProfileLinkArray = mIRProfileGroup.getProfileLinks();
        if (mIRProfileLinkArray != null) {
            for (MIRProfileLink mIRProfileLink : mIRProfileLinkArray) {
                MIRProfile.printProfileLink(printStream, mIRProfileLink, 3);
            }
        }
        printStream.println("\t\t</Group>");
    }

    private static void printProfileProperty(PrintStream printStream, MIRProfileProperty mIRProfileProperty) {
        printStream.println("\t\t<Property name=\"" + mIRProfileProperty.getName() + "\" path=\"" + mIRProfileProperty.getAttributeIdentifier().toMPath() + "\"/>");
    }

    private static void printProfileLink(PrintStream printStream, MIRProfileLink mIRProfileLink, int n) {
        String string = "";
        if (mIRProfileLink.getRoleName() != null) {
            string = " roleName=\"" + mIRProfileLink.getRoleName() + "\"";
        }
        String string2 = "";
        if (mIRProfileLink.getOrderBy() != null) {
            string2 = " orderBy=\"" + mIRProfileLink.getOrderBy().toMPath() + "\"";
        }
        String string3 = "";
        MIRProfileEntity[] mIRProfileEntityArray = mIRProfileLink.getChildren();
        if (mIRProfileEntityArray != null && mIRProfileEntityArray.length > 0) {
            if (mIRProfileLink.isChildLinkType()) {
                for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray) {
                    string3 = string3 + mIRProfileEntity.getName() + ";";
                }
            }
        } else {
            return;
        }
        for (int i = 0; i < n; ++i) {
            printStream.print("\t");
        }
        printStream.println("<Link path=\"" + mIRProfileLink.getLinkIdentifier().toMPath() + "\"" + string + (string3.isEmpty() ? "" : " entities=\"" + string3 + "\"") + string2 + " isAggregation=\"" + (mIRProfileLink.getType() == 3 ? "true" : "false") + "\"/>");
    }

    public HashSet<String> getProfilePropertyNames(AttributeIdentifier attributeIdentifier) {
        HashSet<String> hashSet = new HashSet<String>();
        for (MIRProfileEntity mIRProfileEntity : this.entities.values()) {
            MIRProfileProperty mIRProfileProperty = mIRProfileEntity.getProfileAttribute(attributeIdentifier);
            if (mIRProfileProperty == null) continue;
            hashSet.add(mIRProfileProperty.getName());
        }
        return hashSet;
    }

    public MIRProfileEntity getProfileEntity(String string) {
        return this.entities.get(string.toLowerCase());
    }

    public MIRProfileEntity getProfileEntityById(int n) {
        return this.idToEntity.get(n);
    }

    public MIRProfileEntity getRootProfileEntity() {
        return this.rootProfileEntity;
    }

    public void setRootProfileEntity(MIRProfileEntity mIRProfileEntity) {
        this.rootProfileEntity = mIRProfileEntity;
    }

    public boolean hasSearchGroup() {
        for (MIRProfileEntity mIRProfileEntity : this.entities.values()) {
            if (mIRProfileEntity.getSearchGroup() == null || mIRProfileEntity.getSearchGroup().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static {
        ignoredProfilesForWarnings.add("Data Dictionary");
        ignoredProfilesForWarnings.add("Data Modeling");
        ignoredProfilesForWarnings.add("IDEF1X Data Model");
        ignoredProfilesForWarnings.add("RDBMS Relational Database");
        ignoredProfilesForWarnings.add("UML Object Model");
        ignoredProfilesForWarnings.add("XML Schema");
        ignoredProfilesForWarnings.add("SAP BusinessObjects Metadata Manager");
        ignoredProfilesForWarnings.add("Microsoft Excel");
        ignoredProfilesForWarnings.add("Cobol Copybook");
        for (short s = 0; s < 361; s = (short)(s + 1)) {
            MIRElementType.getJavaClass(s);
        }
    }
}

