/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.entities.Entity;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.persist.EntityConverter;
import com.sas.metadata.remote.ArchiveFile;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.ContentLocation;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Report;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Stream;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.entities.MdOMAEntityUtility;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.URLUtil;
import com.sas.services.storedprocess.metadata.RB;
import com.sas.services.storedprocess.metadata.StoredProcess;
import com.sas.services.util.XMLUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class MetadataManipulatorForUpgrade {
    private ClassifierMap _classifierMap;
    private PromptGroupInterface _promptGroup;
    private TextStore _textStore;
    private SessionContextInterface _sessionContextInterface;
    Document _document;
    Element _storedProcessE;
    boolean _storedProcessServerSelected;
    boolean _hasStreams;
    Locale _locale;
    public static final int RESULT_OPTIONS_GROUP_FILE_SYSTEM_SPS = 0;
    public static final int RESULT_OPTIONS_GROUP_FILE_SYSTEM_WKS = 1;
    public static final int RESULT_OPTIONS_GROUP_DAV_SERVER = 2;
    public static final int RESULT_OPTIONS_GROUP_PR = 3;

    public MetadataManipulatorForUpgrade(ClassifierMap classifierMap, SessionContextInterface sessionContext) throws RemoteException, ServiceException {
        String transformRole;
        this._classifierMap = classifierMap;
        this._sessionContextInterface = sessionContext;
        try {
            this._locale = this._sessionContextInterface.getUserContext().getLocale();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._locale == null) {
            this._locale = Locale.getDefault();
        }
        if ((transformRole = classifierMap.getTransformRole()).equals("StoredProcess")) {
            double version = classifierMap.getUsageVersion();
            if (version != 0.0) {
                throw new ServiceException("Internal logic error: stored process (" + classifierMap.getFQID() + ") version should be zero but is " + version + ".");
            }
            return;
        }
        throw new ServiceException("Internal logic error: TransformRole \"" + transformRole + "\" on ClassifierMap " + classifierMap.getFQID() + " is not valid.");
    }

    public void convertTo92() throws MdException, ServiceException, RemoteException {
        this.convertClassiferMap();
        try {
            this.convertParameters();
            this.convertStreams();
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
        this.writeXML();
    }

    private void convertClassiferMap() throws RemoteException {
        this._classifierMap.setPublicType("StoredProcess");
        this._classifierMap.setUsageVersion(StoredProcess.NINETWO_VERSION.encode());
    }

    private void convertParameters() throws MdException, ParserConfigurationException, RemoteException, ServiceException {
        Entity entity = new Entity();
        MdOMAEntityUtility.populateEntityFromOMRObject((RemoteEntityInterface)entity, (Root)this._classifierMap);
        try {
            this._promptGroup = EntityConverter.DEFAULT_INSTANCE.newPromptGroup((RemoteEntityInterface)entity, null);
            this._promptGroup.setPromptGroupLabel(MetadataConstants.getLabelForParameterPromptGroup(this._locale), this._locale);
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        MdOMAEntityUtility.removeEntityFromOMR((Root)this._classifierMap);
        this.convertResults();
        PromptsPersistUtil.setPromptGroupOnOMRObject((PromptGroupInterface)this._promptGroup, (Root)this._classifierMap, (SessionContextInterface)this._sessionContextInterface, (MdFactory)this._classifierMap.getObjectStore().getFactory());
    }

    private void convertStreams() throws MdException, ParserConfigurationException, RemoteException {
        AssociationList _classiferSourcesAL = this._classifierMap.getClassifierSources();
        if (_classiferSourcesAL.size() == 0) {
            return;
        }
        boolean isWebService = false;
        AssociationList _keywordsAL = this._classifierMap.getKeywords();
        for (Keyword k : _keywordsAL) {
            if (!k.getName().equalsIgnoreCase("XMLA Web Service")) continue;
            isWebService = true;
            break;
        }
        ArrayList<DataItem> list = new ArrayList<DataItem>();
        for (Root root : _classiferSourcesAL) {
            Report report;
            if (!(root instanceof Report) || !(report = (Report)root).getReportType().equalsIgnoreCase("SPInputStream") || !((root = report.getReportLocation()) instanceof Stream)) continue;
            DataItem di = new DataItem();
            di._type = isWebService ? "XMLStream" : "GenericStream";
            di._label = di._fileref = root.getName();
            di._description = root.getDesc();
            di._supportsMultiPass = MetadataConstants.getBooleanPropertyValue(root, "MultiPass");
            list.add(di);
        }
        this.deleteClassifierSources();
        if (list.size() > 0) {
            this._hasStreams = true;
            this.writeDataSourcesToXML(list);
        } else {
            this._hasStreams = false;
        }
    }

    private void deleteClassifierSources() throws MdException, RemoteException {
        ArrayList<Report> objList = new ArrayList<Report>();
        objList.clear();
        for (Object o : this._classifierMap.getClassifierSources()) {
            ContentLocation location;
            Report report;
            String reportType;
            if (!(o instanceof Report) || !(reportType = (report = (Report)o).getReportType()).equalsIgnoreCase("SPInputStream") || !((location = report.getReportLocation()) instanceof Stream)) continue;
            Stream st = (Stream)location;
            MetadataConstants.deleteAllProperties((Root)st);
            st.delete();
            objList.add(report);
        }
        MetadataConstants.deleteObjects(objList);
    }

    private void writeDataSourcesToXML(ArrayList dataItems) throws MdException, RemoteException, ParserConfigurationException {
        Element dataE = this.getOrCreateDataElement();
        for (DataItem di : dataItems) {
            boolean hasLabel;
            Element diE = this._document.createElement("Source");
            diE.setAttribute("Type", di._type);
            diE.setAttribute("Fileref", di._fileref);
            diE.setAttribute("Multipass", di._supportsMultiPass ? "true" : "false");
            boolean hasDesc = di._description != null && di._description.length() > 0;
            boolean bl = hasLabel = di._label != null && di._label.length() > 0;
            if (hasDesc || hasLabel) {
                Element cultureE = this._document.createElement("Culture");
                if (hasLabel) {
                    Element labelE = this._document.createElement("Label");
                    labelE.appendChild(this._document.createTextNode(di._label));
                    cultureE.appendChild(labelE);
                }
                if (hasDesc) {
                    Element descriptionE = this._document.createElement("Description");
                    descriptionE.appendChild(this._document.createTextNode(di._description));
                    cultureE.appendChild(descriptionE);
                }
                diE.appendChild(cultureE);
            }
            dataE.appendChild(diE);
        }
    }

    private Element getOrCreateDataElement() throws RemoteException, ParserConfigurationException, MdException {
        Element dataE;
        this.ensureStoredProcessXMLElementExists();
        NodeList list = this._storedProcessE.getElementsByTagName("Data");
        if (list.getLength() == 0) {
            dataE = this._document.createElement("Data");
            this._storedProcessE.appendChild(dataE);
        } else {
            dataE = (Element)list.item(0);
        }
        return dataE;
    }

    private void convertResults() throws MdException, ParserConfigurationException, RemoteException, ServiceException {
        boolean packagesSupported = false;
        boolean streamingSupported = false;
        boolean shouldCreateNewPackageInstancePrompt = false;
        Report theReport = null;
        Directory archiveDirectory = null;
        Directory davDirectory = null;
        PromptGroupInterface resultOptionsPG = null;
        AssociationList logicalServers = this._classifierMap.getComputeLocations();
        boolean allIsWellWithReport = false;
        for (CMetadata obj : this._classifierMap.getClassifierTargets()) {
            if (!(obj instanceof Report)) continue;
            Report report = (Report)obj;
            String reportType = report.getReportType();
            ContentLocation location = report.getReportLocation();
            if (reportType.equalsIgnoreCase("SPResultsTransientPackage")) {
                theReport = report;
                allIsWellWithReport = true;
                packagesSupported = true;
                break;
            }
            if (reportType.equalsIgnoreCase("SPResultsPermanentFilePackage")) {
                ArchiveLocation al;
                ArchiveFile af;
                boolean runningOnWorkSpaceServer;
                theReport = report;
                if (logicalServers.size() == 0) continue;
                LogicalServer cmLogicalServer = (LogicalServer)logicalServers.get(0);
                boolean bl = runningOnWorkSpaceServer = !cmLogicalServer.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c");
                if (!(location instanceof ArchiveFile) && !(location instanceof Directory)) continue;
                if (location instanceof ArchiveFile) {
                    af = (ArchiveFile)location;
                    al = this.validateArchiveLocation(af);
                } else {
                    af = null;
                    Directory d = (Directory)location;
                    al = this.validateArchiveLocation(d);
                }
                if (al == null) continue;
                allIsWellWithReport = true;
                packagesSupported = true;
                resultOptionsPG = MetadataManipulatorForUpgrade.createResultOptionsPromptGroup(runningOnWorkSpaceServer ? 1 : 0, af == null, this._locale);
                archiveDirectory = al._repository;
                TextDefinition td = MetadataManipulatorForUpgrade.addPromptFor_Result(resultOptionsPG, this._locale);
                td.setDefaultValue((Object)(runningOnWorkSpaceServer ? "PACKAGE_TO_REQUESTER" : "PACKAGE_TO_ARCHIVE"));
                td = MetadataManipulatorForUpgrade.addPromptFor_Archive_Path(resultOptionsPG, this._locale);
                td.setDefaultValue((Object)archiveDirectory.getDirectoryName());
                if (af == null) break;
                td = MetadataManipulatorForUpgrade.addPromptFor_Archive_Name(resultOptionsPG, this._locale);
                td.setDefaultValue((Object)af.getFileName());
                af.delete();
                break;
            }
            if (reportType.equalsIgnoreCase("SPResultsPermanentWebdavPackage")) {
                String resultURL;
                WebDAVLocation wl;
                theReport = report;
                shouldCreateNewPackageInstancePrompt = this.obtainValueOfNewInstancePropertyAndDeletePropertyObject(theReport);
                if (!(location instanceof Directory)) continue;
                Directory basePathDir = (Directory)location;
                Object object = davDirectory = MetadataConstants.checkPropertyNamePresence((Root)basePathDir, "FileSystemType", "WebDAV", true) ? basePathDir : null;
                if (davDirectory != null) {
                    basePathDir = davDirectory.getParent();
                }
                if (basePathDir == null || (wl = this.validateWebDAVLocation(basePathDir)) == null) break;
                resultOptionsPG = MetadataManipulatorForUpgrade.createResultOptionsPromptGroup(2, shouldCreateNewPackageInstancePrompt, this._locale);
                TextDefinition td = MetadataManipulatorForUpgrade.addPromptFor_Result(resultOptionsPG, this._locale);
                td.setDefaultValue((Object)"PACKAGE_TO_WEBDAV");
                Directory basePathDirectory = wl._basePathDirectory;
                ServerComponent DAVServer = wl._serverComponent;
                Iterator itt = DAVServer.getSourceConnections().iterator();
                String serverURL = null;
                while (itt.hasNext()) {
                    Object o = itt.next();
                    if (!(o instanceof TCPIPConnection)) continue;
                    TCPIPConnection con = (TCPIPConnection)o;
                    String host = con.getHostName();
                    int port = con.getPort();
                    String protocol = con.getApplicationProtocol();
                    serverURL = protocol + "://" + host + (port > 0 ? ":" + port : "");
                    break;
                }
                if (serverURL == null) break;
                allIsWellWithReport = true;
                packagesSupported = true;
                String URLOfServerAndBasePath = URLUtil.concat(serverURL, basePathDirectory.getDirectoryName());
                if (davDirectory != null) {
                    resultURL = URLUtil.concat(URLOfServerAndBasePath, davDirectory.getDirectoryName());
                    davDirectory.delete();
                } else {
                    resultURL = URLOfServerAndBasePath;
                }
                td = MetadataManipulatorForUpgrade.addPromptFor_Collection_URL(resultOptionsPG, this._locale);
                td.setDefaultValue((Object)resultURL);
                break;
            }
            if (reportType.equalsIgnoreCase("SPResultsPermanentWebdavPRPackage")) {
                theReport = report;
                shouldCreateNewPackageInstancePrompt = this.obtainValueOfNewInstancePropertyAndDeletePropertyObject(theReport);
                packagesSupported = true;
                allIsWellWithReport = true;
                resultOptionsPG = MetadataManipulatorForUpgrade.createResultOptionsPromptGroup(3, shouldCreateNewPackageInstancePrompt, this._locale);
                TextDefinition td = MetadataManipulatorForUpgrade.addPromptFor_Result(resultOptionsPG, this._locale);
                td.setDefaultValue((Object)"PACKAGE_TO_WEBDAV");
                if (location instanceof Directory) {
                    Directory d = (Directory)location;
                    td = MetadataManipulatorForUpgrade.addPromptFor_PR_Collection_Path(resultOptionsPG, this._locale, !shouldCreateNewPackageInstancePrompt);
                    td.setDefaultValue((Object)d.getDirectoryName());
                    d.delete();
                }
                MetadataManipulatorForUpgrade.addPromptFor_Publish_To_PR(resultOptionsPG, this._locale);
                break;
            }
            if (!reportType.equalsIgnoreCase("SPResultsStream")) continue;
            theReport = report;
            if (!(location instanceof Stream)) continue;
            allIsWellWithReport = true;
            streamingSupported = true;
            location.delete();
            break;
        }
        if (theReport != null) {
            if (!allIsWellWithReport) {
                throw new ServiceException(RB.getStringResource("MM.BadReportData.txt"));
            }
            theReport.delete();
        }
        if (shouldCreateNewPackageInstancePrompt) {
            MetadataManipulatorForUpgrade.addPromptFor_Create_New_Package_Instance(resultOptionsPG, this._locale);
        }
        if (resultOptionsPG != null) {
            this._promptGroup.addPromptSubgroup(resultOptionsPG);
        }
        if (packagesSupported || streamingSupported) {
            this.ensureStoredProcessXMLElementExists();
            Element resultCapabilitiesE = this._document.createElement("ResultCapabilities");
            resultCapabilitiesE.setAttribute("Streaming", streamingSupported ? "true" : "false");
            resultCapabilitiesE.setAttribute("Package", packagesSupported ? "true" : "false");
            this._storedProcessE.appendChild(resultCapabilitiesE);
        }
    }

    public static PromptGroupInterface createResultOptionsPromptGroup(int groupType, boolean newInstance, Locale locale) {
        String label = "";
        String desc = "";
        switch (groupType) {
            case 0: {
                label = RB.getStringResource(newInstance ? "MM.PromtGrpFilSysNISPSLab.txt" : "MM.PromtGrpFilSysEISPSLab.txt");
                desc = RB.getStringResource("MM.PromtGrpFilSysSPSDesc.txt");
                break;
            }
            case 1: {
                label = RB.getStringResource(newInstance ? "MM.PromtGrpFilSysNIWKSLab.txt" : "MM.PromtGrpFilSysEIWKSLab.txt");
                desc = RB.getStringResource("MM.PromtGrpFilSysWKSDesc.txt");
                break;
            }
            case 2: {
                label = RB.getStringResource(newInstance ? "MM.PromtGrpDAVLabNI.txt" : "MM.PromtGrpDAVLabEI.txt");
                desc = RB.getStringResource("MM.PromtGrpDAVDesc.txt");
                break;
            }
            case 3: {
                label = RB.getStringResource(newInstance ? "MM.PromtGrpPRLabNI.txt" : "MM.PromtGrpPRLabEI.txt");
                desc = RB.getStringResource("MM.PromtGrpPRDesc.txt");
            }
        }
        PromptGroup pgi = new PromptGroup();
        pgi.setPromptGroupLabel(label, locale);
        pgi.setPromptGroupDescription(desc, locale);
        pgi.setPromptGroupHidden(true);
        return pgi;
    }

    private void writeXML() throws RemoteException {
        if (this._document == null) {
            return;
        }
        if (this._storedProcessE == null) {
            return;
        }
        this._document.normalize();
        this._textStore.setStoredText(XMLUtil.convertNodeToString((Node)this._document));
    }

    private void ensureDocumentExists() throws ParserConfigurationException, MdException, RemoteException {
        if (this._textStore == null) {
            this._textStore = (TextStore)MetadataConstants.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._classifierMap, "Stored Process", "TextStore");
            this._textStore.setTextRole("StoredProcessConfiguration");
            this._textStore.setTextType("XML");
            this._classifierMap.getNotes().add((Object)this._textStore);
        }
        if (this._document == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._document = builder.newDocument();
        }
    }

    private void ensureStoredProcessXMLElementExists() throws ParserConfigurationException, MdException, RemoteException {
        if (this._storedProcessE == null) {
            this.ensureDocumentExists();
            this._storedProcessE = this._document.createElement("StoredProcess");
            this._document.appendChild(this._storedProcessE);
        }
    }

    private ArchiveLocation validateArchiveLocation(ArchiveFile af) throws MdException, RemoteException {
        String fileName = af.getFileName();
        if (fileName.length() == 0) {
            return null;
        }
        if (af.getIsARelativeName() == 0) {
            return null;
        }
        Directory repository = null;
        AssociationList vv = af.getDirectories();
        for (int i = 0; i < vv.size(); ++i) {
            Directory d = (Directory)vv.get(i);
            AssociationList vvv = d.getProperties();
            boolean isAFileRepository = false;
            for (int ii = 0; ii < vvv.size(); ++ii) {
                Property p = (Property)vvv.get(ii);
                if (!p.getPropertyRole().equalsIgnoreCase("SPPackageFileRepository")) continue;
                isAFileRepository = true;
                break;
            }
            if (!isAFileRepository) continue;
            if (repository != null) {
                return null;
            }
            repository = d;
        }
        if (repository == null || repository.getDirectoryName().length() == 0) {
            return null;
        }
        return new ArchiveLocation(repository);
    }

    private ArchiveLocation validateArchiveLocation(Directory d) throws MdException, RemoteException {
        boolean isAFileRepository = MetadataConstants.checkPropertyRolePresence((Root)d, "SPPackageFileRepository", null, true);
        if (!isAFileRepository) {
            return null;
        }
        return new ArchiveLocation(d);
    }

    private WebDAVLocation validateWebDAVLocation(Directory d) throws MdException, RemoteException {
        if (!MetadataConstants.checkPropertyNamePresence((Root)d, "HttpServerBasePath", "0", false)) {
            return null;
        }
        if (!MetadataConstants.checkPropertyNamePresence((Root)d, "SupportsWebDAV", "0", false)) {
            return null;
        }
        for (Root root : d.getDeployedComponents()) {
            ServerComponent sc;
            if (!(root instanceof ServerComponent) || !(sc = (ServerComponent)root).getClassIdentifier().equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06")) continue;
            return new WebDAVLocation(sc, d);
        }
        return null;
    }

    private boolean obtainValueOfNewInstancePropertyAndDeletePropertyObject(Report report) throws MdException, RemoteException {
        Iterator it = report.getProperties().iterator();
        boolean newInstance = false;
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (!p.getPropertyName().equals("SPNewInstance")) continue;
            newInstance = !p.getDefaultValue().equals("0");
            p.delete();
            break;
        }
        return newInstance;
    }

    public static TextDefinition addPromptFor_Result(PromptGroupInterface resultOptionsPG, Locale locale) {
        TextDefinition td = new TextDefinition("_result");
        td.setPromptLabel(RB.getStringResource("MM.PromtResultLab.txt"), locale);
        td.setPromptDescription(RB.getStringResource("MM.PromtResultDesc.txt"), locale);
        td.setHidden(true);
        td.setMinimumValueCount(1);
        td.setFixed(true);
        if (resultOptionsPG != null) {
            resultOptionsPG.addPromptDefinition((PromptDefinitionInterface)td);
        }
        return td;
    }

    public static TextDefinition addPromptFor_Archive_Path(PromptGroupInterface resultOptionsPG, Locale locale) {
        TextDefinition td = new TextDefinition("_archive_path");
        td.setPromptLabel(RB.getStringResource("MM.PromtArchivePathLab.txt", locale), locale);
        td.setPromptDescription(RB.getStringResource("MM.PromtArchivePathDesc.txt", locale), locale);
        td.setHidden(true);
        td.setMinimumValueCount(1);
        td.setFixed(true);
        if (resultOptionsPG != null) {
            resultOptionsPG.addPromptDefinition((PromptDefinitionInterface)td);
        }
        return td;
    }

    public static TextDefinition addPromptFor_Archive_Name(PromptGroupInterface resultOptionsPG, Locale locale) {
        TextDefinition td = new TextDefinition("_archive_name");
        td.setPromptLabel(RB.getStringResource("MM.PromtArchiveNameLab.txt", locale), locale);
        td.setPromptDescription(RB.getStringResource("MM.PromtArchiveNameDesc.txt", locale), locale);
        td.setHidden(true);
        td.setMinimumValueCount(1);
        td.setFixed(true);
        if (resultOptionsPG != null) {
            resultOptionsPG.addPromptDefinition((PromptDefinitionInterface)td);
        }
        return td;
    }

    public static TextDefinition addPromptFor_Collection_URL(PromptGroupInterface resultOptionsPG, Locale locale) {
        TextDefinition td = new TextDefinition("_collection_url");
        td.setPromptLabel(RB.getStringResource("MM.PromtCollURLLab.txt", locale), locale);
        td.setPromptDescription(RB.getStringResource("MM.PromtCollURLDesc.txt", locale), locale);
        td.setHidden(true);
        td.setMinimumValueCount(1);
        td.setFixed(true);
        if (resultOptionsPG != null) {
            resultOptionsPG.addPromptDefinition((PromptDefinitionInterface)td);
        }
        return td;
    }

    public static TextDefinition addPromptFor_PR_Collection_Path(PromptGroupInterface resultOptionsPG, Locale locale, boolean required) {
        TextDefinition td = new TextDefinition("_pr_collection_path");
        td.setPromptLabel(RB.getStringResource("MM.PromtPRCollPathLab.txt", locale), locale);
        td.setPromptDescription(RB.getStringResource("MM.PromtPRCollPathDesc.txt", locale), locale);
        td.setHidden(true);
        if (required) {
            td.setMinimumValueCount(1);
        }
        td.setFixed(true);
        if (resultOptionsPG != null) {
            resultOptionsPG.addPromptDefinition((PromptDefinitionInterface)td);
        }
        return td;
    }

    public static TextDefinition addPromptFor_Create_New_Package_Instance(PromptGroupInterface resultOptionsPG, Locale locale) {
        TextDefinition td = new TextDefinition("_create_new_package_instance");
        td.setPromptLabel(RB.getStringResource("MM.PromtCreatNewPkgInstncLab.txt", locale), locale);
        td.setPromptDescription(RB.getStringResource("MM.PromtCreatNewPkgInstncDesc.txt", locale), locale);
        td.setDefaultValue((Object)RB.getStringResource("MM.true.txt", locale));
        td.setHidden(true);
        td.setMinimumValueCount(1);
        td.setFixed(true);
        if (resultOptionsPG != null) {
            resultOptionsPG.addPromptDefinition((PromptDefinitionInterface)td);
        }
        return td;
    }

    public static TextDefinition addPromptFor_Publish_To_PR(PromptGroupInterface resultOptionsPG, Locale locale) {
        TextDefinition td = new TextDefinition("_publish_to_pr");
        td.setPromptLabel(RB.getStringResource("MM.PromtPublishToPRLab.txt", locale), locale);
        td.setPromptDescription(RB.getStringResource("MM.PromtPublishToPRDesc.txt", locale), locale);
        td.setDefaultValue((Object)RB.getStringResource("MM.true.txt", locale));
        td.setHidden(true);
        td.setMinimumValueCount(1);
        td.setFixed(true);
        if (resultOptionsPG != null) {
            resultOptionsPG.addPromptDefinition((PromptDefinitionInterface)td);
        }
        return td;
    }

    @SASScope
    static class DataItem {
        String _fileref;
        String _type;
        String _description;
        String _label;
        boolean _supportsMultiPass;

        DataItem() {
        }
    }

    @SASScope
    static class WebDAVLocation {
        ServerComponent _serverComponent;
        Directory _basePathDirectory;

        WebDAVLocation(ServerComponent serverComponent, Directory basePathDirectory) {
            this._basePathDirectory = basePathDirectory;
            this._serverComponent = serverComponent;
        }
    }

    @SASScope
    static class ArchiveLocation {
        Directory _repository;

        ArchiveLocation(Directory repository) {
            this._repository = repository;
        }
    }
}

