/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.storedprocess.metadata.DataSourceOrTarget;
import com.sas.services.storedprocess.metadata.RB;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class GenericStream
extends DataSourceOrTarget
implements Serializable {
    private static final long serialVersionUID = 2495450841877664537L;
    private String _fileref;
    private boolean _allowRewinds;
    private String _expectedContentType = "application/unknown";

    public String getFileref() {
        return this._fileref;
    }

    public String getExpectedContentType() {
        return this._expectedContentType;
    }

    public boolean allowsRewinds() throws IllegalStateException {
        return this._allowRewinds;
    }

    public void setFileref(String fileref) {
        this._fileref = fileref;
    }

    public void setExpectedContentType(String expectedContentType) {
        this._expectedContentType = expectedContentType;
    }

    public void setAllowRewinds(boolean allowRewinds) {
        this._allowRewinds = allowRewinds;
    }

    @Override
    public void validate() throws ServiceException {
        String fileref = this.getFileref();
        if (fileref == null || fileref.length() == 0) {
            throw new ServiceException(RB.getStringResource("GS.noName.ex.txt"));
        }
        try {
            Names.validateSASFilerefName((String)fileref, (boolean)true);
        }
        catch (Exception e) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"GS.badName.ex.fmt.txt", (Object)e.getMessage()));
        }
    }

    @Override
    void writeXML(Document document, Element element) {
        element.setAttribute("Type", "GenericStream");
        element.setAttribute("Fileref", this.getFileref());
        if (this.isSource()) {
            element.setAttribute("Multipass", this.allowsRewinds() ? "true" : "false");
        }
        element.setAttribute("ContentType", this.getExpectedContentType());
        super.writeXML(document, element);
    }
}

