/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.metadata.RB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public abstract class DataSourceOrTarget {
    private boolean _isSource = true;
    private String _label = "";
    private String _description = "";
    protected Element _cultureElement;
    protected Element _labelElement;
    protected Element _descElement;
    protected Element _element;

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public boolean isSource() {
        return this._isSource;
    }

    public void setSource(boolean isSource) {
        this._isSource = isSource;
    }

    void writeXML(Document document, Element element) {
        boolean hasLabel;
        boolean hasDesc = this._description != null && this._description.length() > 0;
        boolean bl = hasLabel = this._label != null && this._label.length() > 0;
        if (hasDesc || hasLabel) {
            Element cultureE = document.createElement("Culture");
            if (hasLabel) {
                Element labelE = document.createElement("Label");
                labelE.appendChild(document.createTextNode(this._label));
                cultureE.appendChild(labelE);
            }
            if (hasDesc) {
                Element descriptionE = document.createElement("Description");
                descriptionE.appendChild(document.createTextNode(this._description));
                cultureE.appendChild(descriptionE);
            }
            element.appendChild(cultureE);
        }
    }

    void readXML(Element element) throws MetadataConstants.MCException {
        this._element = element;
        NodeList cultureElements = element.getElementsByTagName("Culture");
        boolean seenValidCulture = false;
        for (int j = 0; j < cultureElements.getLength(); ++j) {
            Element cultureE = (Element)cultureElements.item(j);
            String xmlLangValue = cultureE.getAttribute("xml:lang");
            if (xmlLangValue.length() != 0) continue;
            if (seenValidCulture) {
                throw new MetadataConstants.MCException(RB.getStringResource("DSOT.MultplVldCultr.ex.txt"));
            }
            this._cultureElement = cultureE;
            seenValidCulture = true;
            NodeList cultureChildren = cultureE.getChildNodes();
            for (int k = 0; k < cultureChildren.getLength(); ++k) {
                Element labelOrDesc;
                Node nn = cultureChildren.item(k);
                if (nn.getNodeType() != 1 || !(labelOrDesc = (Element)nn).getTagName().equals("Label") && !labelOrDesc.getTagName().equals("Description")) continue;
                if (labelOrDesc.getTagName().equals("Label")) {
                    this._labelElement = labelOrDesc;
                    this.setLabel(labelOrDesc.getTextContent());
                    continue;
                }
                this._descElement = labelOrDesc;
                this.setDescription(labelOrDesc.getTextContent());
            }
        }
    }

    public abstract void validate() throws ServiceException;
}

