/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.storedprocess.GenericStream;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.RB;
import com.sas.text.Message;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class XMLStream
extends GenericStream {
    private static final long serialVersionUID = 1L;
    private boolean _schemaIsAvailable;
    private String _schemaURI;
    private String _referenceNameSpace;
    private String _referenceName;
    private boolean _referenceTypeIsForSchemaElement;
    private boolean _schemaIsToBeEmbeddedInWSDL;

    XMLStream(Element element, boolean isSource) throws MetadataConstants.MCException {
        super(element, isSource);
        NodeList schemaElements = this._streamElement.getElementsByTagName("Schema");
        if (schemaElements.getLength() > 1) {
            throw new MetadataConstants.MCException(RB.getStringResource("MC.MultplSchemaTag.ex.txt"));
        }
        if (schemaElements.getLength() == 1) {
            Element schemaE = (Element)schemaElements.item(0);
            this._schemaIsAvailable = true;
            this._schemaURI = schemaE.getAttribute("URI");
            this._referenceNameSpace = schemaE.getAttribute("Namespace");
            this._referenceName = schemaE.getAttribute("Name");
            NodeList wsdlElements = this._streamElement.getElementsByTagName("WSDL");
            if (wsdlElements.getLength() > 1) {
                throw new MetadataConstants.MCException(RB.getStringResource("MC.MultplWSDLTag.ex.txt"));
            }
            if (wsdlElements.getLength() == 0) {
                throw new MetadataConstants.MCException(RB.getStringResource("MC.MissnWSDLTag.ex.txt"));
            }
            Element wsdlE = (Element)wsdlElements.item(0);
            this._schemaIsToBeEmbeddedInWSDL = wsdlE.getAttribute("Embed").equalsIgnoreCase("true");
            String refType = wsdlE.getAttribute("ReferenceType");
            if (refType.equalsIgnoreCase("Element")) {
                this._referenceTypeIsForSchemaElement = true;
            } else if (refType.equalsIgnoreCase("Type")) {
                this._referenceTypeIsForSchemaElement = false;
            } else {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"MC.UnsuppRefType.ex.fmt.txt", (Object)refType);
                throw new MetadataConstants.MCException(msg);
            }
        }
    }

    public boolean isSchemaAvailable() {
        return this._schemaIsAvailable;
    }

    public String getSchemaURI() throws IllegalStateException {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XMLS.inv.ex.txt"));
        }
        return this._schemaURI;
    }

    public String getReferenceNameSpace() {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XMLS.inv.ex.txt"));
        }
        return this._referenceNameSpace;
    }

    public String getReferenceName() {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XMLS.inv.ex.txt"));
        }
        return this._referenceName;
    }

    public boolean isReferenceTypeForSchemaElement() {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XMLS.inv.ex.txt"));
        }
        return this._referenceTypeIsForSchemaElement;
    }

    public boolean isSchemaToBeEmbeddedInWSDL() {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XMLS.inv.ex.txt"));
        }
        return this._schemaIsToBeEmbeddedInWSDL;
    }
}

