/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.storedprocess.Credentials;
import com.sas.services.storedprocess.GetIdentityByDomainAction;
import com.sas.services.storedprocess.InternalUseException;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.ResultHints;
import com.sas.services.storedprocess.URLUtil;
import com.sas.services.storedprocess.UniqueNameGenerator;
import com.sas.services.user.UserContextInterface;
import com.sas.services.webdav.DAVResource;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

public class WebDAVPackageDAVServerResultHints
extends ResultHints {
    static final long serialVersionUID = -2826120673050442697L;
    private HttpServerInterface _davServer;
    private String _collectionUnderDAVServerBasePath;
    private String _DAVServerBasePath;
    private String _domain;
    private boolean attemptedToGetDomain;

    WebDAVPackageDAVServerResultHints() {
    }

    public void setDAVServer(HttpServerInterface davServer) {
        this._davServer = davServer;
    }

    public HttpServerInterface getDAVServer() {
        return this._davServer;
    }

    public void setCollectionUnderDAVServerBasePath(String collectionUnderDAVServerBasePath) {
        this._collectionUnderDAVServerBasePath = collectionUnderDAVServerBasePath;
    }

    public String getCollectionUnderDAVServerBasePath() {
        return this._collectionUnderDAVServerBasePath;
    }

    String getProxyURL() throws RemoteException {
        String result = null;
        try {
            result = this._davServer.getProxyUrl();
        }
        catch (ServiceException ex) {
            result = null;
        }
        return result;
    }

    @Override
    void validate() throws InternalUseException {
        if (!(this.isNewInstanceCreated() || this._collectionUnderDAVServerBasePath != null && this._collectionUnderDAVServerBasePath.length() != 0)) {
            throw new InternalUseException(RB.getStringResource("COM.collNameReqd.ex.txt"));
        }
    }

    void determineResultsLocation(String suggestedName, final Logger logger, final UserContextInterface userContext, String loggingId) throws ServiceException, RemoteException {
        String URLOfServerAndBasePath = URLUtil.concat(this._davServer.getUrl(), this._DAVServerBasePath);
        String resultURL = URLUtil.concat(URLOfServerAndBasePath, this._collectionUnderDAVServerBasePath);
        if (this.isNewInstanceCreated()) {
            final String finalAbsolutePathToInstance = resultURL + '/';
            UniqueNameGenerator.Callback callback = new UniqueNameGenerator.Callback(){

                @Override
                public Object isUnique(String leafName) throws Exception {
                    Credentials credentials = WebDAVPackageDAVServerResultHints.this.getCredentials(logger, userContext);
                    String userName = credentials._userName;
                    String password = credentials._password;
                    String nameToTry = finalAbsolutePathToInstance + leafName;
                    DAVResource r = new DAVResource(nameToTry, userName, password);
                    int statusCode = r.getStatusCode();
                    r.close();
                    if (statusCode == 404) {
                        return nameToTry;
                    }
                    if (statusCode == 200) {
                        return null;
                    }
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"WPDSRH.srvrErr.ex.fmt.txt", (Object)Integer.toString(statusCode), (Object)r.getStatusMessage(), (Object)nameToTry);
                    throw new ServiceException(msg);
                }

                @Override
                public String metadataTypeForErrorMessage() {
                    return "package";
                }

                @Override
                public String repositoryForErrorMessage() {
                    return finalAbsolutePathToInstance;
                }
            };
            try {
                resultURL = (String)UniqueNameGenerator.find(suggestedName, 100, true, callback, logger, loggingId);
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e, RB.getStringResource("COM.noUniq.ex.txt"));
            }
        }
        this.setResultLocation(resultURL);
    }

    Credentials getCredentials(Logger logger, UserContextInterface userContext) throws RemoteException {
        String domain;
        Credentials credentials = new Credentials();
        if (userContext != null && (domain = this.getDomain(logger)) != null) {
            credentials._userIdentity = GetIdentityByDomainAction.getIdentity(userContext, domain, logger);
            if (credentials._userIdentity != null) {
                credentials._userName = (String)credentials._userIdentity.getPrincipal();
                credentials._password = (String)credentials._userIdentity.getCredential();
            }
        }
        if (logger != null && logger.isDebugEnabled()) {
            if (credentials._userIdentity == null) {
                logger.debug(RB.getStringResource("COM.credNull.txt"));
            } else {
                if (credentials._userName == null) {
                    logger.debug(RB.getStringResource("COM.userNameNull.txt"));
                }
                if (credentials._password == null) {
                    logger.debug(RB.getStringResource("COM.passwd.txt"));
                }
            }
        }
        return credentials;
    }

    String getDomain(Logger logger) throws RemoteException {
        if (!this.attemptedToGetDomain) {
            this.attemptedToGetDomain = true;
            try {
                List domains = this._davServer.getDomains();
                if (domains.size() > 0) {
                    if (domains.size() > 1 && logger != null) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.mulDoms.fmt.txt", (Object)this._davServer.getName());
                        logger.warn(msg);
                    }
                    this._domain = (String)domains.get(0);
                }
            }
            catch (ServiceException ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        return this._domain;
    }

    public String getDAVServerBasePath() {
        return this._DAVServerBasePath;
    }

    public void setDAVServerBasePath(String DAVServerBasePath) {
        this._DAVServerBasePath = DAVServerBasePath;
    }
}

