/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.OMRHttpServer;
import com.sas.services.storedprocess.Credentials;
import com.sas.services.storedprocess.GetIdentityByDomainAction;
import com.sas.services.storedprocess.LocationHelper;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.UniqueNameGenerator;
import com.sas.services.user.UserContextInterface;
import com.sas.services.webdav.DAVResource;
import com.sas.text.Message;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

@SASScope
class WebDAVPackageDAVServerLocationHelper
extends LocationHelper {
    private String _initialCollectionURL;
    private MdOMIUtil _mdOMIUtil;
    private MdObjectStore _objectStore;
    private String _reposFQID;
    private HttpServerInterface _davServer;
    private String _basePath;
    private String _collectionUnderBasePath;
    private String _domain;
    private String _authenticationType;
    private boolean attemptedToGetDomain;
    private String _userid;
    private String _password;

    WebDAVPackageDAVServerLocationHelper(String initialCollectionURLvalue, boolean createNewInstance, Root root, Logger logger, String userid, String password) throws RemoteException {
        super(createNewInstance);
        this._initialCollectionURL = initialCollectionURLvalue;
        this._mdOMIUtil = root.getObjectStore().getFactory().getOMIUtil();
        this._objectStore = root.getObjectStore().getFactory().createObjectStore();
        this._reposFQID = this._mdOMIUtil.getReposIdFromMetadataObject((CMetadata)root);
        if (userid != null && userid.length() > 0) {
            this._userid = userid;
        }
        if (password == null) {
            password = "";
        }
        this._password = password;
        if (this._userid != null && password.length() == 0 && logger != null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"WPDSLH.noPasswd.fmt.txt", (Object)this._userid);
            logger.warn(msg);
        }
    }

    String getProxyURL() throws RemoteException {
        String result = null;
        try {
            result = this._davServer == null ? null : this._davServer.getProxyUrl();
        }
        catch (ServiceException ex) {
            result = null;
        }
        return result;
    }

    void determineResultsLocation(String suggestedName, final Logger logger, final UserContextInterface userContext, String loggingId) throws ServiceException, RemoteException, MdException {
        URL initURL = WebDAVPackageDAVServerLocationHelper.getURL(this._initialCollectionURL);
        String protocol = this.getProtocol(initURL);
        ServerComponent sc = this.locateDAVServerAndBasePath(protocol, initURL);
        if (sc != null) {
            this._davServer = new OMRHttpServer(sc);
            this._authenticationType = this._davServer.getAuthenticationType();
        }
        String resultURL = this._initialCollectionURL;
        if (this.isNewInstanceCreated()) {
            final String finalAbsolutePathToInstance = resultURL + '/';
            UniqueNameGenerator.Callback callback = new UniqueNameGenerator.Callback(){

                @Override
                public Object isUnique(String leafName) throws Exception {
                    Credentials credentials = WebDAVPackageDAVServerLocationHelper.this.getCredentials(logger, userContext);
                    String userName = credentials._userName;
                    String password = credentials._password;
                    String nameToTry = finalAbsolutePathToInstance + leafName;
                    DAVResource r = new DAVResource(nameToTry, userName, password);
                    int statusCode = r.getStatusCode();
                    r.close();
                    if (statusCode == 404) {
                        return nameToTry;
                    }
                    if (statusCode == 200) {
                        return null;
                    }
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"WPDSRH.srvrErr.ex.fmt.txt", (Object)Integer.toString(statusCode), (Object)r.getStatusMessage(), (Object)nameToTry);
                    throw new ServiceException(msg);
                }

                @Override
                public String metadataTypeForErrorMessage() {
                    return "package";
                }

                @Override
                public String repositoryForErrorMessage() {
                    return finalAbsolutePathToInstance;
                }
            };
            try {
                resultURL = (String)UniqueNameGenerator.find(suggestedName, 100, true, callback, logger, loggingId);
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e, RB.getStringResource("COM.noUniq.ex.txt"));
            }
        }
        this.setResultLocation(resultURL);
    }

    private static URL getURL(String collectionURL) throws ServiceException {
        try {
            URL url = new URL(collectionURL);
            return url;
        }
        catch (MalformedURLException me) {
            throw new ServiceException((Throwable)me, RB.getStringResource("WPDSLH.invldCollURL.txt"));
        }
    }

    private String getProtocol(URL initURL) throws ServiceException {
        String protocol = initURL.getProtocol();
        if (!(protocol = protocol.toLowerCase(Locale.US)).equals("http") && !protocol.equals("https")) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"WPDSLH.invProtcl.ex.fmt.txt", (Object)protocol, (Object)this._initialCollectionURL);
            throw new ServiceException(msg);
        }
        return protocol;
    }

    Credentials getCredentials(Logger logger, UserContextInterface userContext) throws ServiceException, RemoteException {
        Credentials credentials = new Credentials();
        if (this._userid != null) {
            credentials._userName = this._userid;
            credentials._password = this._password;
            credentials._consumerSupplied = true;
        } else {
            if (userContext != null && this._davServer != null) {
                if (this._authenticationType.equalsIgnoreCase("metadata")) {
                    credentials._userIdentity = userContext.getAuthServer().generatePassword(null);
                } else {
                    String domain = this.getDomain(logger);
                    if (domain != null) {
                        credentials._userIdentity = GetIdentityByDomainAction.getIdentity(userContext, domain, logger);
                    }
                }
                if (credentials._userIdentity != null) {
                    credentials._userName = (String)credentials._userIdentity.getPrincipal();
                    credentials._password = (String)credentials._userIdentity.getCredential();
                }
            }
            if (logger != null && logger.isDebugEnabled()) {
                if (credentials._userIdentity == null) {
                    logger.debug(RB.getStringResource("COM.credNull.txt"));
                } else {
                    if (credentials._userName == null) {
                        logger.debug(RB.getStringResource("COM.userNameNull.txt"));
                    }
                    if (credentials._password == null) {
                        logger.debug(RB.getStringResource("COM.passwd.txt"));
                    }
                }
            }
        }
        return credentials;
    }

    String getDomain(Logger logger) throws ServiceException, RemoteException {
        if (!this.attemptedToGetDomain) {
            List domains;
            this.attemptedToGetDomain = true;
            if (this._davServer != null && (domains = this._davServer.getDomains()).size() > 0) {
                if (domains.size() > 1 && logger != null) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.mulDoms.fmt.txt", (Object)this._davServer.getName());
                    logger.warn(msg);
                }
                this._domain = (String)domains.get(0);
            }
        }
        return this._domain;
    }

    private ServerComponent locateDAVServerAndBasePath(String protocol, URL initURL) throws MdException, RemoteException {
        int flags = 8584;
        List servers = this._mdOMIUtil.getMetadataObjectsSubset((MdStore)this._objectStore, this._reposFQID, "ServerComponent", flags, "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06'][DataPackages/Directory/Properties/Property[@PropertyName='SupportsWebDAV']]\"/>");
        String hostName = initURL.getHost();
        int port = initURL.getPort();
        String file = initURL.getFile();
        int matchLength = -1;
        Iterator it = servers.iterator();
        ServerComponent retSC = null;
        while (it.hasNext()) {
            ServerComponent sc = (ServerComponent)it.next();
            AssociationList al = sc.getSourceConnections();
            for (Object o : al) {
                if (!(o instanceof TCPIPConnection)) continue;
                TCPIPConnection tcpip = (TCPIPConnection)o;
                if (port == -1) {
                    int n = port = protocol.equalsIgnoreCase("http") ? 80 : 443;
                }
                if (port != tcpip.getPort() || !tcpip.getHostName().equalsIgnoreCase(hostName)) continue;
                AssociationList aldp = sc.getDataPackages();
                for (Object od : aldp) {
                    Directory d;
                    String dirName;
                    if (!(od instanceof Directory) || !file.startsWith(dirName = (d = (Directory)od).getDirectoryName()) || dirName.length() <= matchLength) continue;
                    matchLength = dirName.length();
                    this._basePath = dirName;
                    this._collectionUnderBasePath = file.substring(matchLength);
                    if (this._collectionUnderBasePath.length() > 0 && this._collectionUnderBasePath.charAt(0) == '/') {
                        this._collectionUnderBasePath = this._collectionUnderBasePath.substring(1);
                    }
                    retSC = sc;
                }
            }
        }
        return retSC;
    }

    HttpServerInterface getDAVServer() {
        return this._davServer;
    }

    String getBasePath() {
        return this._basePath;
    }

    String getCollectionUnderBasePath() {
        return this._collectionUnderBasePath;
    }

    static WebDAVPackageDAVServerLocationHelper createInstance(String initialCollectionURLvalue, boolean createNewInstance, Root root) throws RemoteException, ServiceException, MdException {
        WebDAVPackageDAVServerLocationHelper lh = new WebDAVPackageDAVServerLocationHelper(initialCollectionURLvalue, createNewInstance, root, null, null, null);
        URL initURL = WebDAVPackageDAVServerLocationHelper.getURL(lh._initialCollectionURL);
        String protocol = lh.getProtocol(initURL);
        ServerComponent sc = lh.locateDAVServerAndBasePath(protocol, initURL);
        if (sc != null) {
            lh._davServer = new OMRHttpServer(sc);
        }
        return lh;
    }
}

