/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.storedprocess.RB;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

@SASScope
class UniqueNameGenerator {
    UniqueNameGenerator() {
    }

    static String getName(int numOfChars) {
        return Names.generateName((int)numOfChars);
    }

    static Object find(String suggestedName, int numberOfTries, boolean appendDate, Callback callback, Logger logger, String loggingId) throws Exception {
        return UniqueNameGenerator.find(suggestedName, numberOfTries, 0, appendDate, callback, logger, loggingId);
    }

    static Object find(String suggestedName, int numberOfTries, int nameLength, boolean appendDate, Callback callback, Logger logger, String loggingId) throws Exception {
        if (nameLength != 0 && appendDate) {
            throw new IllegalStateException(RB.getStringResource("COM.incon.ex.txt"));
        }
        StringBuffer tries = new StringBuffer();
        for (int i = 0; i < numberOfTries; ++i) {
            Object retVal;
            String nameToTry;
            if (suggestedName == null || suggestedName.length() == 0) {
                nameToTry = UniqueNameGenerator.getName(nameLength);
            } else {
                nameToTry = suggestedName;
                suggestedName = null;
            }
            if (logger != null && logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"UNG.tryngNam.fmt.txt", (Object)nameToTry, (Object)loggingId);
                logger.debug(msg);
            }
            if ((retVal = callback.isUnique(nameToTry)) != null) {
                return retVal;
            }
            tries.append(' ');
            tries.append(nameToTry);
            if (!appendDate) continue;
            ++i;
            nameToTry = nameToTry + new Date().getTime();
            if (logger != null && logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"UNG.tryngNam.fmt.txt", (Object)nameToTry, (Object)loggingId);
                logger.debug(msg);
            }
            if ((retVal = callback.isUnique(nameToTry)) != null) {
                return retVal;
            }
            tries.append(' ');
            tries.append(nameToTry);
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"UNG.cantCreatTypItem.ex.fmt.txt", (Object)callback.metadataTypeForErrorMessage(), (Object)callback.repositoryForErrorMessage(), (Object)Integer.toString(numberOfTries), (Object)tries.toString());
        throw new ServiceException(msg);
    }

    @SASScope
    static interface Callback {
        public Object isUnique(String var1) throws Exception;

        public String metadataTypeForErrorMessage();

        public String repositoryForErrorMessage();
    }
}

