/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceFactory;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProfile;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.StoredProcessService;
import com.sas.services.storedprocess.StoredProcessServiceInterface;
import com.sas.services.storedprocess.StoredProcessServiceProfile;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class StoredProcessServiceFactory
extends AbstractServiceFactory {
    public StoredProcessServiceFactory() {
        super((ServiceProfile)new StoredProcessServiceProfile());
    }

    public final StoredProcessServiceInterface getStoredProcessService() {
        return StoredProcessService.getInstance((DiscoveryServiceInterface)DiscoveryService.defaultInstance());
    }

    public final RemoteServiceInterface getService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        StoredProcessServiceInterface service = null;
        try {
            service = StoredProcessService.getInstance(serviceConfiguration, discoveryService);
        }
        catch (RuntimeException e) {
            LogManager.getLogger(StoredProcessServiceFactory.class).error(RB.getStringResource("SPSF.cantGetSvc.txt"), (Throwable)e);
            throw e;
        }
        if (service == null) {
            throw new ServiceException(RB.getStringResource("SPSF.cantGetSvc.txt"));
        }
        return service;
    }

    public static final StoredProcessServiceInterface createService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        return (StoredProcessServiceInterface)new StoredProcessServiceFactory().getService(serviceConfiguration, discoveryService);
    }
}

