/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASStoredProcess.IStoredProcessServer;
import com.sas.iom.SASStoredProcess.IStoredProcessServer_1_1;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.services.TransportException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.SessionMap;
import com.sas.services.storedprocess.StoredProcess;
import com.sas.services.storedprocess.StoredProcess2;
import com.sas.services.storedprocess.StoredProcessInterface;
import com.sas.services.storedprocess.StoredProcessServiceInterface;
import com.sas.services.storedprocess.StoredProcessServiceProxy;
import com.sas.services.storedprocess.metadata.StoredProcessOptions;
import com.sas.services.user.UserContextInterface;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class StoredProcessService
extends AbstractRemoteService
implements StoredProcessServiceInterface {
    private boolean _destroyed = false;
    private String _clientName;
    SessionMap<IStoredProcessServer_1_1> _sessionMap11 = new SessionMap(this);
    SessionMap<IStoredProcessServer> _sessionMap = new SessionMap(this);
    private static StoredProcessService _service;
    private static StoredProcessService _standAloneService;
    private static Logger _logger;

    private StoredProcessService(DiscoveryServiceInterface discoveryService) {
        super(discoveryService);
    }

    private StoredProcessService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws RemoteException, ServiceException {
        super(discoveryService);
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)((Object)this), sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
        this.configure(serviceConfiguration);
    }

    public synchronized void destroy() throws ServiceException, RemoteException {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        short serviceState = this.getServiceState();
        if (!ServiceState.isStateDeactivated((short)serviceState)) {
            _logger = null;
            if (this._sessionMap != null) {
                this._sessionMap.destroy();
                this._sessionMap = null;
            }
            if (this._sessionMap11 != null) {
                this._sessionMap11.destroy();
                this._sessionMap11 = null;
            }
            if (_service == this) {
                _service = null;
            }
            if (_standAloneService == this) {
                _standAloneService = null;
            }
            super.destroy();
        }
    }

    static synchronized StoredProcessServiceInterface getInstance(DiscoveryServiceInterface discoveryService) {
        if (_standAloneService == null) {
            _standAloneService = new StoredProcessService(discoveryService);
        }
        return _standAloneService;
    }

    public static StoredProcessServiceInterface getInstance(ServiceConfigurationInterface serviceConfiguration) throws ServiceException {
        return StoredProcessService.getInstance(serviceConfiguration, (DiscoveryServiceInterface)DiscoveryService.defaultInstance());
    }

    public static StoredProcessServiceInterface getInstance(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        if (_service == null) {
            StoredProcessService.setService(serviceConfiguration, discoveryService);
        } else {
            try {
                _service.configure(serviceConfiguration);
            }
            catch (RemoteException e) {
                throw new ServiceException((Throwable)e, RB.getStringResource("SPS.reconfigFailed.ex.txt"));
            }
        }
        return _service;
    }

    private static final synchronized void setService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        if (_logger == null) {
            _logger = LogManager.getLogger(StoredProcessService.class);
        }
        if (_service == null) {
            try {
                _service = new StoredProcessService(serviceConfiguration, discoveryService);
                _service.bindToDiscoveryService();
            }
            catch (RemoteException e) {
                if (_logger != null) {
                    _logger.fatal(RB.getStringResource("SPS.initRem.ex.txt"), (Throwable)e);
                }
                throw new ServiceException((Throwable)e, RB.getStringResource("SPS.cantCreat.ex.txt"));
            }
        }
    }

    public final RemoteServiceInterface getServiceProxy() {
        StoredProcessServiceProxy proxy = null;
        try {
            proxy = new StoredProcessServiceProxy(_service);
        }
        catch (InitializationException e) {
            proxy = null;
        }
        return proxy;
    }

    @Override
    public StoredProcessInterface newStoredProcess(SessionContextInterface sessionContext, com.sas.services.storedprocess.metadata.StoredProcessInterface storedProcessSmartObject) throws IllegalArgumentException, InitializationException, TransportException, RemoteException {
        if (sessionContext == null) {
            throw new IllegalArgumentException(RB.getStringResource("SPS.noNulSessnCtxt.ex.txt"));
        }
        return new StoredProcess(sessionContext, storedProcessSmartObject, this);
    }

    @Override
    public Object newStoredProcess(com.sas.services.storedprocess.metadata.StoredProcessInterface smartObject, StoredProcessOptions options) throws IllegalArgumentException, InitializationException, TransportException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SPS.svcDestryd.ex.txt"));
        }
        if (options == null) {
            throw new IllegalArgumentException(RB.getStringResource("SPS.noNulOptns.ex.txt"));
        }
        if (smartObject == null) {
            throw new IllegalArgumentException(RB.getStringResource("SPS.noNulSmrtObj.ex.txt"));
        }
        SessionContextInterface sessionContext = options.getSessionContextInterface();
        if (sessionContext == null) {
            RepositoryInterface ri = smartObject.getRepository();
            if (ri == null) {
                throw new InitializationException(RB.getStringResource("SPS.noRepos.msg.txt"));
            }
            UserContextInterface uc = ri.getUserContext();
            if (uc == null) {
                throw new InitializationException(RB.getStringResource("SPS.noUserCtxt.ex.txt"));
            }
            sessionContext = uc.getSessionContext();
            if (sessionContext == null) {
                throw new IllegalArgumentException(RB.getStringResource("SPS.noSessnCtxt.ex.txt"));
            }
            options.setSessionContextInterface(sessionContext);
        }
        options.seal();
        return new StoredProcess2(smartObject, this, options);
    }

    @Override
    public StoredProcessInterface newStoredProcess(SessionContextInterface sessionContext, int serverType, int resultType) throws IllegalArgumentException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SPS.svcDestryd.ex.txt"));
        }
        return new StoredProcess(sessionContext, serverType, resultType, this);
    }

    @Override
    public Object newStoredProcess(int serverType, StoredProcessOptions options) throws IllegalArgumentException, InitializationException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SPS.svcDestryd.ex.txt"));
        }
        options.seal();
        return new StoredProcess2(serverType, options, this);
    }

    @Override
    public String getClientName() {
        return this._clientName;
    }

    @Override
    public void setClientName(String clientName) {
        this._clientName = clientName;
    }
}

