/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.UserContextEnabledObject;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.ConnectionMaker;
import com.sas.services.storedprocess.DataTableWrapper;
import com.sas.services.storedprocess.Execution2;
import com.sas.services.storedprocess.Execution2Interface;
import com.sas.services.storedprocess.ExecutionException;
import com.sas.services.storedprocess.ExecutionStatusListener2Interface;
import com.sas.services.storedprocess.GenericStream;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.MissingParameterException;
import com.sas.services.storedprocess.ObjectCache;
import com.sas.services.storedprocess.OutputParameterInterface;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.ResultTypeDeterminer;
import com.sas.services.storedprocess.StoredProcess2Interface;
import com.sas.services.storedprocess.StoredProcessService;
import com.sas.services.storedprocess.metadata.DataTable;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.storedprocess.metadata.StoredProcessOptions;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SASScope
final class StoredProcess2
extends UnicastRemoteObject
implements StoredProcess2Interface {
    static final int CREATED_BY_USER = 0;
    static final int CREATED_FROM_METADATA = 1;
    final StoredProcessService _service;
    final SessionContextInterface _sessionContext;
    UserContextInterface _userContext;
    boolean _sessionFreedOnDestroy;
    Locale _locale;
    String _privilegedUser;
    Logger _logger;
    final String _seqNum;
    private boolean _packageCapable;
    private boolean _streamCapable;
    private int _howCreated;
    private int _serverType;
    private String _description;
    private String _directory;
    private String _name;
    private String _fileName;
    LinkedHashMap<String, GenericStream> _streams;
    private PromptGroupInterface _promptGroup;
    private PromptValuesInterface _promptValues;
    private boolean _alreadyDestroyed;
    private int _executionCount;
    private ArrayList<OutputParameterInterface> _outputParms;
    private String _clientName;
    private UsageVersion _usageVersion;
    private boolean _isNineTwo;
    LinkedHashMap<String, DataTableWrapper> _sourceTables;
    LinkedHashMap<String, DataTableWrapper> _targetTables;
    private ObjectCache _objectCache;
    private LogicalServerInterface _smartObjectLogicalServer;
    private ServerContext _serverContext;
    private StoredProcessInterface.LogicalServerType _effectiveLogicalServerType;
    private StoredProcessInterface.LogicalServerType _definedLogicalServerType;
    private static int _instanceCount;

    synchronized void incrementExecutionCount() {
        ++this._executionCount;
    }

    static synchronized String getNextId() {
        return Integer.toString(++_instanceCount);
    }

    private StoredProcess2(int howCreated, StoredProcessService service, StoredProcessOptions options) throws InitializationException, RemoteException {
        block6: {
            super(SSLRMISocketFactories.getInstance().getPortForClass(0, StoredProcess2.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(StoredProcess2.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(StoredProcess2.class));
            this._directory = "";
            this._streams = new LinkedHashMap();
            this._outputParms = new ArrayList();
            this._sourceTables = new LinkedHashMap();
            this._targetTables = new LinkedHashMap();
            this._howCreated = howCreated;
            this._sessionContext = options.getSessionContextInterface();
            this._service = service;
            this._seqNum = StoredProcess2.getNextId();
            this._logger = LogManager.getLogger(StoredProcess2.class);
            if (this._service != null) {
                this._clientName = this._service.getClientName();
            }
            if (this._sessionContext != null) {
                this._userContext = this._sessionContext.getUserContext();
                if (this._userContext != null) {
                    try {
                        this._locale = this._userContext.getLocale();
                    }
                    catch (ServiceException e) {
                        String message = RB.getStringResource("COM.noLocale.txt");
                        if (this._logger == null || !this._logger.isInfoEnabled()) break block6;
                        this._logger.info(message, (Throwable)e);
                    }
                }
            }
        }
        if (this._locale == null) {
            this._locale = Locale.getDefault();
        }
    }

    StoredProcess2(int serverType, StoredProcessOptions options, StoredProcessService service) throws IllegalArgumentException, InitializationException, RemoteException {
        this(0, service, options);
        String msg;
        if (serverType != 1 && serverType != 2) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.illSrvrVal.ex.fmt.txt", (Object)Integer.toString(serverType));
            this.logMessageAndThrowIllegalStateException(msg);
        }
        this._usageVersion = options.getUsageVersion();
        this._isNineTwo = this._usageVersion.equals((Object)StoredProcessInterface.NINETWO_VERSION);
        this._packageCapable = true;
        this._serverType = serverType;
        if (this._serverType == 1 || this._usageVersion.compareTo((Object)StoredProcessInterface.NINETWO_VERSION) > 0) {
            this._streamCapable = true;
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.manCrtd.fmt.txt", (Object)Integer.toString(this._serverType), (Object)this._seqNum);
            this._logger.debug(msg);
        }
        this._promptGroup = new PromptGroup();
        this._promptValues = new PromptValues(this._promptGroup, null);
    }

    StoredProcess2(StoredProcessInterface smartObject, StoredProcessService service, StoredProcessOptions options) throws InitializationException, TransportException, RemoteException {
        this(0, service, options);
        if (this._userContext == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.noUserContext.ex.fmt.txt", (Object)smartObject.getName());
            this.logMessageAndThrowInitializationException(msg);
        }
        try {
            String invalid;
            String msg;
            boolean sourceInFileSystem;
            String msg2;
            String publicType;
            this._objectCache = new ObjectCache(this._userContext, smartObject);
            StoredProcessInterface storedProcessSmartObject = this._objectCache.getSmartObject();
            ClassifierMap classifierMap = this._objectCache.getClassifierMap();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.omrCrtng.fmt.txt", (Object)classifierMap.getName(), (Object)classifierMap.getFQID(), (Object)this._seqNum);
                this._logger.debug(msg3);
            }
            if ((publicType = classifierMap.getPublicType()).equalsIgnoreCase("StoredProcess")) {
                double ver = classifierMap.getUsageVersion();
                this._usageVersion = UsageVersion.decode((double)ver);
                if (!this._usageVersion.isReadCompatible(MetadataConstants.OLDEST_VERSION, MetadataConstants.CURRENT_VERSION)) {
                    msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.invldVer.ex.fmt.txt", (Object)classifierMap.getName(), (Object)this._usageVersion.toString());
                    this.logMessageAndThrowInitializationException(msg2);
                }
                this._isNineTwo = this._usageVersion.equals((Object)StoredProcessInterface.NINETWO_VERSION);
            } else if (publicType.length() > 0) {
                String msg4 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.invldPubTyp.ex.fmt.txt", (Object)classifierMap.getName(), (Object)publicType);
                this.logMessageAndThrowInitializationException(msg4);
            } else {
                String msg5 = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.missnPubTyp.ex.fmt.txt", (Object)classifierMap.getName());
                this.logMessageAndThrowInitializationException(msg5);
            }
            this.setName(classifierMap.getName());
            this.setDescription(classifierMap.getDesc());
            if (this._usageVersion.equals((Object)StoredProcessInterface.NINETWO_VERSION)) {
                this.doSetLogicalServer(this._objectCache);
            } else {
                this.doSetServerContext(this._objectCache);
            }
            try {
                BaseOMRPromptInterface omrPI = storedProcessSmartObject.getPrompt();
                if (omrPI instanceof OMRPromptGroupInterface) {
                    OMRPromptGroupInterface omrPGI = (OMRPromptGroupInterface)omrPI;
                    this._promptGroup = omrPGI.getPromptGroup();
                } else {
                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noOMRPGI.ex.txt"));
                }
            }
            catch (ServiceException e) {
                this.logMessageAndThrowInitializationException((Exception)((Object)e), RB.getStringResource("SP2.prmptGet.ex.txt"));
            }
            this._promptValues = new PromptValues(this._promptGroup, null);
            if (this._usageVersion.equals((Object)StoredProcessInterface.NINETWO_VERSION)) {
                sourceInFileSystem = true;
            } else {
                StoredProcessInterface.SourceCodeLocation scl = storedProcessSmartObject.getSourceCodeLocation();
                boolean bl = sourceInFileSystem = scl == StoredProcessInterface.SourceCodeLocation.FILE_SYSTEM;
            }
            if (sourceInFileSystem) {
                Text sc = classifierMap.getSourceCode();
                if (sc instanceof File) {
                    File f = (File)sc;
                    this.setFileName(f.getFileName());
                    this.setDirectory("");
                    if (f.getIsARelativeName() == 0) {
                        if (this._serverType == 2 && this._logger != null) {
                            msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.noRepos.fmt.txt", (Object)this.getName());
                            this._logger.warn(msg);
                        }
                    } else {
                        boolean seenAssociatedObject = false;
                        AssociationList v = f.getDirectories();
                        for (int i = 0; i < v.size(); ++i) {
                            Directory d = (Directory)v.get(i);
                            AssociationList vv = d.getProperties();
                            boolean isASourceCodeRepository = false;
                            for (int ii = 0; ii < vv.size(); ++ii) {
                                Property p = (Property)vv.get(ii);
                                if (!p.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) continue;
                                isASourceCodeRepository = true;
                                break;
                            }
                            if (!isASourceCodeRepository) continue;
                            if (seenAssociatedObject) {
                                if (this._logger == null) continue;
                                String msg6 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulAssoc.fmt.txt", (Object)"Directories", (Object)"File", (Object)d.getName());
                                this._logger.warn(msg6);
                                continue;
                            }
                            seenAssociatedObject = true;
                            this.setDirectory(d.getDirectoryName());
                        }
                        if (!seenAssociatedObject) {
                            int numOfDirs = MetadataConstants.getCountNoSecurity(this._sessionContext, (Root)f, "Directories");
                            if (numOfDirs > v.size()) {
                                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noPermissnDir.ex.txt"));
                            }
                            this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noDir.ex.txt"));
                        }
                    }
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.dirNFile.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)this.getDirectory(), (Object)this.getFileName());
                        this._logger.debug(msg);
                    }
                } else if (sc == null) {
                    int numOfFiles = MetadataConstants.getCountNoSecurity(this._sessionContext, (Root)classifierMap, "SourceCode");
                    if (numOfFiles > 0) {
                        this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noPermissnFile.ex.txt"));
                    }
                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noFil.ex.txt"));
                } else {
                    msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.noFil2.ex.fmt.txt", (Object)sc.getCMetadataType());
                    this.logMessageAndThrowInitializationException(msg2);
                }
            } else if (storedProcessSmartObject.getSourceCode().trim().length() == 0) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noSrcCode.txt"));
            }
            String textStoreXML = null;
            for (Object o : classifierMap.getNotes()) {
                TextStore ts;
                if (!(o instanceof TextStore) || !(ts = (TextStore)o).getTextRole().equalsIgnoreCase("StoredProcessConfiguration") || !ts.getTextType().equalsIgnoreCase("XML")) continue;
                textStoreXML = ts.getStoredText();
                break;
            }
            if (!this._isNineTwo && textStoreXML == null) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.missnTxtStorXML.txt"));
            }
            if (textStoreXML != null && textStoreXML.length() > 0) {
                String msg7 = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.txtStorXML.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)textStoreXML);
                this._logger.debug(msg7);
                Document document = null;
                try {
                    document = XMLUtil.convertStringToDocument((String)textStoreXML);
                }
                catch (Exception e) {
                    this.logMessageAndThrowInitializationException(e.getMessage());
                }
                NodeList list = document.getElementsByTagName("StoredProcess");
                if (list.getLength() > 1) {
                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.multplSPTag.txt"));
                }
                if (list.getLength() == 1) {
                    Element spE = (Element)list.item(0);
                    NodeList list2 = spE.getElementsByTagName("ResultCapabilities");
                    if (list2.getLength() > 1) {
                        this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.multplRCTag.txt"));
                    }
                    if (list2.getLength() == 1) {
                        Element rcE = (Element)list2.item(0);
                        String val = rcE.getAttribute("Package");
                        if (val != null) {
                            this._packageCapable = val.equalsIgnoreCase("true");
                        }
                        if ((val = rcE.getAttribute("Streaming")) != null) {
                            this._streamCapable = val.equalsIgnoreCase("true");
                        }
                    }
                    try {
                        List<OutputParameterInterface> opList = MetadataConstants.getOutputParametersFromXML(spE);
                        for (OutputParameterInterface opi : opList) {
                            this._outputParms.add(opi);
                        }
                    }
                    catch (MetadataConstants.MCException e) {
                        this.logMessageAndThrowInitializationException(e.getMessage());
                    }
                    try {
                        RepositoryInterface ri = storedProcessSmartObject.getRepository();
                        ServerInterface si = ri.getServer();
                        ArrayList sourcesAndtargets = new ArrayList();
                        MetadataConstants.getDataSourcesAndTargetsFromXML(si, spE, sourcesAndtargets);
                        for (Object o : sourcesAndtargets) {
                            if (o instanceof GenericStream) {
                                GenericStream gs = (GenericStream)o;
                                this._streams.put(gs._normalizedName, gs);
                                continue;
                            }
                            if (!(o instanceof DataTable)) continue;
                            DataTable dt = (DataTable)o;
                            String parmName = dt.getParameterName();
                            DataTableWrapper dtw = new DataTableWrapper((DataTable)o);
                            if (dt.isSource()) {
                                this._sourceTables.put(parmName, dtw);
                                continue;
                            }
                            this._targetTables.put(parmName, dtw);
                        }
                    }
                    catch (MetadataConstants.MCException e) {
                        this.logMessageAndThrowInitializationException(e.getMessage());
                    }
                }
            }
            if ((invalid = this.validateServerAndResultTypes(this._serverType)) != null) {
                this.logMessageAndThrowInitializationException(invalid);
            }
            if (this._logger != null && this._logger.isDebugEnabled()) {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.omrCrtd.fmt.txt", (Object)this.getName(), (Object)this._seqNum);
                this._logger.debug(msg);
            }
            this._howCreated = 1;
        }
        catch (MdException e) {
            String msg = RB.getStringResource("SP.omrCr.ex.txt");
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(msg, (Throwable)e);
            }
            throw new TransportException((Throwable)e, msg);
        }
        catch (ServiceException e) {
            String msg = RB.getStringResource("SP.omrCr.ex.txt");
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(msg, (Throwable)e);
            }
            throw new TransportException((Throwable)e, msg);
        }
    }

    private void doSetLogicalServer(ObjectCache objectCache) throws RemoteException, MdException, ServiceException {
        ClassifierMap classifierMap = objectCache.getClassifierMap();
        ServerContext serverContext = null;
        LogicalServer logicalServer = null;
        AssociationList v = classifierMap.getComputeLocations();
        int count = v.size();
        String classid = null;
        for (int i = 0; i < count; ++i) {
            CMetadata server = (CMetadata)v.get(i);
            if (server instanceof LogicalServer) {
                String msg;
                LogicalServerInterface srvr = null;
                try {
                    srvr = (LogicalServerInterface)objectCache.getRepository().factoryProcess((Object)server);
                }
                catch (ServiceException se) {
                    this.logMessageAndThrowInitializationException(se.getMessage());
                }
                classid = srvr.getClassIdentifier();
                if (logicalServer == null) {
                    if (classid.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classid.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                        this._serverType = 2;
                    } else if (classid.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                        this._serverType = 1;
                    } else {
                        msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.unsupClsid.ex.fmt.txt", (Object)classid);
                        this.logMessageAndThrowInitializationException(msg);
                    }
                    logicalServer = (LogicalServer)server;
                    this._smartObjectLogicalServer = srvr;
                    if (this._logger == null || !this._logger.isDebugEnabled()) continue;
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.logSrvr.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)logicalServer.getName(), (Object)logicalServer.getFQID());
                    this._logger.debug(msg);
                    continue;
                }
                if (this._logger != null) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulSrvers.fmt.txt", (Object)this.getName(), (Object)srvr.getName());
                    this._logger.warn(msg);
                }
                if (classid.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classid.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                    if (this._serverType != 1) continue;
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulClsid.ex.fmt.txt", (Object)this.getName());
                    this.logMessageAndThrowInitializationException(msg);
                    continue;
                }
                if (classid.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                    if (this._serverType != 2) continue;
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulClsid.ex.fmt.txt", (Object)this.getName());
                    this.logMessageAndThrowInitializationException(msg);
                    continue;
                }
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.unsupClsid.ex.fmt.txt", (Object)classid);
                this.logMessageAndThrowInitializationException(msg);
                continue;
            }
            if (!(server instanceof ServerContext)) continue;
            serverContext = (ServerContext)server;
        }
        if (logicalServer == null) {
            int numOfServers = MetadataConstants.getCountNoSecurity(this._sessionContext, (Root)classifierMap, "ComputeLocations");
            if (numOfServers > count) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noPermissnSrvr.ex.txt"));
            }
            this.logMessageAndThrowInitializationException(RB.getStringResource("SP.missnSrvr.ex.txt"));
        }
        if (serverContext != null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.bothSrvrs.ex.fmt.txt", (Object)this.getName(), (Object)serverContext.getName(), (Object)logicalServer.getName());
            this.logMessageAndThrowInitializationException(msg);
        }
    }

    private void doSetServerContext(ObjectCache objectCache) throws RemoteException, MdException, ServiceException {
        LogicalServer lsSPS;
        LogicalServer lsWKS;
        ClassifierMap classifierMap = objectCache.getClassifierMap();
        LogicalServer logicalServer = null;
        ServerContext serverContext = null;
        AssociationList v = classifierMap.getComputeLocations();
        int count = v.size();
        for (int i = 0; i < count; ++i) {
            CMetadata server = (CMetadata)v.get(i);
            if (server instanceof ServerContext) {
                String msg;
                if (serverContext == null) {
                    this._serverContext = serverContext = (ServerContext)server;
                    if (this._logger == null || !this._logger.isDebugEnabled()) continue;
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.srvrCtxt.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)serverContext.getName(), (Object)serverContext.getFQID());
                    this._logger.debug(msg);
                    continue;
                }
                if (this._logger == null) continue;
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.mulSrvrCtxts.fmt.txt", (Object)this.getName(), (Object)this._serverContext.getName());
                this._logger.warn(msg);
                continue;
            }
            if (!(server instanceof LogicalServer)) continue;
            logicalServer = (LogicalServer)server;
        }
        if (serverContext == null) {
            int numOfServers = MetadataConstants.getCountNoSecurity(this._sessionContext, (Root)classifierMap, "ComputeLocations");
            if (numOfServers > count) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noPermissnSrvrCtxt.ex.txt"));
            }
            this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.missnSrvrCtxt.ex.txt"));
        }
        if (logicalServer != null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.bothSrvrs.ex.fmt.txt", (Object)this.getName(), (Object)serverContext.getName(), (Object)logicalServer.getName());
            this.logMessageAndThrowInitializationException(msg);
        }
        this._definedLogicalServerType = objectCache.getSmartObject().getLogicalServerType();
        if (this._definedLogicalServerType == StoredProcessInterface.LogicalServerType.WORKSPACE || this._definedLogicalServerType == StoredProcessInterface.LogicalServerType.STORED_PROCESS) {
            LogicalServer ls = MetadataConstants.getLogicalServerFromServerContext(this._definedLogicalServerType == StoredProcessInterface.LogicalServerType.WORKSPACE, serverContext);
            if (ls == null) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.missnLogSrvr.txt"));
            }
            this._effectiveLogicalServerType = this._definedLogicalServerType;
            if (this._definedLogicalServerType == StoredProcessInterface.LogicalServerType.WORKSPACE) {
                lsWKS = ls;
                lsSPS = null;
            } else {
                lsWKS = null;
                lsSPS = ls;
            }
        } else {
            lsWKS = MetadataConstants.getLogicalServerFromServerContext(true, serverContext);
            lsSPS = MetadataConstants.getLogicalServerFromServerContext(false, serverContext);
            if (lsWKS != null && lsSPS != null) {
                this._effectiveLogicalServerType = this._definedLogicalServerType;
            } else if (lsWKS != null) {
                this._effectiveLogicalServerType = StoredProcessInterface.LogicalServerType.WORKSPACE;
            } else if (lsSPS != null) {
                this._effectiveLogicalServerType = StoredProcessInterface.LogicalServerType.STORED_PROCESS;
            } else {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noLogSrvr.txt"));
            }
        }
        this.set_serverTypeAnd_smartObjectLogicalServerForV2SP(lsWKS, lsSPS);
    }

    private void set_serverTypeAnd_smartObjectLogicalServerForV2SP(LogicalServer lsWKS, LogicalServer lsSPS) throws ServiceException, RemoteException {
        LogicalServer ls = lsSPS;
        switch (this._effectiveLogicalServerType) {
            case ANY: {
                this._serverType = 1;
                break;
            }
            case STORED_PROCESS: {
                this._serverType = 1;
                break;
            }
            case WORKSPACE: {
                this._serverType = 2;
                ls = lsWKS;
            }
        }
        this._smartObjectLogicalServer = (LogicalServerInterface)this._objectCache.getRepository().factoryProcess((Object)ls);
    }

    private void logMessageAndThrowInitializationException(Exception e, String message) throws InitializationException {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(message, (Throwable)e);
        }
        throw new InitializationException((Throwable)e, message);
    }

    private void logMessageAndThrowInitializationException(String message) throws InitializationException {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(message);
        }
        throw new InitializationException(message);
    }

    private void logMessageAndThrowIllegalStateException(String message) {
        if (this._logger != null) {
            this._logger.error(message);
        }
        throw new IllegalStateException(message);
    }

    @Override
    public boolean isStreamCapable() {
        this.checkIfDestroyed();
        return this._streamCapable;
    }

    @Override
    public boolean isPackageCapable() {
        this.checkIfDestroyed();
        return this._packageCapable;
    }

    @Override
    public void setDescription(String description) {
        this.checkIfDestroyed();
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._description = description;
    }

    private void setDirectory(String directory) {
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._directory = directory;
    }

    @Override
    public void setSourceFromFile(String directory, String fileName) {
        this.checkIfDestroyed();
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._directory = directory;
        this._fileName = fileName;
    }

    @Override
    public void setName(String name) {
        this.checkIfDestroyed();
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._name = name;
    }

    private void setFileName(String fileName) {
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._fileName = fileName;
    }

    @Override
    public void setPrivilegedUser(String privilegedUser) {
        this.checkIfDestroyed();
        this._privilegedUser = privilegedUser;
    }

    @Override
    public int getServerType() {
        this.checkIfDestroyed();
        return this._serverType;
    }

    @Override
    public LogicalServerInterface getServer() {
        this.checkIfDestroyed();
        return this._smartObjectLogicalServer;
    }

    @Override
    public PromptDefinitionInterface setParameterValue(String name, Object value) throws RemoteException, ServiceException, InvalidPromptValueException {
        this.checkIfDestroyed();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = value == null ? Message.format((ResourceBundle)RB.getResources(), (String)"SP.noParmValSet.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)name) : Message.format((ResourceBundle)RB.getResources(), (String)"SP.parmValSet.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)name, (Object)value.getClass().getName(), (Object)value.toString());
            this._logger.debug(msg);
        }
        try {
            Names.validateSASVariableName((String)name, (boolean)true);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(msg);
            }
            throw new ServiceException(msg);
        }
        PromptDefinitionInterface pd = PromptUtil.findPromptDefinitionByName((PromptValuesInterface)this._promptValues, (String)name, (boolean)true, (boolean)false, (boolean)true);
        if (pd == null) {
            pd = this.addTextPrompt(name, value);
        }
        this._promptValues.setPromptValue(pd, value);
        return pd;
    }

    private PromptDefinitionInterface addTextPrompt(String name, Object value) throws ServiceException {
        if (value instanceof String || value instanceof String[]) {
            TextDefinition td = new TextDefinition(name);
            if (value instanceof String[]) {
                td.setMaximumValueCount(Integer.MAX_VALUE);
            }
            this._promptGroup.addPromptDefinition((PromptDefinitionInterface)td);
            return td;
        }
        if (value == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.onlyStrValsNotNull.ex.fmt.txt", (Object)name);
            throw new ServiceException(msg);
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.onlyStrVals.ex.fmt.txt", (Object)value.getClass().getName(), (Object)name);
        throw new ServiceException(msg);
    }

    @Override
    public void validatePromptValues() throws IllegalStateException, InvalidPromptValueException, RemoteException {
        Object obj;
        Object object = obj = this._sessionContext != null ? this._sessionContext.getAttribute("com.sas.prompts.dataProviderKey") : null;
        if (obj != null && !(obj instanceof DataProviderInterface)) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.noDPI.ex.fmt.txt", (Object)obj.getClass().toString());
            throw new IllegalStateException(msg);
        }
        DataProviderInterface dpi = (DataProviderInterface)obj;
        DynamicPromptValueContext dynamicPromptValueContext = null;
        if (dpi != null) {
            if (dpi instanceof UserContextEnabledObject && ((UserContextEnabledObject)dpi).getUserContext() == null && this._userContext != null) {
                ((UserContextEnabledObject)dpi).setUserContext(this._userContext);
            }
            dynamicPromptValueContext = new DynamicPromptValueContext(this._promptValues, this._promptValues.getPromptGroup(), null, dpi);
        }
        PromptUtil.validateDynamicPromptValues((PromptValuesInterface)this._promptValues, dynamicPromptValueContext, (Locale)this._locale);
    }

    @Override
    public Map setParameterValues(Map map) throws RemoteException, ServiceException {
        String name;
        this.checkIfDestroyed();
        HashMap cloneMap = new HashMap(map.size());
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Object obj = entry.getKey();
            if (!(obj instanceof String)) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.noStringKey.ex.fmt.txt", (Object)obj.toString(), obj.getClass());
                throw new IllegalArgumentException(msg);
            }
            name = (String)obj;
            try {
                Names.validateSASVariableName((String)name, (boolean)true);
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(msg);
                }
                throw new ServiceException(msg);
            }
            cloneMap.put(name, entry.getValue());
        }
        Map errorMap = PromptUtil.setPromptValuesByNameValuePair((PromptValuesInterface)this._promptValues, (PromptGroupInterface)this._promptGroup, cloneMap, (boolean)true);
        entries = cloneMap.entrySet();
        for (Map.Entry entry : entries) {
            try {
                name = (String)entry.getKey();
                Object value = entry.getValue();
                PromptDefinitionInterface pd = this.addTextPrompt(name, value);
                this._promptValues.setPromptValue(pd, value);
            }
            catch (Exception e) {
                errorMap.put(entry.getKey(), e);
            }
        }
        return errorMap;
    }

    @Override
    public boolean addInputStream(String streamKey) throws RemoteException, IllegalStateException {
        this.checkIfDestroyed();
        if (this._isNineTwo && this._serverType != 1) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP2.noStreamSup.ex.txt"));
        }
        try {
            Names.validateSASFilerefName((String)streamKey, (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            this.logMessageAndThrowIllegalStateException(ex.getMessage());
        }
        GenericStream gs = new GenericStream(streamKey, false, false);
        GenericStream gsOld = this._streams.get(gs._normalizedName);
        if (gsOld == null) {
            this._streams.put(gs._normalizedName, gs);
            return true;
        }
        if (gsOld.isEqualsTo(gs)) {
            return false;
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.strmDefAsOutput.ex.fmt.txt", (Object)streamKey);
        this.logMessageAndThrowIllegalStateException(msg);
        return false;
    }

    @Override
    public boolean addOutputStream(String streamKey, boolean isMultiPass) throws RemoteException, IllegalStateException {
        this.checkIfDestroyed();
        if (this._isNineTwo && this._serverType != 1) {
            throw new IllegalStateException(RB.getStringResource("SP2.noStreamSup.ex.txt"));
        }
        try {
            Names.validateSASFilerefName((String)streamKey, (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            this.logMessageAndThrowIllegalStateException(ex.getMessage());
        }
        GenericStream gs = new GenericStream(streamKey, isMultiPass, true);
        GenericStream gsOld = this._streams.get(gs._normalizedName);
        if (gsOld == null) {
            this._streams.put(gs._normalizedName, gs);
            return true;
        }
        if (gsOld.isEqualsTo(gs)) {
            return false;
        }
        String msg = gsOld._isSource != gs._isSource ? Message.format((ResourceBundle)RB.getResources(), (String)"SP.strmDefAsInput.ex.fmt.txt", (Object)streamKey) : Message.format((ResourceBundle)RB.getResources(), (String)"SP.strmDefWithDiffOpt.ex.fmt.txt", (Object)streamKey);
        this.logMessageAndThrowIllegalStateException(msg);
        return false;
    }

    @Override
    public String[] getInputStreamNames() throws RemoteException, IllegalStateException {
        this.checkIfDestroyed();
        return this.getInputOutputStreamNames(true);
    }

    @Override
    public String[] getOutputStreamNames() throws RemoteException, IllegalStateException {
        this.checkIfDestroyed();
        return this.getInputOutputStreamNames(false);
    }

    private String[] getInputOutputStreamNames(boolean input) throws IllegalStateException {
        if (this._isNineTwo && this._serverType != 1) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP2.noStreamSup.ex.txt"));
        }
        ArrayList<String> names = new ArrayList<String>(this._streams.size());
        for (GenericStream gs : this._streams.values()) {
            if (gs._isSource != input) continue;
            names.add(gs._normalizedName);
        }
        return names.toArray(new String[0]);
    }

    @Override
    public String getDescription() {
        this.checkIfDestroyed();
        return this._description;
    }

    @Override
    public String getDirectory() {
        this.checkIfDestroyed();
        return this._directory;
    }

    @Override
    public String getName() {
        this.checkIfDestroyed();
        return this._name;
    }

    @Override
    public String getFileName() {
        this.checkIfDestroyed();
        return this._fileName;
    }

    @Override
    public boolean hasParameters() throws RemoteException {
        this.checkIfDestroyed();
        PromptDefinitionInterface[] parmList = this.getParameters();
        return parmList.length > 0;
    }

    @Override
    public PromptValuesInterface getPromptValues() {
        this.checkIfDestroyed();
        return this._promptValues;
    }

    @Override
    public void setPromptValues(PromptValuesInterface promptValues) {
        this.checkIfDestroyed();
        PromptGroupInterface promptGroup = promptValues.getPromptGroup();
        if (promptGroup == null) {
            throw new IllegalArgumentException(RB.getStringResource("SP2.noPrmptGrp.ex.txt"));
        }
        this._promptGroup = promptGroup;
        this._promptValues = promptValues;
    }

    @Override
    public PromptDefinitionInterface[] getParameters() throws RemoteException {
        this.checkIfDestroyed();
        List parmList = this._promptGroup.getPromptDefinitions(true);
        return parmList.toArray(new PromptDefinitionInterface[0]);
    }

    @Override
    public Object getParameterValue(String parameterName) {
        this.checkIfDestroyed();
        List definitons = PromptUtil.getVisualOrderOfDefinitions((PromptValuesInterface)this._promptValues, (boolean)true);
        for (PromptDefinitionInterface pd : definitons) {
            if (!parameterName.equalsIgnoreCase(pd.getPromptName())) continue;
            try {
                return this._promptValues.getPromptValue(pd);
            }
            catch (PromptValueNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void destroy() throws RemoteException {
        this.checkIfDestroyed();
        this._alreadyDestroyed = true;
        try {
            StoredProcess2.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        try {
            if (this._objectCache != null) {
                this._objectCache.destroy(this._logger);
            }
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<PromptDefinitionInterface> setParameterValues(PromptValuesInterface promptValues) throws RemoteException, ServiceException {
        PromptDefinitionInterface incomingPD;
        String name;
        this.checkIfDestroyed();
        if (promptValues == null) {
            throw new IllegalArgumentException(RB.getStringResource("SP2.nullPVobj.ex.txt"));
        }
        ArrayList<PromptDefinitionInterface> list = new ArrayList<PromptDefinitionInterface>();
        if (promptValues == this._promptValues) {
            return list;
        }
        Map mapOfIncomingPDsToValues = promptValues.getPromptValues();
        Map mapOfExistingPDWhichHaveValues = this._promptValues.getPromptValues();
        for (Map.Entry me : mapOfExistingPDWhichHaveValues.entrySet()) {
            PromptDefinitionInterface existingPD = (PromptDefinitionInterface)me.getKey();
            String nameOfPromptWhichCurrentlyHasAValue = existingPD.getPromptName();
            PromptDefinitionInterface incomingPD2 = PromptUtil.findPromptDefinitionByName((PromptValuesInterface)promptValues, (String)nameOfPromptWhichCurrentlyHasAValue, (boolean)true, (boolean)false, (boolean)true);
            if (incomingPD2 == null) continue;
            if (existingPD.isFixed()) {
                mapOfIncomingPDsToValues.remove(incomingPD2);
                continue;
            }
            if (promptValues.isPromptValueSet(incomingPD2)) continue;
            this._promptValues.clearPromptValue(existingPD);
            if (!incomingPD2.isDefaultValueSet() || !existingPD.isDefaultValueSet() || !PromptUtil.isPromptValuesEqual((Object)incomingPD2.getDefaultValue(), (Object)existingPD.getDefaultValue())) continue;
            mapOfIncomingPDsToValues.remove(incomingPD2);
        }
        HashMap mapOfIncomingNamesToValues = new HashMap(mapOfIncomingPDsToValues.size());
        HashMap<String, PromptDefinitionInterface> mapOfIncomingNamesToPDs = new HashMap<String, PromptDefinitionInterface>(mapOfIncomingPDsToValues.size());
        for (Map.Entry me : mapOfIncomingPDsToValues.entrySet()) {
            PromptDefinitionInterface pdi = (PromptDefinitionInterface)me.getKey();
            mapOfIncomingNamesToValues.put(pdi.getPromptName(), me.getValue());
            mapOfIncomingNamesToPDs.put(pdi.getPromptName(), pdi);
        }
        Map errorMap = PromptUtil.setPromptValuesByNameValuePair((PromptValuesInterface)this._promptValues, (PromptGroupInterface)this._promptGroup, mapOfIncomingNamesToValues, (boolean)true);
        for (Map.Entry me : mapOfIncomingNamesToValues.entrySet()) {
            name = (String)me.getKey();
            Object incomingValue = me.getValue();
            incomingPD = (PromptDefinitionInterface)mapOfIncomingNamesToPDs.get(name);
            list.add(incomingPD);
            if (this._logger == null || !this._logger.isInfoEnabled()) continue;
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.ignoredPD.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)incomingPD.getPromptName(), (Object)incomingValue.toString());
            this._logger.info(msg);
        }
        if (this._logger != null && this._logger.isInfoEnabled()) {
            for (Map.Entry me : errorMap.entrySet()) {
                name = (String)me.getKey();
                Exception exception = (Exception)me.getValue();
                incomingPD = (PromptDefinitionInterface)mapOfIncomingNamesToPDs.get(name);
                Object incomingValue = mapOfIncomingPDsToValues.get(incomingPD);
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.ignoredPDExcp.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)name, incomingValue, (Object)exception.toString());
                this._logger.info(msg);
            }
        }
        return list;
    }

    private void doPromptValidationBeforeExecute() throws ExecutionException {
        Map dupMap = PromptUtil.getDuplicateDefintionsByName((PromptGroupInterface)this._promptGroup, (boolean)true);
        Set keyset = dupMap.keySet();
        int dupMapSize = keyset.size();
        if (dupMapSize > 0) {
            String separator = RB.getStringResource("COM.listItemSeparator.txt");
            String names = "";
            int i = 0;
            Iterator it = keyset.iterator();
            while (it.hasNext()) {
                if (i++ > 0) {
                    names = names + separator;
                }
                names = names + it.next().toString();
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.dupPrompts.ex.fmt.txt", (Object)dupMapSize, (Object)names);
            if (this._logger != null) {
                this._logger.debug(msg);
            }
            throw new ExecutionException(msg);
        }
        List valueless = PromptUtil.getRequiredPromptsWithoutValues((PromptValuesInterface)this._promptValues);
        int valuelessSize = valueless.size();
        if (valuelessSize > 0) {
            String separator = RB.getStringResource("COM.listItemSeparator.txt");
            String names = "";
            int i = 0;
            for (PromptDefinitionInterface pdi : valueless) {
                if (i++ > 0) {
                    names = names + separator;
                }
                names = names + pdi.getPromptName();
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.reqPromptsNoVal.ex.fmt.txt", (Object)valuelessSize, (Object)names);
            if (this._logger != null) {
                this._logger.debug(msg);
            }
            throw new MissingParameterException(msg);
        }
        dupMap = PromptUtil.getDuplicateMacrosByName((PromptValuesInterface)this._promptValues, (Locale)this._locale, (boolean)true);
        keyset = dupMap.keySet();
        dupMapSize = keyset.size();
        if (dupMapSize > 0) {
            String separator = RB.getStringResource("COM.listItemSeparator.txt");
            String names = "";
            int i = 0;
            Iterator it = keyset.iterator();
            while (it.hasNext()) {
                if (i++ > 0) {
                    names = names + separator;
                }
                names = names + it.next().toString();
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.dupPromptsAfterExpn.ex.fmt.txt", (Object)dupMapSize, (Object)names);
            if (this._logger != null) {
                this._logger.debug(msg);
            }
            throw new ExecutionException(msg);
        }
    }

    @Override
    public Execution2Interface executeAsynch(ExecutionStatusListener2Interface listener, boolean createAlert) throws IllegalStateException, ExecutionException, RemoteException {
        Execution2 execution;
        this.incrementExecutionCount();
        this.checkIfDestroyed();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.exeAsyncInvk.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)(createAlert ? 1 : 0));
            this._logger.debug(msg);
        }
        if (this._userContext == null && createAlert) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.userCtxtNeededForAlrt.ex.txt"));
        }
        this.doPromptValidationBeforeExecute();
        try {
            execution = this._isNineTwo ? new Execution2(this, this._smartObjectLogicalServer, createAlert, this._executionCount, true, this._objectCache) : new Execution2(this, this._serverContext, createAlert, this._executionCount, true, this._objectCache);
            execution.execute(this, false, listener);
        }
        catch (ExecutionException ee) {
            if (this._logger != null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (Object)this.getName());
                this._logger.debug(msg, (Throwable)ee);
            }
            throw ee;
        }
        return execution;
    }

    @Override
    public Execution2Interface execute(boolean synchronous, ExecutionStatusListener2Interface listener, boolean createAlert, Object connection) throws IllegalStateException, ExecutionException, RemoteException {
        Execution2 execution;
        this.incrementExecutionCount();
        this.checkIfDestroyed();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.exeInvk.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)(synchronous ? 1 : 0), (Object)(createAlert ? 1 : 0));
            this._logger.debug(msg);
        }
        if (this._userContext == null && createAlert) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.userCtxtNeededForAlrt.ex.txt"));
        }
        this.doPromptValidationBeforeExecute();
        try {
            if (connection == null) {
                execution = this._isNineTwo ? new Execution2(this, this._smartObjectLogicalServer, createAlert, this._executionCount, false, this._objectCache) : new Execution2(this, this._serverContext, createAlert, this._executionCount, false, this._objectCache);
            } else if (connection instanceof String) {
                String sessionID = (String)connection;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.exeSessnID.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)sessionID);
                    this._logger.debug(msg);
                }
                if (this._serverType != 1) {
                    this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.sessnIDOnlyForSPSrvr.ex.txt"));
                }
                if (sessionID == null || sessionID.length() == 0) {
                    this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.noSessnID.ex.txt"));
                }
                execution = new Execution2(this, sessionID, createAlert, this._executionCount, this._objectCache);
            } else {
                execution = new Execution2(this, connection, createAlert, this._executionCount, this._objectCache);
            }
            execution.execute(this, synchronous, listener);
        }
        catch (ExecutionException ee) {
            if (this._logger != null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (Object)this.getName());
                this._logger.debug(msg, (Throwable)ee);
            }
            throw ee;
        }
        return execution;
    }

    private String validateServerAndResultTypes(int serverType) {
        if (this._isNineTwo && serverType == 2 && this._streamCapable) {
            return RB.getStringResource("SP2.inconSrvrRsltCap.ex.txt");
        }
        return null;
    }

    private void checkIfDestroyed() {
        if (this._alreadyDestroyed) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.destryCalld.ex.txt"));
        }
    }

    static boolean checkPropertyRolePresence(Root object, String propertyRole, String defaultValue, boolean equals) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (!p.getPropertyRole().equalsIgnoreCase(propertyRole)) continue;
            if (defaultValue == null) {
                return true;
            }
            if (equals) {
                return defaultValue.equals(p.getDefaultValue());
            }
            return !defaultValue.equals(p.getDefaultValue());
        }
        return false;
    }

    static boolean checkPropertyNamePresence(Root object, String propertyName, String defaultValue, boolean equals) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (!p.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            if (defaultValue == null) {
                return true;
            }
            if (equals) {
                return defaultValue.equals(p.getDefaultValue());
            }
            return !defaultValue.equals(p.getDefaultValue());
        }
        return false;
    }

    @Override
    public List<OutputParameterInterface> getOutputParameters() throws RemoteException {
        return this._outputParms;
    }

    @Override
    public OutputParameterInterface getOutputParameter(String name) throws RemoteException {
        for (OutputParameterInterface opi : this._outputParms) {
            if (!opi.getName().equalsIgnoreCase(name)) continue;
            return opi;
        }
        return null;
    }

    @Override
    public List<GenericStream> getDataSources() {
        this.checkIfDestroyed();
        return this.getDataSourcesOrTargets(true);
    }

    @Override
    public List<GenericStream> getDataTargets() {
        this.checkIfDestroyed();
        return this.getDataSourcesOrTargets(false);
    }

    @Override
    public String getClientName() {
        return this._clientName;
    }

    @Override
    public void setClientName(String clientName) {
        this._clientName = clientName;
    }

    private List<GenericStream> getDataSourcesOrTargets(boolean isSource) {
        if (this._isNineTwo && this._serverType != 1) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP2.noStreamSup.ex.txt"));
        }
        ArrayList<GenericStream> streams = new ArrayList<GenericStream>(this._streams.size());
        for (GenericStream gs : this._streams.values()) {
            if (gs._isSource != isSource) continue;
            streams.add(gs);
        }
        return streams;
    }

    @Override
    public int getResultType() throws ServiceException, RemoteException {
        try {
            int resultType;
            ResultTypeDeterminer.ResultType type = ResultTypeDeterminer.getType(this._usageVersion, this);
            switch (type) {
                case STREAM: {
                    resultType = 1024;
                    break;
                }
                case TRANSIENT_PACKAGE: 
                case FILE_PACKAGE: 
                case PR_PACKAGE: 
                case DAVSERVER_PACKAGE: {
                    resultType = 512;
                    break;
                }
                default: {
                    resultType = 256;
                }
            }
            return resultType;
        }
        catch (ResultTypeDeterminer.InconsistencyException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    public void setInputFileref(String fileref, InputStream inputStream) throws ServiceException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        String normalizedName = fileref.toLowerCase(Locale.US);
        GenericStream gs = this._streams.get(normalizedName);
        if (gs == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.noFilref.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        if (!gs.isSource()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.filrefdtnotds.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        gs._inputStream = inputStream;
        gs._reader = null;
        gs._filerefInitialized = true;
        gs._filerefFileIsOnClient = true;
    }

    @Override
    public void setInputFileref(String fileref, Reader reader) throws ServiceException {
        if (reader == null) {
            throw new NullPointerException();
        }
        String normalizedName = fileref.toLowerCase(Locale.US);
        GenericStream gs = this._streams.get(normalizedName);
        if (gs == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.noFilref.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        if (!gs.isSource()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.filrefdtnotds.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        gs._reader = reader;
        gs._inputStream = null;
        gs._filerefInitialized = true;
        gs._filerefFileIsOnClient = true;
    }

    @Override
    public void setInputFileref(String fileref, String engine, String path, String options) throws ServiceException {
        if (path == null) {
            throw new NullPointerException();
        }
        String normalizedName = fileref.toLowerCase(Locale.US);
        GenericStream gs = this._streams.get(normalizedName);
        if (gs == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.noFilref.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        if (!gs.isSource()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.filrefdtnotds.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        gs._engine = engine;
        gs._path = path;
        gs._options = options;
        gs._filerefInitialized = true;
        gs._filerefFileIsOnClient = false;
    }

    @Override
    public void setOutputFileref(String fileref, OutputStream stream) throws ServiceException {
        if (stream == null) {
            throw new NullPointerException();
        }
        String normalizedName = fileref.toLowerCase(Locale.US);
        GenericStream gs = this._streams.get(normalizedName);
        if (gs == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.noFilref.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        if (gs.isSource()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.filrefdsnotdt.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        gs._outputStream = stream;
        gs._writer = null;
        gs._filerefInitialized = true;
        gs._filerefFileIsOnClient = true;
    }

    @Override
    public void setOutputFileref(String fileref, Writer writer) throws ServiceException {
        if (writer == null) {
            throw new NullPointerException();
        }
        String normalizedName = fileref.toLowerCase(Locale.US);
        GenericStream gs = this._streams.get(normalizedName);
        if (gs == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.noFilref.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        if (gs.isSource()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.filrefdsnotdt.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        gs._writer = writer;
        gs._outputStream = null;
        gs._filerefInitialized = true;
        gs._filerefFileIsOnClient = true;
    }

    @Override
    public void setOutputFileref(String fileref, String engine, String path, String options) throws ServiceException {
        if (path == null) {
            throw new NullPointerException();
        }
        String normalizedName = fileref.toLowerCase(Locale.US);
        GenericStream gs = this._streams.get(normalizedName);
        if (gs == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.noFilref.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        if (gs.isSource()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.filrefdsnotdt.ex.fmt.txt", (Object)fileref);
            throw new ServiceException(msg);
        }
        gs._engine = engine;
        gs._path = path;
        gs._options = options;
        gs._filerefInitialized = true;
        gs._filerefFileIsOnClient = false;
    }

    UsageVersion getUsageVersion() {
        return this._usageVersion;
    }

    @Override
    public void setServerContext(ServerContextInterface pServerContext) throws ServiceException, RemoteException {
        if (this._howCreated == 0) {
            throw new UnsupportedOperationException(RB.getStringResource("SP2.notValidManCrtd.ex.txt"));
        }
        if (this.getUsageVersion().equals((Object)StoredProcessInterface.NINETWO_VERSION)) {
            throw new UnsupportedOperationException(RB.getStringResource("SP2.notSupported.ex.txt"));
        }
        if (pServerContext == null) {
            throw new NullPointerException();
        }
        if (!this._objectCache.getSmartObject().isOtherServerContextAllowed()) {
            throw new ServiceException(RB.getStringResource("SP2.cantChangeSrvrCtxt.ex.txt"));
        }
        ServerContextInterface serverContext = (ServerContextInterface)this._objectCache.getServerInterface().fetch(pServerContext.getReposKey());
        ServerContext sc = (ServerContext)serverContext.getRepositoryEntity();
        try {
            LogicalServer lsSPS;
            LogicalServer lsWKS;
            if (this._definedLogicalServerType == StoredProcessInterface.LogicalServerType.WORKSPACE || this._definedLogicalServerType == StoredProcessInterface.LogicalServerType.STORED_PROCESS) {
                LogicalServer ls = MetadataConstants.getLogicalServerFromServerContext(this._definedLogicalServerType == StoredProcessInterface.LogicalServerType.WORKSPACE, sc);
                if (ls == null) {
                    throw new ServiceException(RB.getStringResource("SP2.missnLogSrvr.txt"));
                }
                this._effectiveLogicalServerType = this._definedLogicalServerType;
                if (this._definedLogicalServerType == StoredProcessInterface.LogicalServerType.WORKSPACE) {
                    lsWKS = ls;
                    lsSPS = null;
                } else {
                    lsWKS = null;
                    lsSPS = ls;
                }
            } else {
                lsWKS = MetadataConstants.getLogicalServerFromServerContext(true, sc);
                lsSPS = MetadataConstants.getLogicalServerFromServerContext(false, sc);
                if (lsWKS != null && lsSPS != null) {
                    this._effectiveLogicalServerType = this._definedLogicalServerType;
                } else if (lsWKS != null) {
                    this._effectiveLogicalServerType = StoredProcessInterface.LogicalServerType.WORKSPACE;
                } else if (lsSPS != null) {
                    this._effectiveLogicalServerType = StoredProcessInterface.LogicalServerType.STORED_PROCESS;
                } else {
                    throw new ServiceException(RB.getStringResource("SP2.noLogSrvr.txt"));
                }
            }
            this.set_serverTypeAnd_smartObjectLogicalServerForV2SP(lsWKS, lsSPS);
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        this._serverContext = sc;
    }

    @Override
    public void setLogicalServerType(StoredProcessInterface.LogicalServerType logicalServerType) throws ServiceException, RemoteException {
        if (this._howCreated == 0) {
            throw new UnsupportedOperationException(RB.getStringResource("SP2.notValidManCrtd.ex.txt"));
        }
        if (this.getUsageVersion().equals((Object)StoredProcessInterface.NINETWO_VERSION)) {
            throw new UnsupportedOperationException(RB.getStringResource("SP2.notSupported.ex.txt"));
        }
        if (logicalServerType == null) {
            throw new NullPointerException();
        }
        if (logicalServerType != StoredProcessInterface.LogicalServerType.STORED_PROCESS && logicalServerType != StoredProcessInterface.LogicalServerType.WORKSPACE) {
            throw new ServiceException(RB.getStringResource("COM.invalidArg.ex.txt"));
        }
        if (this._definedLogicalServerType != StoredProcessInterface.LogicalServerType.ANY) {
            throw new ServiceException(RB.getStringResource("SP2.cantChangeLogTyp.ex.txt"));
        }
        try {
            boolean isWks = logicalServerType == StoredProcessInterface.LogicalServerType.WORKSPACE;
            LogicalServer ls = MetadataConstants.getLogicalServerFromServerContext(isWks, this._serverContext);
            if (ls == null) {
                throw new ServiceException(RB.getStringResource("SP2.missnLogSrvr.txt"));
            }
            this._effectiveLogicalServerType = logicalServerType;
            if (isWks) {
                this.set_serverTypeAnd_smartObjectLogicalServerForV2SP(ls, null);
            } else {
                this.set_serverTypeAnd_smartObjectLogicalServerForV2SP(null, ls);
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("COM.metaExcp.ext.txt"));
        }
    }

    @Override
    public ConnectionInterface getConnection() throws ServiceException, RemoteException {
        if (this._howCreated == 0) {
            throw new UnsupportedOperationException("SP2.notValidManCrtd.ex.txt");
        }
        ConnectionMaker cm = this._isNineTwo ? new ConnectionMaker(this._privilegedUser, this._userContext, this._smartObjectLogicalServer) : new ConnectionMaker(this._privilegedUser, this._userContext, this._serverContext, this._effectiveLogicalServerType, this._objectCache.getRepository());
        try {
            return cm.makeConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("COM.noConn.ex.txt"));
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("COM.metaExcp.ext.txt"));
        }
    }

    private void validateMemberNameAndSetInDTW(DataTableWrapper dtw, String memberName) throws ServiceException {
        if (memberName == null || memberName.length() == 0) {
            dtw._member = null;
        } else {
            try {
                Names.validateSASVariableName((String)memberName, (boolean)true);
                dtw._member = memberName;
            }
            catch (IllegalArgumentException iae) {
                throw new ServiceException((Throwable)iae);
            }
        }
    }

    private void validateLibrefAndSetInDTW(DataTableWrapper dtw, String libref) throws ServiceException {
        if (libref == null || libref.length() == 0) {
            dtw._libref = null;
        } else {
            try {
                Names.validateSASLibrefName((String)libref, (boolean)true);
                dtw._libref = libref;
            }
            catch (IllegalArgumentException iae) {
                throw new ServiceException((Throwable)iae);
            }
        }
    }

    @Override
    public void setInputDataTable(String tableName, String libref, String memberName) throws ServiceException, RemoteException {
        if (tableName == null) {
            throw new ServiceException(RB.getStringResource("SP2.noTablNam.ex.fmt.txt"));
        }
        DataTableWrapper dtw = this._sourceTables.get(tableName);
        if (dtw == null) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SP2.noITable.ex.fmt.txt"), (Object)tableName));
        }
        dtw._case = null;
        this.validateMemberNameAndSetInDTW(dtw, memberName);
        this.validateLibrefAndSetInDTW(dtw, libref);
        dtw._case = DataTableWrapper.Case.LIB_MEM;
    }

    @Override
    public void setInputDataTable(String tableName, InputStream inputStream, String memberName, String xmlLibraryOptions) throws ServiceException, RemoteException {
        if (tableName == null) {
            throw new ServiceException(RB.getStringResource("SP2.noTablNam.ex.fmt.txt"));
        }
        DataTableWrapper dtw = this._sourceTables.get(tableName);
        if (dtw == null) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SP2.noITable.ex.fmt.txt"), (Object)tableName));
        }
        if (inputStream == null) {
            throw new ServiceException(RB.getStringResource("SP2.noInputStream.ex.txt"));
        }
        dtw._case = null;
        this.validateMemberNameAndSetInDTW(dtw, memberName);
        dtw._xmlLibraryOptions = xmlLibraryOptions == null ? "" : xmlLibraryOptions;
        dtw._inputStream = inputStream;
        dtw._case = DataTableWrapper.Case.XML;
    }

    @Override
    public void setOutputDataTable(String tableName, String libref, String memberName) throws ServiceException, RemoteException {
        if (tableName == null) {
            throw new ServiceException(RB.getStringResource("SP2.noTablNam.ex.fmt.txt"));
        }
        DataTableWrapper dtw = this._targetTables.get(tableName);
        if (dtw == null) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SP2.noOTable.ex.fmt.txt"), (Object)tableName));
        }
        dtw._case = null;
        this.validateMemberNameAndSetInDTW(dtw, memberName);
        this.validateLibrefAndSetInDTW(dtw, libref);
        dtw._case = DataTableWrapper.Case.LIB_MEM;
    }

    @Override
    public void setOutputDataTable(String tableName, OutputStream outputStream, String memberName, String xmlLibraryOptions) throws ServiceException, RemoteException {
        if (tableName == null) {
            throw new ServiceException(RB.getStringResource("SP2.noTablNam.ex.fmt.txt"));
        }
        DataTableWrapper dtw = this._targetTables.get(tableName);
        if (dtw == null) {
            throw new ServiceException(Message.format((String)RB.getStringResource("SP2.noOTable.ex.fmt.txt"), (Object)tableName));
        }
        if (outputStream == null) {
            throw new ServiceException(RB.getStringResource("SP2.noOutputStream.ex.txt"));
        }
        dtw._case = null;
        this.validateMemberNameAndSetInDTW(dtw, memberName);
        dtw._xmlLibraryOptions = xmlLibraryOptions == null ? "" : xmlLibraryOptions;
        dtw._outputStream = outputStream;
        dtw._case = DataTableWrapper.Case.XML;
    }

    StoredProcessInterface.LogicalServerType getEffectiveLogicalServerType() {
        return this._effectiveLogicalServerType;
    }

    @Override
    public void setSessionFreedOnDestroy(boolean sessionFreedOnDestroy) {
        this._sessionFreedOnDestroy = sessionFreedOnDestroy;
    }
}

