/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMCommon.IServerStatus;
import com.sas.iom.SASIOMCommon.IServerStatusHelper;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.services.storedprocess.InternalUseException;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.StoredProcessService;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;

@SASScope
class SessionMap<E> {
    private HashMap<String, SessionValue<E>> _sessionIDMap;
    private HashMap<String, ConnectionValue<E>> _guidAndSessionContextMap;
    private Logger _logger;
    private Timer _timer;
    private ArrayList<SessionValue<E>> _staleSessions;
    private ArrayList<ConnectionValue<E>> _staleConnections;
    private String _sessionContextKey = "com.sas.services.storedprocess.SessionMap." + Integer.toString(_sessionContextKeyCount++);
    private static int _sessionContextKeyCount;
    private static long TIMER_INTERVAL;

    SessionMap(StoredProcessService service) {
        this._sessionIDMap = new HashMap();
        this._guidAndSessionContextMap = new HashMap();
        this._staleConnections = new ArrayList();
        this._staleSessions = new ArrayList();
        this._timer = new Timer(true);
        this._timer.schedule((TimerTask)new CheckSessionsTask(), TIMER_INTERVAL, TIMER_INTERVAL);
        this._logger = LogManager.getLogger(SessionMap.class);
    }

    synchronized void add(String sessionID, SessionContextInterface sessionContext, E server, ConnectionInterface connection, boolean isConnectionSuppliedByUser) throws InternalUseException, RemoteException {
        SessionValue<E> value = this._sessionIDMap.get(sessionID);
        if (value != null) {
            String sessionContextEntityKeyIncoming;
            String sessionContextEntityKeyFromCV = value._connectionValue._sessionContextEntityKey;
            String string = sessionContextEntityKeyIncoming = sessionContext != null ? sessionContext.getEntityKey() : null;
            if (sessionContextEntityKeyFromCV == null && sessionContextEntityKeyIncoming != null || sessionContextEntityKeyIncoming == null && sessionContextEntityKeyFromCV != null || !sessionContextEntityKeyFromCV.equalsIgnoreCase(sessionContextEntityKeyIncoming)) {
                this.markDuplicateAndLog(sessionID, value);
                throw new InternalUseException(0);
            }
            if (value._connectionValue._server != server) {
                this.markDuplicateAndLog(sessionID, value);
                throw new InternalUseException(0);
            }
            return;
        }
        value = new SessionValue<E>(sessionContext, server, connection, sessionID, isConnectionSuppliedByUser);
        this._sessionIDMap.put(sessionID, value);
    }

    private synchronized void markDuplicateAndLog(String sessionID, SessionValue<E> sv) {
        sv._isADuplicate = true;
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SPSM.dupSessn.fmt.txt", (java.lang.Object)sessionID);
        this._logger.error(msg);
    }

    synchronized void harvestDestroyedSessionContextConnections(SessionContextInterface sessionContext, HashSet<SessionValue<E>> sessions, HashSet<ConnectionValue<E>> connections) throws RemoteException {
        String sessionContextEntityKeyToMatch = sessionContext.getEntityKey();
        Iterator<Map.Entry<String, SessionValue<E>>> it = this._sessionIDMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, SessionValue<E>> me = it.next();
            SessionValue<E> sessionValue = me.getValue();
            ConnectionValue cv = sessionValue._connectionValue;
            if (cv == null || cv._sessionContext == null || !cv._sessionContextEntityKey.equals(sessionContextEntityKeyToMatch)) continue;
            this._guidAndSessionContextMap.remove(cv._serverGUIDAndSessionContextKey);
            if (!sessionValue._isConnectionSuppliedByUser) {
                connections.add(cv);
            }
            sessions.add(sessionValue);
            it.remove();
        }
    }

    synchronized void harvestStaleConnections() {
        this._staleConnections.clear();
        this._staleSessions.clear();
        Iterator<Map.Entry<String, SessionValue<E>>> it = this._sessionIDMap.entrySet().iterator();
        while (it.hasNext()) {
            long now;
            long staleAt;
            Map.Entry<String, SessionValue<E>> me = it.next();
            SessionValue<E> sessionValue = me.getValue();
            if (!sessionValue._isPermanent || (staleAt = sessionValue._lastAccessTime + (long)sessionValue._timeOut) >= (now = System.currentTimeMillis())) continue;
            ConnectionValue cv = sessionValue._connectionValue;
            --cv._sessionCount;
            if (cv._sessionCount <= 0) {
                if (cv._serverGUIDAndSessionContextKey != null) {
                    this._guidAndSessionContextMap.remove(cv._serverGUIDAndSessionContextKey);
                }
                if (!sessionValue._isConnectionSuppliedByUser) {
                    this._staleConnections.add(cv);
                }
            }
            this._staleSessions.add(sessionValue);
            it.remove();
        }
    }

    synchronized void remove(String sessionID) {
        SessionValue<E> value = this._sessionIDMap.get(sessionID);
        if (value == null) {
            return;
        }
        this._sessionIDMap.remove(sessionID);
    }

    synchronized void removeExpiredSession(String sessionID) {
        SessionValue<E> sessionValue = this._sessionIDMap.get(sessionID);
        if (sessionValue == null) {
            return;
        }
        this._sessionIDMap.remove(sessionID);
        ConnectionValue cv = sessionValue._connectionValue;
        --cv._sessionCount;
        if (cv._sessionCount <= 0) {
            if (cv._serverGUIDAndSessionContextKey != null) {
                this._guidAndSessionContextMap.remove(cv._serverGUIDAndSessionContextKey);
            }
            if (!sessionValue._isConnectionSuppliedByUser) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SPSM.remExpConn.fmt.txt", (java.lang.Object)cv._connection.toString());
                    this._logger.debug(msg);
                }
                cv._connection.close();
            }
        }
    }

    synchronized E getServerIncrementingSPUseCount(String sessionID, SessionContextInterface sessionContext) throws InternalUseException, RemoteException {
        String sessionContextEntityKeyIncoming;
        SessionValue<E> sessionValue = this._sessionIDMap.get(sessionID);
        if (sessionValue == null) {
            throw new InternalUseException(2);
        }
        if (sessionValue._isADuplicate) {
            throw new InternalUseException(3);
        }
        String sessionContextEntityKeyFromCV = sessionValue._connectionValue._sessionContextEntityKey;
        String string = sessionContextEntityKeyIncoming = sessionContext != null ? sessionContext.getEntityKey() : null;
        if (sessionContextEntityKeyFromCV == null && sessionContextEntityKeyIncoming != null || sessionContextEntityKeyIncoming == null && sessionContextEntityKeyFromCV != null || !sessionContextEntityKeyFromCV.equalsIgnoreCase(sessionContextEntityKeyIncoming)) {
            throw new InternalUseException(1);
        }
        sessionValue._lastAccessTime = System.currentTimeMillis();
        ++sessionValue._storedProcessCount;
        return sessionValue._connectionValue._server;
    }

    synchronized void decrementSPUseCount(String sessionID) {
        SessionValue<E> sessionValue = this._sessionIDMap.get(sessionID);
        if (sessionValue == null) {
            return;
        }
        if (--sessionValue._storedProcessCount <= 0) {
            ConnectionValue cv = sessionValue._connectionValue;
            if (cv._sessionContextEntityKey == null) {
                return;
            }
            if (cv._serverGUIDAndSessionContextKey == null) {
                String serverGUID = this.getGUIDFromConnection(cv._connection);
                cv._serverGUIDAndSessionContextKey = serverGUID + cv._sessionContextEntityKey;
                ConnectionValue<E> masterValue = this._guidAndSessionContextMap.get(cv._serverGUIDAndSessionContextKey);
                if (masterValue == null) {
                    this._guidAndSessionContextMap.put(cv._serverGUIDAndSessionContextKey, cv);
                } else {
                    sessionValue._connectionValue = masterValue;
                    ++masterValue._sessionCount;
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SPSM.closFrmDecr.fmt.txt", (java.lang.Object)cv._connection.toString());
                        this._logger.debug(msg);
                    }
                    cv._connection.close();
                }
            }
        }
    }

    synchronized void updateWithTimes(String sessionID, String timeOut, String spName) throws RemoteException {
        int intTimeOut;
        SessionValue<E> sessionValue = this._sessionIDMap.get(sessionID);
        if (sessionValue == null) {
            return;
        }
        try {
            intTimeOut = Integer.parseInt(timeOut);
        }
        catch (Exception e) {
            return;
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SPSM.addSessn.fmt.txt", (java.lang.Object)spName, (java.lang.Object)sessionID);
            this._logger.debug(msg);
        }
        sessionValue._isPermanent = true;
        sessionValue._lastAccessTime = System.currentTimeMillis();
        sessionValue._timeOut = intTimeOut * 1000;
        ConnectionValue cv = sessionValue._connectionValue;
        if (cv == null) {
            return;
        }
        SessionContextInterface sessionContext = cv._sessionContext;
        if (sessionContext == null) {
            return;
        }
        try {
            java.lang.Object o = sessionContext.getAttribute(this._sessionContextKey);
            if (o != null) {
                return;
            }
        }
        catch (IllegalStateException e) {
            return;
        }
        sessionContext.setAttribute(this._sessionContextKey, (java.lang.Object)new NotifierObjectOnSessionContext());
    }

    void destroy() {
        this._timer.cancel();
    }

    private String getGUIDFromConnection(ConnectionInterface ci) {
        int i;
        IServerStatus stpStatus = IServerStatusHelper.narrow((Object)ci.getObject());
        UUID uuid = stpStatus.ServerStatusUniqueID();
        StringBuffer uuidBuffer = new StringBuffer();
        SessionMap.dataToString(uuid.Data1, 8, uuidBuffer);
        uuidBuffer.append('-');
        SessionMap.dataToString(uuid.Data2 & 0xFFFF, 4, uuidBuffer);
        uuidBuffer.append('-');
        SessionMap.dataToString(uuid.Data3 & 0xFFFF, 4, uuidBuffer);
        uuidBuffer.append('-');
        for (i = 0; i < 2; ++i) {
            SessionMap.dataToString(uuid.Data4[i] & 0xFF, 2, uuidBuffer);
        }
        uuidBuffer.append('-');
        for (i = 2; i < 8; ++i) {
            SessionMap.dataToString(uuid.Data4[i] & 0xFF, 2, uuidBuffer);
        }
        return uuidBuffer.toString();
    }

    private static void dataToString(int data, int length, StringBuffer hexBuffer) {
        String hex = Integer.toHexString(data);
        for (int i = length - hex.length(); i > 0; --i) {
            hexBuffer.append('0');
        }
        hexBuffer.append(hex);
    }

    static {
        TIMER_INTERVAL = 900000L;
    }

    @SASScope
    class CheckSessionsTask
    extends TimerTask {
        CheckSessionsTask() {
        }

        @Override
        public void run() {
            java.lang.Object value;
            int i;
            SessionMap.this.harvestStaleConnections();
            int len = SessionMap.this._staleConnections.size();
            for (i = 0; i < len; ++i) {
                value = (ConnectionValue)SessionMap.this._staleConnections.get(i);
                ConnectionInterface connection = ((ConnectionValue)value)._connection;
                if (SessionMap.this._logger != null && SessionMap.this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SPSM.closStalConn.fmt.txt", (java.lang.Object)connection.toString());
                    SessionMap.this._logger.debug(msg);
                }
                connection.close();
            }
            len = SessionMap.this._staleSessions.size();
            for (i = 0; i < len; ++i) {
                value = (SessionValue)SessionMap.this._staleSessions.get(i);
                if (SessionMap.this._logger == null || !SessionMap.this._logger.isDebugEnabled()) continue;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SPSM.remSessn.fmt.txt", (java.lang.Object)((SessionValue)value)._sessionID);
                SessionMap.this._logger.debug(msg);
            }
            SessionMap.this._staleConnections.clear();
            SessionMap.this._staleSessions.clear();
        }
    }

    @SASScope
    private static class ConnectionValue<E> {
        SessionContextInterface _sessionContext;
        String _sessionContextEntityKey;
        E _server;
        ConnectionInterface _connection;
        int _sessionCount = 1;
        String _serverGUIDAndSessionContextKey;

        ConnectionValue(SessionContextInterface sessionContext, E server, ConnectionInterface connection) {
            if (sessionContext != null) {
                try {
                    this._sessionContext = sessionContext;
                    this._sessionContextEntityKey = sessionContext.getEntityKey();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this._server = server;
            this._connection = connection;
        }
    }

    @SASScope
    private static class SessionValue<E> {
        boolean _isPermanent;
        boolean _isConnectionSuppliedByUser;
        long _lastAccessTime;
        int _timeOut;
        ConnectionValue<E> _connectionValue;
        int _storedProcessCount = 1;
        String _sessionID;
        boolean _isADuplicate;

        SessionValue(SessionContextInterface sessionContext, E server, ConnectionInterface connection, String sessionID, boolean isConnectionSuppliedByUser) {
            this._connectionValue = new ConnectionValue<E>(sessionContext, server, connection);
            this._sessionID = sessionID;
            this._isConnectionSuppliedByUser = isConnectionSuppliedByUser;
        }
    }

    @SASScope
    class NotifierObjectOnSessionContext
    extends UnicastRemoteObject
    implements RemoteSessionContextStateChangedListener {
        NotifierObjectOnSessionContext() throws RemoteException {
            super(SSLRMISocketFactories.getInstance().getPortForClass(0, NotifierObjectOnSessionContext.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(NotifierObjectOnSessionContext.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(NotifierObjectOnSessionContext.class));
        }

        public void contextStateChanged(SessionContextStateChangedEvent event) throws RemoteException {
            HashSet sessions = new HashSet();
            HashSet connections = new HashSet();
            SessionMap.this.harvestDestroyedSessionContextConnections(event.getSessionContext(), sessions, connections);
            for (ConnectionValue connectionValue : connections) {
                ConnectionInterface connection = connectionValue._connection;
                if (SessionMap.this._logger != null && SessionMap.this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SPSM.closConnOnSessCtxtDestroy.fmt.txt", (java.lang.Object)connection.toString());
                    SessionMap.this._logger.debug(msg);
                }
                connection.close();
            }
            for (SessionValue sessionValue : sessions) {
                if (SessionMap.this._logger == null || !SessionMap.this._logger.isDebugEnabled()) continue;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SPSM.remSessnOnSessCtxtDestroy.fmt.txt", (java.lang.Object)sessionValue._sessionID);
                SessionMap.this._logger.debug(msg);
            }
        }
    }
}

