/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2Package.CarriageControl2;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2Package.LineType2;
import com.sas.services.storedprocess.RB;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class SASLog
implements Serializable {
    private static final long serialVersionUID = 288783646645260028L;
    public static final int LINE_TYPE_NORMAL = 0;
    public static final int LINE_TYPE_HIGHLIGHTED = 1;
    public static final int LINE_TYPE_SOURCE = 2;
    public static final int LINE_TYPE_TITLE = 3;
    public static final int LINE_TYPE_BYLINE = 4;
    public static final int LINE_TYPE_FOOTNOTE = 5;
    public static final int LINE_TYPE_ERROR = 6;
    public static final int LINE_TYPE_WARNING = 7;
    public static final int LINE_TYPE_NOTE = 8;
    public static final int LINE_TYPE_MESSAGE = 9;
    public static final int CARRIAGE_CONTROL_NORMAL = 0;
    public static final int CARRIAGE_CONTROL_NEWPAGE = 1;
    public static final int CARRIAGE_CONTROL_OVERPRINT = 2;
    public static final int CARRIAGE_CONTROL_SKIPLINE = 3;
    public static final int CARRIAGE_CONTROL_SKIPTWOLINES = 4;
    private static int[] EMPTY_INT_ARRAY = new int[0];
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private int _linesRequested;
    private int _linesAvailable;
    private String[] _lines = EMPTY_STRING_ARRAY;
    private int[] _lineTypes = EMPTY_INT_ARRAY;
    private int[] _carriageControls = EMPTY_INT_ARRAY;

    SASLog(int linesRequested) {
        this._linesRequested = linesRequested;
    }

    public int getLinesRequested() {
        return this._linesRequested;
    }

    public int getLinesAvailable() {
        return this._linesAvailable;
    }

    public String[] getLines() {
        return this._lines;
    }

    public int[] getLineTypes() {
        return this._lineTypes;
    }

    public int[] getCarriageControls() {
        return this._carriageControls;
    }

    void setValues(String[] lines, LineType[] ltArr, CarriageControl[] ccArr, Logger logger) {
        String msg;
        String text;
        int count = lines.length;
        if (count != ltArr.length) {
            text = count + " " + ltArr.length;
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)text);
            this.logMessageAndThrowIllegalStateException(msg, logger);
        }
        if (count != ccArr.length) {
            text = count + " " + ccArr.length;
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)text);
            this.logMessageAndThrowIllegalStateException(msg, logger);
        }
        this._linesAvailable = count;
        this._lines = lines;
        int[] lineTypeArray = new int[count];
        for (int i = 0; i < count; ++i) {
            int temp;
            switch (ltArr[i].value()) {
                case 0: {
                    temp = 0;
                    break;
                }
                case 1: {
                    temp = 1;
                    break;
                }
                case 2: {
                    temp = 2;
                    break;
                }
                case 3: {
                    temp = 3;
                    break;
                }
                case 4: {
                    temp = 4;
                    break;
                }
                case 5: {
                    temp = 5;
                    break;
                }
                case 6: {
                    temp = 6;
                    break;
                }
                case 7: {
                    temp = 7;
                    break;
                }
                case 8: {
                    temp = 8;
                    break;
                }
                case 9: {
                    temp = 9;
                    break;
                }
                default: {
                    temp = 0;
                    String text2 = "Unsupported line type: " + ltArr[i].value();
                    String msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)text2);
                    this.logError(msg2, logger);
                }
            }
            lineTypeArray[i] = temp;
        }
        this._lineTypes = lineTypeArray;
        int[] carriageControlArray = new int[count];
        for (int i = 0; i < count; ++i) {
            int temp;
            switch (ccArr[i].value()) {
                case 0: {
                    temp = 0;
                    break;
                }
                case 1: {
                    temp = 1;
                    break;
                }
                case 2: {
                    temp = 2;
                    break;
                }
                case 3: {
                    temp = 3;
                    break;
                }
                case 4: {
                    temp = 4;
                    break;
                }
                default: {
                    temp = 0;
                    String text3 = "Unsupported carriage control type: " + ccArr[i].value();
                    String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)text3);
                    this.logError(msg3, logger);
                }
            }
            carriageControlArray[i] = temp;
        }
        this._carriageControls = carriageControlArray;
    }

    void setValues(String[] lines, LineType2[] ltArr, CarriageControl2[] ccArr, Logger logger) {
        String msg;
        String text;
        int count = lines.length;
        if (count != ltArr.length) {
            text = count + " " + ltArr.length;
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)text);
            this.logMessageAndThrowIllegalStateException(msg, logger);
        }
        if (count != ccArr.length) {
            text = count + " " + ccArr.length;
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)text);
            this.logMessageAndThrowIllegalStateException(msg, logger);
        }
        this._linesAvailable = count;
        this._lines = lines;
        int[] lineTypeArray = new int[count];
        for (int i = 0; i < count; ++i) {
            int temp;
            switch (ltArr[i].value()) {
                case 0: {
                    temp = 0;
                    break;
                }
                case 1: {
                    temp = 1;
                    break;
                }
                case 2: {
                    temp = 2;
                    break;
                }
                case 3: {
                    temp = 3;
                    break;
                }
                case 4: {
                    temp = 4;
                    break;
                }
                case 5: {
                    temp = 5;
                    break;
                }
                case 6: {
                    temp = 6;
                    break;
                }
                case 7: {
                    temp = 7;
                    break;
                }
                case 8: {
                    temp = 8;
                    break;
                }
                case 9: {
                    temp = 9;
                    break;
                }
                default: {
                    temp = 0;
                    String text2 = "Unsupported line type: " + ltArr[i].value();
                    String msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)text2);
                    this.logError(msg2, logger);
                }
            }
            lineTypeArray[i] = temp;
        }
        this._lineTypes = lineTypeArray;
        int[] carriageControlArray = new int[count];
        for (int i = 0; i < count; ++i) {
            int temp;
            switch (ccArr[i].value()) {
                case 0: {
                    temp = 0;
                    break;
                }
                case 1: {
                    temp = 1;
                    break;
                }
                case 2: {
                    temp = 2;
                    break;
                }
                case 3: {
                    temp = 3;
                    break;
                }
                case 4: {
                    temp = 4;
                    break;
                }
                default: {
                    temp = 0;
                    String text3 = "Unsupported carriage control type: " + ccArr[i].value();
                    String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)text3);
                    this.logError(msg3, logger);
                }
            }
            carriageControlArray[i] = temp;
        }
        this._carriageControls = carriageControlArray;
    }

    private void logError(String message, Logger logger) {
        if (logger != null) {
            logger.error(message);
        }
    }

    private void logMessageAndThrowIllegalStateException(String message, Logger logger) {
        if (logger != null) {
            logger.error(message);
        }
        throw new IllegalStateException(message);
    }
}

