/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValuesInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.storedprocess.CaseNeutralLookup;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.StoredProcess2Interface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.ResourceBundle;

@SASScope
public class ResultTypeDeterminer {
    public static ResultType getType(UsageVersion usageVersion, StoredProcess2Interface storedProcess) throws RemoteException, InconsistencyException {
        boolean nineTwoworkspaceServerBased = usageVersion.equals((Object)StoredProcessInterface.NINETWO_VERSION) && storedProcess.getServerType() == 2;
        PromptValuesInterface promptValues = storedProcess.getPromptValues();
        boolean packageCapable = storedProcess.isPackageCapable();
        boolean streamCapable = storedProcess.isStreamCapable();
        return ResultTypeDeterminer.getType(nineTwoworkspaceServerBased, promptValues, packageCapable, streamCapable, usageVersion);
    }

    public static ResultType getType(StoredProcessInterface smartObject, PromptValuesInterface promptValues) throws RemoteException, InconsistencyException, ServiceException {
        UsageVersion usageVersion = smartObject.getUsageVersion();
        boolean nineTwoworkspaceServerBased = false;
        if (usageVersion.equals((Object)StoredProcessInterface.NINETWO_VERSION)) {
            LogicalServerInterface lsi = smartObject.getServer();
            if (lsi == null) {
                throw new ServiceException(RB.getStringResource("RTD.noSrvrPrsnt.ex.txt"));
            }
            nineTwoworkspaceServerBased = !lsi.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c");
        }
        return ResultTypeDeterminer.getType(nineTwoworkspaceServerBased, promptValues, smartObject.isPackageCapable(), smartObject.isStreamCapable(), smartObject.getUsageVersion());
    }

    private static ResultType getType(boolean nineTwoworkspaceServerBased, PromptValuesInterface promptValues, boolean packageCapable, boolean streamCapable, UsageVersion usageVersion) throws RemoteException, InconsistencyException {
        Map nameValues = PromptUtil.getMacroVariableValues((PromptValuesInterface)promptValues, null, (boolean)false);
        CaseNeutralLookup cnl = new CaseNeutralLookup(nameValues);
        String resultValue = cnl.get("_result");
        if (resultValue != null) {
            resultValue = resultValue.toUpperCase();
        }
        if (resultValue == null || resultValue.length() == 0) {
            if (!packageCapable && !streamCapable) {
                return ResultType.STATUS;
            }
            if (!packageCapable && streamCapable) {
                return ResultType.STREAM;
            }
            return ResultType.TRANSIENT_PACKAGE;
        }
        if (resultValue.startsWith("STREAM")) {
            if (!streamCapable) {
                throw new InconsistencyException(RB.getStringResource("RTD.STREAMinvld.ex.txt"));
            }
            return ResultType.STREAM;
        }
        if (resultValue.startsWith("PACKAGE_TO_")) {
            if (!packageCapable) {
                throw new InconsistencyException(RB.getStringResource("RTD.resWrngPkgPrefix.ex.txt"));
            }
            if (resultValue.equals("PACKAGE_TO_REQUESTER") && !nineTwoworkspaceServerBased) {
                throw new InconsistencyException(RB.getStringResource("RTD.reqstrWksOnly.ex.txt"));
            }
            if (resultValue.equals("PACKAGE_TO_REQUESTER") || resultValue.equals("PACKAGE_TO_ARCHIVE") && !nineTwoworkspaceServerBased) {
                String ap = cnl.get("_archive_path");
                if (ap == null || ap.length() == 0) {
                    throw new InconsistencyException(RB.getStringResource("RTD.noAPVal.ex.txt"));
                }
                return ResultType.FILE_PACKAGE;
            }
            if (resultValue.equals("PACKAGE_TO_WEBDAV")) {
                String toPRVal = cnl.get("_publish_to_pr");
                if (toPRVal != null && toPRVal.equalsIgnoreCase("true")) {
                    return ResultType.PR_PACKAGE;
                }
                return ResultType.DAVSERVER_PACKAGE;
            }
            return ResultType.UNSUPPORTED_BY_SERVICE;
        }
        if (resultValue.equals("STATUS")) {
            if (!packageCapable && !streamCapable) {
                return ResultType.STATUS;
            }
            throw new InconsistencyException(RB.getStringResource("RTD.STATUSisInv.ex.txt"));
        }
        if (!packageCapable && !streamCapable) {
            return ResultType.UNSUPPORTED_BY_SERVICE;
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RTD.invldRESULT.ex.fmt.txt", (Object)resultValue);
        throw new InconsistencyException(msg);
    }

    @SASScope
    public static enum ResultType {
        STATUS,
        STREAM,
        TRANSIENT_PACKAGE,
        FILE_PACKAGE,
        PR_PACKAGE,
        DAVSERVER_PACKAGE,
        UNSUPPORTED_BY_SERVICE;

    }

    @SASScope
    public static class InconsistencyException
    extends Exception {
        public InconsistencyException(String exceptionMessage) {
            super(exceptionMessage);
        }
    }
}

