/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.metadata.remote.ClassifierMap;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.IdFilter;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

class ObjectCache
extends AtomicInteger {
    private static final long serialVersionUID = 1L;
    private ChildServerInterface _childServerInterface;
    private ClassifierMap _classifierMap;
    private StoredProcessInterface _storedProcessSmartObject;
    private RepositoryInterface _repositoryInterface;
    private String _storedProcessName;

    ObjectCache(UserContextInterface userContext, StoredProcessInterface storedProcessSmartObject) throws RemoteException, ServiceException {
        this.incrementAndGet();
        MetadataServerInterface msi = (MetadataServerInterface)userContext.getAuthServer();
        this._childServerInterface = msi.newChild(true);
        IdFilter filter = new IdFilter(storedProcessSmartObject.getReposId());
        String template = "<Templates><ClassifierMap><ComputeLocations/><Keywords/><Notes/><Prompts/><ResponsibleParties/><SourceCode/><Trees/></ClassifierMap><Directory><Properties/></Directory><File><Directories/></File><ServerContext><UsingComponents/></ServerContext></Templates>";
        filter.setOMRTemplate(template);
        List searchResults = this._childServerInterface.search((FilterInterface)filter);
        int numberFound = searchResults.size();
        if (numberFound == 0) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"OC.noSP.ex.fmt.txt", (Object)storedProcessSmartObject.getReposId());
            throw new InitializationException(msg);
        }
        if (numberFound > 1) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"OC.mulSP.ex.fmt.txt", (Object)storedProcessSmartObject.getReposId());
            throw new InitializationException(msg);
        }
        this._storedProcessSmartObject = (StoredProcessInterface)searchResults.get(0);
        this._classifierMap = (ClassifierMap)this._storedProcessSmartObject.getRepositoryEntity();
        this._storedProcessName = this._storedProcessSmartObject.getName();
        this._repositoryInterface = this._storedProcessSmartObject.getRepository();
    }

    RepositoryInterface getRepository() {
        return this._repositoryInterface;
    }

    ClassifierMap getClassifierMap() {
        return this._classifierMap;
    }

    StoredProcessInterface getSmartObject() {
        return this._storedProcessSmartObject;
    }

    ServerInterface getServerInterface() {
        return this._childServerInterface;
    }

    void destroy(Logger logger) throws ServiceException, RemoteException {
        int count = this.decrementAndGet();
        if (logger != null && logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"OC.destroyCalled.fmt.txt", (Object)this._storedProcessName, (Object)count);
            logger.debug(msg);
        }
        if (count > 0) {
            return;
        }
        try {
            this._childServerInterface.rollback();
        }
        catch (ServiceException e) {
            if (logger != null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"OC.cacheDestroyExcp.fmt.txt", (Object)this._storedProcessName);
                logger.warn(msg, (Throwable)e);
            }
            throw e;
        }
    }
}

