/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.entities.MdOMAEntityUtility;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.IdFilter;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.GenericStream;
import com.sas.services.storedprocess.OutputParameter;
import com.sas.services.storedprocess.OutputParameterInterface;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.XMLStream;
import com.sas.services.storedprocess.metadata.DataTable;
import com.sas.services.storedprocess.metadata.StoredProcess;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.XMLUtil;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class MetadataConstants {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(2, 0);
    public static final String ARCHIVEFILE_DIRECTORY_PROPERTYROLE = "SPPackageFileRepository";
    public static final String CLASSIFIERMAP_PUBLIC_TYPE = "StoredProcess";
    public static final String CLASSIFIERMAP_TRANSFORM_ROLE = "StoredProcess";
    public static final String OMR_NAME_SOURCE_DIR = "SP Source Directory";
    public static final String OMR_NAME_SOURCE_FILE = "SP Source File";
    public static final String OMR_NAME_STORED_PROCESS = "Stored Process";
    public static final String OMR_NAME_XMLA_WEBSERVICE = "XMLA Web Service";
    public static final String CUSTOMIZER_PROPERTYROLE = "SPCustomizer";
    public static final String INPUT_TYPE_STREAM = "SPInputStream";
    public static final String STREAM_MULTIPASS_PROPERTYNAME = "MultiPass";
    public static final String REPORT_NEW_INSTANCE_PROPERTYNAME = "SPNewInstance";
    public static final String REPORT_TYPE_TRANSIENT_PACKAGE = "SPResultsTransientPackage";
    public static final String REPORT_TYPE_PERMANENT_FILE_PACKAGE = "SPResultsPermanentFilePackage";
    public static final String REPORT_TYPE_PERMANENT_WEBDAV_PACKAGE = "SPResultsPermanentWebdavPackage";
    public static final String REPORT_TYPE_PERMANENT_WEBDAV_PR_PACKAGE = "SPResultsPermanentWebdavPRPackage";
    public static final String REPORT_TYPE_STREAM = "SPResultsStream";
    public static final String SOURCECODE_DIRECTORY_PROPERTYROLE = "SPSourceCodeRepository";
    public static final String WEBOUT = "_WEBOUT";
    public static final String FILE_SYSTEM_TYPE_PROPERTYNAME = "FileSystemType";
    public static final String FILE_SYSTEM_TYPE_WEBDAV = "WebDAV";
    public static final String STORED_PROCESS_TEXT_ROLE = "StoredProcessConfiguration";
    public static final String STORED_PROCESS_TEXT_TYPE = "XML";
    public static final String STORED_PROCESS_SOURCE_CODE_TEXT_ROLE = "StoredProcessSourceCode";
    public static final String STORED_PROCESS_SOURCE_CODE_NAME = "SourceCode";
    public static final String XML_A_OTHERSERVERCONTEXTSALLOWED = "OtherAllowed";
    public static final String XML_A_LOGICALSERVERTYPE = "LogicalServerType";
    public static final String XML_A_MULTIPASS = "Multipass";
    public static final String XML_A_NAME = "Name";
    public static final String XML_A_NAMESPACE = "Namespace";
    public static final String XML_A_CONTENTTYPE = "ContentType";
    public static final String XML_A_FILEREF = "Fileref";
    public static final String XML_A_PACKAGE = "Package";
    public static final String XML_A_REFTYPE = "ReferenceType";
    public static final String XML_A_STREAMING = "Streaming";
    public static final String XML_A_TEMPLATE_TABLE = "TemplateTableLocation";
    public static final String XML_A_TYPE = "Type";
    public static final String XML_A_URI = "URI";
    public static final String XML_A_VALUE_FALSE = "false";
    public static final String XML_A_VALUE_TRUE = "true";
    public static final String XML_A_VALUE_GENERIC_STREAM = "GenericStream";
    public static final String XML_A_VALUE_XML_STREAM = "XMLStream";
    public static final String XML_A_VALUE_DATA_TABLE = "DataTable";
    public static final String XML_A_VALUE_SOURCE_PREFIX = "_Source_";
    public static final String XML_A_VALUE_TARGET_PREFIX = "_Target_";
    public static final String XML_A_VALUE_REFTYPE_ELEMENT = "Element";
    public static final String XML_A_VALUE_REFTYPE_TYPE = "Type";
    public static final String XML_A_VALUE_LOGICALSERVERTYPE_ANY = "Any";
    public static final String XML_A_VALUE_LOGICALSERVERTYPE_WKS = "Wks";
    public static final String XML_A_VALUE_LOGICALSERVERTYPE_SPS = "Sps";
    public static final String XML_A_EMBED = "Embed";
    public static final String XML_A_XMLLANG = "xml:lang";
    public static final String XML_E_CULTURE = "Culture";
    public static final String XML_E_DATA = "Data";
    public static final String XML_E_DESCRIPTION = "Description";
    public static final String XML_E_LABEL = "Label";
    public static final String XML_E_OUTPUT_PARAMETERS = "OutputParameters";
    public static final String XML_E_PARAMETER = "Parameter";
    public static final String XML_E_RESULT_CAPABILITIES = "ResultCapabilities";
    public static final String XML_E_SCHEMA = "Schema";
    public static final String XML_E_SERVER_CONTEXT = "ServerContext";
    public static final String XML_E_SOURCE = "Source";
    public static final String XML_E_STORED_PROCESS = "StoredProcess";
    public static final String XML_E_TARGET = "Target";
    public static final String XML_E_WSDL = "WSDL";
    public static final String RES_NAME_RESULT = "_result";
    public static final String RES_NAME_ARCHIVE_NAME = "_archive_name";
    public static final String RES_NAME_ARCHIVE_PATH = "_archive_path";
    public static final String RES_NAME_PUBLISH_TO_PR = "_publish_to_pr";
    public static final String RES_NAME_PR_COLLECTION_PATH = "_pr_collection_path";
    public static final String RES_NAME_CREATE_NEW_PACKAGE_INSTANCE = "_create_new_package_instance";
    public static final String RES_NAME_COLLECTION_URL = "_collection_url";
    public static final String RES_NAME_HTTP_USER = "_http_user";
    public static final String RES_NAME_HTTP_PASSWORD = "_http_password";
    public static final String RES_NAME_HTTP_PROXY_URL = "_http_proxy_url";
    public static final String HTTP_SERVER_CLASSID = "DAC0D7F0-10DA-11D6-8816-AA0004006D06";
    public static final String HTTP_SERVER_BASE_PATH_PROPERTY_NAME = "HttpServerBasePath";
    public static final String HTTP_SERVER_SUPPORTS_DAV_PROPERTY_NAME = "SupportsWebDAV";
    public static final String LOCALIZATION_KEY_DESCRIPTION = "Description";
    public static final String LOCALIZATION_KEY_LABEL = "Label";
    public static final String LOCALIZATION_PREFIX_OUTPUT_PARAMETERS = "OutputParameters";
    public static final String LOCALIZATION_PREFIX_PROMPTS = "Prompts";
    public static final String LOCALIZATION_PREFIX_STREAMS = "Streams";
    public static final String LOCALIZATION_PREFIX_TABLES = "Tables";
    public static final String GENERIC_STREAM_DEFAULT_CONTENT_TYPE = "application/unknown";
    public static final String XML_STREAM_DEFAULT_CONTENT_TYPE = "text/xml";
    public static final String CLASSIFIERMAP_TEMPLATE = "<ClassifierMap><ClassifierSources/><ClassifierTargets/><ComputeLocations/><Keywords/><Notes/><Properties/><SourceCode/><Trees/></ClassifierMap><ArchiveFile><Directories/></ArchiveFile><Directory><Parent/><Properties/><DeployedComponents/></Directory><File><Directories/></File><Report><Properties/><ReportLocation/></Report><Stream><Properties/></Stream><Tree><ParentTree/><SoftwareComponents/></Tree>";
    public static final String STORED_PROCESS_V1_AND_V2_TEMPLATE = "<ClassifierMap><ComputeLocations/><Keywords/><Notes/><Prompts/><ResponsibleParties/><SourceCode/><Trees/></ClassifierMap><Directory><Properties/></Directory><File><Directories/></File><ServerContext><UsingComponents/></ServerContext>";
    static List _entityPropertyTypes;
    static String _repositoryIDForCachedEntityPropertyTypes;

    private MetadataConstants() {
    }

    public static List<OutputParameterInterface> getOutputParametersFromXML(Element spE) throws MCException {
        ArrayList<OutputParameterInterface> outputParameters = new ArrayList<OutputParameterInterface>();
        if (spE == null) {
            return outputParameters;
        }
        NodeList list = spE.getElementsByTagName("OutputParameters");
        if (list.getLength() == 0) {
            return outputParameters;
        }
        if (list.getLength() > 1) {
            throw new MCException(RB.getStringResource("MC.MultplOPTag.ex.txt"));
        }
        Element outputParametersE = (Element)list.item(0);
        list = outputParametersE.getElementsByTagName(XML_E_PARAMETER);
        for (int i = 0; i < list.getLength(); ++i) {
            Element parmE = (Element)list.item(i);
            OutputParameter op = new OutputParameter(parmE);
            outputParameters.add(op);
        }
        return outputParameters;
    }

    public static void getDataSourcesAndTargetsFromXML(ServerInterface si, Element spE, ArrayList sourcesAndtargets) throws MCException, RemoteException, IllegalStateException {
        if (spE == null) {
            return;
        }
        NodeList list = spE.getElementsByTagName(XML_E_DATA);
        if (list.getLength() == 0) {
            return;
        }
        if (list.getLength() > 1) {
            throw new MCException(RB.getStringResource("MC.MultplDataTag.ex.txt"));
        }
        Element dataE = (Element)list.item(0);
        list = dataE.getElementsByTagName(XML_E_SOURCE);
        MetadataConstants.readDataItemsFromXML(si, list, sourcesAndtargets, true);
        list = dataE.getElementsByTagName(XML_E_TARGET);
        MetadataConstants.readDataItemsFromXML(si, list, sourcesAndtargets, false);
    }

    private static void readDataItemsFromXML(ServerInterface si, NodeList nodeList, ArrayList itemList, boolean isSource) throws MCException, RemoteException, IllegalStateException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element dataItemE = (Element)nodeList.item(i);
            boolean dataTable = false;
            boolean genStream = false;
            String type = dataItemE.getAttribute("Type");
            if (type.length() == 0) {
                throw new MCException(RB.getStringResource("MC.MissnType.ex.txt"));
            }
            if (type.equalsIgnoreCase(XML_A_VALUE_GENERIC_STREAM)) {
                genStream = true;
            } else if (type.equalsIgnoreCase(XML_A_VALUE_XML_STREAM)) {
                genStream = false;
            } else if (type.equalsIgnoreCase(XML_A_VALUE_DATA_TABLE)) {
                dataTable = true;
            } else {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"MC.UnsuppType.ex.fmt.txt", (Object)type);
                throw new MCException(msg);
            }
            if (dataTable) {
                DataTable dt = new DataTable(si, dataItemE, isSource);
                itemList.add(dt);
                continue;
            }
            GenericStream stream = genStream ? new GenericStream(dataItemE, isSource) : new XMLStream(dataItemE, isSource);
            itemList.add(stream);
        }
    }

    public static int getCountNoSecurity(SessionContextInterface sessionContextInterface, Root root, String association) throws RemoteException, ServiceException {
        UserContextInterface uci = sessionContextInterface.getUserContext();
        String cMetadataType = root.getCMetadataType();
        MetadataServerInterface msi = (MetadataServerInterface)uci.getAuthServer();
        String rootFQID = root.getFQID();
        IdFilter filter = new IdFilter(rootFQID);
        filter.setType(cMetadataType);
        String template = "<Templates><" + cMetadataType + "><" + association + "/></" + cMetadataType + "></Templates>";
        filter.setOMRTemplate(template);
        String reposFQID = "A0000001." + rootFQID.substring(0, 8);
        filter.setOMRRepository(reposFQID);
        int count = msi.getCountNoSecurity((Filter)filter, association);
        return count;
    }

    public static PropertyList getLocalizableProperties(StoredProcess spi, PropertyList list) throws RemoteException, MdException, ServiceException {
        ClassifierMap classifierMap;
        TextStore textStore;
        Element spE;
        OMRPromptGroupInterface promptGroupSmartObject = (OMRPromptGroupInterface)spi.getPrompt();
        PromptGroupInterface promptGroup = promptGroupSmartObject.getPromptGroup();
        if (promptGroup != null && !promptGroup.getPromptDefinitionsAndSubgroups().isEmpty()) {
            list.addBlankLine();
            list.addComment(LOCALIZATION_PREFIX_PROMPTS);
            list.addProperty(LOCALIZATION_PREFIX_PROMPTS, ((LocalizableProperties)promptGroup).getLocalizableProperties());
        }
        if ((spE = MetadataConstants.getSPElement(textStore = MetadataConstants.getTextStore(classifierMap = (ClassifierMap)spi.getRepositoryEntity()))) != null) {
            try {
                List<OutputParameterInterface> opList = MetadataConstants.getOutputParametersFromXML(spE);
                if (opList.size() > 0) {
                    list.addBlankLine();
                    list.addComment("Output Parameters");
                    for (OutputParameter outputParameter : opList) {
                        list.addProperty("OutputParameters." + outputParameter.getName(), outputParameter.getLocalizableProperties());
                    }
                }
            }
            catch (MCException e) {
                throw new IllegalStateException("Exception encountered processing output parameters: " + e.toString());
            }
            try {
                ArrayList sourcesAndtargets = new ArrayList();
                MetadataConstants.getDataSourcesAndTargetsFromXML(null, spE, sourcesAndtargets);
                if (sourcesAndtargets.size() > 0) {
                    list.addBlankLine();
                    list.addComment("Data Sources and Targets");
                    for (Object e : sourcesAndtargets) {
                        if (e instanceof GenericStream) {
                            GenericStream stream = (GenericStream)e;
                            list.addProperty("Streams." + stream._normalizedName, stream.getLocalizableProperties());
                            continue;
                        }
                        if (e instanceof DataTable) {
                            DataTable dt = (DataTable)e;
                            list.addProperty("Tables." + dt.getParameterName(), dt.getLocalizableProperties());
                            continue;
                        }
                        throw new IllegalStateException("Unknown object in data sources and targets list: " + e.getClass());
                    }
                }
            }
            catch (MCException e) {
                throw new IllegalStateException("Exception encountered processing data sources and targets: " + e.toString());
            }
        }
        return list;
    }

    public static void setLocalizableProperties(StoredProcess spi, PropertyMap map) throws RemoteException, MdException, ServiceException {
        if (map == null) {
            return;
        }
        ClassifierMap classifierMap = (ClassifierMap)spi.getRepositoryEntity();
        TextStore textStore = MetadataConstants.getTextStore(classifierMap);
        Element spE = MetadataConstants.getSPElement(textStore);
        if (spE != null) {
            boolean hasLocalizableTables;
            PropertyMap outputParmMap = map.getNestedProperties("OutputParameters");
            if (outputParmMap != null && !outputParmMap.isEmpty()) {
                try {
                    List<OutputParameterInterface> opList = MetadataConstants.getOutputParametersFromXML(spE);
                    for (OutputParameter outputParameter : opList) {
                        outputParameter.setLocalizableProperties(outputParmMap.getNestedProperties(outputParameter.getName()));
                    }
                }
                catch (MCException e) {
                    throw new IllegalStateException("Exception encountered processing output parameters: " + e.toString());
                }
            }
            PropertyMap streamMap = map.getNestedProperties(LOCALIZATION_PREFIX_STREAMS);
            PropertyMap tableMap = map.getNestedProperties(LOCALIZATION_PREFIX_TABLES);
            boolean bl = streamMap != null && !streamMap.isEmpty();
            boolean bl2 = hasLocalizableTables = tableMap != null && !tableMap.isEmpty();
            if (bl || hasLocalizableTables) {
                try {
                    ArrayList sourcesAndTargets = new ArrayList();
                    MetadataConstants.getDataSourcesAndTargetsFromXML(null, spE, sourcesAndTargets);
                    for (Object o : sourcesAndTargets) {
                        if (o instanceof GenericStream) {
                            if (!bl) continue;
                            GenericStream stream = (GenericStream)o;
                            PropertyMap sMap = streamMap.getNestedProperties(stream._normalizedName);
                            stream.setLocalizableProperties(sMap);
                            continue;
                        }
                        if (o instanceof DataTable) {
                            if (!hasLocalizableTables) continue;
                            DataTable datatable = (DataTable)o;
                            PropertyMap tMap = tableMap.getNestedProperties(datatable.getParameterName());
                            datatable.setLocalizableProperties(tMap);
                            continue;
                        }
                        throw new IllegalStateException("Unknown object in data sources and targets list: " + o.getClass());
                    }
                }
                catch (MCException e) {
                    throw new IllegalStateException("Exception encountered processing data sources and targets: " + e.toString());
                }
            }
            Document document = spE.getOwnerDocument();
            document.normalize();
            textStore.setStoredText(XMLUtil.convertNodeToString((Node)document));
        }
    }

    private static Element getSPElement(TextStore textStore) throws RemoteException {
        if (textStore == null) {
            return null;
        }
        String textStoreXML = textStore.getStoredText();
        if (textStoreXML != null && textStoreXML.length() > 0) {
            Document document = XMLUtil.convertStringToDocument((String)textStoreXML);
            NodeList nlist = document.getElementsByTagName("StoredProcess");
            if (nlist.getLength() > 1) {
                throw new IllegalStateException("Multiple \"StoredProcess\" elements in TextStore.");
            }
            if (nlist.getLength() == 1) {
                Element spE = (Element)nlist.item(0);
                return spE;
            }
        }
        return null;
    }

    private static TextStore getTextStore(ClassifierMap classifierMap) throws RemoteException, MdException {
        for (Object o : classifierMap.getNotes()) {
            TextStore ts;
            if (!(o instanceof TextStore) || !(ts = (TextStore)o).getTextRole().equalsIgnoreCase(STORED_PROCESS_TEXT_ROLE) || !ts.getTextType().equalsIgnoreCase(STORED_PROCESS_TEXT_TYPE)) continue;
            return ts;
        }
        return null;
    }

    public static boolean getBooleanPropertyValue(Root root, String propertyName) throws MdException, RemoteException {
        return MetadataConstants.checkPropertyNamePresence(root, propertyName, "0", false);
    }

    public static boolean checkPropertyRolePresence(Root object, String propertyRole, String defaultValue, boolean equals) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (!p.getPropertyRole().equalsIgnoreCase(propertyRole)) continue;
            if (defaultValue == null) {
                return true;
            }
            if (equals) {
                return defaultValue.equals(p.getDefaultValue());
            }
            return !defaultValue.equals(p.getDefaultValue());
        }
        return false;
    }

    public static boolean checkPropertyNamePresence(Root object, String propertyName, String defaultValue, boolean equals) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (!p.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            if (defaultValue == null) {
                return true;
            }
            if (equals) {
                return defaultValue.equals(p.getDefaultValue());
            }
            return !defaultValue.equals(p.getDefaultValue());
        }
        return false;
    }

    public static void deleteAllProperties(Root root) throws MdException, RemoteException {
        MetadataConstants.deleteAllAssociatedObjects(root.getProperties());
    }

    public static void deleteObjects(ArrayList objList) throws MdException, RemoteException {
        for (Root root : objList) {
            if (root instanceof Property) {
                MetadataConstants.deleteProperty((Property)root);
                continue;
            }
            root.delete();
        }
    }

    public static void deleteProperty(Property property) throws MdException, RemoteException {
        PropertyType propertyType = property.getOwningType();
        boolean canDeletePropertyType = true;
        List list = MetadataConstants.getEntityPropertyTypes((Root)propertyType);
        if (list != null) {
            String ptID = propertyType.getFQID();
            for (String id : list) {
                if (!ptID.equals(id)) continue;
                canDeletePropertyType = false;
                break;
            }
        }
        if (canDeletePropertyType) {
            AssociationList alArrayTypes = propertyType.getArrayTypes();
            AssociationList alGroups = propertyType.getGroups();
            AssociationList alTypedAttProperties = propertyType.getTypedAttProperties();
            AssociationList alTypedProperties = propertyType.getTypedProperties();
            if (alArrayTypes.size() != 0 || alGroups.size() != 0 || alTypedAttProperties.size() != 0 || alTypedProperties.size() != 1) {
                canDeletePropertyType = false;
            }
        }
        if (canDeletePropertyType) {
            propertyType.delete();
        }
        property.delete();
    }

    static synchronized List getEntityPropertyTypes(Root root) throws RemoteException {
        boolean getEntityPropertyTypes = false;
        if (_entityPropertyTypes == null) {
            getEntityPropertyTypes = true;
        } else {
            String reposID = root.getRepositoryID();
            if (!reposID.equals(_repositoryIDForCachedEntityPropertyTypes)) {
                getEntityPropertyTypes = true;
            }
        }
        if (getEntityPropertyTypes) {
            try {
                _entityPropertyTypes = MdOMAEntityUtility.getPropertyTypesForObjectRepositoryIDList((Root)root);
                _repositoryIDForCachedEntityPropertyTypes = root.getRepositoryID();
            }
            catch (MdException e) {
                _entityPropertyTypes = null;
            }
        }
        return _entityPropertyTypes;
    }

    public static void deleteAllAssociatedObjects(AssociationList al) throws MdException, RemoteException {
        ArrayList<Root> objList = new ArrayList<Root>();
        for (Root root : al) {
            objList.add(root);
        }
        MetadataConstants.deleteObjects(objList);
    }

    public static CMetadata createANewComplexObjectToBeAssociatedWithGivenObject(CMetadata source, String name, String type) throws RemoteException {
        MdFactory factory = source.getObjectStore().getFactory();
        CMetadata newObject = factory.createComplexMetadataObject((MdObjectStore)source.getObjectStore(), null, name, type, source.getRepositoryID());
        return newObject;
    }

    public static String getLabelForParameterPromptGroup(Locale locale) {
        return RB.getStringResource("MC.Parms.txt", locale);
    }

    public static LogicalServer getLogicalServerFromServerContext(boolean isWorkspaceServerDesired, ServerContext sc) throws RemoteException, MdException {
        LogicalServer ls = null;
        for (CMetadata m : sc.getUsingComponents()) {
            if (!(m instanceof LogicalServer)) continue;
            ls = (LogicalServer)m;
            String classID = ls.getClassIdentifier();
            if (!(isWorkspaceServerDesired ? classID.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") : classID.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c"))) continue;
            return ls;
        }
        return null;
    }

    static {
        _repositoryIDForCachedEntityPropertyTypes = "";
    }

    @SASScope
    public static class MCException
    extends Exception {
        public MCException(Throwable t) {
            super(t);
        }

        public MCException(String s) {
            super(s);
        }
    }
}

