/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.RB;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class GenericStream
implements Serializable,
LocalizableProperties {
    private static final long serialVersionUID = 8253832499790302007L;
    final String _fileref;
    final boolean _isSource;
    final boolean _allowsRewinds;
    final String _normalizedName;
    private String _label = "";
    private String _description = "";
    private String _expectedContentType;
    protected final transient Element _streamElement;
    private transient Element _descElement;
    private transient Element _labelElement;
    private transient Element _cultureElement;
    private transient Document _document;
    transient Reader _reader;
    transient InputStream _inputStream;
    transient Writer _writer;
    transient OutputStream _outputStream;
    transient String _path;
    transient String _engine;
    transient String _options;
    transient boolean _filerefInitialized;
    transient boolean _filerefFileIsOnClient;

    GenericStream(Element element, boolean isSource) throws MetadataConstants.MCException {
        this._streamElement = element;
        this._document = this._streamElement.getOwnerDocument();
        this._fileref = element.getAttribute("Fileref");
        if (this._fileref.length() == 0) {
            throw new MetadataConstants.MCException(RB.getStringResource("MC.MissnFileref.ex.txt"));
        }
        this._normalizedName = this._fileref.toLowerCase(Locale.US);
        String multiPass = element.getAttribute("Multipass");
        this._allowsRewinds = multiPass.equalsIgnoreCase("true");
        this._isSource = isSource;
        this._expectedContentType = this._streamElement.getAttribute("ContentType");
        NodeList cultureElements = this._streamElement.getElementsByTagName("Culture");
        boolean seenValidCulture = false;
        for (int j = 0; j < cultureElements.getLength(); ++j) {
            Element cultureE = (Element)cultureElements.item(j);
            String xmlLangValue = cultureE.getAttribute("xml:lang");
            if (xmlLangValue.length() != 0) continue;
            if (seenValidCulture) {
                throw new MetadataConstants.MCException(RB.getStringResource("MC.MultplVldCultr.ex.txt"));
            }
            this._cultureElement = cultureE;
            seenValidCulture = true;
            NodeList cultureChildren = cultureE.getChildNodes();
            for (int k = 0; k < cultureChildren.getLength(); ++k) {
                Element labelOrDesc;
                Node nn = cultureChildren.item(k);
                if (nn.getNodeType() != 1 || !(labelOrDesc = (Element)nn).getTagName().equals("Label") && !labelOrDesc.getTagName().equals("Description")) continue;
                if (labelOrDesc.getTagName().equals("Label")) {
                    this._labelElement = labelOrDesc;
                    this._label = this._labelElement.getTextContent();
                    continue;
                }
                this._descElement = labelOrDesc;
                this._description = this._descElement.getTextContent();
            }
        }
    }

    GenericStream(String fileref, boolean allowsRewinds, boolean isSource) {
        this._streamElement = null;
        this._fileref = fileref;
        this._normalizedName = fileref.toLowerCase(Locale.US);
        this._allowsRewinds = allowsRewinds;
        this._isSource = isSource;
    }

    public String getFileref() {
        return this._fileref;
    }

    boolean isEqualsTo(GenericStream gs) {
        return gs._normalizedName.equals(this._normalizedName) && gs._isSource == this._isSource && gs._allowsRewinds == this._allowsRewinds;
    }

    public String getLabel() {
        return this._label;
    }

    public String getExpectedContentType() {
        return this._expectedContentType;
    }

    public boolean allowsRewinds() throws IllegalStateException {
        if (!this._isSource) {
            throw new IllegalStateException(RB.getStringResource("GS.inv.ex.txt"));
        }
        return this._allowsRewinds;
    }

    public String getDescription() {
        return this._description;
    }

    public String toString() {
        return this._fileref;
    }

    public boolean isSource() {
        return this._isSource;
    }

    private void setDescription(String description) {
        this._description = description;
        if (this._descElement == null) {
            this.ensureCultureExists();
            this._descElement = this._document.createElement("Description");
            this._cultureElement.appendChild(this._descElement);
        }
        this._descElement.setTextContent(description);
    }

    private void setLabel(String label) {
        this._label = label;
        if (this._labelElement == null) {
            this.ensureCultureExists();
            this._labelElement = this._document.createElement("Label");
            this._cultureElement.appendChild(this._labelElement);
        }
        this._labelElement.setTextContent(label);
    }

    private void ensureCultureExists() {
        if (this._cultureElement != null) {
            return;
        }
        this._cultureElement = this._document.createElement("Culture");
        this._streamElement.appendChild(this._cultureElement);
    }

    public PropertyList getLocalizableProperties() {
        PropertyList list = new PropertyList();
        list.addProperty("Label", this.getLabel());
        list.addProperty("Description", this.getDescription());
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) {
        if (map == null) {
            return;
        }
        if (map.containsProperty("Label")) {
            this.setLabel(map.getProperty("Label"));
        }
        if (map.containsProperty("Description")) {
            this.setDescription(map.getProperty("Description"));
        }
    }
}

