/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamAdapter;
import com.sas.io.InputStreamHeaderInterface;
import com.sas.io.OutputStreamHeaderInterface;
import com.sas.io.OutputStreamProxy;
import com.sas.iom.InputStream;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileServicePackage.AssignmentContextSeqHolder;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.ILibref;
import com.sas.iom.SAS.IResultPackage;
import com.sas.iom.SAS.IResultPackageHolder;
import com.sas.iom.SAS.IResultPackageService;
import com.sas.iom.SAS.IResultPackage_1_2;
import com.sas.iom.SAS.IResultPackage_1_2Helper;
import com.sas.iom.SAS.IStoredProcessService;
import com.sas.iom.SAS.IStoredProcessService_1_1;
import com.sas.iom.SAS.IStoredProcessService_1_1Helper;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.ITextStreamPackage.ContainsNull;
import com.sas.iom.SAS.ITextStreamPackage.LineTruncated;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspace_1_1;
import com.sas.iom.SAS.IWorkspace_1_1Helper;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASCache.ICacheReader;
import com.sas.iom.SASCache.ICacheService;
import com.sas.iom.SASCache.ICacheWriter;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2Helper;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2Package.BadSessionID2;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2Package.CarriageControl2SeqHolder;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2Package.InvalidFileref;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2Package.LineType2SeqHolder;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2Package.StreamFilerefFail;
import com.sas.iom.SASStoredProcess.IStoredProcessServer;
import com.sas.iom.SASStoredProcess.IStoredProcessServerPackage.BadSessionID;
import com.sas.iom.SASStoredProcess.IStoredProcessServer_1_1;
import com.sas.iom.SASStoredProcess.IStoredProcessServer_1_1Helper;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValuesInterface;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MyInbox;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonalRepositoryInterface;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TransportFactory;
import com.sas.services.publish.archive.ArchiveTransport;
import com.sas.services.publish.metadata.DavBinaryPackageInterface;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.requester.RequesterTransportInterface;
import com.sas.services.publish.webdav.DAVTransportInterface;
import com.sas.services.session.LockingException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.AlertProcessingException;
import com.sas.services.storedprocess.CaseNeutralLookup;
import com.sas.services.storedprocess.ConnectionMaker;
import com.sas.services.storedprocess.Credentials;
import com.sas.services.storedprocess.DataTableWrapper;
import com.sas.services.storedprocess.Event;
import com.sas.services.storedprocess.Execution2Interface;
import com.sas.services.storedprocess.ExecutionException;
import com.sas.services.storedprocess.ExecutionStatusListener2Interface;
import com.sas.services.storedprocess.ExecutionStatusListenerException;
import com.sas.services.storedprocess.GenericStream;
import com.sas.services.storedprocess.InternalUseException;
import com.sas.services.storedprocess.LocationHelper;
import com.sas.services.storedprocess.LogFormatter;
import com.sas.services.storedprocess.ObjectCache;
import com.sas.services.storedprocess.OutputParameter;
import com.sas.services.storedprocess.OutputParameterInterface;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.ResultTypeDeterminer;
import com.sas.services.storedprocess.ResultsBindingException;
import com.sas.services.storedprocess.SASLog;
import com.sas.services.storedprocess.SASServerException;
import com.sas.services.storedprocess.SessionNotAvailableException;
import com.sas.services.storedprocess.SessionNotFoundException;
import com.sas.services.storedprocess.StoredProcess2;
import com.sas.services.storedprocess.StoredProcessBaseInterface;
import com.sas.services.storedprocess.StoredProcessService;
import com.sas.services.storedprocess.StreamDefinition2;
import com.sas.services.storedprocess.UniqueNameGenerator;
import com.sas.services.storedprocess.WebDAVPackageDAVServerLocationHelper;
import com.sas.services.storedprocess.WebDAVPackagePRLocationHelper;
import com.sas.services.storedprocess.metadata.DataTable;
import com.sas.services.storedprocess.metadata.StoredProcessAlertItemInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.GlobalProfileInterface;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import com.sas.util.UsageVersion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@SASScope
final class Execution2
extends UnicastRemoteObject
implements Execution2Interface {
    private static final int STREAM_BUFFER_SIZE = 4096;
    private static final int TEXTSTREAM_LINES_TO_READ = 100;
    private static final String CLIENT_NAME = "StoredProcessService 9.4";
    static final String CLIENT = "_client";
    static final String METAPERSON = "_metaperson";
    static final String METAUSER = "_metauser";
    static final String PROGRAM = "_program";
    static final String METAFOLDER = "_metafolder";
    static final String UNKNOWN = "UNKNOWN";
    static final String FILEREF_LIBREF_PREFIX = "_STP";
    static final int NUMBER_OF_TRIES = 100;
    private ExecutionStatusListener2Interface _listener;
    private boolean _synchronous;
    private boolean _createAlert;
    private IResultPackage _iResultPackage;
    private ResultPackageInterface _resultPackage;
    private boolean _resultPackageAccessed;
    private volatile int _status = -1;
    private String[] _parmsNames;
    private String[] _parmsValues;
    private final String[] _parmsNamesForAlert;
    private final java.lang.Object[] _parmsValuesForAlert;
    private int _numberOfParms;
    private IResultPackageService _resultPackageService;
    private LocationHelper _locationHelper;
    private IStoredProcessContext2 _storedProcessContext;
    private IStoredProcessServer_1_1 _storedProcessServer;
    private String _resultPackageFilePath;
    private final HashMap<String, StreamDefinition2> _streamsMap = new HashMap();
    private final LinkedHashMap<String, DataTableWrapper> _targetTables = new LinkedHashMap();
    private final LinkedHashMap<String, DataTableWrapper> _sourceTables = new LinkedHashMap();
    private ILanguageService _languageService;
    boolean _languageServiceAsyncSettingSavedForRestorationPurposes;
    private IWorkspace_1_1 _workspace;
    private final java.lang.Object _completionStatusLock = new java.lang.Object();
    private final AbortLock _abortLock = new AbortLock();
    private final java.lang.Object _connectionAttemptLock = new java.lang.Object();
    private int _SASCondtionCode;
    private String _sessionID;
    private StoredProcessAlertItemInterface _alert;
    private PersonalRepositoryInterface _personalRepository;
    private ArrayList<ExecutionException> _exceptionList;
    private AlertEvent _alertEvent;
    private final String _eId;
    private boolean _cacheServiceIsNeeded;
    private String _PROGRAMvalue;
    private String _METAFOLDERvalue;
    private Credentials _webDAVCredentialsUsedForParameters;
    private boolean _completionStatusSet = false;
    private boolean _connectionAttemptCompleted;
    private Logger _logger;
    private boolean _addedSessionIDWhichShouldBeRemovedIfNotCreated;
    private String _sessionIDWhichMayHaveToBeRemoved;
    private Connection _connectionType;
    private String _connectionSessionID;
    private java.lang.Object _connectionServer;
    private ConnectionInterface _createdConnection;
    private boolean _alreadyDestroyed;
    private final SessionContextInterface _sessionContext;
    private java.lang.Object _sessionLock;
    private final UserContextInterface _userContext;
    private boolean _sessionFreedOnDestroy;
    private boolean _needToReadFromTempFileRefsAfterExecution;
    private final String _storedProcessName;
    private final StoredProcessService _service;
    private final String _storedProcessDirectory;
    private final String _storedProcessFileName;
    private boolean _isResultPackageLifeCycleBound = true;
    private final ArrayList<OutputParameterInterface> _outputParms = new ArrayList();
    private boolean _outputParmValuesAvailable;
    private final ResultTypeDeterminer.ResultType _result;
    private int _resultTypeForAlert;
    private String _storedProcessPrivilegedUser;
    private LogicalServerInterface _logicalServer;
    private ServerContext _serverContext;
    private boolean _runningOnWorkspaceServer;
    private boolean _is92workspaceServerBased;
    private UsageVersion _usageVersion;
    private boolean _isNineTwo;
    private String _sourceCode;
    private int _filrefLibrefCount;
    private ObjectCache _objectCache;
    private boolean _rareDuplicateSessionIDCase;
    private StoredProcessInterface.LogicalServerType _logicalServerType;
    private RepositoryInterface _ri;

    private void logMessageAndThrowIllegalStateException(String message) {
        if (this._logger != null) {
            this._logger.error(message);
        }
        throw new IllegalStateException(message);
    }

    Execution2(StoredProcess2 storedProcess, String sessionID, boolean createAlert, int executionCount, ObjectCache objectCache) throws RemoteException, ExecutionException {
        this(storedProcess, createAlert, executionCount, objectCache);
        if (storedProcess.getServerType() != 1) {
            String text = "Inconsistent server type " + storedProcess.getServerType() + " used with sessionID constructor.";
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (java.lang.Object)text);
            this.logMessageAndThrowIllegalStateException(msg);
        }
        this._connectionType = Connection.SESSIONID;
        this._connectionSessionID = sessionID;
    }

    Execution2(StoredProcess2 storedProcess, java.lang.Object userSpecifiedServer, boolean createAlert, int executionCount, ObjectCache objectCache) throws RemoteException, ExecutionException {
        this(storedProcess, createAlert, executionCount, objectCache);
        this._connectionType = Connection.USER_SPECIFIED_SERVER;
        this._connectionServer = this.setConnection(userSpecifiedServer);
        if (this._is92workspaceServerBased && !this._runningOnWorkspaceServer) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.wrngConnFor92WksSP.ex.txt"));
        }
    }

    Execution2(StoredProcess2 storedProcess, LogicalServerInterface logicalServer, boolean createAlert, int executionCount, boolean deferGettingConnection, ObjectCache objectCache) throws RemoteException, ExecutionException {
        this(storedProcess, createAlert, executionCount, objectCache);
        if (this._userContext == null) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.userCtxtNeededForCnxn.ex.txt"));
        }
        this._storedProcessPrivilegedUser = storedProcess._privilegedUser;
        this._logicalServer = logicalServer;
        if (deferGettingConnection) {
            this._connectionType = Connection.OBTAINED_FROM_METADATA_PENDING;
        } else {
            this.makeConnection();
            this._connectionType = Connection.OBTAINED_FROM_METADATA;
        }
    }

    Execution2(StoredProcess2 storedProcess, ServerContext serverContext, boolean createAlert, int executionCount, boolean deferGettingConnection, ObjectCache objectCache) throws RemoteException, ExecutionException {
        this(storedProcess, createAlert, executionCount, objectCache);
        if (this._userContext == null) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.userCtxtNeededForCnxn.ex.txt"));
        }
        this._storedProcessPrivilegedUser = storedProcess._privilegedUser;
        this._serverContext = serverContext;
        this._logicalServerType = storedProcess.getEffectiveLogicalServerType();
        this._ri = objectCache.getRepository();
        if (deferGettingConnection) {
            this._connectionType = Connection.OBTAINED_FROM_METADATA_PENDING;
        } else {
            this.makeConnection();
            this._connectionType = Connection.OBTAINED_FROM_METADATA;
        }
    }

    private void makeConnection() throws ExecutionException, RemoteException {
        ConnectionMaker cm = this._isNineTwo ? new ConnectionMaker(this._storedProcessPrivilegedUser, this._userContext, this._logicalServer) : new ConnectionMaker(this._storedProcessPrivilegedUser, this._userContext, this._serverContext, this._logicalServerType, this._ri);
        try {
            this._createdConnection = cm.makeConnection();
            this._connectionServer = this.setConnection(this._createdConnection);
        }
        catch (ServiceException se) {
            throw new ExecutionException(RB.getStringResource("COM.noConn.ex.txt"), se);
        }
        catch (ConnectionFactoryException cfe) {
            throw new ExecutionException(RB.getStringResource("COM.noConn.ex.txt"), cfe);
        }
        catch (MdException mde) {
            throw new ExecutionException(RB.getStringResource("COM.metaExcp.ext.txt"), mde);
        }
    }

    private Execution2(StoredProcess2 storedProcess, boolean createAlert, int executionCount, ObjectCache objectCache) throws RemoteException, ExecutionException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, Execution2.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(Execution2.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(Execution2.class));
        String osStuff;
        String valueMETAUSER;
        String valueMETAPERSON;
        this._createAlert = createAlert;
        this._sessionContext = storedProcess._sessionContext;
        this._userContext = storedProcess._userContext;
        this._sessionFreedOnDestroy = storedProcess._sessionFreedOnDestroy;
        this._usageVersion = storedProcess.getUsageVersion();
        this._isNineTwo = this._usageVersion.equals((java.lang.Object)StoredProcessInterface.NINETWO_VERSION);
        this._is92workspaceServerBased = this._isNineTwo && storedProcess.getServerType() == 2;
        this._storedProcessName = storedProcess.getName();
        this._service = storedProcess._service;
        this._storedProcessDirectory = storedProcess.getDirectory();
        this._storedProcessFileName = storedProcess.getFileName();
        this._objectCache = objectCache;
        if (this._objectCache != null) {
            this._objectCache.incrementAndGet();
        }
        this._eId = executionCount == 1 ? storedProcess._seqNum : storedProcess._seqNum + '-' + Integer.toString(executionCount);
        this._logger = LogManager.getLogger(Execution2.class);
        this.compute_Program(storedProcess);
        List<OutputParameterInterface> ops = storedProcess.getOutputParameters();
        for (OutputParameter outputParameter : ops) {
            OutputParameter opDest = (OutputParameter)outputParameter.clone();
            this._outputParms.add(opDest);
        }
        PromptValuesInterface promptValues = storedProcess.getPromptValues();
        Map map = PromptUtil.getMacroVariableValues((PromptValuesInterface)promptValues, null, (boolean)false, (Locale)storedProcess._locale);
        CaseNeutralLookup cnl = null;
        try {
            cnl = new CaseNeutralLookup(map);
        }
        catch (ResultTypeDeterminer.InconsistencyException e2) {
            throw new ExecutionException("Consistency check.  " + e2.getLocalizedMessage());
        }
        int numberOfParms = map.size();
        ArrayList<String> namesForAlert = new ArrayList<String>(numberOfParms);
        ArrayList<String> valuesForAlert = new ArrayList<String>(numberOfParms);
        for (java.lang.Object name : map.keySet()) {
            if (name == null) {
                throw new ExecutionException(RB.getStringResource("COM.noPromptNam.ex.txt"));
            }
            if (((String)name).length() > 32) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.prmptTooLong.ex.fmt.txt", (java.lang.Object)name, (java.lang.Object)((String)name).length(), (java.lang.Object)32);
                throw new ExecutionException(msg);
            }
            String val = (String)map.get(name);
            namesForAlert.add((String)name);
            valuesForAlert.add(val);
        }
        if (this._createAlert) {
            try {
                this._resultTypeForAlert = storedProcess.getResultType();
            }
            catch (ServiceException e) {
                throw new ExecutionException(e.getMessage());
            }
            this.createAlertItem();
        }
        try {
            this._result = ResultTypeDeterminer.getType(this._usageVersion, storedProcess);
        }
        catch (ResultTypeDeterminer.InconsistencyException e1) {
            throw new ExecutionException(e1.getMessage());
        }
        String resultValue = cnl.get("_result");
        if (resultValue != null) {
            resultValue = resultValue.toUpperCase();
        }
        for (String key : storedProcess._streams.keySet()) {
            GenericStream gs = storedProcess._streams.get(key);
            StreamDefinition2 sd = new StreamDefinition2(gs);
            this._streamsMap.put(key, sd);
            if (sd._filerefInitialized) continue;
            this._cacheServiceIsNeeded = true;
        }
        this._sourceTables.putAll(storedProcess._sourceTables);
        this._targetTables.putAll(storedProcess._targetTables);
        switch (this._result) {
            case STATUS: {
                if (resultValue != null && resultValue.length() != 0) break;
                cnl.put("_result", "STATUS");
                break;
            }
            case STREAM: {
                StreamDefinition2 sd;
                if (resultValue == null || resultValue.length() == 0) {
                    cnl.put("_result", "STREAM");
                }
                if ((sd = this.getInputOutputStream("_webout")) != null) {
                    if (sd._isInput) break;
                    throw new ExecutionException(RB.getStringResource("E2.noWEBOUTforOutput.ex.txt"));
                }
                GenericStream gs = new GenericStream("_webout", false, false);
                sd = new StreamDefinition2(gs);
                this._streamsMap.put("_webout", sd);
                this._cacheServiceIsNeeded = true;
                break;
            }
            case TRANSIENT_PACKAGE: {
                if (this._is92workspaceServerBased) {
                    cnl.put("_result", "PACKAGE_TO_REQUESTER");
                    break;
                }
                cnl.put("_result", "PACKAGE_TO_ARCHIVE");
                this.setParmValueInLocalMapWarningIfParmExists(cnl, "_archive_path", "TEMPFILE");
                break;
            }
            case PR_PACKAGE: {
                String newInstance = cnl.get("_create_new_package_instance");
                boolean createNewInstance = newInstance != null && newInstance.equalsIgnoreCase("true");
                String webDAVCollectionURL = null;
                String webDAVuserid = null;
                String webDAVpassword = null;
                try {
                    String prCollPath = cnl.get("_pr_collection_path");
                    if (!(createNewInstance || prCollPath != null && prCollPath.length() != 0)) {
                        throw new ExecutionException(RB.getStringResource("COM.collNameReqd.ex.txt"));
                    }
                    WebDAVPackagePRLocationHelper lh = new WebDAVPackagePRLocationHelper(prCollPath, createNewInstance);
                    this.findPersonalRepository();
                    lh.setPersonalRepository(this._personalRepository);
                    lh.determineResultsLocation(this._alert == null ? null : this._alert.getName(), this._logger, this._eId);
                    webDAVCollectionURL = lh.getResultLocation();
                    this._webDAVCredentialsUsedForParameters = lh.getCredentials(this._logger);
                    this._locationHelper = lh;
                }
                catch (ServiceException se) {
                    throw new SASServerException(se);
                }
                this.setParmValueInLocalMapWarningIfParmExists(cnl, "_collection_url", webDAVCollectionURL);
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.DAVResltLoc.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)webDAVCollectionURL);
                    this._logger.debug(msg);
                }
                webDAVuserid = this._webDAVCredentialsUsedForParameters._userName;
                webDAVpassword = this._webDAVCredentialsUsedForParameters._password;
                if (webDAVuserid == null || webDAVpassword == null) break;
                this.setParmValueInLocalMapWarningIfParmExists(cnl, "_http_user", webDAVuserid);
                cnl.put("_http_password", webDAVpassword);
                break;
            }
            case DAVSERVER_PACKAGE: {
                String newInstance = cnl.get("_create_new_package_instance");
                boolean createNewInstance = newInstance != null && newInstance.equalsIgnoreCase("true");
                String webDAVCollectionURL = null;
                String webDAVuserid = cnl.get("_http_user");
                String webDAVpassword = cnl.get("_http_password");
                String proxyURL = null;
                try {
                    String collURL = cnl.get("_collection_url");
                    if (collURL == null || collURL.length() == 0) {
                        throw new ExecutionException(RB.getStringResource("COM.missnCollURL.ex.txt"));
                    }
                    if (objectCache == null) {
                        throw new ExecutionException(RB.getStringResource("E2.noSmartObjUnsupp.ex.txt"));
                    }
                    ClassifierMap cm = objectCache.getClassifierMap();
                    WebDAVPackageDAVServerLocationHelper lh = new WebDAVPackageDAVServerLocationHelper(collURL, createNewInstance, (Root)cm, this._logger, webDAVuserid, webDAVpassword);
                    try {
                        lh.determineResultsLocation(this._alert == null ? null : this._alert.getName(), this._logger, this._userContext, this._eId);
                    }
                    catch (MdException e) {
                        throw new ServiceException((Throwable)e, "Exception occurred accessing WebDAV server metadata.");
                    }
                    webDAVCollectionURL = lh.getResultLocation();
                    this._webDAVCredentialsUsedForParameters = lh.getCredentials(this._logger, this._userContext);
                    proxyURL = lh.getProxyURL();
                    this._locationHelper = lh;
                }
                catch (ServiceException se) {
                    throw new SASServerException(se);
                }
                cnl.put("_collection_url", webDAVCollectionURL);
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.DAVResltLoc.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)webDAVCollectionURL);
                    this._logger.debug(msg);
                }
                if (!this._webDAVCredentialsUsedForParameters._consumerSupplied) {
                    webDAVuserid = this._webDAVCredentialsUsedForParameters._userName;
                    webDAVpassword = this._webDAVCredentialsUsedForParameters._password;
                    if (webDAVuserid != null && webDAVpassword != null) {
                        this.setParmValueInLocalMapWarningIfParmExists(cnl, "_http_user", webDAVuserid);
                        cnl.put("_http_password", webDAVpassword);
                    }
                }
                if (proxyURL == null || proxyURL.length() <= 0) break;
                this.setParmValueInLocalMapWarningIfParmExists(cnl, "_http_proxy_url", proxyURL);
            }
        }
        if (this._userContext == null) {
            valueMETAPERSON = UNKNOWN;
            valueMETAUSER = UNKNOWN;
        } else {
            valueMETAPERSON = this._userContext.getName();
            if (valueMETAPERSON == null || valueMETAPERSON.length() == 0) {
                valueMETAPERSON = UNKNOWN;
            }
            try {
                valueMETAUSER = this._userContext.getResolvedUserId();
                if (valueMETAUSER == null || valueMETAUSER.length() == 0) {
                    valueMETAUSER = UNKNOWN;
                }
            }
            catch (Exception e) {
                if (this._logger != null) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"COM.metauserVal.ex.fmt.txt", (java.lang.Object)valueMETAPERSON), (Throwable)e);
                }
                valueMETAUSER = UNKNOWN;
            }
        }
        this.setParmValueInLocalMapWarningIfParmExists(cnl, METAPERSON, valueMETAPERSON);
        this.setParmValueInLocalMapWarningIfParmExists(cnl, METAUSER, valueMETAUSER);
        cnl.put(PROGRAM, this._PROGRAMvalue);
        cnl.put(METAFOLDER, this._METAFOLDERvalue);
        String client = storedProcess.getClientName();
        if (client == null || client.length() == 0) {
            client = CLIENT_NAME;
        }
        client = client + "; ";
        String jvm = "JVM ";
        try {
            jvm = jvm + System.getProperty("java.version");
        }
        catch (SecurityException se) {
            jvm = jvm + ' ';
        }
        client = client + jvm + "; ";
        try {
            osStuff = System.getProperty("os.name");
        }
        catch (SecurityException se) {
            osStuff = " ";
        }
        osStuff = osStuff + " (";
        try {
            osStuff = osStuff + System.getProperty("os.arch");
        }
        catch (SecurityException se) {
            osStuff = osStuff + " ";
        }
        osStuff = osStuff + ") ";
        try {
            osStuff = osStuff + System.getProperty("os.version");
        }
        catch (SecurityException se) {
            osStuff = osStuff + " ";
        }
        client = client + osStuff;
        this.setParmValueInLocalMapWarningIfParmExists(cnl, CLIENT, client);
        ArrayList<String> names = new ArrayList<String>(numberOfParms);
        ArrayList<String> values = new ArrayList<String>(numberOfParms);
        for (String parmName : map.keySet()) {
            String value = (String)map.get(parmName);
            if (parmName == null) continue;
            names.add(parmName);
            values.add(value);
        }
        this._numberOfParms = names.size();
        if (this._is92workspaceServerBased) {
            for (int i = 0; i < this._numberOfParms; ++i) {
                java.lang.Object parmVal = values.get(i);
                if (!(parmVal instanceof String)) continue;
                String val = (String)parmVal;
                if (val.matches(".*[%&'\";].*")) {
                    val = val.replaceAll("%", "%nrstr(%%)");
                    val = val.replaceAll("'", "%nrstr(%')");
                    val = val.replaceAll("\"", "%nrstr(%\")");
                    val = val.replaceAll("&", "%nrstr(&)");
                    val = val.replaceAll(";", "%nrstr(;)");
                }
                val = val.replaceAll("\r\n", " ");
                val = val.replaceAll("\r", " ");
                val = val.replaceAll("\n", " ");
                values.set(i, val);
            }
        }
        this._parmsNames = names.toArray(new String[0]);
        this._parmsValues = values.toArray(new String[0]);
        this._parmsNamesForAlert = namesForAlert.toArray(new String[0]);
        this._parmsValuesForAlert = valuesForAlert.toArray(new String[0]);
        this._exceptionList = new ArrayList();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            int count = this._parmsNames.length;
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.parmLst.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)count);
            this._logger.debug(msg);
            for (int i = 0; i < count; ++i) {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.parmNV.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)this._parmsNames[i], (java.lang.Object)(this._parmsNames[i].toLowerCase().contains("password") ? "****" : this._parmsValues[i]));
                this._logger.debug(msg);
            }
        }
        try {
            StoredProcessInterface storedProcessSmartObject;
            StoredProcessInterface.SourceCodeLocation scl;
            if (objectCache != null && (scl = (storedProcessSmartObject = objectCache.getSmartObject()).getSourceCodeLocation()) == StoredProcessInterface.SourceCodeLocation.METADATA) {
                this._sourceCode = storedProcessSmartObject.getSourceCode();
            }
        }
        catch (ServiceException e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    private void setParmValueInLocalMapWarningIfParmExists(CaseNeutralLookup cnl, String name, String value) {
        String val = cnl.get(name);
        if (val != null && !val.toString().equals(value) && this._logger != null && this._logger.isEnabled(Level.WARN)) {
            if (name.toLowerCase().contains("password")) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.parmValReplcd.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)"****", (java.lang.Object)name, (java.lang.Object)"****");
                this._logger.warn(msg);
            } else {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.parmValReplcd.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)val.toString(), (java.lang.Object)name, (java.lang.Object)value);
                this._logger.warn(msg);
            }
        }
        cnl.put(name, value);
    }

    private String[] getParameterValues(String valueString) {
        ArrayList<String> values = new ArrayList<String>();
        int fromPos = 0;
        while (true) {
            int nextPos;
            String thisValue = (nextPos = valueString.indexOf(31, fromPos)) == -1 ? valueString.substring(fromPos) : valueString.substring(fromPos, nextPos);
            values.add(thisValue);
            if (nextPos == -1) break;
            fromPos = nextPos + 1;
        }
        return values.toArray(new String[0]);
    }

    @Override
    public int getSASConditionCode() {
        this.checkIfDestroyed();
        if (this._status == 7 || this._status == 1 || this._status == 2) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noCC.ex.txt"));
        }
        return this._SASCondtionCode;
    }

    @Override
    public ResultPackageInterface getResultPackage() {
        this.checkIfDestroyed();
        if (this._status == 7 || this._status == 1 || this._status == 2 || this._status == 6) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noRP.ex.txt"));
        }
        this._resultPackageAccessed = true;
        return this._resultPackage;
    }

    @Override
    public StoredProcessAlertItemInterface getStoredProcessAlert() {
        this.checkIfDestroyed();
        return this._alert;
    }

    @Override
    public String getSessionID() throws IllegalStateException {
        this.checkIfDestroyed();
        if (this._status == 7 || this._status == 1 || this._status == 2 || this._status == 6) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noSessnID.ex.txt"));
        }
        return this._sessionID;
    }

    @Override
    public boolean isSynchronous() {
        this.checkIfDestroyed();
        return this._synchronous;
    }

    @Override
    public synchronized int getStatus() {
        this.checkIfDestroyed();
        return this.realGetStatus();
    }

    private int realGetStatus() {
        return this._status;
    }

    @Override
    public ExecutionException[] getExceptions() {
        this.checkIfDestroyed();
        return this._exceptionList.toArray(new ExecutionException[0]);
    }

    @Override
    public String readSASLog(int flag, int maxLines) throws IllegalStateException, TransportException {
        int i;
        int[] lineTypeArray;
        java.lang.Object[] ltArr;
        int count;
        java.lang.Object lineTypes;
        java.lang.Object carriageControls;
        this.checkIfDestroyed();
        boolean valid = true;
        switch (this._status) {
            case 1: 
            case 7: {
                valid = false;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                valid = true;
            }
        }
        if (!valid) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noLog.ex.txt"));
        }
        if (maxLines == -1) {
            maxLines = Integer.MAX_VALUE;
        }
        StringSeqHolder logLines = new StringSeqHolder();
        if (this._is92workspaceServerBased) {
            carriageControls = new CarriageControlSeqHolder();
            lineTypes = new LineTypeSeqHolder();
            try {
                this._languageService.FlushLogLines(maxLines, carriageControls, lineTypes, logLines);
            }
            catch (Exception ex) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug("COM.genIOM.ex.txt", (Throwable)ex);
                }
                throw new TransportException((Throwable)ex, RB.getStringResource("COM.genIOM.ex.txt"));
            }
            if (logLines.value.length == 0) {
                return "";
            }
            count = logLines.value.length;
            ltArr = lineTypes.value;
            if (count != ltArr.length) {
                String text = count + " " + ltArr.length;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (java.lang.Object)text);
                this.logMessageAndThrowIllegalStateException(msg);
            }
            lineTypeArray = new int[count];
            for (i = 0; i < count; ++i) {
                int temp;
                switch (ltArr[i].value()) {
                    case 6: {
                        temp = 1;
                        break;
                    }
                    case 8: {
                        temp = 2;
                        break;
                    }
                    case 7: {
                        temp = 3;
                        break;
                    }
                    default: {
                        temp = 0;
                    }
                }
                lineTypeArray[i] = temp;
            }
        } else {
            carriageControls = new CarriageControl2SeqHolder();
            lineTypes = new LineType2SeqHolder();
            try {
                this._storedProcessContext.GetSasLog(maxLines, (CarriageControl2SeqHolder)carriageControls, (LineType2SeqHolder)lineTypes, logLines);
            }
            catch (Exception ex) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug("COM.genIOM.ex.txt", (Throwable)ex);
                }
                throw new TransportException((Throwable)ex, RB.getStringResource("COM.genIOM.ex.txt"));
            }
            if (logLines.value.length == 0) {
                return "";
            }
            count = logLines.value.length;
            ltArr = lineTypes.value;
            if (count != ltArr.length) {
                String text = count + " " + ltArr.length;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (java.lang.Object)text);
                this.logMessageAndThrowIllegalStateException(msg);
            }
            lineTypeArray = new int[count];
            for (i = 0; i < count; ++i) {
                int temp;
                switch (ltArr[i].value()) {
                    case 6: {
                        temp = 1;
                        break;
                    }
                    case 8: {
                        temp = 2;
                        break;
                    }
                    case 7: {
                        temp = 3;
                        break;
                    }
                    default: {
                        temp = 0;
                    }
                }
                lineTypeArray[i] = temp;
            }
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.logLnHdr.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)count);
            this._logger.debug(msg);
            for (int i2 = 0; i2 < count; ++i2) {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.logLn.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)i2, (java.lang.Object)lineTypeArray[i2], (java.lang.Object)logLines.value[i2]);
                this._logger.debug(msg);
            }
        }
        return LogFormatter.format(flag == 1 ? 17 : 23, lineTypeArray, logLines.value);
    }

    @Override
    public SASLog getSASListing() throws IllegalStateException, TransportException {
        return this.doGetSASListing(true, -1);
    }

    @Override
    public SASLog getSASListing(int maxLines) throws IllegalStateException, TransportException {
        if (maxLines < 1) {
            throw new IllegalArgumentException(RB.getStringResource("E2.argGrtn0.ex.txt"));
        }
        return this.doGetSASListing(false, maxLines);
    }

    private SASLog doGetSASListing(boolean all, int maxLines) throws IllegalStateException, TransportException {
        this.checkIfDestroyed();
        boolean valid = true;
        switch (this._status) {
            case 1: 
            case 7: {
                valid = false;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                valid = true;
            }
        }
        if (!valid) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.noList.ex.txt"));
        }
        SASLog sasLog = new SASLog(maxLines);
        if (all) {
            maxLines = Integer.MAX_VALUE;
        }
        StringSeqHolder logLines = new StringSeqHolder();
        ILanguageService ls = this._workspace.LanguageService();
        CarriageControlSeqHolder carriageControls = new CarriageControlSeqHolder();
        LineTypeSeqHolder lineTypes = new LineTypeSeqHolder();
        try {
            ls.FlushListLines(maxLines, carriageControls, lineTypes, logLines);
        }
        catch (Exception ex) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("COM.genIOM.ex.txt", (Throwable)ex);
            }
            throw new TransportException((Throwable)ex, RB.getStringResource("COM.genIOM.ex.txt"));
        }
        if (logLines.value.length == 0) {
            return sasLog;
        }
        sasLog.setValues(logLines.value, lineTypes.value, carriageControls.value, this._logger);
        if (this._logger != null && this._logger.isDebugEnabled()) {
            int count = sasLog.getLinesAvailable();
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.lstLnHdr.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)count);
            this._logger.debug(msg);
            String[] lines = sasLog.getLines();
            int[] lts = sasLog.getLineTypes();
            int[] ccs = sasLog.getCarriageControls();
            for (int i = 0; i < count; ++i) {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.lstLn.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)i, (java.lang.Object)lts[i], (java.lang.Object)ccs[i], (java.lang.Object)lines[i]);
                this._logger.debug(msg);
            }
        }
        return sasLog;
    }

    @Override
    public SASLog getSASLog() throws IllegalStateException, TransportException {
        return this.doGetSASLog(true, -1);
    }

    @Override
    public SASLog getSASLog(int maxLines) throws IllegalStateException, TransportException {
        if (maxLines < 1) {
            throw new IllegalArgumentException(RB.getStringResource("E2.argGrtn0.ex.txt"));
        }
        return this.doGetSASLog(false, maxLines);
    }

    private SASLog doGetSASLog(boolean all, int maxLines) throws IllegalStateException, TransportException {
        java.lang.Object lineTypes;
        java.lang.Object carriageControls;
        this.checkIfDestroyed();
        boolean valid = true;
        switch (this._status) {
            case 1: 
            case 7: {
                valid = false;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                valid = true;
            }
        }
        if (!valid) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noLog.ex.txt"));
        }
        SASLog sasLog = new SASLog(maxLines);
        if (all) {
            maxLines = Integer.MAX_VALUE;
        }
        StringSeqHolder logLines = new StringSeqHolder();
        if (this._is92workspaceServerBased) {
            carriageControls = new CarriageControlSeqHolder();
            lineTypes = new LineTypeSeqHolder();
            try {
                this._languageService.FlushLogLines(maxLines, carriageControls, lineTypes, logLines);
            }
            catch (Exception ex) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug("COM.genIOM.ex.txt", (Throwable)ex);
                }
                throw new TransportException((Throwable)ex, RB.getStringResource("COM.genIOM.ex.txt"));
            }
            if (logLines.value.length == 0) {
                return sasLog;
            }
            sasLog.setValues(logLines.value, lineTypes.value, carriageControls.value, this._logger);
        } else {
            carriageControls = new CarriageControl2SeqHolder();
            lineTypes = new LineType2SeqHolder();
            try {
                this._storedProcessContext.GetSasLog(maxLines, (CarriageControl2SeqHolder)carriageControls, (LineType2SeqHolder)lineTypes, logLines);
            }
            catch (Exception ex) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug("COM.genIOM.ex.txt", (Throwable)ex);
                }
                throw new TransportException((Throwable)ex, RB.getStringResource("COM.genIOM.ex.txt"));
            }
            if (logLines.value.length == 0) {
                return sasLog;
            }
            sasLog.setValues(logLines.value, lineTypes.value, carriageControls.value, this._logger);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            int count = sasLog.getLinesAvailable();
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.logLnHdr.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)count);
            this._logger.debug(msg);
            String[] lines = sasLog.getLines();
            int[] lineTypes2 = sasLog.getLineTypes();
            int[] carriageControls2 = sasLog.getCarriageControls();
            for (int i = 0; i < count; ++i) {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.logLn.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)i, (java.lang.Object)lineTypes2[i], (java.lang.Object)carriageControls2[i], (java.lang.Object)lines[i]);
                this._logger.debug(msg);
            }
        }
        return sasLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForCompletion() throws InterruptedException {
        java.lang.Object object = this._completionStatusLock;
        synchronized (object) {
            while (!this._completionStatusSet) {
                this._completionStatusLock.wait();
            }
        }
        return this.realGetStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForCompletion(long milliSecondTimeout) throws InterruptedException {
        java.lang.Object object = this._completionStatusLock;
        synchronized (object) {
            if (!this._completionStatusSet) {
                this._completionStatusLock.wait(milliSecondTimeout);
            }
        }
        return this.realGetStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForConnection() throws InterruptedException {
        this.checkIfDestroyed();
        java.lang.Object object = this._connectionAttemptLock;
        synchronized (object) {
            while (!this._connectionAttemptCompleted) {
                this._connectionAttemptLock.wait();
            }
        }
        return this.realGetStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForConnection(long milliSecondTimeout) throws InterruptedException {
        this.checkIfDestroyed();
        java.lang.Object object = this._connectionAttemptLock;
        synchronized (object) {
            if (!this._connectionAttemptCompleted) {
                this._connectionAttemptLock.wait(milliSecondTimeout);
            }
        }
        return this.realGetStatus();
    }

    @Override
    public synchronized void destroy() throws ConnectionFactoryException, TransportException, RemoteException {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.dstry.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
            this._logger.debug(msg);
        }
        if (this._status == 7 || this._status == 1) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.cantDstry.ex.txt"));
        }
        if (this._alreadyDestroyed) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.destryCalld.ex.txt"));
        }
        this._alreadyDestroyed = true;
        this._status = 5;
        try {
            Execution2.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.doDestroy();
    }

    private void doDestroy() throws ConnectionFactoryException, TransportException, RemoteException {
        String msg2;
        if (this._objectCache != null) {
            try {
                this._objectCache.destroy(this._logger);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        if (this._isResultPackageLifeCycleBound) {
            block30: {
                if (this._resultPackage != null) {
                    block28: {
                        try {
                            if (this._logger != null && this._logger.isDebugEnabled()) {
                                msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.closRP.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                                this._logger.debug(msg2);
                            }
                            this._resultPackage.close();
                        }
                        catch (IllegalStateException msg2) {
                        }
                        catch (Exception e) {
                            if (this._logger == null) break block28;
                            this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                        }
                    }
                    if (this._iResultPackage != null) {
                        block29: {
                            try {
                                this._iResultPackage.Close();
                            }
                            catch (Exception e) {
                                if (this._logger == null) break block29;
                                this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                            }
                        }
                        this._iResultPackage = null;
                    }
                }
                if (!this._is92workspaceServerBased && this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE && this._resultPackage != null) {
                    try {
                        if (this._logger != null && this._logger.isDebugEnabled()) {
                            msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.delTmpArc.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                            this._logger.debug(msg2);
                        }
                        this._resultPackageService.DeleteResultPackage("ARCHIVE", this._resultPackageFilePath, new String[0][0]);
                    }
                    catch (Exception e) {
                        if (this._logger == null) break block30;
                        this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                    }
                }
            }
            this._resultPackage = null;
        }
        if (!this._is92workspaceServerBased) {
            try {
                if (this._storedProcessContext != null) {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.closCtxt.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                        this._logger.debug(msg2);
                    }
                    this._storedProcessContext.Close();
                }
            }
            catch (Exception e) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                }
                throw new TransportException((Throwable)e, RB.getStringResource("COM.genIOM.ex.txt"));
            }
        }
        boolean okToCloseConnection = false;
        if (this._connectionType == Connection.OBTAINED_FROM_METADATA) {
            okToCloseConnection = true;
            if (!this._runningOnWorkspaceServer && this._sessionID != null && !this._rareDuplicateSessionIDCase) {
                okToCloseConnection = false;
                this._service._sessionMap11.decrementSPUseCount(this._sessionID);
            }
        } else if (this._connectionType == Connection.SESSIONID) {
            this._service._sessionMap11.decrementSPUseCount(this._sessionID);
        }
        if (okToCloseConnection) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"E.closCnxn.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                this._logger.debug(msg3);
            }
            this._createdConnection.close();
        }
    }

    private void checkIfDestroyed() {
        if (this._alreadyDestroyed) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.destryCalld.ex.txt"));
        }
    }

    @Override
    public java.io.InputStream getInputStream(java.lang.Object streamKey) {
        this.checkIfDestroyed();
        try {
            this.waitForConnection();
        }
        catch (InterruptedException e) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.waitIntruptd.ex.txt"));
        }
        StreamDefinition2 sd = this.getInputOutputStream(streamKey);
        if (sd == null || !sd._isInput) {
            return null;
        }
        return sd._inputStreamAdapter;
    }

    @Override
    public OutputStream getOutputStream(java.lang.Object streamKey) {
        this.checkIfDestroyed();
        try {
            this.waitForConnection();
        }
        catch (InterruptedException e) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.waitIntruptd.ex.txt"));
        }
        StreamDefinition2 sd = this.getInputOutputStream(streamKey);
        if (sd == null || sd._isInput) {
            return null;
        }
        return sd._outputStreamProxy;
    }

    private StreamDefinition2 getInputOutputStream(java.lang.Object streamKey) {
        String streamName = streamKey.toString().toLowerCase(Locale.US);
        StreamDefinition2 sd = this._streamsMap.get(streamName);
        return sd;
    }

    @Override
    public InputStreamHeaderInterface getInputStreamHeader(String streamKey) {
        this.checkIfDestroyed();
        try {
            this.waitForConnection();
        }
        catch (InterruptedException e) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.waitIntruptd.ex.txt"));
        }
        StreamDefinition2 sd = this.getInputOutputStream(streamKey);
        if (sd == null || !sd._isInput) {
            return null;
        }
        return sd._inputStream.getHeader();
    }

    @Override
    public OutputStreamHeaderInterface getOutputStreamHeader(String streamKey) {
        this.checkIfDestroyed();
        try {
            this.waitForConnection();
        }
        catch (InterruptedException e) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.waitIntruptd.ex.txt"));
        }
        StreamDefinition2 sd = this.getInputOutputStream(streamKey);
        if (sd == null || sd._isInput) {
            return null;
        }
        return sd._outputStream.getHeader();
    }

    void execute(StoredProcess2 storedProcess, boolean synchronous, ExecutionStatusListener2Interface listener) throws RemoteException, ExecutionException {
        this._status = this._connectionType == Connection.OBTAINED_FROM_METADATA_PENDING ? 7 : 1;
        this._synchronous = synchronous;
        this._listener = listener;
        if (this._createAlert) {
            this.initializeAlertItem(storedProcess, this._objectCache);
        }
        if (this._listener != null) {
            try {
                this._listener.executionStatusChanged(this);
            }
            catch (Throwable t) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (java.lang.Object)this._storedProcessName);
                    this._logger.debug(msg, t);
                }
                throw new ExecutionStatusListenerException(t);
            }
        }
        if (this._is92workspaceServerBased) {
            this.executeWorkspaceServerStoredProcess();
        } else {
            this.executeStoredProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws TransportException, RemoteException {
        this.checkIfDestroyed();
        if (this._synchronous) {
            throw new IllegalStateException(RB.getStringResource("E2.noAbort.ex.txt"));
        }
        AbortLock abortLock = this._abortLock;
        synchronized (abortLock) {
            if (this._abortLock._executionEnded) {
                return;
            }
            this._status = 6;
            this._abortLock._abortRequested = true;
            if (!this._abortLock._executionBegun) {
                return;
            }
        }
        try {
            if (this._is92workspaceServerBased) {
                this._languageService.Cancel();
            } else {
                this._storedProcessContext.Abort();
            }
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.exeAbrtd.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                this._logger.debug(msg);
            }
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e, RB.getStringResource("COM.genIOM.ex.txt"));
        }
    }

    private String formatExecutionException(Exception e) {
        StringBuffer exceptionText = new StringBuffer();
        Throwable t = e;
        while (t.getCause() != null) {
            exceptionText.append(t.toString());
            exceptionText.append('\n');
            t = t.getCause();
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        exceptionText.append(sw.toString());
        return exceptionText.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCompletion() throws RemoteException {
        if (this._createAlert) {
            try {
                this.setCompletionInfoInAlertItem();
            }
            catch (RemoteException e) {
                this.addExceptionToListAndSetStatus(new ExecutionException(RB.getStringResource("E.execerr.ex.txt"), e));
            }
        }
        if (this._listener != null) {
            try {
                this._listener.executionStatusChanged(this);
            }
            catch (Throwable t) {
                ExecutionStatusListenerException esle = new ExecutionStatusListenerException(t);
                this.addExceptionToListAndSetStatus(esle);
            }
        }
        if ((this._status == 4 || this._status == 2) && this._logger != null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeEnd.ex.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
            this._logger.error(msg);
            int numberOfExceptions = this._exceptionList.size();
            for (int i = 0; i < numberOfExceptions; ++i) {
                this._logger.error("", (Throwable)this._exceptionList.get(i));
            }
        }
        if (this._sessionLock != null) {
            this._sessionContext.unlock(this._sessionLock);
            try {
                this._sessionContext.destroy();
            }
            catch (LockingException lockingException) {
                // empty catch block
            }
        }
        java.lang.Object object = this._completionStatusLock;
        synchronized (object) {
            this._completionStatusSet = true;
            this._completionStatusLock.notifyAll();
        }
    }

    private void compute_Program(StoredProcessBaseInterface storedProcess) throws RemoteException {
        StoredProcessInterface smartObject = this._objectCache != null ? this._objectCache.getSmartObject() : null;
        this._PROGRAMvalue = "";
        this._METAFOLDERvalue = "";
        if (smartObject == null) {
            this._PROGRAMvalue = this._storedProcessFileName;
        } else {
            try {
                PathUrl pathURL = smartObject.getPathUrl();
                String absPath = pathURL.getAbsolutePath();
                int l = absPath.length();
                if (absPath.charAt(l - 1) == ')') {
                    l = absPath.lastIndexOf(40);
                    if (l != -1) {
                        this._PROGRAMvalue = absPath.substring(0, l);
                        l = this._PROGRAMvalue.lastIndexOf(47);
                        if (l != -1) {
                            this._METAFOLDERvalue = this._PROGRAMvalue.substring(0, l + 1);
                        }
                    }
                } else if (this._logger != null) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.noPROGval.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)absPath);
                    this._logger.warn(msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setResultPackageLifeCycleBound(boolean boundToLifeCycle) throws ResultsBindingException, RemoteException {
        if (boundToLifeCycle == this._isResultPackageLifeCycleBound) {
            return;
        }
        if (this._resultPackageAccessed) {
            throw new IllegalStateException(RB.getStringResource("SP2.cantChngLifCyclAftrAccess.ex.txt"));
        }
        if (boundToLifeCycle) {
            throw new IllegalStateException(RB.getStringResource("SP2.cantResetLifCycl.ex.txt"));
        }
        this._isResultPackageLifeCycleBound = boundToLifeCycle;
        if (this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE || this._result == ResultTypeDeterminer.ResultType.FILE_PACKAGE) {
            if (this._resultPackage == null) {
                throw new ResultsBindingException(RB.getStringResource("SP2.noResltPkgAvlbl.ex.txt"));
            }
            try {
                this.replaceServerResultPackageWithJVMTierCopyAndCleanup();
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (Exception e) {
                throw new ResultsBindingException(e);
            }
        }
    }

    private void replaceServerResultPackageWithJVMTierCopyAndCleanup() throws RemoteException, IllegalStateException, IOException, TransportException, IllegalArgumentException {
        ResultPackageInterface copyOfResultPackage;
        block3: {
            java.io.InputStream is = this._resultPackage.getInputStream();
            ArchiveTransport transport = new ArchiveTransport(is, this._sessionContext);
            copyOfResultPackage = transport.getResultPackage();
            try {
                this._resultPackage.close();
                this._iResultPackage.Close();
                if (this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE && !this._is92workspaceServerBased) {
                    this._resultPackageService.DeleteResultPackage("ARCHIVE", this._resultPackageFilePath, new String[0][0]);
                }
            }
            catch (Exception e) {
                if (this._logger == null) break block3;
                this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
            }
        }
        this._iResultPackage = null;
        this._resultPackage = copyOfResultPackage;
    }

    private void executeWorkspaceServerStoredProcess() throws RemoteException {
        if (this._sessionContext != null) {
            this._sessionLock = this._sessionContext.lock("com.sas.services.storedprocess");
        }
        if (this._synchronous) {
            this.doExecuteWorkspaceServerStoredProcess();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Execution2.this.doExecuteWorkspaceServerStoredProcess();
                    }
                    catch (RemoteException e) {
                        if (Execution2.this._logger != null) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (java.lang.Object)Execution2.this._storedProcessName);
                            Execution2.this._logger.error(msg, (Throwable)e);
                        }
                        e.printStackTrace();
                    }
                }
            };
            Thread t = new Thread(r);
            t.setName(Message.format((String)"{0}_{1}", (java.lang.Object)this.getClass().getName(), (java.lang.Object)t.getName()));
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.newThrd.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                this._logger.debug(msg);
            }
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteWorkspaceServerStoredProcess() throws RemoteException {
        try {
            boolean listenerExceptionOccurredInConnectionPendingCase;
            block52: {
                listenerExceptionOccurredInConnectionPendingCase = false;
                try {
                    if (this._connectionType == Connection.OBTAINED_FROM_METADATA_PENDING) {
                        this.makeConnection();
                        this._connectionType = Connection.OBTAINED_FROM_METADATA;
                        this._status = 1;
                        this.setExecutingStatusInAlertItem();
                        if (this._listener != null) {
                            try {
                                this._listener.executionStatusChanged(this);
                            }
                            catch (Throwable t) {
                                ExecutionStatusListenerException esle = new ExecutionStatusListenerException(t);
                                this._exceptionList.add(esle);
                                listenerExceptionOccurredInConnectionPendingCase = true;
                            }
                        }
                    }
                }
                finally {
                    this.signalConnectionAttempted();
                }
                this._workspace = null;
                switch (this._connectionType) {
                    case USER_SPECIFIED_SERVER: 
                    case OBTAINED_FROM_METADATA: {
                        this._workspace = (IWorkspace_1_1)this._connectionServer;
                        break;
                    }
                    default: {
                        this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.incon.ex.txt"));
                    }
                }
                this._languageService = this._workspace.LanguageService();
                this._languageServiceAsyncSettingSavedForRestorationPurposes = this._languageService.Async();
                this._languageService.Async(false);
                this.hookUpFileRefsAndTables();
                String[][] nameValuePairs = new String[this._numberOfParms][2];
                for (int i = 0; i < this._numberOfParms; ++i) {
                    nameValuePairs[i][0] = this._parmsNames[i];
                    nameValuePairs[i][1] = this._parmsValues[i];
                }
                IResultPackageHolder resultPackageHolder = null;
                boolean executeWasClean = true;
                try {
                    IStoredProcessService spsOld = this._languageService.StoredProcessService();
                    IStoredProcessService_1_1 sps = IStoredProcessService_1_1Helper.narrow((Object)spsOld);
                    if (sps == null) {
                        throw new ExecutionException(RB.getStringResource("E2.noSPS11.ex.txt"));
                    }
                    sps.Repository("file:" + this._storedProcessDirectory);
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeStrt.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)this._storedProcessFileName, (java.lang.Object)this._storedProcessDirectory);
                        this._logger.debug(msg);
                    }
                    boolean skipExecutionDueToAbort = false;
                    AbortLock abortLock = this._abortLock;
                    synchronized (abortLock) {
                        if (this._abortLock._abortRequested) {
                            skipExecutionDueToAbort = true;
                        } else {
                            this._abortLock._executionBegun = true;
                        }
                    }
                    if (skipExecutionDueToAbort) {
                        executeWasClean = false;
                    } else {
                        switch (this._result) {
                            case STATUS: 
                            case PR_PACKAGE: 
                            case DAVSERVER_PACKAGE: {
                                sps.ExecuteNameValue(this._storedProcessFileName, nameValuePairs);
                                break;
                            }
                            case TRANSIENT_PACKAGE: {
                                resultPackageHolder = new IResultPackageHolder();
                                sps.ResultPackageArchivePath("TEMPFILE");
                                sps.ExecuteNameValueWithResults(this._storedProcessFileName, nameValuePairs, resultPackageHolder);
                                break;
                            }
                            case FILE_PACKAGE: {
                                resultPackageHolder = new IResultPackageHolder();
                                sps.ExecuteNameValueWithResults(this._storedProcessFileName, nameValuePairs, resultPackageHolder);
                            }
                        }
                        abortLock = this._abortLock;
                        synchronized (abortLock) {
                            if (this._abortLock._abortRequested) {
                                executeWasClean = false;
                            } else {
                                this._abortLock._executionEnded = true;
                            }
                        }
                    }
                    if (executeWasClean && this._logger != null && this._logger.isDebugEnabled()) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeEndNoSrvrExcp.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                        this._logger.debug(msg);
                    }
                }
                catch (GenericError ge) {
                    SASServerException sse = new SASServerException(ge);
                    throw sse;
                }
                if (executeWasClean) {
                    if (this._needToReadFromTempFileRefsAfterExecution) {
                        this.getHookedUpFileRefAndTableData();
                    }
                    if (this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE || this._result == ResultTypeDeterminer.ResultType.FILE_PACKAGE || this._result == ResultTypeDeterminer.ResultType.PR_PACKAGE || this._result == ResultTypeDeterminer.ResultType.DAVSERVER_PACKAGE) {
                        if (this._logger != null && this._logger.isDebugEnabled()) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.getRP.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                            this._logger.debug(msg);
                        }
                        try {
                            if (this._result == ResultTypeDeterminer.ResultType.PR_PACKAGE || this._result == ResultTypeDeterminer.ResultType.DAVSERVER_PACKAGE) {
                                LocationHelper lh;
                                String webDAVCollectionURL = null;
                                String webDAVuserid = null;
                                String webDAVpassword = null;
                                Credentials credentials = null;
                                if (this._locationHelper instanceof WebDAVPackagePRLocationHelper) {
                                    lh = (WebDAVPackagePRLocationHelper)this._locationHelper;
                                    webDAVCollectionURL = lh.getResultLocation();
                                    credentials = ((WebDAVPackagePRLocationHelper)lh).getCredentials(this._logger);
                                } else if (this._locationHelper instanceof WebDAVPackageDAVServerLocationHelper) {
                                    lh = (WebDAVPackageDAVServerLocationHelper)this._locationHelper;
                                    webDAVCollectionURL = lh.getResultLocation();
                                    credentials = ((WebDAVPackageDAVServerLocationHelper)lh).getCredentials(this._logger, this._userContext);
                                }
                                webDAVuserid = credentials._userName;
                                webDAVpassword = credentials._password;
                                TransportFactory factory = new TransportFactory();
                                DAVTransportInterface dt = factory.getDAVTransportWithCredentials(webDAVCollectionURL, webDAVuserid, webDAVpassword, this._sessionContext);
                                this._resultPackage = dt.getResultPackage();
                                break block52;
                            }
                            TransportFactory factory = new TransportFactory();
                            this._iResultPackage = resultPackageHolder.value;
                            boolean resultPackageExists = true;
                            if (this._iResultPackage == null) {
                                resultPackageExists = false;
                            } else {
                                IResultPackage_1_2 rp = IResultPackage_1_2Helper.narrow((Object)this._iResultPackage);
                                if (rp != null) {
                                    resultPackageExists = rp.PackageExists();
                                }
                            }
                            if (resultPackageExists) {
                                RequesterTransportInterface rt = factory.getRequesterTransport(this._iResultPackage, this._sessionContext);
                                this._resultPackage = rt.getResultPackage();
                                break block52;
                            }
                            throw new ResultsBindingException(RB.getStringResource("E.noGenRP.ex.txt"));
                        }
                        catch (Exception e) {
                            ResultsBindingException rbe = e instanceof ResultsBindingException ? (ResultsBindingException)e : new ResultsBindingException(e);
                            throw rbe;
                        }
                    }
                }
            }
            if (this._status != 6) {
                this._status = listenerExceptionOccurredInConnectionPendingCase ? 4 : 3;
            }
        }
        catch (Exception e) {
            ExecutionException ee = e instanceof ExecutionException ? (ExecutionException)e : new ExecutionException(RB.getStringResource("E.execerr.ex.txt"), e);
            this.addExceptionToListAndSetStatus(ee);
        }
        if (this._languageService != null) {
            this._languageService.Async(this._languageServiceAsyncSettingSavedForRestorationPurposes);
        }
        this.notifyCompletion();
    }

    private void getHookedUpFileRefAndTableData() throws GenericError, LineTruncated, ContainsNull, ExecutionException {
        for (StreamDefinition2 sd : this._streamsMap.values()) {
            if (!sd._filerefInitialized || !sd._filerefFileIsOnClient || !sd._isInput) continue;
            if (sd._writer != null) {
                this.copyFromFileRefToWriter(sd._fileref, sd._writer, sd._originalName);
                continue;
            }
            this.copyFromFileRefToOutputStream(sd._fileref, sd._filerefOutputStream, sd._originalName);
        }
        if (this._targetTables.size() > 0) {
            for (DataTableWrapper dtw : this._targetTables.values()) {
                if (dtw._case != DataTableWrapper.Case.XML) continue;
                this.copyFromFileRefToOutputStream(dtw._fileref, dtw._outputStream, "_TARGET_" + dtw._dataTable.getParameterName());
            }
        }
    }

    private void hookUpFileRefsAndTables() throws ExecutionException, RemoteException, UserException {
        IFileService fs = null;
        if (this._streamsMap.size() != 0) {
            fs = this._workspace.FileService();
            if (fs == null) {
                throw new ExecutionException(RB.getStringResource("E2.noFS.ex.txt"));
            }
            for (String fileref : this._streamsMap.keySet()) {
                IFileref fref;
                StringHolder assignedNameHolder;
                StreamDefinition2 sd = this._streamsMap.get(fileref);
                if (!sd._filerefInitialized) continue;
                if (sd._filerefFileIsOnClient) {
                    assignedNameHolder = new StringHolder();
                    fref = fs.AssignFileref(fileref, "TEMP", "", "", assignedNameHolder);
                    if (fref == null) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.couldntAssignFileref.ex.fmt.txt", (java.lang.Object)fileref);
                        throw new ExecutionException(msg);
                    }
                    if (sd._isInput) {
                        this._needToReadFromTempFileRefsAfterExecution = true;
                        sd._fileref = fref;
                        continue;
                    }
                    if (sd._reader != null) {
                        this.copyFromReaderToFileRef(fref, sd._reader, sd._originalName);
                        continue;
                    }
                    this.copyFromInputStreamToFileRef(fref, sd._filerefInputStream, sd._originalName);
                    continue;
                }
                fref = fs.AssignFileref(fileref, sd._engine == null ? "" : sd._engine, sd._path, sd._options == null ? "" : sd._options, assignedNameHolder = new StringHolder());
                if (fref != null) continue;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.couldntAssignFilerefToPath.ex.fmt.txt", (java.lang.Object)fileref, (java.lang.Object)sd._path);
                throw new ExecutionException(msg);
            }
        }
        if (this._sourceTables.size() > 0 || this._targetTables.size() > 0) {
            String value;
            String macroName;
            DataTable dt;
            CaseNeutralLookup cnl;
            HashMap<String, String> nameValues = new HashMap<String, String>();
            for (int i = 0; i < this._numberOfParms; ++i) {
                nameValues.put(this._parmsNames[i], this._parmsValues[i]);
            }
            try {
                cnl = new CaseNeutralLookup(nameValues);
            }
            catch (ResultTypeDeterminer.InconsistencyException e2) {
                throw new ExecutionException("Consistency check.  " + e2.getLocalizedMessage());
            }
            IDataService ds = null;
            HashSet<String> librefNames = new HashSet<String>();
            if (this._sourceTables.size() > 0) {
                for (DataTableWrapper dtw : this._sourceTables.values()) {
                    dt = dtw._dataTable;
                    macroName = "_SOURCE_" + dt.getParameterName();
                    value = cnl.get(macroName);
                    if (dtw._case == null) {
                        this.doDataTableNullCase(macroName, value, dt, cnl);
                        continue;
                    }
                    if (dtw._case == DataTableWrapper.Case.LIB_MEM) {
                        this.doDataTableLibMemCase(macroName, value, dtw, cnl);
                        continue;
                    }
                    if (dtw._case != DataTableWrapper.Case.XML) continue;
                    if (fs == null) {
                        fs = this._workspace.FileService();
                    }
                    if (fs == null) {
                        throw new ExecutionException(RB.getStringResource("E2.noFS.ex.txt"));
                    }
                    if (ds == null) {
                        ds = this.getDataServiceAndLibrefNames(librefNames);
                    }
                    if (ds == null) {
                        throw new ExecutionException(RB.getStringResource("E2.noDS.ex.txt"));
                    }
                    this.doDataTableXMLCase(fs, ds, librefNames, macroName, value, dtw, cnl);
                    this.copyFromInputStreamToFileRef(dtw._fileref, dtw._inputStream, macroName);
                }
            }
            if (this._targetTables.size() > 0) {
                for (DataTableWrapper dtw : this._targetTables.values()) {
                    dt = dtw._dataTable;
                    macroName = "_TARGET_" + dt.getParameterName();
                    value = cnl.get(macroName);
                    if (dtw._case == null) {
                        this.doDataTableNullCase(macroName, value, dt, cnl);
                        continue;
                    }
                    if (dtw._case == DataTableWrapper.Case.LIB_MEM) {
                        this.doDataTableLibMemCase(macroName, value, dtw, cnl);
                        continue;
                    }
                    if (dtw._case != DataTableWrapper.Case.XML) continue;
                    if (fs == null) {
                        fs = this._workspace.FileService();
                    }
                    if (fs == null) {
                        throw new ExecutionException(RB.getStringResource("E2.noFS.ex.txt"));
                    }
                    if (ds == null) {
                        ds = this.getDataServiceAndLibrefNames(librefNames);
                    }
                    if (ds == null) {
                        throw new ExecutionException(RB.getStringResource("E2.noDS.ex.txt"));
                    }
                    this.doDataTableXMLCase(fs, ds, librefNames, macroName, value, dtw, cnl);
                    this._needToReadFromTempFileRefsAfterExecution = true;
                }
            }
            this._parmsNames = cnl._nameValues.keySet().toArray(new String[0]);
            this._parmsValues = cnl._nameValues.values().toArray(new String[0]);
            this._numberOfParms = this._parmsNames.length;
        }
    }

    private IDataService getDataServiceAndLibrefNames(HashSet<String> librefNames) throws UserException, ExecutionException {
        IDataService ds = this._workspace.DataService();
        if (ds == null) {
            throw new ExecutionException(RB.getStringResource("E2.noDS.ex.txt"));
        }
        StringSeqHolder librefNamesHolder = new StringSeqHolder();
        ds.ListLibrefs(librefNamesHolder);
        String[] names = librefNamesHolder.value;
        if (names != null) {
            for (String name : names) {
                librefNames.add(name);
            }
        }
        return ds;
    }

    private String getNextFilerefLibrefName() throws ExecutionException {
        if (this._filrefLibrefCount > 65535) {
            throw new ExecutionException(RB.getStringResource("E2.noFileref.ex.txt"));
        }
        Formatter f = new Formatter();
        f.format("%s%04X", FILEREF_LIBREF_PREFIX, this._filrefLibrefCount++);
        return f.toString();
    }

    private void doDataTableNullCase(String macroName, String value, DataTable dt, CaseNeutralLookup cnl) throws RemoteException {
        if (value == null || value.length() == 0) {
            cnl.put(macroName, dt.getParameterName());
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.dtParmNV.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)macroName, (java.lang.Object)dt.getParameterName());
                this._logger.debug(msg);
            }
        }
    }

    private String getMemberName(DataTableWrapper dtw, String macroName) throws RemoteException {
        String member;
        DataTable dt = dtw._dataTable;
        if (dtw._member != null) {
            member = dtw._member;
        } else {
            PhysicalTableInterface pti;
            try {
                pti = dt.getTemplateTable();
            }
            catch (ServiceException e) {
                this._logger.warn(Message.format((String)RB.getStringResource("E2.excepGetngTabl.fmt.txt"), (java.lang.Object)macroName), (Throwable)e);
                pti = null;
            }
            if (pti != null) {
                try {
                    member = pti.getTableName();
                }
                catch (ServiceException e) {
                    this._logger.warn(Message.format((String)RB.getStringResource("E2.excepGetngTablName.fmt.txt"), (java.lang.Object)macroName), (Throwable)e);
                    member = dt.getParameterName();
                }
            } else {
                member = dt.getParameterName();
            }
        }
        return member;
    }

    private void doDataTableLibMemCase(String macroName, String value, DataTableWrapper dtw, CaseNeutralLookup cnl) throws RemoteException {
        String oldValue = null;
        if (value != null && value.length() > 0) {
            oldValue = value;
        }
        String libref = dtw._libref != null ? dtw._libref + "." : "";
        String member = this.getMemberName(dtw, macroName);
        value = libref + member;
        if (oldValue != null && !oldValue.equalsIgnoreCase(value)) {
            this._logger.warn(Message.format((String)RB.getStringResource("E2.promptOverridden.fmt.txt"), (java.lang.Object)macroName, (java.lang.Object)oldValue, (java.lang.Object)value));
        }
        cnl.put(macroName, value);
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.dtParmNV.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)macroName, (java.lang.Object)value);
            this._logger.debug(msg);
        }
    }

    private void doDataTableXMLCase(IFileService fs, IDataService ds, HashSet<String> librefNames, String macroName, String value, DataTableWrapper dtw, CaseNeutralLookup cnl) throws ExecutionException, UserException, RemoteException {
        IFileref fref;
        StringHolder assignedNameHolder = new StringHolder();
        String filerefName = null;
        while (true) {
            if (librefNames.contains(filerefName = this.getNextFilerefLibrefName())) {
                continue;
            }
            fref = null;
            try {
                fref = fs.AssignFileref(filerefName, "TEMP", "", "", assignedNameHolder);
            }
            catch (GenericError ge) {
                boolean[] fieldInclusionMask = new boolean[4];
                fieldInclusionMask[0] = true;
                StringSeqHolder namesHolder = new StringSeqHolder();
                AssignmentContextSeqHolder acsHolder = new AssignmentContextSeqHolder();
                StringSeqHolder pathsHolder = new StringSeqHolder();
                StringSeqHolder amsHolder = new StringSeqHolder();
                fs.ListFilerefs(fieldInclusionMask, namesHolder, acsHolder, pathsHolder, amsHolder);
                HashSet<String> nameSet = new HashSet<String>();
                for (String name : namesHolder.value) {
                    nameSet.add(name.toUpperCase());
                }
                if (nameSet.contains(filerefName)) continue;
                throw ge;
            }
            if (fref == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.couldntAssignFileref.ex.fmt.txt", (java.lang.Object)filerefName);
                throw new ExecutionException(msg);
            }
            if (filerefName.equals(assignedNameHolder.value) || !librefNames.contains(filerefName = assignedNameHolder.value)) break;
        }
        ILibref libref = ds.AssignLibref(filerefName, "XML", "", dtw._xmlLibraryOptions);
        if (libref == null) {
            try {
                fs.DeassignFileref(filerefName);
            }
            catch (GenericError e) {
                this._logger.warn(Message.format((String)RB.getStringResource("E2.errDeAssgnFilref.ex.fmt.txt"), (java.lang.Object)filerefName), (Throwable)e);
            }
            throw new ExecutionException(Message.format((String)RB.getStringResource("E2.cantAssignLibref.ex.fmt.txt"), (java.lang.Object)filerefName, (java.lang.Object)dtw._xmlLibraryOptions));
        }
        String oldValue = null;
        if (value != null && value.length() > 0) {
            oldValue = value;
        }
        String member = this.getMemberName(dtw, macroName);
        value = filerefName + "." + member;
        dtw._fileref = fref;
        if (oldValue != null && !oldValue.equalsIgnoreCase(value)) {
            this._logger.warn(Message.format((String)RB.getStringResource("E2.promptOverridden.fmt.txt"), (java.lang.Object)macroName, (java.lang.Object)oldValue, (java.lang.Object)value));
        }
        cnl.put(macroName, value);
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.dtParmNV.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)macroName, (java.lang.Object)value);
            this._logger.debug(msg);
        }
    }

    private void copyFromFileRefToOutputStream(IFileref fref, OutputStream os, String nameForException) throws ExecutionException, GenericError {
        IBinaryStream binaryStream;
        try {
            binaryStream = fref.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
        }
        catch (Exception e) {
            throw new ExecutionException(Message.format((String)RB.getStringResource("E2.cantReadTableOrFilref.ex.fmt.txt"), (java.lang.Object)nameForException), e);
        }
        try {
            OctetSeqHolder osh = new OctetSeqHolder();
            while (true) {
                binaryStream.Read(4096, osh);
                byte[] bytesRead = osh.value;
                if (bytesRead.length == 0) {
                    break;
                }
                os.write(bytesRead);
            }
        }
        catch (IOException ioe) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.exeOS.ex.fmt.txt", (java.lang.Object)nameForException);
            throw new ExecutionException(msg, ioe);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.couldntCloseOS.fmt.txt", (java.lang.Object)nameForException);
                throw new ExecutionException(msg, e);
            }
            binaryStream.Close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFromFileRefToWriter(IFileref fref, Writer w, String nameForException) throws ExecutionException, GenericError {
        ITextStream textStream;
        try {
            textStream = fref.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, -27994);
        }
        catch (Exception e) {
            throw new ExecutionException(Message.format((String)RB.getStringResource("E2.cantReadTableOrFilref.ex.fmt.txt"), (java.lang.Object)nameForException), e);
        }
        BufferedWriter writer = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
        StringSeqHolder ssh = new StringSeqHolder();
        LongSeqHolder lsh = new LongSeqHolder();
        try {
            block11: while (true) {
                textStream.ReadLines(100, lsh, ssh);
                if (ssh.value.length == 0) {
                    break;
                }
                String[] stringArray = ssh.value;
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block11;
                    String line = stringArray[n2];
                    try {
                        writer.write(line);
                        writer.newLine();
                    }
                    catch (IOException ioe) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.exeWrtr.ex.fmt.txt", (java.lang.Object)nameForException);
                        throw new ExecutionException(msg, ioe);
                    }
                    ++n2;
                }
                break;
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.couldntCloseWriter.fmt.txt", (java.lang.Object)nameForException);
                throw new ExecutionException(msg, e);
            }
            textStream.Close();
        }
    }

    private void copyFromInputStreamToFileRef(IFileref fref, java.io.InputStream is, String nameForException) throws GenericError, ExecutionException {
        IBinaryStream binaryStream = fref.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer, 0, 4096)) > 0) {
                byte[] bufferToUse;
                if (n == 4096) {
                    bufferToUse = buffer;
                } else {
                    bufferToUse = new byte[n];
                    System.arraycopy(buffer, 0, bufferToUse, 0, n);
                }
                binaryStream.Write(bufferToUse);
            }
        }
        catch (IOException ioe) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.exeIS.ex.fmt.txt", (java.lang.Object)nameForException);
            throw new ExecutionException(msg, ioe);
        }
        finally {
            block14: {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (this._logger == null || !this._logger.isInfoEnabled()) break block14;
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.exeClosIS.ex.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)nameForException);
                    this._logger.info(msg);
                }
            }
            binaryStream.Close();
        }
    }

    private void copyFromReaderToFileRef(IFileref fref, Reader r, String nameForException) throws GenericError, ExecutionException {
        ITextStream textStream = fref.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, -27994);
        BufferedReader reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                textStream.Write(line);
            }
        }
        catch (Exception ioe) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.exeRdr.ex.fmt.txt", (java.lang.Object)nameForException);
            throw new SASServerException(msg, ioe);
        }
        finally {
            block11: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (this._logger == null || !this._logger.isInfoEnabled()) break block11;
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.exeClosRdr.ex.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)nameForException);
                    this._logger.info(msg);
                }
            }
            textStream.Close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractConnectionAndGetStreams(Context context) throws ExecutionException {
        boolean hadException = false;
        try {
            Object obj;
            ICacheService cs = null;
            String sessionID = null;
            switch (this._connectionType) {
                case SESSIONID: {
                    sessionID = this._connectionSessionID;
                    try {
                        this._storedProcessServer = this._service._sessionMap11.getServerIncrementingSPUseCount(sessionID, this._sessionContext);
                        this._storedProcessContext = this._storedProcessServer.CreateSTPContextFromWorkspace(sessionID);
                        if (this._storedProcessContext == null) {
                            throw new ExecutionException(RB.getStringResource("E2.noObjFromCreateSTPCtxt2.ex.txt"));
                        }
                        break;
                    }
                    catch (BadSessionID bsid) {
                        this._service._sessionMap.removeExpiredSession(sessionID);
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.sessnInvld.ex.fmt.txt", (java.lang.Object)sessionID);
                        throw new SASServerException(msg, (Throwable)((java.lang.Object)bsid));
                    }
                    catch (InternalUseException iue) {
                        if (iue._type != 1 && iue._type != 3) throw new SessionNotFoundException(sessionID);
                        throw new SessionNotAvailableException(sessionID);
                    }
                }
                case USER_SPECIFIED_SERVER: 
                case OBTAINED_FROM_METADATA: {
                    sessionID = "";
                    if (this._runningOnWorkspaceServer) {
                        this._workspace = (IWorkspace_1_1)this._connectionServer;
                        obj = this._workspace.CreateSTPContextFromWorkspace();
                        if (obj == null) {
                            throw new ExecutionException(RB.getStringResource("E2.noObjFromCreateSTPCtxt1.ex.txt"));
                        }
                        this._storedProcessContext = IStoredProcessContext2Helper.narrow(obj);
                        if (this._storedProcessContext != null) break;
                        throw new ExecutionException(RB.getStringResource("E2.noCtxtFromCreateSTPCtxt.ex.txt"));
                    }
                    this._storedProcessServer = (IStoredProcessServer_1_1)this._connectionServer;
                    this._storedProcessContext = this._storedProcessServer.CreateSTPContextFromWorkspace(sessionID);
                    if (this._storedProcessContext != null) break;
                    throw new ExecutionException(RB.getStringResource("E2.noObjFromCreateSTPCtxt2.ex.txt"));
                }
            }
            if (this._cacheServiceIsNeeded) {
                try {
                    cs = this._storedProcessContext.CacheService();
                }
                catch (Exception e) {
                    ExecutionException ee = new ExecutionException(RB.getStringResource("E.noCachSvc.ex.txt"), e);
                    throw ee;
                }
                if (cs == null) {
                    throw new ExecutionException(RB.getStringResource("E.noCachSvc.ex.txt"));
                }
            }
            if (!(this._runningOnWorkspaceServer || this._connectionType != Connection.OBTAINED_FROM_METADATA && this._connectionType != Connection.USER_SPECIFIED_SERVER)) {
                this._sessionIDWhichMayHaveToBeRemoved = this._storedProcessContext.SessionID();
                try {
                    this._service._sessionMap11.add(this._sessionIDWhichMayHaveToBeRemoved, this._sessionContext, this._storedProcessServer, this._createdConnection, this._connectionType == Connection.USER_SPECIFIED_SERVER);
                    this._addedSessionIDWhichShouldBeRemovedIfNotCreated = true;
                }
                catch (InternalUseException isse) {
                    this._rareDuplicateSessionIDCase = true;
                    this._addedSessionIDWhichShouldBeRemovedIfNotCreated = false;
                }
            }
            if (this._workspace == null) {
                obj = this._storedProcessContext.Workspace();
                if (obj == null) {
                    throw new TransportException(RB.getStringResource("E.noWrks.ex.txt"));
                }
                this._workspace = IWorkspace_1_1Helper.narrow((Object)obj);
                if (this._workspace == null) {
                    throw new TransportException(RB.getStringResource("E2.noWksFromContext2.ex.txt"));
                }
            }
            this.hookUpFileRefsAndTables();
            try {
                if (this._sourceCode != null) {
                    this._storedProcessContext.SetInputParameters("_CLIENT_", this._sourceCode, this._parmsNames, this._parmsValues);
                } else {
                    this._storedProcessContext.SetInputParameters(this._storedProcessDirectory, this._storedProcessFileName, this._parmsNames, this._parmsValues);
                }
            }
            catch (BadSessionID2 bsid) {
                this._service._sessionMap11.removeExpiredSession(sessionID);
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.sessnInvld.ex.fmt.txt", (java.lang.Object)sessionID);
                throw new SASServerException(msg, (Throwable)((java.lang.Object)bsid));
            }
            if (!this._cacheServiceIsNeeded) return;
            for (StreamDefinition2 sd : this._streamsMap.values()) {
                String msg;
                if (sd._filerefInitialized) continue;
                try {
                    if (sd._isInput) {
                        ICacheReader cr = this._storedProcessContext.CreateStreamReader(sd._normalizedName, "");
                        sd._inputStream = new InputStream(cr, cs);
                        sd._inputStreamAdapter = new InputStreamAdapter((java.io.InputStream)sd._inputStream);
                        continue;
                    }
                    ICacheWriter cw = this._storedProcessContext.CreateStreamWriter(sd._normalizedName, sd._isMultiPass ? "MULTIPASS" : "");
                    sd._outputStream = new com.sas.iom.OutputStream(cw, cs);
                    sd._outputStreamProxy = new OutputStreamProxy((OutputStream)sd._outputStream);
                    if (sd._outputStream == null) continue;
                    OutputStreamHeaderInterface hi = sd._outputStream.getHeader();
                    if (hi == null) {
                        if (this._logger == null) continue;
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"E.noOSHI.fmt.txt", (java.lang.Object)sd._normalizedName));
                        continue;
                    }
                    String contentType = sd._expectedContentType;
                    if (contentType == null || contentType.length() == 0) {
                        contentType = sd._isXMLStream ? "text/xml" : "application/unknown";
                    }
                    hi.setHeader("HTTP:Content-type", contentType);
                }
                catch (InvalidFileref ifr) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.invldStrm.ex.fmt.txt", (java.lang.Object)sd._normalizedName);
                    throw new SASServerException(msg, (Throwable)((java.lang.Object)ifr));
                }
                catch (StreamFilerefFail ifr) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noAssnFilref.ex.fmt.txt", (java.lang.Object)sd._normalizedName);
                    throw new SASServerException(msg, (Throwable)((java.lang.Object)ifr));
                    return;
                }
            }
        }
        catch (UserException ue) {
            hadException = true;
            SASServerException sse = new SASServerException(ue);
            throw sse;
        }
        catch (Exception e) {
            hadException = true;
            if (e instanceof ExecutionException) {
                throw (ExecutionException)e;
            }
            ExecutionException ee = new ExecutionException(RB.getStringResource("E.execerr.ex.txt"), e);
            throw ee;
        }
        finally {
            if (hadException && context == Context.EXCEPTION_THROWN && this._connectionType == Connection.OBTAINED_FROM_METADATA) {
                try {
                    this.doDestroy();
                    if (this._addedSessionIDWhichShouldBeRemovedIfNotCreated) {
                        this._service._sessionMap11.remove(this._sessionIDWhichMayHaveToBeRemoved);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalConnectionAttempted() {
        java.lang.Object object = this._connectionAttemptLock;
        synchronized (object) {
            this._connectionAttemptCompleted = true;
            this._connectionAttemptLock.notifyAll();
        }
    }

    private void executeStoredProcess() throws ExecutionException, RemoteException {
        if (this._connectionType != Connection.OBTAINED_FROM_METADATA_PENDING) {
            boolean enounteredException = false;
            try {
                this.extractConnectionAndGetStreams(Context.EXCEPTION_THROWN);
            }
            catch (ExecutionException ee) {
                enounteredException = true;
                this.addExceptionToListAndSetStatus(ee);
                throw ee;
            }
            finally {
                this.signalConnectionAttempted();
                if (enounteredException) {
                    this.notifyCompletion();
                }
            }
        }
        if (this._sessionContext != null) {
            this._sessionLock = this._sessionContext.lock("com.sas.services.storedprocess");
        }
        if (this._synchronous) {
            this.doExecuteStoredProcess();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Execution2.this.doExecuteStoredProcess();
                    }
                    catch (RemoteException e) {
                        if (Execution2.this._logger != null) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (java.lang.Object)Execution2.this._storedProcessName);
                            Execution2.this._logger.error(msg, (Throwable)e);
                        }
                        e.printStackTrace();
                    }
                }
            };
            Thread t = new Thread(r);
            t.setName(Message.format((String)"{0}_{1}", (java.lang.Object)this.getClass().getName(), (java.lang.Object)t.getName()));
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.newThrd.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                this._logger.debug(msg);
            }
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteStoredProcess() throws RemoteException {
        block46: {
            try {
                LocationHelper lh;
                String msg;
                boolean listenerExceptionOccurredInConnectionPendingCase = false;
                if (this._connectionType == Connection.OBTAINED_FROM_METADATA_PENDING) {
                    try {
                        this.makeConnection();
                        this._connectionType = Connection.OBTAINED_FROM_METADATA;
                        this._status = 1;
                        this.setExecutingStatusInAlertItem();
                        if (this._listener != null) {
                            try {
                                this._listener.executionStatusChanged(this);
                            }
                            catch (Throwable t) {
                                ExecutionStatusListenerException esle = new ExecutionStatusListenerException(t);
                                this._exceptionList.add(esle);
                                listenerExceptionOccurredInConnectionPendingCase = true;
                            }
                        }
                        this.extractConnectionAndGetStreams(Context.EXCEPTION_CAPTURED);
                    }
                    finally {
                        this.signalConnectionAttempted();
                    }
                }
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeStrt.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)this._storedProcessFileName, (java.lang.Object)this._storedProcessDirectory);
                    this._logger.debug(msg2);
                }
                boolean executeWasClean = true;
                StringHolder sessionIDHolder = new StringHolder();
                boolean skipExecutionDueToAbort = false;
                AbortLock abortLock = this._abortLock;
                synchronized (abortLock) {
                    if (this._abortLock._abortRequested) {
                        skipExecutionDueToAbort = true;
                    } else {
                        this._abortLock._executionBegun = true;
                    }
                }
                if (skipExecutionDueToAbort) {
                    executeWasClean = false;
                } else {
                    if (!this._runningOnWorkspaceServer && this._sessionFreedOnDestroy) {
                        this._storedProcessContext.MarkExplicitDeleteSession();
                    }
                    try {
                        this._storedProcessContext.Execute(sessionIDHolder);
                    }
                    catch (Exception e) {
                        SASServerException sse = new SASServerException(e);
                        this.addExceptionToListAndSetStatus(sse);
                        executeWasClean = false;
                    }
                    AbortLock e = this._abortLock;
                    synchronized (e) {
                        if (this._abortLock._abortRequested) {
                            executeWasClean = false;
                        } else {
                            this._abortLock._executionEnded = true;
                        }
                    }
                }
                this._webDAVCredentialsUsedForParameters = null;
                if (executeWasClean && this._logger != null && this._logger.isDebugEnabled()) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeEndNoSrvrExcp.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                    this._logger.debug(msg);
                }
                if (!this._runningOnWorkspaceServer) {
                    String sessionID = sessionIDHolder.value;
                    if (sessionID == null || sessionID.length() == 0 || this._sessionFreedOnDestroy) {
                        this._sessionID = null;
                        if (this._addedSessionIDWhichShouldBeRemovedIfNotCreated) {
                            this._service._sessionMap11.remove(this._sessionIDWhichMayHaveToBeRemoved);
                        }
                    } else {
                        this._sessionID = sessionID;
                        if (!this._rareDuplicateSessionIDCase) {
                            String timeOut = this.doGetOutputParameter("_SESSION_TIMEOUT");
                            this._service._sessionMap11.updateWithTimes(sessionID, timeOut, this._storedProcessName);
                        }
                    }
                }
                if (!executeWasClean) break block46;
                if (this._needToReadFromTempFileRefsAfterExecution) {
                    this.getHookedUpFileRefAndTableData();
                }
                this._SASCondtionCode = this._storedProcessContext.SASConditionCode();
                if (this._status != 6) {
                    this._status = listenerExceptionOccurredInConnectionPendingCase ? 4 : 3;
                }
                if (this._result != ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE && this._result != ResultTypeDeterminer.ResultType.FILE_PACKAGE && this._result != ResultTypeDeterminer.ResultType.PR_PACKAGE && this._result != ResultTypeDeterminer.ResultType.DAVSERVER_PACKAGE) break block46;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.getRP.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                    this._logger.debug(msg);
                }
                if (this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE || this._result == ResultTypeDeterminer.ResultType.FILE_PACKAGE) {
                    IUtilities utilities;
                    this._resultPackageFilePath = this.doGetOutputParameter("_ARCHIVE_FULLPATH");
                    if (this._resultPackageFilePath.length() == 0) {
                        throw new ResultsBindingException(RB.getStringResource("E.noGenRP.ex.txt"));
                    }
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        msg = Message.format((ResourceBundle)RB.getResources(), (String)(this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE ? "E.arcPthTmp.fmt.txt" : "E.arcPth.fmt.txt"), (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)this._resultPackageFilePath);
                        this._logger.debug(msg);
                    }
                    if ((utilities = this._workspace.Utilities()) == null) {
                        throw new ResultsBindingException(RB.getStringResource("E.noUtil.ex.txt"));
                    }
                    this._resultPackageService = utilities.ResultPackageService();
                    if (this._resultPackageService == null) {
                        throw new ResultsBindingException(RB.getStringResource("E.noRPS.ex.txt"));
                    }
                    this._iResultPackage = this._resultPackageService.BrowseResultPackage("ARCHIVE", this._resultPackageFilePath, new String[0][0]);
                    if (this._iResultPackage == null) {
                        String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"E.cantBind.ex.fmt.txt", (java.lang.Object)this._resultPackageFilePath);
                        throw new ResultsBindingException(msg3);
                    }
                    TransportFactory factory = new TransportFactory();
                    RequesterTransportInterface rt = factory.getRequesterTransport(this._iResultPackage, this._sessionContext);
                    this._resultPackage = rt.getResultPackage();
                    break block46;
                }
                if (this._result != ResultTypeDeterminer.ResultType.PR_PACKAGE && this._result != ResultTypeDeterminer.ResultType.DAVSERVER_PACKAGE) break block46;
                String webDAVCollectionURL = this._locationHelper.getResultLocation();
                String webDAVuserid = null;
                String webDAVpassword = null;
                Credentials credentials = null;
                if (this._locationHelper instanceof WebDAVPackagePRLocationHelper) {
                    lh = (WebDAVPackagePRLocationHelper)this._locationHelper;
                    webDAVCollectionURL = lh.getResultLocation();
                    credentials = ((WebDAVPackagePRLocationHelper)lh).getCredentials(this._logger);
                } else if (this._locationHelper instanceof WebDAVPackageDAVServerLocationHelper) {
                    lh = (WebDAVPackageDAVServerLocationHelper)this._locationHelper;
                    webDAVCollectionURL = lh.getResultLocation();
                    credentials = ((WebDAVPackageDAVServerLocationHelper)lh).getCredentials(this._logger, this._userContext);
                }
                webDAVuserid = credentials._userName;
                webDAVpassword = credentials._password;
                try {
                    TransportFactory factory = new TransportFactory();
                    DAVTransportInterface dt = factory.getDAVTransportWithCredentials(webDAVCollectionURL, webDAVuserid, webDAVpassword, this._sessionContext);
                    this._resultPackage = dt.getResultPackage();
                }
                catch (Exception e) {
                    ResultsBindingException rbe = new ResultsBindingException(e);
                    throw rbe;
                }
            }
            catch (Exception e) {
                ExecutionException ee = e instanceof ExecutionException ? (ExecutionException)e : new ExecutionException(RB.getStringResource("E.execerr.ex.txt"), e);
                this.addExceptionToListAndSetStatus(ee);
            }
        }
        this.notifyCompletion();
    }

    private String doGetOutputParameter(String name) throws TransportException {
        StringSeqHolder stringSeqHolder = new StringSeqHolder();
        String[] names = new String[]{name};
        try {
            this._storedProcessContext.GetOutputParameters(names, stringSeqHolder);
        }
        catch (Exception e) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("COM.genIOM.ex.txt", (Throwable)e);
            }
            throw new TransportException((Throwable)e, RB.getStringResource("COM.genIOM.ex.txt"));
        }
        return stringSeqHolder.value[0];
    }

    private void doGetOutputParameters() throws TransportException {
        int i;
        StringSeqHolder stringSeqHolder = new StringSeqHolder();
        int count = this._outputParms.size();
        String[] names = new String[count];
        for (i = 0; i < count; ++i) {
            names[i] = this._outputParms.get(i).getName();
        }
        try {
            this._storedProcessContext.GetOutputParameters(names, stringSeqHolder);
        }
        catch (Exception e) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug("COM.genIOM.ex.txt", (Throwable)e);
            }
            throw new TransportException((Throwable)e, RB.getStringResource("COM.genIOM.ex.txt"));
        }
        for (i = 0; i < count; ++i) {
            OutputParameter op = (OutputParameter)this._outputParms.get(i);
            String value = stringSeqHolder.value[i];
            op.setValue(value);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this._alreadyDestroyed) {
                this.doDestroy();
            }
        }
        finally {
            super.finalize();
        }
    }

    private java.lang.Object setConnection(java.lang.Object connection) {
        java.lang.Object retConnection;
        if (connection instanceof ConnectionInterface) {
            Object obj = ((ConnectionInterface)connection).getObject();
            retConnection = this.setConnectionFromCorbaObj(obj);
        } else if (connection instanceof IWorkspace_1_1) {
            this._runningOnWorkspaceServer = true;
            retConnection = connection;
        } else if (connection instanceof IStoredProcessServer_1_1) {
            this._runningOnWorkspaceServer = false;
            retConnection = connection;
        } else if (connection instanceof IWorkspace) {
            IWorkspace ws = (IWorkspace)connection;
            IWorkspace_1_1 ws11 = IWorkspace_1_1Helper.narrow((Object)ws);
            if (ws11 == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.oldSrvr.ex.fmt.txt", (java.lang.Object)"IWorkspace_1_1");
                this.logMessageAndThrowIllegalStateException(msg);
            }
            this._runningOnWorkspaceServer = true;
            retConnection = ws11;
        } else if (connection instanceof IStoredProcessServer) {
            IStoredProcessServer sps = (IStoredProcessServer)connection;
            IStoredProcessServer_1_1 sps11 = IStoredProcessServer_1_1Helper.narrow(sps);
            if (sps11 == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.oldSrvr.ex.fmt.txt", (java.lang.Object)"IStoredProcessServer_1_1");
                this.logMessageAndThrowIllegalStateException(msg);
            }
            this._runningOnWorkspaceServer = false;
            retConnection = sps11;
        } else if (connection instanceof Object) {
            Object obj = (Object)connection;
            retConnection = this.setConnectionFromCorbaObj(obj);
        } else {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.invConn.ex.txt"));
            retConnection = null;
        }
        return retConnection;
    }

    private java.lang.Object setConnectionFromCorbaObj(Object obj) {
        java.lang.Object retConnection = null;
        retConnection = IWorkspace_1_1Helper.narrow((Object)obj);
        if (retConnection == null) {
            retConnection = IStoredProcessServer_1_1Helper.narrow(obj);
            this._runningOnWorkspaceServer = false;
        } else {
            this._runningOnWorkspaceServer = true;
        }
        if (retConnection == null) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.invConn.ex.txt"));
        }
        return retConnection;
    }

    private void addExceptionToListAndSetStatus(ExecutionException ee) {
        this._exceptionList.add(ee);
        if (ee instanceof SASServerException) {
            this._status = 2;
        } else if (this._status != 2) {
            this._status = 4;
        }
    }

    private void findPersonalRepository() throws RemoteException, ExecutionException {
        String msg;
        if (this._personalRepository != null) {
            return;
        }
        ProfileInterface po2 = this._userContext.getProfile();
        if (po2 == null) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noProf.ex.fmt.txt", (java.lang.Object)this._userContext.getName());
            this.logMessageAndThrowIllegalStateException(msg);
        }
        if (!(po2 instanceof GlobalProfileInterface)) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.profNotGlbl.ex.fmt.txt", (java.lang.Object)po2.getClass().getName());
            this.logMessageAndThrowIllegalStateException(msg);
        }
        try {
            this._personalRepository = ((GlobalProfileInterface)po2).getPersonalRepository();
        }
        catch (ServiceException se) {
            throw new ExecutionException(RB.getStringResource("COM.prAcc.ex.txt"), se);
        }
        if (this._personalRepository == null) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noPRfromGP.ex.fmt.txt", (java.lang.Object)this._userContext.getName());
            this.logMessageAndThrowIllegalStateException(msg);
        }
    }

    private void createAlertItem() throws ExecutionException, RemoteException {
        try {
            this.findPersonalRepository();
            FolderInterface myInbox = this._personalRepository.getApplicationManager(1);
            if (myInbox == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noInbox.ex.fmt.txt", (java.lang.Object)MyInbox.applicationExtension, (java.lang.Object)this._userContext.getName());
                this.logMessageAndThrowIllegalStateException(msg);
            }
            this._alert = (StoredProcessAlertItemInterface)this.createNewItem(null, "", "storedprocessalert", myInbox);
        }
        catch (ServiceException se) {
            throw new AlertProcessingException(se);
        }
    }

    private void initializeAlertItem(StoredProcessBaseInterface storedProcess, ObjectCache objectCache) throws ExecutionException, RemoteException {
        try {
            this._alertEvent = new AlertEvent();
            this._alertEvent.initialize(storedProcess, objectCache);
            String eventString = this._alertEvent.serialize();
            this._alert.setEventDocumentFromString(eventString);
            this._alert.update();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.alertCrtd.fmt.txt", (java.lang.Object)this._alert.getName(), (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                this._logger.debug(msg);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new AlertProcessingException(pce);
        }
        catch (ServiceException se) {
            throw new AlertProcessingException(se);
        }
    }

    private void setExecutingStatusInAlertItem() throws RemoteException {
        if (this._personalRepository == null) {
            return;
        }
        this._alertEvent.updateStatus();
        String eventString = this._alertEvent.serialize();
        this._alert.setEventDocumentFromString(eventString);
        try {
            this._alert.update();
        }
        catch (Exception e) {
            AlertProcessingException ape = new AlertProcessingException(e);
            this.addExceptionToListAndSetStatus(ape);
        }
    }

    private void setCompletionInfoInAlertItem() throws RemoteException {
        if (this._personalRepository == null) {
            return;
        }
        try {
            if (this._status == 3 && (this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE || this._result == ResultTypeDeterminer.ResultType.FILE_PACKAGE || this._result == ResultTypeDeterminer.ResultType.DAVSERVER_PACKAGE || this._result == ResultTypeDeterminer.ResultType.PR_PACKAGE)) {
                PackageInterface pi = null;
                EventDataInterface edi = null;
                boolean canConnect = false;
                if (this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE || this._result == ResultTypeDeterminer.ResultType.FILE_PACKAGE) {
                    FolderInterface myDocuments = this._personalRepository.getApplicationManager(2);
                    DavBinaryPackageInterface dbp = (DavBinaryPackageInterface)this.createNewItem(this._alert.getName(), ".spk", "binarypackage", myDocuments);
                    ResultPackageInterface rpi = this.getResultPackage();
                    java.io.InputStream is = rpi.getInputStream();
                    edi = dbp.publish(rpi, is);
                    is.close();
                    pi = dbp;
                    canConnect = true;
                } else if (this._result == ResultTypeDeterminer.ResultType.DAVSERVER_PACKAGE || this._result == ResultTypeDeterminer.ResultType.PR_PACKAGE) {
                    ResultPackageInterface rpi = this.getResultPackage();
                    edi = rpi.getEventData();
                    if (this._locationHelper instanceof WebDAVPackagePRLocationHelper) {
                        WebDAVPackagePRLocationHelper lh = (WebDAVPackagePRLocationHelper)this._locationHelper;
                        pi = lh.getSmartObject();
                        canConnect = true;
                    } else if (this._locationHelper instanceof WebDAVPackageDAVServerLocationHelper) {
                        WebDAVPackageDAVServerLocationHelper lh = (WebDAVPackageDAVServerLocationHelper)this._locationHelper;
                        String url = lh.getResultLocation();
                        InformationServiceInterface is = this.discoverInformationService();
                        if (is == null) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noInfoSvc.ex.fmt.txt", (java.lang.Object)this._storedProcessName);
                            AlertProcessingException ape = new AlertProcessingException(msg);
                            this.addExceptionToListAndSetStatus(ape);
                        } else {
                            String domain = lh.getDomain(this._logger);
                            MetadataInterface mi = is.fetchEntityByUrl(this._userContext, url, domain);
                            if (mi instanceof PackageInterface) {
                                pi = (PackageInterface)mi;
                                canConnect = true;
                            } else {
                                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noEntityKey.ex.fmt.txt", (java.lang.Object)url, (java.lang.Object)domain, (java.lang.Object)this._userContext.getName());
                                AlertProcessingException ape = new AlertProcessingException(msg);
                                this.addExceptionToListAndSetStatus(ape);
                            }
                        }
                    }
                }
                if (canConnect) {
                    this._alertEvent.setPackageEvent(edi.getBodyAsString(), pi.getEntityKey());
                }
            }
        }
        catch (Exception e) {
            AlertProcessingException ape = new AlertProcessingException(e);
            this.addExceptionToListAndSetStatus(ape);
        }
        this._alertEvent.updateStatusDescriptionEndTimeExceptions();
        String eventString = this._alertEvent.serialize();
        this._alert.setEventDocumentFromString(eventString);
        try {
            this._alert.update();
        }
        catch (Exception e) {
            AlertProcessingException ape = new AlertProcessingException(e);
            this.addExceptionToListAndSetStatus(ape);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.alertUpdtd.fmt.txt", (java.lang.Object)this._alert.getName(), (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
            this._logger.debug(msg);
        }
    }

    private java.lang.Object createNewItem(String suggestedName, final String extension, final String metadataType, final FolderInterface folder) throws ServiceException, RemoteException {
        if (extension == null) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.incon.ex.txt"));
        }
        UniqueNameGenerator.Callback callback = new UniqueNameGenerator.Callback(){

            @Override
            public java.lang.Object isUnique(String leafName) throws Exception {
                String nameToTry = leafName + extension;
                try {
                    return folder.addNewItem(nameToTry, metadataType);
                }
                catch (ServiceException se) {
                    if (ChainedException.chainContains((Throwable)se, ItemAlreadyExistsException.class)) {
                        return null;
                    }
                    throw se;
                }
            }

            @Override
            public String metadataTypeForErrorMessage() {
                return "collection";
            }

            @Override
            public String repositoryForErrorMessage() {
                String s;
                try {
                    s = folder.getEntityKey();
                }
                catch (Exception e) {
                    s = e.getMessage();
                }
                return s;
            }
        };
        try {
            return UniqueNameGenerator.find(suggestedName, 100, true, callback, this._logger, this._eId);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("COM.noUniq.ex.txt"));
        }
    }

    private InformationServiceInterface discoverInformationService() {
        InformationServiceInterface is;
        try {
            is = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        }
        catch (Throwable t) {
            is = null;
        }
        return is;
    }

    @Override
    public List<OutputParameterInterface> getOutputParameters() throws TransportException, RemoteException {
        this.checkIfDestroyed();
        if (this._status == 7 || this._status == 1 || this._status == 2) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noOP.ex.txt"));
        }
        if (this._is92workspaceServerBased) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.noOPonWKS.ex.txt"));
        }
        if (!this._outputParmValuesAvailable) {
            this.doGetOutputParameters();
            this._outputParmValuesAvailable = true;
        }
        return this._outputParms;
    }

    @Override
    public OutputParameterInterface getOutputParameter(String name) throws TransportException, RemoteException {
        OutputParameterInterface op2;
        this.checkIfDestroyed();
        if (this._status == 7 || this._status == 1 || this._status == 2) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noOP.ex.txt"));
        }
        if (this._is92workspaceServerBased) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E2.noOPonWKS.ex.txt"));
        }
        if (!this._outputParmValuesAvailable) {
            this.getOutputParameters();
        }
        for (OutputParameterInterface op2 : this._outputParms) {
            if (!op2.getName().equalsIgnoreCase(name)) continue;
            return op2;
        }
        String value = this.doGetOutputParameter(name);
        if (value.length() == 0) {
            return null;
        }
        op2 = new OutputParameter(name, "String");
        ((OutputParameter)op2).setValue(value);
        return op2;
    }

    @SASScope
    private class AlertEvent
    extends Event {
        private static final String NS = "http://www.sas.com/xml/namespace/services.alerts.sp-1.1";
        private static final String NS_COLON = "http://www.sas.com/xml/namespace/services.alerts.sp-1.1:";
        private static final String NS_PREFIX_BARE = "sas-alerts-sp";
        private static final String NS_PREFIXX = "sas-alerts-sp:";
        private static final String TAG_SP_NAME = "StoredProcessName";
        private static final String TAG_STATUS = "Status";
        private static final String TAG_RESULT_TYPE = "ResultType";
        private static final String TAG_VERSION = "Version";
        private static final String E_ROOT_NAME = "sas-alerts-sp:StoredProcessAlert";
        private static final String A_VERSION = "sas-alerts-sp:version";
        private static final String A_NAME = "sas-alerts-sp:name";
        private static final String A_START_TIME = "sas-alerts-sp:startTime";
        private static final String A_END_TIME = "sas-alerts-sp:endTime";
        private static final String E_ALERT_ENTITY_KEY = "sas-alerts-sp:AlertEntityKey";
        private static final String E_DESCRIPTION = "sas-alerts-sp:Description";
        private static final String E_SP_NAME = "sas-alerts-sp:StoredProcessName";
        private static final String E_SP_DESCRIPTION = "sas-alerts-sp:StoredProcessDescription";
        private static final String E_STATUS = "sas-alerts-sp:Status";
        private static final String E_RESULT_TYPE = "sas-alerts-sp:ResultType";
        private static final String E_SP_ENTITY_KEY = "sas-alerts-sp:StoredProcessEntityKey";
        private static final String E_SP_PATH = "sas-alerts-sp:StoredProcessPath";
        private static final String E_SP_PARAMETERS = "sas-alerts-sp:StoredProcessParameters";
        private static final String E_PARAMETER = "sas-alerts-sp:Parameter";
        private static final String E_PARM_NAME = "sas-alerts-sp:ParmName";
        private static final String E_PARM_VALUES = "sas-alerts-sp:ParmValues";
        private static final String E_PARM_VALUE = "sas-alerts-sp:ParmValue";
        private static final String E_PACKAGE = "sas-alerts-sp:Package";
        private static final String E_PACKAGE_ENTITY_KEY = "sas-alerts-sp:PackageEntityKey";
        private static final String E_EXCEPTIONS = "sas-alerts-sp:ExecutionExceptions";
        private static final String E_EXCEPTION = "sas-alerts-sp:Exception";
        private static final String VERSION_NUMBER = "2.0";
        private Element _root;
        private Text _description;
        private Text _statusText;
        private Element _package;
        private Element _exceptions;
        private Element _packageEntityKey;
        private Document _document;
        private Map<String, String> _propertyMap;

        AlertEvent() {
            super("com.sas.services.storedprocess.ExecutionStatusEvent");
            this._propertyMap = new HashMap<String, String>();
        }

        void setPackageEvent(String event, String packageURL) {
            Text text = this._document.createTextNode(packageURL);
            this._packageEntityKey.appendChild(text);
            Document doc = XMLUtil.convertStringToDocument((String)event);
            Element root = doc.getDocumentElement();
            this._package.appendChild(this._document.importNode(root, true));
        }

        void initialize(StoredProcessBaseInterface storedProcess, ObjectCache objectCache) throws ParserConfigurationException, ServiceException, RemoteException {
            PathUrl pathURL;
            StoredProcessInterface smartObject = objectCache == null ? null : objectCache.getSmartObject();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._document = builder.newDocument();
            this._root = this._document.createElementNS(NS, E_ROOT_NAME);
            this._document.appendChild(this._root);
            String statusStr = Integer.toString(Execution2.this._status);
            String resultTypeStr = Integer.toString(Execution2.this._resultTypeForAlert);
            this._root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sas-alerts-sp", NS);
            this._root.setAttributeNS(NS, A_VERSION, VERSION_NUMBER);
            this._root.setAttributeNS(NS, A_NAME, Execution2.this._alert.getName());
            this._root.setAttributeNS(NS, A_START_TIME, this.getFormattedTime(new Date()));
            this._root.setAttributeNS(NS, A_END_TIME, "");
            Element e = this._document.createElementNS(NS, E_ALERT_ENTITY_KEY);
            e.appendChild(this._document.createTextNode(Execution2.this._alert.getEntityKey()));
            this._root.appendChild(e);
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.alertDescStrt.fmt.txt", (java.lang.Object)Execution2.this._storedProcessName);
            e = this._document.createElementNS(NS, E_DESCRIPTION);
            this._description = this._document.createTextNode(msg);
            e.appendChild(this._description);
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_SP_NAME);
            e.appendChild(this._document.createTextNode(Execution2.this._storedProcessName));
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_SP_DESCRIPTION);
            e.appendChild(this._document.createTextNode(storedProcess.getDescription()));
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_STATUS);
            this._statusText = this._document.createTextNode(statusStr);
            e.appendChild(this._statusText);
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_RESULT_TYPE);
            e.appendChild(this._document.createTextNode(resultTypeStr));
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_SP_ENTITY_KEY);
            e.appendChild(this._document.createTextNode(smartObject == null ? "" : smartObject.getEntityKey()));
            this._root.appendChild(e);
            PathUrl pathUrl = pathURL = smartObject == null ? null : smartObject.getPathUrl();
            if (pathURL != null) {
                e = this._document.createElementNS(NS, E_SP_PATH);
                e.appendChild(this._document.createTextNode(pathURL.toString()));
                this._root.appendChild(e);
            }
            e = this._document.createElementNS(NS, E_SP_PARAMETERS);
            this._root.appendChild(e);
            for (int i = 0; i < Execution2.this._parmsNamesForAlert.length; ++i) {
                Element parm = this._document.createElementNS(NS, E_PARAMETER);
                e.appendChild(parm);
                Element parmName = this._document.createElementNS(NS, E_PARM_NAME);
                parmName.appendChild(this._document.createTextNode(Execution2.this._parmsNamesForAlert[i]));
                parm.appendChild(parmName);
                java.lang.Object value = Execution2.this._parmsValuesForAlert[i];
                if (value instanceof String && ((String)value).indexOf(31) != -1) {
                    Element parmValues = this._document.createElementNS(NS, E_PARM_VALUES);
                    parm.appendChild(parmValues);
                    String[] valueArr = Execution2.this.getParameterValues((String)value);
                    int numberForThisEntry = valueArr.length;
                    for (int j = 0; j < numberForThisEntry; ++j) {
                        Element parmValue = this._document.createElementNS(NS, E_PARM_VALUE);
                        parmValue.appendChild(this._document.createTextNode(valueArr[j]));
                        parmValues.appendChild(parmValue);
                    }
                    continue;
                }
                Element parmValue = this._document.createElementNS(NS, E_PARM_VALUE);
                parmValue.appendChild(this._document.createTextNode(value.toString()));
                parm.appendChild(parmValue);
            }
            if (Execution2.this._result == ResultTypeDeterminer.ResultType.TRANSIENT_PACKAGE || Execution2.this._result == ResultTypeDeterminer.ResultType.FILE_PACKAGE || Execution2.this._result == ResultTypeDeterminer.ResultType.DAVSERVER_PACKAGE || Execution2.this._result == ResultTypeDeterminer.ResultType.PR_PACKAGE) {
                this._package = this._document.createElementNS(NS, E_PACKAGE);
                this._packageEntityKey = this._document.createElementNS(NS, E_PACKAGE_ENTITY_KEY);
                this._package.appendChild(this._packageEntityKey);
                this._root.appendChild(this._package);
            }
            this._exceptions = this._document.createElementNS(NS, E_EXCEPTIONS);
            this._root.appendChild(this._exceptions);
            this._document.normalize();
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:Version", VERSION_NUMBER);
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:StoredProcessName", Execution2.this._storedProcessName);
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:Status", statusStr);
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:ResultType", resultTypeStr);
            this.setProperties(this._propertyMap);
            this.setBody(this._root);
        }

        void updateStatus() {
            this.setExecutionStatus();
            this.setProperties(this._propertyMap);
        }

        void updateStatusDescriptionEndTimeExceptions() {
            this.setExecutionStatus();
            Date endTime = new Date();
            this.setCompletionDescription(endTime);
            this.setEndTime(endTime);
            this.setProperties(this._propertyMap);
            if (Execution2.this._status == 2 || Execution2.this._status == 4) {
                int numberOfExceptions = Execution2.this._exceptionList.size();
                for (int i = 0; i < numberOfExceptions; ++i) {
                    String s = Execution2.this.formatExecutionException((Exception)Execution2.this._exceptionList.get(i));
                    Element exception = this._document.createElementNS(NS, E_EXCEPTION);
                    Text text = this._document.createTextNode(s);
                    exception.appendChild(text);
                    this._exceptions.appendChild(exception);
                }
            }
        }

        private void setExecutionStatus() {
            this._statusText.setData(Integer.toString(Execution2.this._status));
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:Status", Integer.toString(Execution2.this._status));
        }

        private void setCompletionDescription(Date endTime) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.alertDescEnd.fmt.txt", (java.lang.Object)Execution2.this._storedProcessName, (java.lang.Object)this.getFormattedTime(endTime));
            this._description.setData(msg);
        }

        private void setEndTime(Date endTime) {
            this._root.setAttributeNS(NS, A_END_TIME, this.getFormattedTime(endTime));
        }

        private String getFormattedTime(Date time) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            return simpleDateFormat.format(time);
        }
    }

    private static enum Context {
        EXCEPTION_THROWN,
        EXCEPTION_CAPTURED;

    }

    @SASScope
    private static enum Connection {
        SESSIONID,
        USER_SPECIFIED_SERVER,
        OBTAINED_FROM_METADATA,
        OBTAINED_FROM_METADATA_PENDING;

    }

    @SASScope
    private static class AbortLock {
        volatile boolean _executionBegun;
        volatile boolean _executionEnded;
        volatile boolean _abortRequested;

        private AbortLock() {
        }
    }
}

