/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.WorkTable;
import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.SasFormatUtil;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.MessageHandler;
import com.sas.query.wa.WADataSourceLibrefContainer;
import com.sas.query.wa.WAdminDataSourceTable;
import com.sas.query.wa.WAdminSqlLogic;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.Serializable;
import java.rmi.RemoteException;

public class WAdminDataSource
extends DataSource
implements Serializable {
    protected DataSourceContainerList m_librefList;
    protected transient SqlProperties m_properties;
    protected ServerContext m_Server;
    private WAdminResource bundle = WAdminResource.getBundle(WAdminDataSource.class);

    public WAdminDataSource() throws QueryException {
        super(new MessageHandler());
        this.m_librefList = new DataSourceContainerList();
        this.m_properties = new SqlProperties((DataSource)this);
        this.m_databaseProductName = "";
    }

    public void close() {
        this.m_librefList = null;
        this.m_properties = null;
    }

    public void initialize() {
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public DataSourceContainer getParent() {
        return null;
    }

    public String getName() {
        return this.bundle.getString("WAdminDataSource.MetadataName.txt");
    }

    public SqlLogic getSqlLogic(Query query) {
        if (this.m_sqlLogicQuery == null) {
            this.m_sqlLogicQuery = new WAdminSqlLogic(query, this.m_passwordList);
        }
        this.m_sqlLogicQuery.setQuery(query);
        return this.m_sqlLogicQuery;
    }

    public SqlProperties getProperties() {
        return this.m_properties;
    }

    public void setServer(ServerContext iServer) {
        this.m_Server = iServer;
    }

    public ServerContext getServer() {
        return this.m_Server;
    }

    public void execute(String executeStr) {
    }

    public DataSourceTable getTable(DataTable wTable) {
        try {
            String tblFQID = wTable.getFQID();
            String libref = this._getLibref(wTable);
            String tbl2FQID = "";
            DataSourceContainerList children = this.getItems();
            for (int index = 0; index < children.size(); ++index) {
                DataTable table2;
                DataSourceContainer child = children.elementAt(index);
                if (libref.length() > 0) {
                    if (!child.getName().equalsIgnoreCase(libref)) continue;
                    DataSourceContainerList tableList = child.getItems();
                    for (int tableIndex = 0; tableIndex < tableList.size(); ++tableIndex) {
                        DataSourceContainer dsc = tableList.elementAt(tableIndex);
                        if (!(dsc instanceof DataSourceTable) || tblFQID.compareToIgnoreCase(tbl2FQID = (table2 = (DataTable)((DataSourceTable)dsc).getUnderlyingTable()).getFQID()) != 0) continue;
                        return (DataSourceTable)dsc;
                    }
                    continue;
                }
                if (!(child instanceof DataSourceTable) || tblFQID.compareToIgnoreCase(tbl2FQID = (table2 = (DataTable)((DataSourceTable)child).getUnderlyingTable()).getFQID()) != 0) continue;
                return (DataSourceTable)child;
            }
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public DataSourceTable getTable(String strQualifiedTableName) {
        int pos = strQualifiedTableName.lastIndexOf(".");
        if (pos == -1) {
            DataSourceContainerList children = this.getItems();
            for (int index = 0; index < children.size(); ++index) {
                DataSourceContainer child = children.elementAt(index);
                if (!(child instanceof DataSourceTable) || !child.getName().equalsIgnoreCase(strQualifiedTableName)) continue;
                return (DataSourceTable)child;
            }
            return null;
        }
        try {
            DataSourceContainerList children = this.getItems();
            for (int index = 0; index < children.size(); ++index) {
                DataSourceContainer child = children.elementAt(index);
                if (!child.getName().equalsIgnoreCase(strQualifiedTableName.substring(0, pos))) continue;
                DataSourceContainerList tableList = child.getItems();
                for (int tableIndex = 0; tableIndex < tableList.size(); ++tableIndex) {
                    DataSourceContainer table = tableList.elementAt(tableIndex);
                    if (!(table instanceof DataSourceTable) || !table.getName().equalsIgnoreCase(strQualifiedTableName.substring(pos + 1))) continue;
                    return (DataSourceTable)table;
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean getHasMultipleLayers() {
        return true;
    }

    public int getItemCount() {
        return this.m_librefList.size();
    }

    public String[] getItemNames() {
        String[] tableList = new String[this.m_librefList.size()];
        for (int index = 0; index < this.m_librefList.size(); ++index) {
            tableList[index] = this.m_librefList.elementAt(index).getName();
        }
        return tableList;
    }

    public DataSourceContainerList getItems() {
        return this.m_librefList;
    }

    public void addTable(DataTable wTable) {
        WADataSourceLibrefContainer wadsc = null;
        String libref = this._getLibref(wTable);
        if (libref.length() > 0) {
            for (int i = 0; i < this.m_librefList.size() && wadsc == null; ++i) {
                DataSourceContainer dsc = this.m_librefList.elementAt(i);
                if (!libref.equals(dsc.getName())) continue;
                wadsc = (WADataSourceLibrefContainer)dsc;
            }
            if (wadsc == null) {
                wadsc = new WADataSourceLibrefContainer(libref, (DataSourceContainer)this);
                this.m_librefList.addElement((DataSourceContainer)wadsc);
            }
            wadsc.m_tables.addElement((DataSourceContainer)new WAdminDataSourceTable(wadsc, wTable));
        }
    }

    public static int mapSasToSqlType(String strType, String strFormat) {
        int retType = 0;
        retType = strType.equalsIgnoreCase("N") ? SasFormatUtil.getNumericSqlType((String)strFormat) : (strType.equalsIgnoreCase("C") ? 1 : 1111);
        return retType;
    }

    protected String _getLibref(DataTable table) {
        String libref = "";
        try {
            RelationalSchema lib = table.getTablePackage();
            if (lib instanceof SASLibrary) {
                SASLibrary tempLib = LibraryUtil.getClientLibrary((SASLibrary)((SASLibrary)lib), (ServerContext)this.m_Server);
                libref = tempLib.getLibref();
            } else if (lib instanceof DatabaseSchema) {
                AssociationList list = ((DatabaseSchema)lib).getUsedByPackages();
                if (list.size() > 0) {
                    SASLibrary slib = (SASLibrary)list.get(0);
                    slib = LibraryUtil.getClientLibrary((SASLibrary)slib, (ServerContext)this.m_Server);
                    libref = slib.getLibref();
                }
            } else {
                libref = "WORK";
            }
        }
        catch (Exception e) {
            System.err.println("Error getting libref: " + e.getMessage());
            e.printStackTrace();
        }
        return libref;
    }

    protected String _getTableName(DataTable table) {
        String name = "";
        try {
            name = table instanceof PhysicalTable ? ((PhysicalTable)table).getSASTableName() : table.getTableName();
            if (name.length() == 0 && table instanceof WorkTable) {
                name = table.getFQID().replace('.', '_');
                name = name.replace('$', 'A');
            }
        }
        catch (Exception e) {
            System.err.println("Error getting table name: " + e.getMessage());
            e.printStackTrace();
        }
        return name;
    }
}

