/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.Operator;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnList;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.Join;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.ParenExpression;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.Parser;
import com.sas.query.visuals.ClueView;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.ExpressionEditDialog;
import com.sas.query.visuals.PopMenuCheckBoxItem;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.WindowUtil;
import com.sas.query.wa.AdvancedJoinPropertyView;
import com.sas.query.wa.QueryStandardDialog;
import com.sas.query.wa.WAQuery;
import com.sas.query.wa.WATablesAndRelsTableView;
import com.sas.query.wa.WAdminSqlLogic;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WATablesAndRelsView
extends JLayeredPane
implements Scrollable,
ModelChangeListener,
PropertyChangeConstants {
    public static final String DATA_CHANGED_PROPERTY = "DataChanged";
    protected boolean m_bDataChanged = false;
    protected Query m_query;
    protected JScrollPane m_scrollPane;
    protected int m_ascent = 0;
    protected int m_lineHeight = 0;
    protected Vector m_views = new Vector();
    protected boolean m_bHasDragged = false;
    protected boolean m_joinHasDrawn = false;
    protected boolean m_addDataItem = false;
    protected WATablesAndRelsTableView m_selectedTable = null;
    protected JoinRelationship m_selectedJoinRelationship = null;
    protected DropTarget m_dropTarget;
    protected JPopupMenu m_barPopmenu;
    protected JPopupMenu m_joinPopmenu;
    protected static final int HORIZONTAL_SPACING = 15;
    protected static final int VERTICAL_SPACING = 15;
    protected static final int MINIMUM_DISTANCE_TO_LINE = 6;
    protected transient Dimension m_preferredSize = new Dimension(450, 160);
    protected transient ExpressionEditDialog m_expBuilder;
    private static WAdminResource bundle = WAdminResource.getBundle(WATablesAndRelsView.class);
    protected ArrayList m_alTables = new ArrayList();
    protected ArrayList m_alColumns = new ArrayList();
    protected transient DraggingPanel m_draggingPanel;
    protected transient JoinsRelationshipPanel m_joinsRelationshipPanel;
    protected transient boolean m_colDragging = false;
    protected transient boolean m_colDropVaild = false;
    protected transient Dimension m_dragOffset;
    protected transient Rectangle m_dragStartRect = new Rectangle();
    protected transient Rectangle m_dragCurRect = new Rectangle();
    protected transient Point m_dragPoint = new Point(-1, -1);
    protected transient com.sas.metadata.remote.Column m_dragStartColumn;
    protected transient WATablesAndRelsTableView m_dragStartTable;
    protected transient ColumnMouseListener m_columnMouseListener;
    protected transient ColumnMouseMotionListener m_columnMouseMotionListener;
    protected transient ColumnViewChangeListener m_columnViewChangeListener;
    protected transient TableComponentListener m_tableComponentListener;
    protected transient boolean m_bInitialSizeSet = false;
    protected String m_columnLabelFormat = null;

    public WATablesAndRelsView(Query query, JScrollPane scrollPane) {
        this.m_dropTarget = new DropTarget(this, this.createDropTargetListener());
        this.m_dropTarget.setDefaultActions(0);
        this.m_query = query;
        this.m_query.addPropertyListener((ModelChangeListener)this, 24);
        this.m_scrollPane = scrollPane;
        this.setLayout(null);
        this.m_joinsRelationshipPanel = new JoinsRelationshipPanel();
        this.m_joinsRelationshipPanel.setLayout(null);
        this.m_joinsRelationshipPanel.setSize(this.getSize());
        this.m_joinsRelationshipPanel.setOpaque(false);
        this.add(this.m_joinsRelationshipPanel);
        this.setLayer(this.m_joinsRelationshipPanel, DEFAULT_LAYER - 1);
        this.m_draggingPanel = new DraggingPanel();
        this.m_draggingPanel.setLayout(null);
        this.m_draggingPanel.setSize(this.getSize());
        this.m_draggingPanel.setOpaque(false);
        this.add(this.m_draggingPanel);
        this.setLayer(this.m_draggingPanel, DRAG_LAYER);
        this.addKeyListener(new MyKeyListener());
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        this.m_query.addPropertyListener((ModelChangeListener)this, 8, 4);
        this._refresh();
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.m_draggingPanel != null) {
            this.m_draggingPanel.setSize(width, height - 1);
        }
        if (this.m_joinsRelationshipPanel != null) {
            this.m_joinsRelationshipPanel.setSize(width, height - 1);
        }
        this.m_preferredSize = new Dimension(width, height);
    }

    @Override
    public void setSize(Dimension dim) {
        this.setSize(dim.width, dim.height);
    }

    public void closing() {
        this.m_query.removePropertyListener((ModelChangeListener)this);
    }

    public void modelChangeCallback(ModelChangeEvent event) {
        this._refresh();
    }

    protected DropTargetListener createDropTargetListener() {
        return new cDropTargetListener();
    }

    public Query getQuery() {
        return this.m_query;
    }

    protected void finalize() throws Throwable {
        this.closing();
        super.finalize();
    }

    public void addError(String message) {
        this.m_query.getMessageHandler().addError(message);
    }

    public void addInternalError(Exception e) {
        this.m_query.getMessageHandler().addInternalError(e);
    }

    public void endQueryChange() {
        this.m_query.getMessageHandler().firePropertyChanges();
        com.sas.query.visuals.MessageUtil.displayMessages((MessageHandler)this.m_query.getMessageHandler());
    }

    public boolean failureHasOccurred() {
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
        return this.m_query.getMessageHandler().failureHasOccurred();
    }

    public void firePropertyChanges() {
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
    }

    public void onEditJoinRelationship() {
        this.addQueryTablesToMetadataTableList();
        Expression expr = this.getSelectedJoinRelationship().getComparisonDetails();
        ColumnList colList = expr.getReferencedColumns();
        this.m_alColumns.clear();
        if (colList != null) {
            for (int c = 0; c < colList.size(); ++c) {
                Column col = colList.elementAt(c);
                this.m_alColumns.add(this.getMetadataColumn(col));
            }
        }
        ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(this.m_alColumns, this.m_alTables, true);
        tabExpressionBuilder.setExpression(expr.generateSQL(this.m_query.getDataSource().getSqlLogic(this.getQuery()), 1));
        tabExpressionBuilder.setUseQuotes(((WAQuery)this.m_query).isQuotingRequired());
        tabExpressionBuilder.setColumnGroupNodeName(bundle.getString("AdvancedJoinDialog.ExpColsNode.txt"));
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("AdvancedJoinDialog.ExpBuilder.Title.txt"), true, (WAPanel)tabExpressionBuilder);
        dialog.setResizable(true);
        dialog.show();
        try {
            if (dialog.getReturnValue() == 1) {
                String strExpr = tabExpressionBuilder.getExpression();
                Parser parse = new Parser();
                Expression expression = parse.parseExpression(this.getQuery(), strExpr);
                JoinRelationship join = this.getSelectedJoinRelationship();
                if (expression.generateSQL(this.getQuery().getDataSource().getSqlLogic(this.getQuery()), 1).trim().length() == 0) {
                    this.m_query.deleteJoinRelationship(join);
                } else {
                    join.setComparisonDetails(expression);
                }
                this.m_query.isValidSql();
                this.setDataChanged(true);
            }
        }
        catch (Throwable t) {
            WindowUtil.busyOff((JComponent)this);
            MessageUtil.displayMessage((String)t.getLocalizedMessage(), (int)0);
        }
        WindowUtil.busyOff((JComponent)this);
        this.m_expBuilder = null;
        this.endQueryChange();
    }

    protected com.sas.metadata.remote.Column getMetadataColumn(Column col) {
        com.sas.metadata.remote.Column metaCol = (com.sas.metadata.remote.Column)((PhysicalColumn)col).getDataSourceColumn().getUnderlyingColumn();
        return metaCol;
    }

    public void addQueryTablesToMetadataTableList() {
        this.m_alTables.clear();
        TableList tblList = this.getQuery().getTables();
        for (int i = 0; i < tblList.size(); ++i) {
            Table table = tblList.elementAt(i);
            this.m_alTables.add(table.getDataSourceTable().getUnderlyingTable());
        }
    }

    public void onDistinct() {
        if (this.getQuery().getDuplicateRows()) {
            this.getQuery().setDuplicateRowsRule(0);
        } else {
            this.getQuery().setDuplicateRowsRule(2);
        }
        this.endQueryChange();
        this.setDataChanged(true);
    }

    public void onAdvancedJoins() {
        WindowUtil.busyOn((JComponent)this);
        try {
            AdvancedJoinPropertyView propertyView = new AdvancedJoinPropertyView(this.getQuery());
            QueryStandardDialog joinDialog = new QueryStandardDialog(WindowUtil.getParentFrame((Component)this), this.getQuery(), propertyView, bundle.getString("TARV.AdvanceJoin.title.txt"));
            joinDialog.setHelpProduct("wdb");
            joinDialog.setHelpTopic("advanced_joins");
            propertyView.setSelectedJoinReleationship(this.getSelectedJoinRelationship());
            joinDialog.show();
            if (joinDialog.getReturnValue() == 1) {
                this.setDataChanged(true);
            }
        }
        catch (Throwable t) {
            WindowUtil.busyOff((JComponent)this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff((JComponent)this);
        this.endQueryChange();
    }

    public void onDeleteJoinRelationship() {
        this.m_query.deleteJoinRelationship(this.getSelectedJoinRelationship());
        this.endQueryChange();
        this.setDataChanged(true);
    }

    public void onDeleteAllRelationships() {
        int eAnswer = MessageUtil.displayMessage((String)bundle.getString("TARV.DeleteAllJoins.Message.txt"), (String)bundle.getString("Common.ConfirmDelete.Title.txt"), (int)1, (int)0);
        if (eAnswer == 0) {
            JoinRelationshipList joinList = this.m_query.getJoinRelationships();
            while (joinList.size() > 0) {
                this.m_query.deleteJoinRelationship(joinList.elementAt(0));
            }
            this.endQueryChange();
            this.setDataChanged(true);
        }
    }

    public boolean isJoinACompoundExpressionWithMultipleColumns(Expression expression) {
        if (expression instanceof ParenExpression) {
            expression = ((ParenExpression)expression).getExpression();
        }
        if (expression instanceof CompoundExpression) {
            CompoundExpression compound = (CompoundExpression)expression;
            ExpressionList paramList = compound.getParameters();
            Expression leftObj = paramList.elementAt(0);
            Expression rightObj = paramList.elementAt(1);
            if (leftObj instanceof ColumnExpression && rightObj instanceof ColumnExpression) {
                return false;
            }
            if (leftObj instanceof CompoundExpression && ((CompoundExpression)leftObj).getReferencedColumns().size() > 1) {
                return true;
            }
            if (rightObj instanceof CompoundExpression && ((CompoundExpression)rightObj).getReferencedColumns().size() > 1) {
                return true;
            }
        }
        return false;
    }

    public WATablesAndRelsTableView getNodeView(Table table) {
        for (int index = 0; index < this.m_views.size(); ++index) {
            WATablesAndRelsTableView tableView = (WATablesAndRelsTableView)((Object)this.m_views.elementAt(index));
            if (tableView.getTable() != table) continue;
            return tableView;
        }
        WATablesAndRelsTableView newView = new WATablesAndRelsTableView(this.m_query, this, table);
        newView.addTableAliasEventListener(this.createTableAliasEventListener());
        TablePosition tablepos = new TablePosition(newView.getSize());
        Dimension currentSize = this.getSize();
        Dimension newSize = new Dimension(currentSize);
        int tempscalar = tablepos.x + newView.getWidth() + 10;
        if (currentSize.width < tempscalar) {
            newSize.width = tempscalar;
        }
        if (currentSize.height < (tempscalar = tablepos.y + newView.getHeight() + 10)) {
            newSize.height = tempscalar;
        }
        if (!newSize.equals(currentSize)) {
            this.setMinimumSize(newSize);
            this.setSize(newSize);
        }
        if (this.m_columnMouseListener == null) {
            this.m_columnMouseListener = new ColumnMouseListener();
        }
        if (this.m_columnMouseMotionListener == null) {
            this.m_columnMouseMotionListener = new ColumnMouseMotionListener();
        }
        newView.addColumnMouseListener(this.m_columnMouseListener);
        newView.addColumnMouseMotionListener(this.m_columnMouseMotionListener);
        if (this.m_columnViewChangeListener == null) {
            this.m_columnViewChangeListener = new ColumnViewChangeListener();
        }
        if (this.m_tableComponentListener == null) {
            this.m_tableComponentListener = new TableComponentListener();
        }
        newView.addColumnViewChangeListener(this.m_columnViewChangeListener);
        newView.addComponentListener(this.m_tableComponentListener);
        newView.setLocation(tablepos);
        this.m_views.addElement(newView);
        newView.setVisible(true);
        this.add((Component)((Object)newView));
        newView.doLayout();
        newView.revalidate();
        newView.requestFocus();
        this.resizeForNodes();
        if (this.isShowing()) {
            this.setSelectedTable(newView);
            this.makeTableVisible(newView);
        }
        return newView;
    }

    public WATablesAndRelsTableView getSelectedTable() {
        return this.m_selectedTable;
    }

    public synchronized void setSelectedTable(WATablesAndRelsTableView tableView) {
        this.m_selectedTable = tableView;
        this.m_selectedTable.isSelected = true;
        this.m_selectedJoinRelationship = null;
        this.repaint();
    }

    public JoinRelationship getSelectedJoinRelationship() {
        return this.m_selectedJoinRelationship;
    }

    public synchronized void setSelectedJoinRelationship(JoinRelationship joinRelationship) {
        this.m_selectedTable = null;
        this.requestFocus();
        this.m_selectedJoinRelationship = joinRelationship;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    public void makeTableVisible(WATablesAndRelsTableView tableView) {
        boolean fPositionChanged = false;
        this.m_scrollPane.validate();
        if (tableView.getX() > 0 && this.m_scrollPane != null) {
            int scrollX = this.m_scrollPane.getHorizontalScrollBar().getValue();
            int scrollY = this.m_scrollPane.getVerticalScrollBar().getValue();
            Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
            int change = scrollX + viewPortSize.width - (tableView.getX() + tableView.getWidth() + 20);
            if (change < 0) {
                this.m_scrollPane.getHorizontalScrollBar().setValue(scrollX - change);
                fPositionChanged = true;
            } else {
                change = scrollX - tableView.getX() + 20;
                if (change > 0) {
                    this.m_scrollPane.getHorizontalScrollBar().setValue(scrollX - change);
                    fPositionChanged = true;
                }
            }
            change = scrollY + viewPortSize.height - (tableView.getY() + tableView.getHeight() + 20);
            if (change < 0) {
                this.m_scrollPane.getVerticalScrollBar().setValue(scrollY - change);
                fPositionChanged = true;
            } else {
                change = scrollY - tableView.getY() + 20;
                if (change > 0) {
                    this.m_scrollPane.getVerticalScrollBar().setValue(scrollY - change);
                    fPositionChanged = true;
                }
            }
        }
        if (fPositionChanged) {
            this.repaint();
        }
    }

    public WATablesAndRelsTableView getTableViewAt(Point p) {
        for (int index = 0; index < this.m_views.size(); ++index) {
            if (!((WATablesAndRelsTableView)((Object)this.m_views.elementAt(index))).getBounds().contains(p)) continue;
            return (WATablesAndRelsTableView)((Object)this.m_views.elementAt(index));
        }
        return null;
    }

    public WATablesAndRelsTableView getTableViewAt(int x, int y) {
        return this.getTableViewAt(new Point(x, y));
    }

    public void resizeForNodes() {
        if (this.m_scrollPane == null) {
            return;
        }
        int desiredWidth = this.m_scrollPane.getViewport().getSize().width - 5;
        int desiredHeight = this.m_scrollPane.getViewport().getSize().height - 5;
        for (int tableIndex = 0; tableIndex < this.m_views.size(); ++tableIndex) {
            WATablesAndRelsTableView view = (WATablesAndRelsTableView)((Object)this.m_views.elementAt(tableIndex));
            desiredWidth = Math.max(desiredWidth, view.getLocation().x + view.getSize().width + 10);
            desiredHeight = Math.max(desiredHeight, view.getLocation().y + view.getSize().height + 10);
        }
        this.setSize(desiredWidth, desiredHeight);
    }

    private void repositionNodes() {
        Vector transientViews = new Vector();
        for (int i = 0; i < this.m_views.size(); ++i) {
            transientViews.addElement(this.m_views.elementAt(i));
        }
        this.m_views.removeAllElements();
        for (int tableIndex = 0; tableIndex < transientViews.size(); ++tableIndex) {
            WATablesAndRelsTableView view = (WATablesAndRelsTableView)((Object)transientViews.elementAt(tableIndex));
            TablePosition tablepos = new TablePosition(view.getSize());
            view.setLocation(tablepos);
            this.m_views.addElement(view);
        }
    }

    public void resizeTableHeights() {
        Rectangle rect = new Rectangle();
        this.computeVisibleRect(rect);
        for (int index = 0; index < this.m_views.size(); ++index) {
            WATablesAndRelsTableView tbl = (WATablesAndRelsTableView)((Object)this.m_views.elementAt(index));
            int height = 250;
            int colCnt = tbl.getTable().getColumnCount();
            if (colCnt < 12) {
                height = colCnt < 6 ? colCnt * 21 + 48 : colCnt * 21 + 16;
            }
            if (height > (int)rect.getHeight() - 45) {
                height = (int)rect.getHeight() - 45;
            }
            tbl.setSize(150, height);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.m_bInitialSizeSet) {
            this.m_bInitialSizeSet = true;
            this.resizeForNodes();
            this.repositionNodes();
            this.resizeForNodes();
            return;
        }
    }

    public void displayMessage(ClueView message, int startX, int startY) {
        message.setSize(message.getPreferredSize());
        message.setLocation(startX, startY);
        message.setVisible(false);
    }

    public void paintJoins(Graphics g, JoinRelationshipList joinList) {
        Rectangle right = new Rectangle();
        Rectangle left = new Rectangle();
        for (int index = 0; index < joinList.size(); ++index) {
            JoinRelationship joinRelationship = joinList.elementAt(index);
            int comparisonType = joinRelationship.getComparisonType();
            if (comparisonType == 1) continue;
            this.buildJoinParms(joinRelationship, left, right);
            Table table = joinRelationship.getRightTable();
            Join join = this.m_query.getJoin(table);
            int type = join.getJoinType();
            DrawUtil.drawJoinLine((Graphics)g, (joinRelationship == this.getSelectedJoinRelationship() ? 1 : 0) != 0, (int)type, (Rectangle)left, (Rectangle)right);
        }
    }

    public void buildJoinParms(JoinRelationship join, Rectangle leftRect, Rectangle rightRect) {
        int comparisonType = join.getComparisonType();
        Expression details = join.getComparisonDetails();
        Rectangle dest = null;
        Rectangle source = null;
        Column rightColumn = null;
        Column leftColumn = null;
        if (comparisonType != 1 && comparisonType == 4) {
            if (details instanceof UnparsedExpression) {
                details = this.updateColumnAliasInJoin(details, join.getLeftTable());
                leftColumn = this.searchJoinExpressionForColumn(details, join.getLeftTable());
                dest = this.getColumnRectangle(leftColumn);
                details = this.updateColumnAliasInJoin(details, join.getRightTable());
                rightColumn = this.searchJoinExpressionForColumn(details, join.getRightTable());
                source = this.getColumnRectangle(rightColumn);
                join.setComparisonDetails(details);
            }
            if (details instanceof ParenExpression) {
                details = ((ParenExpression)details).getExpression();
            }
            if (details instanceof CompoundExpression) {
                CompoundExpression compound = (CompoundExpression)details;
                ExpressionList paramList = compound.getParameters();
                Function function = compound.getCurrentFunction();
                Expression leftObj = paramList.elementAt(0);
                Expression rightObj = paramList.elementAt(1);
                if (leftObj instanceof ColumnExpression) {
                    leftColumn = ((ColumnExpression)leftObj).getColumn();
                } else if (leftObj instanceof CompoundExpression) {
                    ColumnList leftColList = ((CompoundExpression)leftObj).getReferencedColumns();
                    leftColumn = leftColList.elementAt(0);
                }
                if (rightObj instanceof ColumnExpression) {
                    rightColumn = ((ColumnExpression)rightObj).getColumn();
                } else if (rightObj instanceof CompoundExpression) {
                    ColumnList rightColList = ((CompoundExpression)rightObj).getReferencedColumns();
                    rightColumn = rightColList.elementAt(0);
                }
                if (function instanceof Operator && leftColumn != null && rightColumn != null) {
                    dest = this.getColumnRectangle(leftColumn);
                    source = this.getColumnRectangle(rightColumn);
                }
            } else if (comparisonType == 5) {
                // empty if block
            }
        }
        if (source == null || dest == null) {
            int height;
            source = this.getNodeView(join.getRightTable()).getBounds();
            dest = this.getNodeView(join.getLeftTable()).getBounds();
            source.height = height = this.getNodeView(join.getRightTable()).getHeaderHeight();
            dest.height = height;
        }
        leftRect.setBounds(dest);
        rightRect.setBounds(source);
    }

    protected Rectangle getColumnRectangle(Column col) {
        if (col == null) {
            return null;
        }
        Rectangle rect = new Rectangle();
        WATablesAndRelsTableView tableView = this.getNodeView(col.getParent());
        com.sas.metadata.remote.Column leftMetaCol = (com.sas.metadata.remote.Column)((PhysicalColumn)col).getDataSourceColumn().getUnderlyingColumn();
        rect = tableView.getJoinRectangle(leftMetaCol);
        rect.setLocation(rect.getLocation().x + tableView.getLocation().x, rect.getLocation().y + tableView.getLocation().y + 2);
        return rect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Column searchJoinExpressionForColumn(Expression expr, Table table) {
        int startOfTableName = -1;
        String columnStart = "";
        String tableName = "";
        String searchString = expr.getDisplayString();
        String alias = table.getCorrelationName();
        if (alias != null) {
            if (alias.compareTo(tableName) != 0) {
                tableName = alias;
            }
        } else {
            tableName = table.getName();
        }
        if ((startOfTableName = searchString.indexOf(tableName = ((WAdminSqlLogic)this.m_query.getSqlLogic()).genIdentifier(tableName) + ".")) != -1) {
            columnStart = searchString.substring(startOfTableName + tableName.length());
        } else {
            if (((WAQuery)this.m_query).isQuotingRequired()) return null;
            tableName = tableName.substring(0, tableName.length() - 1);
            tableName = "'" + tableName + "'n.";
            startOfTableName = searchString.indexOf(tableName);
            if (startOfTableName == -1) return null;
            columnStart = searchString.substring(startOfTableName + tableName.length());
        }
        ColumnList colList = table.getColumns();
        for (int i = 0; i < colList.size(); ++i) {
            String checkName;
            Column col = colList.elementAt(i);
            String colName = ((WAdminSqlLogic)this.m_query.getSqlLogic()).genIdentifier(col.getName().trim());
            int nameLength = colName.length();
            if (columnStart.length() < nameLength || colName.compareTo(checkName = columnStart.substring(0, nameLength)) != 0) continue;
            return col;
        }
        return null;
    }

    public Expression updateColumnAliasInJoin(Expression expr, Table table) {
        String tblName = table.getName();
        String alias = table.getCorrelationName();
        if (alias == null) {
            return expr;
        }
        if (alias == tblName) {
            return expr;
        }
        tblName = ((WAdminSqlLogic)this.m_query.getSqlLogic()).genIdentifier(tblName) + ".";
        String searchString = expr.getDisplayString();
        int startOfTableName = searchString.indexOf(tblName);
        if (startOfTableName == -1) {
            return expr;
        }
        if (startOfTableName == 0) {
            String last = searchString.substring(tblName.length() - 1);
            searchString = alias + last;
        } else {
            String first = searchString.substring(0, startOfTableName);
            String last = searchString.substring(startOfTableName + tblName.length());
            searchString = first + alias + "." + last;
        }
        expr = Expression.createInstance((Query)this.m_query, (String)searchString);
        return expr;
    }

    protected void _refresh() {
        TableList tableList = this.m_query.getReferableTables();
        int cTables = tableList.size();
        for (int index = this.m_views.size() - 1; index >= 0; --index) {
            WATablesAndRelsTableView view = (WATablesAndRelsTableView)((Object)this.m_views.elementAt(index));
            boolean bFound = false;
            for (int tableIndex = 0; tableIndex < cTables; ++tableIndex) {
                if (tableList.elementAt(tableIndex) != view.getTable()) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            this.remove((Component)this.m_views.elementAt(index));
            this.m_views.removeElementAt(index);
        }
        for (int tableIndex = 0; tableIndex < cTables; ++tableIndex) {
            this.getNodeView(tableList.elementAt(tableIndex));
        }
        this.repaint();
    }

    protected WATablesAndRelsTableView.cAliasEventListener createTableAliasEventListener() {
        return new NewAliasEventListener();
    }

    protected JoinRelationship _getJoinRelationshipByLocation(Point point) {
        JoinRelationshipList joinList = this.m_query.getJoinRelationships();
        if (joinList.size() == 0) {
            return null;
        }
        Rectangle dest = new Rectangle();
        Rectangle source = new Rectangle();
        Rectangle rightRect = new Rectangle();
        Rectangle leftRect = new Rectangle();
        Point rightPoint = new Point();
        Point leftPoint = new Point();
        int minJoinIndex = -1;
        double minDist = 10.0;
        double dist = -1.0;
        for (int index = 0; index < joinList.size(); ++index) {
            JoinRelationship join = joinList.elementAt(index);
            int comparisonType = join.getComparisonType();
            if (comparisonType == 1) continue;
            this.buildJoinParms(join, dest, source);
            DrawUtil.getJoinLineAreas((boolean)false, (int)0, (Rectangle)source, (Rectangle)dest, (Rectangle)rightRect, (Rectangle)leftRect, (Point)rightPoint, (Point)leftPoint);
            if (rightRect.contains(point) || leftRect.contains(point)) {
                return join;
            }
            dist = DrawUtil.distanceToLine((Point)rightPoint, (Point)leftPoint, (Point)point);
            if (!(Math.abs(dist) < 6.0) || !(dist < minDist)) continue;
            minDist = dist;
            minJoinIndex = index;
        }
        if (minJoinIndex != -1) {
            return this.m_query.getJoinRelationships().elementAt(minJoinIndex);
        }
        return null;
    }

    public boolean validatePairing(Column sourceColumn, Column targetColumn) {
        try {
            com.sas.metadata.remote.Column sourceCol = (com.sas.metadata.remote.Column)((PhysicalColumn)sourceColumn).getDataSourceColumn().getUnderlyingColumn();
            com.sas.metadata.remote.Column targetCol = (com.sas.metadata.remote.Column)((PhysicalColumn)targetColumn).getDataSourceColumn().getUnderlyingColumn();
            if (targetCol.getSASColumnType().equalsIgnoreCase(sourceCol.getSASColumnType())) {
                if (targetCol.getSASColumnType().equalsIgnoreCase("N")) {
                    if (targetCol.getSASColumnLength() == sourceCol.getSASColumnLength()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public JPopupMenu getOverallPopmenu() {
        this.m_barPopmenu = new JPopupMenu("BarViewMenu");
        this.m_barPopmenu.add((JMenuItem)new PopMenuItem(bundle.getString("TARV.AdvancedJoins.txt"), "onAdvancedJoins", (Object)this));
        this.m_barPopmenu.add((JMenuItem)new PopMenuItem(bundle.getString("TARV.DeleteAllJoins.txt"), "onDeleteAllRelationships", (Object)this));
        this.m_barPopmenu.add((JMenuItem)new PopMenuCheckBoxItem(!this.getQuery().getDuplicateRows(), bundle.getString("TARV.SelectDistinct.txt"), "onDistinct", (Object)this));
        return this.m_barPopmenu;
    }

    public JPopupMenu getJoinPopmenu() {
        this.m_joinPopmenu = this.getOverallPopmenu();
        this.m_joinPopmenu.insert(new JPopupMenu.Separator(), 0);
        this.m_joinPopmenu.insert((Component)new PopMenuItem(bundle.getString("TARV.DeleteRelationship.txt"), "onDeleteJoinRelationship", (Object)this), 0);
        this.m_joinPopmenu.insert((Component)new PopMenuItem(bundle.getString("TARV.EditRelationship....txt"), "onEditJoinRelationship", (Object)this), 0);
        return this.m_joinPopmenu;
    }

    public void setJoinPopmenu(JPopupMenu menu) {
        this.m_joinPopmenu = menu;
    }

    public String getColumnLabelFormat() {
        return this.m_columnLabelFormat;
    }

    public void setColumnLabelFormat(String value) {
        this.m_columnLabelFormat = value;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.m_scrollPane.getViewport().getSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 60;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    protected class NewAliasEventListener
    implements WATablesAndRelsTableView.cAliasEventListener {
        protected NewAliasEventListener() {
        }

        @Override
        public void tableAliasAdded(WATablesAndRelsTableView.cNewAliasEvent e) {
            Table table = e.getTable();
            JoinRelationshipList joinList = WATablesAndRelsView.this.getQuery().getJoinRelationships();
            for (int index = 0; index < joinList.size(); ++index) {
                String newAlias;
                String oldAlias;
                JoinRelationship join = joinList.elementAt(index);
                Expression details = join.getComparisonDetails();
                if (!(details instanceof UnparsedExpression)) continue;
                String strExpr = details.getDisplayString();
                Table rightTable = join.getRightTable();
                Table leftTable = join.getLeftTable();
                if (rightTable == table) {
                    oldAlias = rightTable.getName();
                    newAlias = rightTable.getCorrelationName();
                    strExpr = this.updateTableName(newAlias, oldAlias, strExpr);
                    join.setComparisonDetails(Expression.createInstance((Query)WATablesAndRelsView.this.getQuery(), (String)strExpr));
                    continue;
                }
                if (leftTable != table) continue;
                oldAlias = leftTable.getName();
                newAlias = leftTable.getCorrelationName();
                strExpr = this.updateTableName(newAlias, oldAlias, strExpr);
                join.setComparisonDetails(Expression.createInstance((Query)WATablesAndRelsView.this.getQuery(), (String)strExpr));
            }
        }

        @Override
        public void tableAliasChanged(WATablesAndRelsTableView.cNewAliasEvent e) {
            String oldAlias = e.getOldAliasUsed();
            Table table = e.getTable();
            JoinRelationshipList joinList = WATablesAndRelsView.this.getQuery().getJoinRelationships();
            for (int index = 0; index < joinList.size(); ++index) {
                String newAlias;
                JoinRelationship join = joinList.elementAt(index);
                Expression details = join.getComparisonDetails();
                if (!(details instanceof UnparsedExpression)) continue;
                String strExpr = details.getDisplayString();
                Table rightTable = join.getRightTable();
                Table leftTable = join.getLeftTable();
                if (rightTable == table) {
                    newAlias = rightTable.getCorrelationName();
                    strExpr = this.updateTableName(newAlias, oldAlias, strExpr);
                    join.setComparisonDetails(Expression.createInstance((Query)WATablesAndRelsView.this.getQuery(), (String)strExpr));
                    continue;
                }
                if (leftTable != table) continue;
                newAlias = leftTable.getCorrelationName();
                strExpr = this.updateTableName(newAlias, oldAlias, strExpr);
                join.setComparisonDetails(Expression.createInstance((Query)WATablesAndRelsView.this.getQuery(), (String)strExpr));
            }
        }

        @Override
        public void tableAliasRemoved(WATablesAndRelsTableView.cNewAliasEvent e) {
            String oldAlias = e.getOldAliasUsed();
            Table table = e.getTable();
            JoinRelationshipList joinList = WATablesAndRelsView.this.getQuery().getJoinRelationships();
            for (int index = 0; index < joinList.size(); ++index) {
                String newAlias;
                JoinRelationship join = joinList.elementAt(index);
                Expression details = join.getComparisonDetails();
                if (!(details instanceof UnparsedExpression)) continue;
                String strExpr = details.getDisplayString();
                Table rightTable = join.getRightTable();
                Table leftTable = join.getLeftTable();
                if (rightTable == table) {
                    newAlias = rightTable.getName();
                    strExpr = this.updateTableName(newAlias, oldAlias, strExpr);
                    join.setComparisonDetails(Expression.createInstance((Query)WATablesAndRelsView.this.getQuery(), (String)strExpr));
                    continue;
                }
                if (leftTable != table) continue;
                newAlias = leftTable.getName();
                strExpr = this.updateTableName(newAlias, oldAlias, strExpr);
                join.setComparisonDetails(Expression.createInstance((Query)WATablesAndRelsView.this.getQuery(), (String)strExpr));
            }
        }

        public String updateTableName(String newAlias, String oldAlias, String strExpr) {
            newAlias = ((WAdminSqlLogic)WATablesAndRelsView.this.m_query.getSqlLogic()).genIdentifier(newAlias) + ".";
            oldAlias = ((WAdminSqlLogic)WATablesAndRelsView.this.m_query.getSqlLogic()).genIdentifier(oldAlias) + ".";
            int begloc = strExpr.indexOf(oldAlias);
            if (begloc == -1 && !((WAQuery)WATablesAndRelsView.this.m_query).isQuotingRequired()) {
                oldAlias = oldAlias.substring(0, oldAlias.length() - 1);
                oldAlias = "'" + oldAlias + "'n.";
                begloc = strExpr.indexOf(oldAlias);
            }
            while (begloc > -1) {
                String endString = "";
                String begString = "";
                int endloc = begloc + oldAlias.length();
                if (begloc == 0) {
                    endString = strExpr.substring(endloc);
                    strExpr = newAlias + endString;
                } else {
                    begString = strExpr.substring(0, begloc);
                    endString = strExpr.substring(endloc);
                    strExpr = begString + newAlias + endString;
                }
                begloc = strExpr.indexOf(oldAlias);
            }
            return strExpr;
        }
    }

    protected class cDropTargetListener
    implements DropTargetListener {
        protected cDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.rejectDrag();
            Workspace.getWorkspace().getStatusBar().setText(bundle.getString("TARV.InvalidDrop.txt"));
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            e.rejectDrag();
            Workspace.getWorkspace().getStatusBar().setText(bundle.getString("TARV.InvalidDrop.txt"));
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            e.rejectDrop();
            Workspace.getWorkspace().getStatusBar().setText(bundle.getString("TARV.InvalidDrop.txt"));
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getID() != 401) {
                return;
            }
            switch (event.getKeyCode()) {
                case 127: {
                    if (WATablesAndRelsView.this.getSelectedJoinRelationship() != null) {
                        WATablesAndRelsView.this.onDeleteJoinRelationship();
                    }
                    event.consume();
                    WATablesAndRelsView.this.setDataChanged(true);
                    break;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }

    class DraggingPanel
    extends JPanel {
        DraggingPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (WATablesAndRelsView.this.m_colDragging) {
                DrawUtil.drawJoinLine((Graphics)g, (boolean)false, (int)0, (Rectangle)WATablesAndRelsView.this.m_dragStartRect, (Rectangle)WATablesAndRelsView.this.m_dragCurRect);
            }
        }
    }

    class JoinsRelationshipPanel
    extends JPanel {
        JoinsRelationshipPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            WATablesAndRelsView.this.paintJoins(g, WATablesAndRelsView.this.m_query.getJoinRelationships());
        }
    }

    protected class TableComponentListener
    extends ComponentAdapter {
        protected TableComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            WATablesAndRelsView.this.m_joinsRelationshipPanel.repaint();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            WATablesAndRelsView.this.m_joinsRelationshipPanel.repaint();
        }
    }

    public class ColumnViewChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            WATablesAndRelsView.this.m_joinsRelationshipPanel.repaint();
        }
    }

    class ColumnMouseListener
    extends MouseAdapter {
        ColumnMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 4) == 0) {
                if (!WATablesAndRelsView.this.m_colDragging) {
                    WATablesAndRelsView.this.repaint();
                    return;
                }
                WATablesAndRelsView.this.m_colDragging = false;
                int curX = e.getX();
                int curY = e.getY();
                for (Component curComp = (Component)e.getSource(); WATablesAndRelsView.this != curComp; curComp = curComp.getParent()) {
                    curX += curComp.getLocation().x;
                    curY += curComp.getLocation().y;
                }
                WATablesAndRelsTableView targetTable = WATablesAndRelsView.this.getTableViewAt(curX, curY);
                if (targetTable != null) {
                    if (targetTable == WATablesAndRelsView.this.m_dragStartTable) {
                        WATablesAndRelsView.this.repaint();
                        return;
                    }
                    Point colPoint = new Point(curX - targetTable.getLocation().x, curY - targetTable.getLocation().y);
                    Column targetCol = targetTable.getColumnAtPoint(colPoint);
                    if (targetCol != null) {
                        try {
                            if (WATablesAndRelsView.this.m_dragStartTable == null) {
                                return;
                            }
                            Column sourceCol = WATablesAndRelsView.this.m_dragStartTable.m_table.getColumn(WATablesAndRelsView.this.m_dragStartColumn.getSASColumnName());
                            if (WATablesAndRelsView.this.validatePairing(sourceCol, targetCol)) {
                                WATablesAndRelsView.this.m_query.addJoinRelationship(sourceCol, targetCol);
                                WATablesAndRelsView.this.m_joinHasDrawn = true;
                                WATablesAndRelsView.this.m_query.isValidSql();
                                WATablesAndRelsView.this.endQueryChange();
                                WATablesAndRelsView.this.setDataChanged(true);
                            }
                            MessageUtil.displayMessage((String)bundle.getString("TARV.InvalidJoin.txt"), (int)0);
                        }
                        catch (NullPointerException ex) {
                            return;
                        }
                        catch (Exception ex) {
                            return;
                        }
                    }
                } else {
                    ((Component)e.getSource()).requestFocus();
                }
                WATablesAndRelsView.this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 4) == 0) {
                WATablesAndRelsView.this.m_dragPoint = new Point(e.getX(), e.getY());
            }
        }
    }

    class ColumnMouseMotionListener
    extends MouseMotionAdapter {
        ColumnMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Component curComp;
            int curX = e.getX();
            int curY = e.getY();
            for (curComp = (Component)e.getSource(); WATablesAndRelsView.this != curComp; curComp = curComp.getParent()) {
                curX += curComp.getLocation().x;
                curY += curComp.getLocation().y;
            }
            WATablesAndRelsTableView targetTable = WATablesAndRelsView.this.getTableViewAt(curX, curY);
            if (WATablesAndRelsView.this.m_colDragging) {
                curComp = WATablesAndRelsView.this.getComponentAt(curX, curY);
                if (targetTable != null && targetTable != WATablesAndRelsView.this.m_dragStartTable) {
                    targetTable.requestFocus();
                    Point columnPoint = new Point(curX - targetTable.getLocation().x, curY - targetTable.getLocation().y);
                    Column targetCol = targetTable.getColumnAtPoint(columnPoint);
                    if (targetCol == null) {
                        WATablesAndRelsView.this.m_dragCurRect.setBounds(curX, curY, 0, 0);
                        WATablesAndRelsView.this.m_colDropVaild = false;
                    } else {
                        targetTable.setSelection(columnPoint);
                        WATablesAndRelsView.this.m_dragCurRect = targetTable.getJoinRectangle(targetTable.getSelectedColumn());
                        WATablesAndRelsView.this.m_dragCurRect.setLocation(WATablesAndRelsView.this.m_dragCurRect.getLocation().x + targetTable.getLocation().x, WATablesAndRelsView.this.m_dragCurRect.getLocation().y + targetTable.getLocation().y + 2);
                    }
                } else {
                    WATablesAndRelsView.this.m_dragCurRect.setBounds(curX, curY, 0, 0);
                    WATablesAndRelsView.this.m_colDropVaild = false;
                }
            } else if (targetTable != null) {
                Point p = e.getPoint();
                if (Math.abs(WATablesAndRelsView.this.m_dragPoint.x - p.x) < 3 && Math.abs(WATablesAndRelsView.this.m_dragPoint.x - p.x) < 3) {
                    return;
                }
                WATablesAndRelsView.this.m_colDragging = true;
                com.sas.metadata.remote.Column col = targetTable.getSelectedColumn();
                if (col == null) {
                    return;
                }
                WATablesAndRelsView.this.m_dragStartRect = targetTable.getJoinRectangle(col);
                WATablesAndRelsView.this.m_dragStartRect.setLocation(WATablesAndRelsView.this.m_dragStartRect.getLocation().x + targetTable.getLocation().x, WATablesAndRelsView.this.m_dragStartRect.getLocation().y + targetTable.getLocation().y + 2);
                WATablesAndRelsView.this.m_dragStartColumn = targetTable.getSelectedColumn();
                WATablesAndRelsView.this.m_dragStartTable = targetTable;
                WATablesAndRelsView.this.m_dragCurRect.setBounds(curX, curY, 0, 0);
            }
            WATablesAndRelsView.this.m_draggingPanel.repaint();
        }
    }

    class TablePosition
    extends Point {
        protected TablePosition(Dimension size2find) {
            if (WATablesAndRelsView.this.m_views.size() == 0) {
                this.x = 15;
                this.y = 15;
                return;
            }
            Dimension panelSize = WATablesAndRelsView.this.getSize();
            Rectangle masterRect = new Rectangle(0, 0, panelSize.width, panelSize.height);
            Rectangle tempRect = WATablesAndRelsView.this.getVisibleRect();
            if (this.bigenough(size2find, tempRect.getSize())) {
                masterRect.setBounds(tempRect.x, tempRect.y, tempRect.width, masterRect.height - tempRect.y);
            }
            Vector<Rectangle> tableRects = new Vector<Rectangle>();
            for (int index = 0; index < WATablesAndRelsView.this.m_views.size(); ++index) {
                tempRect = ((WATablesAndRelsTableView)((Object)WATablesAndRelsView.this.m_views.elementAt(index))).getBounds();
                tempRect.width += 30;
                tempRect.height += 30;
                tableRects.addElement(tempRect);
            }
            Vector<Rectangle> availableRects = new Vector<Rectangle>();
            availableRects.addElement(masterRect);
            for (int i = 0; i < tableRects.size(); ++i) {
                Vector workRects = new Vector();
                Rectangle cantBeHereRect = (Rectangle)tableRects.elementAt(i);
                for (int j = 0; j < availableRects.size(); ++j) {
                    Rectangle newRect;
                    Rectangle bigTestRect = (Rectangle)availableRects.elementAt(j);
                    if (!cantBeHereRect.intersects(bigTestRect)) {
                        this.addWithoutDuplicates(workRects, bigTestRect);
                        continue;
                    }
                    if (cantBeHereRect.y - bigTestRect.y > 0 && this.bigenough(size2find, (newRect = new Rectangle(bigTestRect.x, bigTestRect.y, bigTestRect.width, cantBeHereRect.y - bigTestRect.y)).getSize())) {
                        this.addWithoutDuplicates(workRects, newRect);
                    }
                    if (bigTestRect.y + bigTestRect.height - (cantBeHereRect.y + cantBeHereRect.height) > 0 && this.bigenough(size2find, (newRect = new Rectangle(bigTestRect.x, cantBeHereRect.y + cantBeHereRect.height - 15, bigTestRect.width, bigTestRect.y + bigTestRect.height - cantBeHereRect.y + cantBeHereRect.height)).getSize())) {
                        this.addWithoutDuplicates(workRects, newRect);
                    }
                    if (cantBeHereRect.x - bigTestRect.x > 0 && this.bigenough(size2find, (newRect = new Rectangle(bigTestRect.x, bigTestRect.y, cantBeHereRect.x - bigTestRect.x, bigTestRect.height)).getSize())) {
                        this.addWithoutDuplicates(workRects, newRect);
                    }
                    if (bigTestRect.x + bigTestRect.width - (cantBeHereRect.x + cantBeHereRect.width) <= 0 || !this.bigenough(size2find, (newRect = new Rectangle(cantBeHereRect.x + cantBeHereRect.width, bigTestRect.y, bigTestRect.x + bigTestRect.width - (cantBeHereRect.x + cantBeHereRect.width), bigTestRect.height)).getSize())) continue;
                    this.addWithoutDuplicates(workRects, newRect);
                }
                availableRects = workRects;
            }
            if (availableRects.size() == 0) {
                this.x = masterRect.x + 15;
                this.y = masterRect.y + size2find.height + 45;
            } else {
                int bestY = 5555;
                int bestX = masterRect.x;
                for (int index = 0; index < availableRects.size(); ++index) {
                    tempRect = (Rectangle)availableRects.elementAt(index);
                    if (tempRect.y < bestY) {
                        bestY = tempRect.y;
                        bestX = tempRect.x;
                        continue;
                    }
                    if (tempRect.y != bestY || tempRect.x >= bestX) continue;
                    bestY = tempRect.y;
                    bestX = tempRect.x;
                }
                this.x = bestX + 15;
                this.y = bestY + 15;
            }
        }

        private void addWithoutDuplicates(Vector workRects, Rectangle newRect) {
            for (int index = 0; index < workRects.size(); ++index) {
                Rectangle tempRect = (Rectangle)workRects.elementAt(index);
                if (tempRect.x != newRect.x || tempRect.y != newRect.y || tempRect.width != newRect.width || tempRect.height != newRect.height) continue;
                return;
            }
            workRects.addElement(newRect);
        }

        private boolean bigenough(Dimension desired, Dimension test) {
            return desired.width <= test.width && desired.height <= test.height;
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        MouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            WATablesAndRelsView.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            WATablesAndRelsView.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            JoinRelationship joinRelationship = WATablesAndRelsView.this._getJoinRelationshipByLocation(event.getPoint());
            if (joinRelationship != null) {
                WATablesAndRelsView.this.setSelectedJoinRelationship(joinRelationship);
            }
            if (event.getClickCount() == 2 && (event.getModifiers() & 4) == 0 && joinRelationship != null) {
                WATablesAndRelsView.this.onEditJoinRelationship();
            }
            WATablesAndRelsView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if ((event.getModifiers() & 4) != 0) {
                JPopupMenu popmenu = null;
                JoinRelationship join = WATablesAndRelsView.this._getJoinRelationshipByLocation(event.getPoint());
                if (join != null) {
                    WATablesAndRelsView.this.setSelectedJoinRelationship(join);
                    popmenu = WATablesAndRelsView.this.getJoinPopmenu();
                } else if (event.getSource() instanceof WATablesAndRelsView) {
                    popmenu = WATablesAndRelsView.this.getOverallPopmenu();
                }
                if (popmenu != null) {
                    JComponent source = (JComponent)event.getSource();
                    source.add(popmenu);
                    popmenu.show(source, event.getX(), event.getY());
                    return;
                }
            }
        }
    }
}

