/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.QueryDefiner;
import com.sas.query.models.JDataSourceTree;
import com.sas.query.visuals.JDataSourceTreeView;
import com.sas.query.wa.WADataFilterSection;
import com.sas.query.wa.WAGroupFilterSection;
import com.sas.query.wa.WAJReferableTreeView;
import com.sas.query.wa.WAQuery;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;

public class WAQueryDefiner
extends QueryDefiner {
    public static final String DATA_CHANGED_PROPERTY = "DataChanged";
    protected boolean m_bDataChanged = false;
    protected boolean m_bListeningForChanges = true;
    private cPanelListener m_PanelListener = new cPanelListener();
    protected WAGroupFilterSection m_groupFilterSection;
    protected WADataFilterSection m_dataFilterSection;

    public WAQueryDefiner(WAQuery query, int features, int limits) {
        super((Query)query, features, limits);
    }

    protected void _constructPanel() {
        JSplitPane splitter = new JSplitPane();
        splitter.setBorder(BorderFactory.createEmptyBorder());
        if ((this.m_features & 0x40) != 0) {
            this.m_referableTreeView = new WAJReferableTreeView(this, this.m_query);
            splitter.setLeftComponent((Component)this.m_referableTreeView);
        } else {
            JDataSourceTree dataSourceTree = new JDataSourceTree(this.m_query, this.m_query.getDataSource(), false);
            this.m_dataSourceTreeView = new JDataSourceTreeView(this.m_query, dataSourceTree);
            splitter.setLeftComponent((Component)this.m_dataSourceTreeView);
        }
        JSplitPane parent = splitter;
        int nPosition = 0;
        if (this._getCountOfSections() > 1) {
            parent = new JSplitPane(0);
            parent.setBorder(BorderFactory.createEmptyBorder());
        }
        if ((this.m_features & 1) != 0) {
            this.m_dataFilterSection = new WADataFilterSection(this, this.m_query, 1L);
            this.listenForDataChangesTo(this.m_dataFilterSection);
            this._addSection(parent, nPosition++, this.m_dataFilterSection);
            if (this.m_referableTreeView != null) {
                this.m_referableTreeView.setDefaultAction(1);
            }
        }
        if ((this.m_features & 0x200) != 0) {
            this.m_groupFilterSection = new WAGroupFilterSection(this, this.m_query, 1L);
            this._addSection(parent, nPosition++, this.m_groupFilterSection);
            if (this.m_referableTreeView != null) {
                this.m_referableTreeView.setDefaultAction(2);
            }
        }
        if (this._getCountOfSections() > 1) {
            parent.setBorder(BorderFactory.createEmptyBorder());
            splitter.setRightComponent(parent);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(splitter, gbc);
        this.add(splitter);
        splitter.setDividerLocation(170);
        parent.setDividerLocation(170);
    }

    protected void listenForDataChangesTo(WADataFilterSection pnl) {
        pnl.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_PanelListener);
    }

    public void setListeningForChanges(boolean bListeningForChanges) {
        this.m_bListeningForChanges = bListeningForChanges;
    }

    public boolean isListeningForChanges() {
        return this.m_bListeningForChanges;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            if (this.m_groupFilterSection != null) {
                this.m_groupFilterSection.setDataChanged(bDataChanged);
            }
            if (this.m_dataFilterSection != null) {
                this.m_dataFilterSection.setDataChanged(bDataChanged);
            }
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    private class cPanelListener
    implements PropertyChangeListener {
        private cPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (WAQueryDefiner.this.isListeningForChanges()) {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    WAQueryDefiner.this.setDataChanged(true);
                } else {
                    WAQueryDefiner.this.setDataChanged(false);
                }
            }
        }
    }
}

