/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.codegen.CodegenException;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.UniqueKey;
import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.Relationship;
import com.sas.query.datasources.RelationshipList;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnList;
import com.sas.query.models.Expression;
import com.sas.query.models.GroupItem;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.OrderItem;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.Parser;
import com.sas.query.wa.WAdminDataSource;
import com.sas.query.wa.WAdminSqlLogic;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class WAQuery
extends Query {
    protected Select m_select = null;
    protected TransformationStep m_transformationStep = null;
    protected boolean m_bLoaded = false;
    protected boolean m_quote = false;
    protected boolean m_bCodegen = false;
    protected String m_origSQL = "";
    protected boolean m_hasSamePhysicalTable;
    protected Vector m_vQualifiedNames;
    protected boolean b_hasDerivedResultItems = false;
    private WAdminResource bundle = WAdminResource.getBundle(WAQuery.class);

    public WAQuery(WAdminDataSource ds, CMetadata obj) {
        super((DataSource)ds);
        if (obj instanceof TransformationStep) {
            this.m_transformationStep = (TransformationStep)obj;
        } else if (obj instanceof Select) {
            this.m_select = (Select)obj;
        }
        this.setAutoGroup(false);
    }

    public void reloadModelFromMetadata() {
        try {
            this.m_bLoaded = false;
            this.clear();
            this.m_dataSource = new WAdminDataSource();
            this.m_messageHandler.removeAllMessages();
            this.loadModelFromMetadata();
            this.getPropertyChangeHandler().firePropertyChanges();
        }
        catch (QueryException e) {
            System.err.println("Error reloading query model from metadata: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean loadModelFromMetadata(boolean isCodegen) {
        this.m_bCodegen = isCodegen;
        return this.loadModelFromMetadata();
    }

    public boolean loadModelFromMetadata() {
        boolean retValue = false;
        try {
            if (this.loadSelect()) {
                retValue = true;
                this.m_origSQL = "";
                if (!this.m_bLoaded) {
                    GroupByClause m_groupByClause;
                    AssociationList lColumns;
                    OrderByClause m_orderByClause;
                    int j;
                    int i;
                    TextStore sourcecode = null;
                    for (int ii = 0; ii < this.m_select.getSourceSpecifications().size(); ++ii) {
                        Root obj = (Root)this.m_select.getSourceSpecifications().get(ii);
                        if (!(obj instanceof TextStore) || !obj.getName().equals("SQL")) continue;
                        sourcecode = (TextStore)obj;
                    }
                    String sql = null;
                    if (sourcecode != null) {
                        sql = sourcecode.getStoredText();
                        if (this.m_select.getIsUserDefined() == 0 && sql != null && sql.length() < 5) {
                            sql = null;
                        }
                        if (sql != null && sql.indexOf("DISTINCT ") == 0) {
                            this.setDuplicateRowsRule(0);
                            sql = sql.substring(9);
                        }
                    }
                    Vector searchSourceList = new Vector();
                    AssociationList classifierSources = this.m_select.getClassifierSources();
                    int clsSourcesSize = classifierSources.size();
                    this.addTablesFromClassifierSources(classifierSources, searchSourceList);
                    this.enableAutoJoin(sql == null);
                    for (i = 0; classifierSources != null && i < clsSourcesSize; ++i) {
                        DataSourceTable wadsTable = ((WAdminDataSource)this.m_dataSource).getTable((DataTable)classifierSources.elementAt(i));
                        if (wadsTable == null) continue;
                        String alias = this._findUniqueTableName(wadsTable.getName(), 0);
                        Table qTable = this.addTable(wadsTable);
                        if (!alias.equals(wadsTable.getName())) {
                            qTable.setCorrelationName(alias);
                        }
                        if (qTable != null) {
                            Workspace.getDefaultLogger().debug((Object)("Added table <" + qTable.getName() + "> to query"));
                            continue;
                        }
                        Workspace.getDefaultLogger().debug((Object)("Could not add <" + wadsTable.getName() + "> to query"));
                    }
                    PhysicalTable MainWork = null;
                    AssociationList targetTableList = this.m_select.getClassifierTargets();
                    for (i = 0; i < targetTableList.size(); ++i) {
                        MainWork = (PhysicalTable)targetTableList.elementAt(i);
                    }
                    if (MainWork != null) {
                        AssociationList featureMapList = this.m_select.getFeatureMaps();
                        AssociationList colList = MainWork.getColumns();
                        String name = "abc";
                        for (j = 0; j < colList.size() && name != null && name.length() > 0; ++j) {
                            com.sas.metadata.remote.Column mCol = (com.sas.metadata.remote.Column)colList.elementAt(j);
                            name = mCol.getSASColumnName();
                            if (name == null || name.length() < 1) {
                                throw new NoSuchFieldError(this.bundle.getString("WAQuery.NoColumnName.txt"));
                            }
                            int length = mCol.getSASColumnLength();
                            if (length < 1) {
                                throw new NoSuchFieldError(this.bundle.getString("WAQuery.NoColumnLength.txt"));
                            }
                            String expression = "";
                            String format = "";
                            boolean isAliasRequired = true;
                            int k = this.findTargetColumnIDInFeatureMapList((List)featureMapList, mCol.getFQID());
                            if (k >= 0) {
                                FeatureMap featureMap = (FeatureMap)featureMapList.elementAt(k);
                                com.sas.metadata.remote.Column targetColumn = (com.sas.metadata.remote.Column)featureMap.getFeatureTargets().elementAt(0);
                                Workspace.getDefaultLogger().debug((Object)("Feature map for <" + name + ">: " + featureMap.getTransformRole() + " with " + featureMap.getFeatureSources().size() + " source"));
                                String mapRole = featureMap.getTransformRole();
                                if (mapRole.equals("ONETOONE") || mapRole.equals("1:1")) {
                                    AssociationList featureSources = featureMap.getFeatureSources();
                                    if (featureSources != null && featureSources.size() > 0) {
                                        com.sas.metadata.remote.Column sourceColumn = (com.sas.metadata.remote.Column)featureSources.elementAt(0);
                                        expression = "";
                                        Column qCol = this.findColumnInQuery(sourceColumn);
                                        if (qCol != null) {
                                            Table aTable = qCol.getParent();
                                            String tAlias = aTable.getCorrelationName();
                                            expression = tAlias == null || tAlias.length() < 1 ? ((WAdminSqlLogic)this.getSqlLogic()).genIdentifier(aTable.getDisplayName()) + "." : ((WAdminSqlLogic)this.getSqlLogic()).genIdentifier(tAlias) + ".";
                                        }
                                        expression = expression + ((WAdminSqlLogic)this.getSqlLogic()).genIdentifier(sourceColumn.getSASColumnName());
                                        if (sourceColumn.getSASColumnName().length() < 1) {
                                            throw new NoSuchFieldError(this.bundle.getString("WAQuery.NoColumnName.txt"));
                                        }
                                        if (sourceColumn.getSASColumnName().equalsIgnoreCase(targetColumn.getSASColumnName())) {
                                            isAliasRequired = false;
                                        }
                                        if (sourceColumn.getSASColumnLength() != targetColumn.getSASColumnLength()) {
                                            format = targetColumn.getSASColumnType().charAt(0) == 'C' ? "$" + targetColumn.getSASColumnLength() + "." : targetColumn.getSASColumnLength() + ".";
                                        }
                                    }
                                } else if (mapRole.equals("DERIVED") || mapRole.equals("Derived")) {
                                    TextStore expr = (TextStore)featureMap.getSourceCode();
                                    if (expr != null && expr.getStoredText().length() > 0) {
                                        expression = expr.getStoredText();
                                        expression = ExpressionParser.detokenizeString((String)expression, (AbstractTransformation)featureMap, (boolean)this.m_quote);
                                    }
                                    format = targetColumn.getSASColumnType().charAt(0) == 'C' ? "$" + targetColumn.getSASColumnLength() + "." : targetColumn.getSASColumnLength() + ".";
                                    if (!this.b_hasDerivedResultItems) {
                                        this.b_hasDerivedResultItems = true;
                                    }
                                }
                            }
                            if (expression.length() < 1) continue;
                            Workspace.getDefaultLogger().debug((Object)("Adding result item <" + expression + "> with format <" + format + ">"));
                            ResultItem item = this.addResultItem(Expression.createInstance((Query)this, (String)expression));
                            if (isAliasRequired || format.length() > 0) {
                                item.setAlias(mCol.getSASColumnName());
                            }
                            if (format.length() <= 0) continue;
                            item.setFormat(format);
                        }
                    }
                    if (sql != null) {
                        Workspace.getDefaultLogger().debug((Object)("Found SQL <" + sql + ">"));
                        if (this.m_select.getIsSubstitutionAllowed() == 1) {
                            String temp = this.getSql();
                            int indTemp = temp.indexOf(" FROM ");
                            sql = temp.substring(0, indTemp + 1) + sql;
                            ExpressionParser.setServer((ServerContext)((WAdminDataSource)this.m_dataSource).getServer());
                            sql = ExpressionParser.detokenizeString((String)sql, (AbstractTransformation)this.m_select, (boolean)this.m_quote);
                            ExpressionParser.setServer(null);
                        }
                        this.setSQL(sql);
                        Vector<Table> vBadTables = new Vector<Table>();
                        for (i = 0; classifierSources != null && i < clsSourcesSize; ++i) {
                            DataTable metaTable = (DataTable)classifierSources.elementAt(i);
                            String metaFQID = metaTable.getFQID();
                            TableList queryTableList = this.getTables();
                            boolean found = false;
                            int saved = 0;
                            for (j = 0; j < queryTableList.size(); ++j) {
                                Table queryTable = queryTableList.elementAt(j);
                                String queryTableFQID = ((DataTable)queryTable.getDataSourceTable().getUnderlyingTable()).getFQID();
                                if (metaFQID.equalsIgnoreCase(queryTableFQID)) {
                                    ++saved;
                                    found = true;
                                }
                                if (saved <= 1) continue;
                                vBadTables.add(queryTable);
                            }
                            if (found) continue;
                            DataSourceTable wadsTable = ((WAdminDataSource)this.m_dataSource).getTable(metaTable);
                            if (vBadTables.size() == 0) {
                                this.enableAutoJoin(true);
                                this.addTable(wadsTable);
                                Workspace.getDefaultLogger().debug((Object)("Added table <" + wadsTable.getName() + "> to query"));
                                continue;
                            }
                            boolean badfound = false;
                            for (int b = 0; b < vBadTables.size(); ++b) {
                                Table badTable = (Table)vBadTables.get(b);
                                String tableName = badTable.getName();
                                if (!tableName.equals(wadsTable.getName())) continue;
                                this.fixDataSourceProblem(badTable, wadsTable);
                                vBadTables.remove(b);
                                badfound = true;
                                break;
                            }
                            if (badfound) continue;
                            this.enableAutoJoin(true);
                            this.addTable(wadsTable);
                            Workspace.getDefaultLogger().debug((Object)("Added table <" + wadsTable.getName() + "> to query"));
                        }
                        TableList qTables = this.getTables();
                        for (int a = 0; a < qTables.size(); ++a) {
                            Table qTable = qTables.elementAt(a);
                            String oAlias = qTable.getName();
                            String nAlias = qTable.getCorrelationName();
                            if (nAlias == null || nAlias.length() <= 0 || oAlias.equals(nAlias)) continue;
                            ((WAdminSqlLogic)qTable.getSqlLogic()).updateResultsWithNewAlias(oAlias, nAlias);
                        }
                    } else if (this.b_hasDerivedResultItems) {
                        String strSQL = this.getSql();
                        this.setSQL(strSQL);
                    }
                    if (this.m_orderItems.size() > 0) {
                        this.m_orderItems.removeAllElements();
                    }
                    if ((m_orderByClause = this.m_select.getOrderByForSelect()) != null && (lColumns = m_orderByClause.getColumns()) != null && lColumns.size() > 0) {
                        for (int o = 0; o < lColumns.size(); ++o) {
                            com.sas.metadata.remote.Column col = (com.sas.metadata.remote.Column)lColumns.get(o);
                            String sortOrder = col.getSortOrder();
                            ResultItem resultItem = this.findResultNameInQuery(col.getSASColumnName());
                            if (resultItem == null) continue;
                            OrderItem order = null;
                            if (((FeatureMap)col.getTargetFeatureMaps().get(0)).getTransformRole().equalsIgnoreCase("Derived")) {
                                int colNum = this.m_resultItems.indexOf(resultItem);
                                Integer number = new Integer(colNum + 1);
                                Parser parse = new Parser();
                                Expression expression = parse.parseExpression((Query)this, number.toString());
                                order = new OrderItem((Query)this, expression);
                            } else {
                                String expr = resultItem.getExpression().getDisplayString();
                                int index = expr.indexOf("format=");
                                if (index > -1) {
                                    int colNum = this.m_resultItems.indexOf(resultItem);
                                    Integer number = new Integer(colNum + 1);
                                    Parser parse = new Parser();
                                    Expression expression = parse.parseExpression((Query)this, number.toString());
                                    order = new OrderItem((Query)this, expression);
                                } else {
                                    order = new OrderItem(resultItem);
                                }
                            }
                            if (sortOrder.toUpperCase().equals("DESCENDING")) {
                                order.setSortingDirection(2);
                            }
                            this.addOrderItem(order);
                        }
                    }
                    if (this.m_groupItems.size() > 0) {
                        this.m_groupItems.removeAllElements();
                    }
                    if ((m_groupByClause = this.m_select.getGroupByForSelect()) != null) {
                        AssociationList glColumns = m_groupByClause.getColumns();
                        GroupItem group = null;
                        if (glColumns != null && glColumns.size() > 0) {
                            for (int o = 0; o < glColumns.size(); ++o) {
                                com.sas.metadata.remote.Column col = (com.sas.metadata.remote.Column)glColumns.get(o);
                                ResultItem resultItem = this.findResultNameInQuery(col.getSASColumnName());
                                if (resultItem == null) continue;
                                AssociationList alFM = col.getTargetFeatureMaps();
                                boolean isInteger = false;
                                boolean isColumnDerived = false;
                                for (int g = 0; g < alFM.size(); ++g) {
                                    FeatureMap fM = (FeatureMap)alFM.get(g);
                                    if (fM == null) continue;
                                    String role = fM.getTransformRole();
                                    if (role.equalsIgnoreCase("SQLGROUPBYINTEGER")) {
                                        int colNum = this.m_resultItems.indexOf(resultItem);
                                        Integer number = new Integer(colNum + 1);
                                        Parser parse = new Parser();
                                        Expression expression = parse.parseExpression((Query)this, number.toString());
                                        group = new GroupItem((Query)this, expression);
                                        isInteger = true;
                                        break;
                                    }
                                    if (!role.equalsIgnoreCase("DERIVED")) continue;
                                    isColumnDerived = true;
                                }
                                if (!isInteger && isColumnDerived) {
                                    MessageUtil.displayMessage((String)this.bundle.messageString("WAQuery.GroupByDerivedError.txt", (Object)col.getSASColumnName()), (int)0);
                                    return false;
                                }
                                if (!isInteger) {
                                    Expression expr = resultItem.getExpression();
                                    String format = resultItem.getFormat();
                                    if (format != null || expr instanceof UnparsedExpression) {
                                        int colNum = this.m_resultItems.indexOf(resultItem);
                                        Integer number = new Integer(colNum + 1);
                                        Parser parse = new Parser();
                                        Expression expression = parse.parseExpression((Query)this, number.toString());
                                        group = new GroupItem((Query)this, expression);
                                    } else {
                                        group = new GroupItem(resultItem);
                                    }
                                }
                                this.addGroupItem(group);
                            }
                        }
                    }
                }
                this.m_origSQL = this.getSql();
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            retValue = false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_bLoaded = retValue;
        return retValue;
    }

    public boolean saveModelToMetadata(boolean saveSQL, boolean saveFeatureMaps, boolean saveGroupby, boolean saveOrderby) {
        boolean retValue = false;
        try {
            if (this.loadSelect() && !this.m_origSQL.equals(this.getSql())) {
                retValue = true;
                if (saveSQL) {
                    this.updateSQLSource();
                }
                if (saveFeatureMaps) {
                    this.updateFeatureMaps();
                }
                if (saveGroupby) {
                    this.updateGroupByClause();
                }
                if (saveOrderby) {
                    this.updateOrderByClause();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error saving query model to metadata: " + e.getMessage());
            e.printStackTrace();
            retValue = false;
        }
        return retValue;
    }

    protected boolean loadSelect() throws MdException, RemoteException {
        if (this.m_transformationStep != null && this.m_select == null) {
            this.m_select = (Select)this.m_transformationStep.getTransformations().elementAt(0);
        }
        return this.m_select != null;
    }

    private void updateSQLSource() throws MdException, RemoteException {
        int i;
        String origSQL = this.getSql();
        boolean bDistinct = origSQL.indexOf("SELECT DISTINCT ") == 0;
        int index = origSQL.indexOf(" FROM ");
        if (index > 1) {
            origSQL = origSQL.substring(index + 1);
        }
        if (bDistinct) {
            origSQL = "DISTINCT " + origSQL;
        }
        Vector<Object> tablesAndCols = new Vector<Object>();
        TableList tList = this.getReferableTables();
        for (i = 0; i < tList.size(); ++i) {
            Object table = tList.elementAt(i).getDataSourceTable().getUnderlyingTable();
            tablesAndCols.add(table);
        }
        for (i = 0; i < tList.size(); ++i) {
            ColumnList cols = tList.elementAt(i).getColumns();
            for (int j = 0; j < cols.size(); ++j) {
                Column col = cols.elementAt(j);
                if (!(col instanceof PhysicalColumn)) continue;
                tablesAndCols.add(((PhysicalColumn)col).getDataSourceColumn().getUnderlyingColumn());
            }
        }
        ExpressionParser.setServer((ServerContext)((WAdminDataSource)this.m_dataSource).getServer());
        String parsedSQL = ExpressionParser.tokenizeString((String)origSQL, tablesAndCols, (AbstractTransformation)this.m_select, (boolean)this.m_quote, (boolean)this.m_quote);
        ExpressionParser.setServer(null);
        TextStore text = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(this.m_select.getObjectStore(), null, "SQL", "TextStore", this.m_select.getRepositoryID(), null);
        text.setStoredText(parsedSQL);
        text.setDesc("SASJoin created SQL");
        this.m_select.getSourceSpecifications().flushAll();
        this.m_select.getSourceSpecifications().add((Object)text);
        this.m_select.setIsSubstitutionAllowed(1);
    }

    public boolean isQuotingRequired() {
        return this.m_quote;
    }

    protected void fixDataSourceProblem(Table badTable, DataSourceTable goodDataSource) {
        this.m_tables.removeElement(badTable);
        this.queueStructureChange(8, 2, badTable);
        for (int i = 0; i < this.m_joins.size(); ++i) {
            if (this.m_joins.elementAt(i).getTable() != badTable) continue;
            this.queueStructureChange(16, 2, this.m_joins.elementAt(i));
            this.m_joins.removeElementAt(i);
            break;
        }
        Vector<Integer> badResultItemsNumbers = new Vector<Integer>();
        block1: for (int index = this.m_resultItems.size() - 1; index >= 0; --index) {
            Expression expression = this.m_resultItems.elementAt(index).getExpression();
            ColumnList columnList = expression.getReferencedColumns();
            for (int colIndex = 0; colIndex < columnList.size(); ++colIndex) {
                if (columnList.elementAt(colIndex).getParent() != badTable) continue;
                badResultItemsNumbers.add(new Integer(index));
                continue block1;
            }
        }
        JoinRelationshipList joinList = this.getJoinRelationships();
        JoinRelationshipList savedJoinRelationshipList = new JoinRelationshipList();
        for (int index = joinList.size() - 1; index >= 0; --index) {
            JoinRelationship joinRelationship = this.m_joinRelationships.elementAt(index);
            if (joinRelationship.getLeftTable() == badTable || joinRelationship.getRightTable() == badTable) {
                savedJoinRelationshipList.addElement(joinRelationship);
                this._deleteJoinRelationship(joinRelationship);
            }
            if (index != 0) continue;
            this.m_joins.groupJoinsFromList(this.m_joinRelationships);
        }
        Table newTable = this.addTable(goodDataSource);
        for (int i = 0; i < badResultItemsNumbers.size(); ++i) {
            int badItem = (Integer)badResultItemsNumbers.get(i);
            Expression expression = this.m_resultItems.elementAt(badItem).getExpression();
            Column columnToAdd = ((ColumnExpression)expression).getColumn();
            this.deleteResultItem(this.m_resultItems.elementAt(badItem));
            this.addResultItem(columnToAdd, badItem);
        }
        for (int j = 0; j < savedJoinRelationshipList.size(); ++j) {
            JoinRelationship joinRel = savedJoinRelationshipList.elementAt(j);
            Table leftTable = joinRel.getLeftTable();
            Table rightTable = joinRel.getRightTable();
            Expression expr = joinRel.getComparisonDetails();
            String strExpr = expr.generateSQL(this.getSqlLogic(), 1);
            int compType = joinRel.getComparisonType();
            if (leftTable.equals(badTable)) {
                leftTable = newTable;
            } else {
                rightTable = newTable;
            }
            JoinRelationship newJoin = new JoinRelationship((Query)this, leftTable, rightTable, compType, strExpr);
            this.addJoinRelationship(newJoin);
        }
    }

    private void updateFeatureMaps() throws MdException, RemoteException {
        String sOneToOneRole = "ONETOONE";
        String sDerivedRole = "DERIVED";
        String sOneToOne = this.bundle.getString("CommonTableModel.OneToOne.txt");
        String sDerived = this.bundle.getString("CommonTableModel.Derived.txt");
        MdObjectStore store = (MdObjectStore)this.m_select.getObjectStore();
        String reposID = this.m_select.getRepositoryID();
        AssociationList aFMList = this.m_select.getFeatureMaps(false);
        ArrayList aOldFMList = new ArrayList(aFMList);
        aFMList.removeAllElements();
        ResultItemList results = this.getResultItems();
        int nResults = results.size();
        for (int rIndex = 0; rIndex < nResults; ++rIndex) {
            Column qColumn;
            com.sas.metadata.remote.Column mColumn;
            FeatureMap oFM;
            ResultItem resultItem = results.elementAt(rIndex);
            Expression expr = resultItem.getExpression();
            ColumnList colList = expr.getReferencedColumns();
            int nColList = colList.size();
            String resultCode = resultItem.getExpression().generateSQL(this.getSqlLogic(), 1);
            int fIndex = resultCode.indexOf(" format=");
            if (fIndex > 0) {
                resultCode = resultCode.substring(0, fIndex);
            }
            resultCode.trim();
            String rAlias = resultItem.getAlias();
            if (rAlias == null) {
                if (nColList == 1) {
                    Column column = colList.elementAt(0);
                    rAlias = column.getName();
                } else {
                    int index = resultCode.indexOf(".");
                    rAlias = index > 0 ? resultCode.substring(index + 1) : resultCode;
                }
            }
            if (resultCode.length() <= 0) continue;
            int pos = this.findTargetColumnNameInFeatureMapList(aOldFMList, rAlias);
            if (pos > -1) {
                String parsedExpr;
                TextStore sourceCode;
                oFM = (FeatureMap)aOldFMList.get(pos);
                AssociationList alSourceColumns = oFM.getFeatureSources(false);
                if (oFM.getTransformRole().equals(sOneToOneRole)) {
                    if (expr.getReferencedFunctions().size() > 0 || nColList == 0) {
                        oFM.setTransformRole(sDerivedRole);
                        sourceCode = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, "FeatureMapExpression", "TextStore", reposID);
                        sourceCode.setTextRole("FeatureMapExpression");
                        parsedExpr = ExpressionParser.tokenizeString((String)resultCode, (List)alSourceColumns, (AbstractTransformation)oFM, (boolean)this.m_quote, (boolean)false);
                        sourceCode.setStoredText(parsedExpr);
                        oFM.setSourceCode((Text)sourceCode);
                    } else {
                        AssociationList fSources = oFM.getFeatureSources(false);
                        mColumn = (com.sas.metadata.remote.Column)fSources.get(0);
                        if (nColList == 1) {
                            qColumn = colList.elementAt(0);
                            com.sas.metadata.remote.Column qMetaColumn = (com.sas.metadata.remote.Column)((PhysicalColumn)qColumn).getDataSourceColumn().getUnderlyingColumn();
                            if (!qMetaColumn.getFQID().equals(mColumn.getFQID())) {
                                fSources.removeAllElements();
                                fSources.addElement((Object)qMetaColumn);
                            }
                        } else if (nColList > 1) {
                            for (int cIndex = 0; cIndex < nColList; ++cIndex) {
                                qColumn = colList.elementAt(cIndex);
                                mColumn = (com.sas.metadata.remote.Column)((PhysicalColumn)qColumn).getDataSourceColumn().getUnderlyingColumn();
                                fSources.addElement((Object)mColumn);
                            }
                        }
                    }
                } else {
                    sourceCode = (TextStore)oFM.getSourceCode();
                    parsedExpr = ExpressionParser.tokenizeString((String)resultCode, (List)alSourceColumns, (AbstractTransformation)oFM, (boolean)this.m_quote, (boolean)false);
                    sourceCode.setStoredText(parsedExpr);
                }
            } else {
                oFM = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, sOneToOne, "FeatureMap", reposID);
                oFM.setTransformRole(sOneToOneRole);
                mColumn = this.findColumnInClassifierTarget(rAlias);
                if (mColumn == null) {
                    MessageUtil.displayMessage((String)this.bundle.getString("WAQuery.NoTargetColumn.Error.txt"), (int)2);
                    continue;
                }
                oFM.getFeatureTargets(false).add((Object)mColumn);
                String role = sOneToOneRole;
                if (nColList > 1) {
                    role = sDerivedRole;
                }
                if (expr.getReferencedFunctions().size() > 0) {
                    role = sDerivedRole;
                }
                if (nColList > 0) {
                    for (int cIndex = 0; cIndex < nColList; ++cIndex) {
                        qColumn = colList.elementAt(cIndex);
                        mColumn = (com.sas.metadata.remote.Column)((PhysicalColumn)qColumn).getDataSourceColumn().getUnderlyingColumn();
                        oFM.getFeatureSources().addElement((Object)mColumn);
                    }
                } else {
                    role = sDerivedRole;
                }
                if (role.equals(sDerivedRole)) {
                    TextStore sourceCode = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, "FeatureMapExpression", "TextStore", reposID);
                    sourceCode.setTextRole("FeatureMapExpression");
                    AssociationList alSourceColumns = oFM.getFeatureSources(false);
                    String parsedExpr = ExpressionParser.tokenizeString((String)resultCode, (List)alSourceColumns, (AbstractTransformation)oFM, (boolean)this.m_quote, (boolean)false);
                    sourceCode.setStoredText(parsedExpr);
                    oFM.setSourceCode((Text)sourceCode);
                    oFM.setName(sDerived);
                    oFM.setTransformRole(role);
                }
            }
            aFMList.addElement((Object)oFM);
        }
    }

    private void updateOrderByClause() throws MdException, RemoteException {
        int modSize;
        boolean change = false;
        OrderByClause obc = this.m_select.getOrderByForSelect();
        AssociationList byColumns = obc.getColumns();
        int bySize = byColumns.size();
        if (bySize != (modSize = this.m_orderItems.size())) {
            change = true;
        } else {
            for (int i = 0; i < modSize; ++i) {
                com.sas.metadata.remote.Column col;
                String cl_colName;
                String dm_colName;
                OrderItem order = this.m_orderItems.elementAt(i);
                ResultItem item = order.getResultItem();
                if (item == null) {
                    Expression expr = order.getExpression();
                    String strExpr = expr.generateSQL(this.getSqlLogic(), 1);
                    try {
                        Integer intExpr = new Integer(strExpr);
                        item = this.m_resultItems.elementAt(intExpr - 1);
                    }
                    catch (NumberFormatException ex) {
                        continue;
                    }
                }
                if ((dm_colName = item.getAlias()) == null) {
                    Expression expr = item.getExpression();
                    ColumnList colList = expr.getReferencedColumns();
                    if (colList.size() == 1) {
                        Column column = colList.elementAt(0);
                        dm_colName = column.getName();
                    } else {
                        String displayName = item.getDisplayName();
                        int index = displayName.indexOf(".");
                        dm_colName = index > 0 ? displayName.substring(index + 1) : displayName;
                    }
                }
                if ((cl_colName = (col = (com.sas.metadata.remote.Column)byColumns.get(i)).getSASColumnName()).equals(dm_colName)) continue;
                change = true;
                break;
            }
        }
        AssociationList ptList = this.m_select.getClassifierTargets();
        if (ptList.size() > 0) {
            PhysicalTable table = (PhysicalTable)ptList.get(0);
            AssociationList allColumns = table.getColumns();
            if (change) {
                byColumns.removeAllElements();
                block7: for (int i = 0; i < modSize; ++i) {
                    String dm_colName;
                    OrderItem order = this.m_orderItems.elementAt(i);
                    ResultItem item = order.getResultItem();
                    if (item == null) {
                        Expression expr = order.getExpression();
                        String strExpr = expr.generateSQL(this.getSqlLogic(), 1);
                        try {
                            Integer intExpr = new Integer(strExpr);
                            item = this.m_resultItems.elementAt(intExpr - 1);
                        }
                        catch (NumberFormatException ex) {
                            continue;
                        }
                    }
                    if ((dm_colName = item.getAlias()) == null) {
                        Expression expr = item.getExpression();
                        ColumnList colList = expr.getReferencedColumns();
                        if (colList.size() == 1) {
                            Column column = colList.elementAt(0);
                            dm_colName = column.getName();
                        } else {
                            String displayName = item.getDisplayName();
                            int index = displayName.indexOf(".");
                            dm_colName = index > 0 ? displayName.substring(index + 1) : displayName;
                        }
                    }
                    for (int j = 0; j < allColumns.size(); ++j) {
                        com.sas.metadata.remote.Column col = (com.sas.metadata.remote.Column)allColumns.get(j);
                        String cl_colName = col.getSASColumnName();
                        if (!cl_colName.equals(dm_colName)) continue;
                        byColumns.add((Object)col);
                        continue block7;
                    }
                }
            }
            for (int i = 0; i < allColumns.size(); ++i) {
                boolean inByColumns = false;
                com.sas.metadata.remote.Column col = (com.sas.metadata.remote.Column)allColumns.get(i);
                String cl_colName = col.getSASColumnName();
                String cl_sortOrder = col.getSortOrder();
                for (int j = 0; j < modSize; ++j) {
                    String dm_colName;
                    OrderItem order = this.m_orderItems.elementAt(j);
                    ResultItem item = order.getResultItem();
                    if (item == null) {
                        Expression expr = order.getExpression();
                        String strExpr = expr.generateSQL(this.getSqlLogic(), 1);
                        try {
                            Integer intExpr = new Integer(strExpr);
                            item = this.m_resultItems.elementAt(intExpr - 1);
                        }
                        catch (NumberFormatException ex) {
                            continue;
                        }
                    }
                    if ((dm_colName = item.getAlias()) == null) {
                        Expression expr = item.getExpression();
                        ColumnList colList = expr.getReferencedColumns();
                        if (colList.size() == 1) {
                            Column column = colList.elementAt(0);
                            dm_colName = column.getName();
                        } else {
                            String displayName = item.getDisplayName();
                            int index = displayName.indexOf(".");
                            dm_colName = index > 0 ? displayName.substring(index + 1) : displayName;
                        }
                    }
                    String dm_sortOrder = "";
                    int sortOrder = order.getSortingDirection();
                    dm_sortOrder = sortOrder == 2 ? "Descending" : (sortOrder == 1 ? "Ascending" : "");
                    if (!cl_colName.equals(dm_colName)) continue;
                    if (cl_sortOrder == null || !cl_sortOrder.equals(dm_sortOrder)) {
                        col.setSortOrder(dm_sortOrder);
                    }
                    inByColumns = true;
                    break;
                }
                if (inByColumns || cl_sortOrder == null || cl_sortOrder.equals("")) continue;
                col.setSortOrder(null);
            }
        }
    }

    private void updateGroupByClause() throws MdException, RemoteException {
        com.sas.metadata.remote.Column col;
        AssociationList byColumns;
        int bySize;
        boolean change = false;
        MdObjectStore store = (MdObjectStore)this.m_select.getObjectStore();
        String reposID = this.m_select.getRepositoryID();
        GroupByClause gbc = this.m_select.getGroupByForSelect();
        int modSize = this.m_groupItems.size();
        if (gbc == null) {
            if (modSize > 0) {
                gbc = (GroupByClause)Workspace.getMdFactory().createComplexMetadataObject(store, "GroupBy", "GroupByClause", reposID);
                this.m_select.setGroupByForSelect(gbc);
            } else {
                return;
            }
        }
        if ((bySize = (byColumns = gbc.getColumns()).size()) != modSize) {
            change = true;
        } else {
            for (int i = 0; i < modSize; ++i) {
                String cl_colName;
                String dm_colName;
                GroupItem group = this.m_groupItems.elementAt(i);
                ResultItem item = group.getResultItem();
                if (item == null) {
                    Expression expr = group.getExpression();
                    String strExpr = expr.generateSQL(this.getSqlLogic(), 1);
                    try {
                        Integer intExpr = new Integer(strExpr);
                        item = this.m_resultItems.elementAt(intExpr - 1);
                    }
                    catch (NumberFormatException ex) {
                        continue;
                    }
                }
                if ((dm_colName = item.getAlias()) == null) {
                    Expression expr = item.getExpression();
                    ColumnList colList = expr.getReferencedColumns();
                    if (colList.size() == 1) {
                        Column column = colList.elementAt(0);
                        dm_colName = column.getName();
                    } else {
                        String displayName = item.getDisplayName();
                        int index = displayName.indexOf(".");
                        dm_colName = index > 0 ? displayName.substring(index + 1) : displayName;
                    }
                }
                if ((cl_colName = (col = (com.sas.metadata.remote.Column)byColumns.get(i)).getSASColumnName()).equals(dm_colName)) continue;
                change = true;
                break;
            }
        }
        AssociationList ptList = this.m_select.getClassifierTargets();
        if (ptList.size() > 0) {
            PhysicalTable table = (PhysicalTable)ptList.get(0);
            AssociationList allColumns = table.getColumns();
            if (change) {
                int i;
                for (i = 0; i < byColumns.size(); ++i) {
                    col = (com.sas.metadata.remote.Column)byColumns.get(i);
                    AssociationList alFM = col.getTargetFeatureMaps(true);
                    if (alFM == null) continue;
                    for (int j = 0; j < alFM.size(); ++j) {
                        FeatureMap fM = (FeatureMap)alFM.get(j);
                        if (fM == null || !fM.getTransformRole().equals("SQLGROUPBYINTEGER")) continue;
                        store.removeObjectFromStore((CMetadata)fM, null);
                    }
                }
                byColumns.removeAllElements();
                block7: for (i = 0; i < modSize; ++i) {
                    String dm_colName;
                    GroupItem group = this.m_groupItems.elementAt(i);
                    ResultItem item = group.getResultItem();
                    boolean isInteger = false;
                    if (item == null) {
                        Expression expr = group.getExpression();
                        String strExpr = expr.generateSQL(this.getSqlLogic(), 1);
                        try {
                            Integer intExpr = new Integer(strExpr);
                            item = this.m_resultItems.elementAt(intExpr - 1);
                            isInteger = true;
                        }
                        catch (NumberFormatException ex) {
                            continue;
                        }
                    }
                    if ((dm_colName = item.getAlias()) == null) {
                        Expression expr = item.getExpression();
                        ColumnList colList = expr.getReferencedColumns();
                        if (colList.size() == 1) {
                            Column column = colList.elementAt(0);
                            dm_colName = column.getName();
                        } else {
                            String displayName = item.getDisplayName();
                            int index = displayName.indexOf(".");
                            dm_colName = index > 0 ? displayName.substring(index + 1) : displayName;
                        }
                    }
                    for (int j = 0; j < allColumns.size(); ++j) {
                        com.sas.metadata.remote.Column col2 = (com.sas.metadata.remote.Column)allColumns.get(j);
                        String cl_colName = col2.getSASColumnName();
                        if (!cl_colName.equalsIgnoreCase(dm_colName)) continue;
                        byColumns.add((Object)col2);
                        if (!isInteger) continue block7;
                        boolean hasFM = false;
                        FeatureMap oFM = null;
                        AssociationList alFM = col2.getTargetFeatureMaps();
                        for (int k = 0; k < alFM.size(); ++k) {
                            oFM = (FeatureMap)alFM.get(k);
                            if (!oFM.getTransformRole().equalsIgnoreCase("SQLGROUPBYINTEGER")) continue;
                            hasFM = true;
                            break;
                        }
                        if (hasFM) continue block7;
                        oFM = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, this.bundle.getString("WAQuery.GroupByFMName.txt"), "FeatureMap", reposID);
                        oFM.setTransformRole("SQLGROUPBYINTEGER");
                        oFM.setIsUserDefined(1);
                        oFM.getFeatureTargets().add((Object)col2);
                        this.m_select.getFeatureMaps().add((Object)oFM);
                        continue block7;
                    }
                }
            }
        }
    }

    protected com.sas.metadata.remote.Column findColumnInClassifierTarget(String colname) {
        com.sas.metadata.remote.Column retValue = null;
        try {
            AssociationList tableList = this.m_select.getClassifierTargets();
            if (tableList != null && colname != null) {
                for (int tIndex = 0; tIndex < tableList.size() && retValue == null; ++tIndex) {
                    PhysicalTable table = (PhysicalTable)tableList.elementAt(tIndex);
                    AssociationList colList = table.getColumns();
                    for (int cIndex = 0; cIndex < colList.size() && retValue == null; ++cIndex) {
                        com.sas.metadata.remote.Column col = (com.sas.metadata.remote.Column)colList.elementAt(cIndex);
                        String name = col.getSASColumnName();
                        if (!name.equals(colname)) continue;
                        retValue = col;
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error finding column: " + e.getMessage());
            e.printStackTrace();
        }
        return retValue;
    }

    protected int findTargetColumnNameInFeatureMapList(List list, String colname) {
        int retValue = -1;
        try {
            for (int index = 0; index < list.size() && retValue < 0 && colname != null; ++index) {
                String name;
                com.sas.metadata.remote.Column col;
                FeatureMap fm = (FeatureMap)list.get(index);
                AssociationList target = fm.getFeatureTargets();
                if (target == null || target.size() != 1 || (col = (com.sas.metadata.remote.Column)target.elementAt(0)) == null || !(name = col.getSASColumnName()).equals(colname)) continue;
                retValue = index;
            }
        }
        catch (Exception e) {
            System.err.println("Error finding column: " + e.getMessage());
            e.printStackTrace();
        }
        return retValue;
    }

    protected int findTargetColumnIDInFeatureMapList(List list, String id) {
        int retValue = -1;
        try {
            for (int index = 0; index < list.size() && retValue < 0; ++index) {
                String name;
                com.sas.metadata.remote.Column col;
                FeatureMap fm = (FeatureMap)list.get(index);
                AssociationList target = fm.getFeatureTargets();
                if (target == null || target.size() != 1 || (col = (com.sas.metadata.remote.Column)target.elementAt(0)) == null || !(name = col.getFQID()).equals(id)) continue;
                retValue = index;
            }
        }
        catch (Exception e) {
            System.err.println("Error finding column: " + e.getMessage());
            e.printStackTrace();
        }
        return retValue;
    }

    protected int findColumnInList(List list, Column qCol) {
        int retValue = -1;
        try {
            String qTableName = qCol.getParent().getDataSourceTable().getQualifiedName();
            for (int index = 0; index < list.size() && retValue < 0; ++index) {
                com.sas.metadata.remote.Column col = (com.sas.metadata.remote.Column)list.get(index);
                DataTable table = col.getTable();
                if (!table.getTableName().equals(qTableName) || !col.getSASColumnName().equals(qCol.getName())) continue;
                retValue = index;
            }
        }
        catch (Exception e) {
            System.err.println("Error finding column: " + e.getMessage());
            e.printStackTrace();
        }
        return retValue;
    }

    protected int findColumnSASNameInList(List list, String colname) {
        int retValue = -1;
        try {
            for (int index = 0; index < list.size() && retValue < 0 && colname != null; ++index) {
                com.sas.metadata.remote.Column col = (com.sas.metadata.remote.Column)list.get(index);
                String name = col.getSASColumnName();
                if (!name.equals(colname)) continue;
                retValue = index;
            }
        }
        catch (Exception e) {
            System.err.println("Error finding column: " + e.getMessage());
            e.printStackTrace();
        }
        return retValue;
    }

    protected Column findColumnInQuery(com.sas.metadata.remote.Column col) throws MdException, RemoteException {
        Column retValue = null;
        DataTable iTab = null;
        iTab = col.getTable();
        String tabID = iTab.getId();
        TableList tList = this.getTables();
        for (int i = 0; i < tList.size() && retValue == null && col != null; ++i) {
            Table qTable = tList.elementAt(i);
            String qTabID = ((DataTable)qTable.getDataSourceTable().getUnderlyingTable()).getId();
            if (!qTabID.equals(tabID)) continue;
            retValue = qTable.getColumn(col.getSASColumnName());
        }
        return retValue;
    }

    protected ResultItem findResultNameInQuery(String resultName) {
        ResultItem retValue = null;
        ResultItemList rList = this.getResultItems();
        for (int i = 0; i < rList.size(); ++i) {
            if (!rList.elementAt(i).getDisplayName().equals(resultName)) continue;
            retValue = rList.elementAt(i);
            break;
        }
        return retValue;
    }

    protected void _autoJoin(Table newTable) {
        TableList referableTables = this.getReferableTables();
        RelationshipList relationshipList = newTable.getRelationships();
        if (relationshipList == null || relationshipList.size() == 0) {
            boolean isJoinCreated = this._autoJoinByKeys(newTable);
            if (!isJoinCreated && !(isJoinCreated = this._autoJoinByUniqueKeyOnly(newTable))) {
                this._autoJoinByName(newTable);
            }
            return;
        }
        for (int referableIndex = 0; referableIndex < referableTables.size(); ++referableIndex) {
            Table referableTable = referableTables.elementAt(referableIndex);
            for (int relIndex = 0; relIndex < relationshipList.size(); ++relIndex) {
                Relationship relationship = relationshipList.elementAt(relIndex);
                String strForeignTable = relationship.getForeignTableName();
                if (!strForeignTable.equals(referableTable.getName())) continue;
                JoinRelationship newJoin = new JoinRelationship((Query)this, newTable, referableTable, 4, (Object)relationship.getComparisonDetails(this.m_dataSource, newTable, referableTable));
                this.addJoinRelationship(newJoin);
                return;
            }
        }
    }

    protected boolean _autoJoinByKeys(Table newTable) {
        boolean isJoinCreated = false;
        Vector joinList = new Vector();
        joinList = (Vector)this._getJoinRelationshipForKeyColumn(newTable, this.m_tables);
        int size = joinList.size();
        if (size > 0) {
            isJoinCreated = true;
            for (int i = 0; i < size; ++i) {
                this.addJoinRelationship((JoinRelationship)joinList.get(i));
            }
        }
        TableList isolatedTables = this._getIsolatedTables();
        TableList newTableList = new TableList(1);
        newTableList.addElement(newTable);
        for (int index = 0; index < isolatedTables.size(); ++index) {
            Workspace.getDefaultLogger().debug((Object)"Working on the isolated tables relationships");
            Table table = isolatedTables.elementAt(index);
            joinList.clear();
            joinList = (Vector)this._getJoinRelationshipForKeyColumn(table, newTableList);
            size = joinList.size();
            if (size <= 0) continue;
            isJoinCreated = true;
            for (int i = 0; i < size; ++i) {
                this.addJoinRelationship((JoinRelationship)joinList.get(i));
            }
        }
        return isJoinCreated;
    }

    protected boolean _autoJoinByUniqueKeyOnly(Table newTable) {
        boolean isJoinCreated = false;
        Vector joinList = new Vector();
        joinList = (Vector)this._getJoinRelationshipForUniqueKeyColumn(newTable, this.m_tables);
        int size = joinList.size();
        if (size > 0) {
            isJoinCreated = true;
            for (int i = 0; i < size; ++i) {
                this.addJoinRelationship((JoinRelationship)joinList.get(i));
            }
        }
        TableList isolatedTables = this._getIsolatedTables();
        TableList newTableList = new TableList(1);
        newTableList.addElement(newTable);
        for (int index = 0; index < isolatedTables.size(); ++index) {
            Workspace.getDefaultLogger().debug((Object)"Working on the isolated tables relationships");
            Table table = isolatedTables.elementAt(index);
            joinList.clear();
            joinList = (Vector)this._getJoinRelationshipForUniqueKeyColumn(table, newTableList);
            size = joinList.size();
            if (size <= 0) continue;
            isJoinCreated = true;
            for (int i = 0; i < size; ++i) {
                this.addJoinRelationship((JoinRelationship)joinList.get(i));
            }
        }
        return isJoinCreated;
    }

    protected List _getJoinRelationshipForKeyColumn(Table newTable, TableList possibleTables) {
        Vector<JoinRelationship> returnList = new Vector<JoinRelationship>();
        JoinRelationship returnValue = null;
        Object temp = newTable.getDataSourceTable().getUnderlyingTable();
        if (temp instanceof DataTable) {
            try {
                DataTable currTable = (DataTable)temp;
                AssociationList uKeyList = currTable.getUniqueKeys();
                int size = uKeyList.size();
                for (int i = 0; i < size; ++i) {
                    UniqueKey uKey = (UniqueKey)uKeyList.get(i);
                    AssociationList fKeyList = uKey.getForeignKeys();
                    int fKeySize = fKeyList.size();
                    if (fKeySize <= 0) continue;
                    for (int j = 0; j < fKeySize; ++j) {
                        ForeignKey fkey = (ForeignKey)fKeyList.get(j);
                        DataTable fkTable = fkey.getTable();
                        String fkFQID = fkTable.getFQID();
                        int cTables = possibleTables.size();
                        for (int tableIndex = cTables - 1; tableIndex >= 0; --tableIndex) {
                            String mFQID;
                            Object temp2;
                            Table table = possibleTables.elementAt(tableIndex);
                            if (table == newTable || !((temp2 = table.getDataSourceTable().getUnderlyingTable()) instanceof DataTable) || !fkFQID.equalsIgnoreCase(mFQID = ((DataTable)temp2).getFQID())) continue;
                            AssociationList fkColumns = fkey.getKeyedColumns();
                            for (int colIndex = 0; colIndex < fkColumns.size(); ++colIndex) {
                                KeyAssociation keyAssoc;
                                DataTable tempTable;
                                com.sas.metadata.remote.Column fkCol = (com.sas.metadata.remote.Column)fkColumns.get(colIndex);
                                Column joinColumn = table.getColumn(fkCol.getSASColumnName());
                                AssociationList keyAssocList = fkCol.getForeignKeyAssociations();
                                com.sas.metadata.remote.Column ukCol = null;
                                for (int d = 0; d < keyAssocList.size() && !(tempTable = (ukCol = (keyAssoc = (KeyAssociation)keyAssocList.get(d)).getUniqueKeyColumn()).getTable()).getFQID().equals(currTable.getFQID()); ++d) {
                                }
                                if (ukCol == null) continue;
                                Column newColumn = newTable.getColumn(ukCol.getSASColumnName());
                                returnValue = new JoinRelationship((Query)this, joinColumn, newColumn);
                                returnList.addElement(returnValue);
                            }
                        }
                    }
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return returnList;
    }

    protected List _getJoinRelationshipForUniqueKeyColumn(Table newTable, TableList possibleTables) {
        Vector<JoinRelationship> returnList = new Vector<JoinRelationship>();
        JoinRelationship returnValue = null;
        Object temp = newTable.getDataSourceTable().getUnderlyingTable();
        if (temp instanceof DataTable) {
            try {
                DataTable currTable = (DataTable)temp;
                AssociationList uKeyList = currTable.getUniqueKeys();
                int size = uKeyList.size();
                for (int i = 0; i < size; ++i) {
                    UniqueKey uKey = (UniqueKey)uKeyList.get(i);
                    AssociationList ukColumns = uKey.getKeyedColumns();
                    for (int j = 0; j < ukColumns.size(); ++j) {
                        com.sas.metadata.remote.Column colObj = (com.sas.metadata.remote.Column)ukColumns.get(j);
                        Column newColumn = newTable.getColumn(colObj.getSASColumnName());
                        int cTables = possibleTables.size();
                        for (int tableIndex = cTables - 1; tableIndex >= 0; --tableIndex) {
                            Table table = possibleTables.elementAt(tableIndex);
                            if (table == newTable) continue;
                            int cColumns = table.getColumnCount();
                            ColumnList existingColumns = table.getColumns();
                            for (int columnIndex = 0; columnIndex < cColumns; ++columnIndex) {
                                Column existingColumn = existingColumns.elementAt(columnIndex);
                                if (!this.getSqlLogic().identifierEquals(existingColumn.getName(), newColumn.getName()) || existingColumn.getSqlType() != newColumn.getSqlType()) continue;
                                returnValue = new JoinRelationship((Query)this, existingColumn, newColumn);
                                returnList.addElement(returnValue);
                            }
                        }
                    }
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return returnList;
    }

    protected void addTablesFromClassifierSources(AssociationList classifierSources, List columnList) throws MdException, RemoteException {
        this.m_hasSamePhysicalTable = false;
        this.m_vQualifiedNames = new Vector();
        for (int i = 0; classifierSources != null && i < classifierSources.size(); ++i) {
            WAdminDataSource wads;
            DataSourceTable wadsTable;
            DataTable table = (DataTable)classifierSources.elementAt(i);
            ParametersModel paraModel = new ParametersModel((Root)table);
            if (paraModel.isParameterizedObject()) {
                if (this.m_bCodegen) {
                    throw new CodegenException(this.bundle.messageString("WAQuery.ParameterTableError.txt", (Object)table.getName()));
                }
                MessageUtil.displayMessage((String)this.bundle.messageString("WAQuery.ParameterTableError.txt", (Object)table.getName()), (int)0);
            }
            if (!this.m_quote) {
                this.m_quote = DBMSNamesPropertyHandler.needQuotes((DataTable)table);
            }
            if ((wadsTable = (wads = (WAdminDataSource)this.m_dataSource).getTable(table)) != null) continue;
            wads.addTable(table);
            wadsTable = wads.getTable(table);
            if (wadsTable != null) {
                String strQualifiedName = wadsTable.getQualifiedName();
                int currSize = this.m_vQualifiedNames.size();
                if (currSize == 0) {
                    this.m_vQualifiedNames.add(strQualifiedName);
                } else {
                    boolean found = false;
                    for (int k = 0; k < currSize; ++k) {
                        String test = (String)this.m_vQualifiedNames.get(k);
                        if (!test.equals(strQualifiedName)) continue;
                        found = true;
                    }
                    if (!found) {
                        this.m_vQualifiedNames.add(strQualifiedName);
                    }
                }
                Workspace.getDefaultLogger().debug((Object)("Added table <" + wadsTable.getName() + "> to DataSource"));
                OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)table, false);
                Property options = OP.getSpecificProperty("AdditionalOptions");
                if (options != null) {
                    wadsTable.setTableOptions(options.getDefaultValue());
                }
            } else {
                Workspace.getDefaultLogger().debug((Object)("Could not add table " + table.getName()));
            }
            AssociationList colList = table.getColumns();
            for (int j = 0; j < colList.size(); ++j) {
                com.sas.metadata.remote.Column mCol = (com.sas.metadata.remote.Column)colList.elementAt(j);
                columnList.add(mCol);
            }
        }
        if (this.getTableCount() > this.m_vQualifiedNames.size()) {
            this.m_hasSamePhysicalTable = true;
        }
    }

    public ResultItem addResultItem(Column columnToAdd) {
        ColumnExpression columnExpression = new ColumnExpression(columnToAdd);
        ResultItem resultItem = new ResultItem((Query)this, (Expression)columnExpression);
        String uniqueName = this.getUniqueResultName(columnToAdd.getName());
        resultItem.setAlias(uniqueName);
        this.addResultItem(resultItem);
        return resultItem;
    }

    public ResultItem addResultItem(Column columnToAdd, int position) {
        ColumnExpression columnExpression = new ColumnExpression(columnToAdd);
        ResultItem resultItem = new ResultItem((Query)this, (Expression)columnExpression);
        String uniqueName = this.getUniqueResultName(columnToAdd.getName());
        resultItem.setAlias(uniqueName);
        this.addResultItem(resultItem, position);
        return resultItem;
    }

    public void cleanUp() {
        this.m_messageHandler = null;
    }
}

