/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.Expression;
import com.sas.query.models.Join;
import com.sas.query.models.JoinList;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.Parser;
import com.sas.query.visuals.JoinPropertyView;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.WindowUtil;
import com.sas.query.wa.WAQuery;
import com.sas.query.wa.WAdminSqlLogic;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class WAJoinPropertyView
extends JoinPropertyView {
    protected ArrayList m_alTables = new ArrayList();
    protected ArrayList m_alColumns = new ArrayList();
    private static WAdminResource bundle2 = WAdminResource.getBundle(WAJoinPropertyView.class);
    private Table m_temp_leftTable;
    private Table m_temp_rightTable;

    public WAJoinPropertyView(Query query, JoinList joinList, JoinRelationshipList joinRelationshipList) {
        super(query, joinList, joinRelationshipList);
    }

    public void onEditJoinRelationship() {
        JoinRelationship selectedRelationship = null;
        if (this.m_relationshipList != null) {
            selectedRelationship = (JoinRelationship)this.m_relationshipList.getSelectedValue();
        }
        if (selectedRelationship == null) {
            return;
        }
        this.addQueryTablesToMetadataTableList();
        Expression expr = selectedRelationship.getComparisonDetails();
        this.m_alColumns.clear();
        ColumnList colList = expr.getReferencedColumns();
        if (colList != null) {
            for (int c = 0; c < colList.size(); ++c) {
                Column col = colList.elementAt(c);
                this.m_alColumns.add(this.getMetadataColumn(col));
            }
        }
        this.busyOn();
        ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(this.m_alColumns, this.m_alTables, true);
        tabExpressionBuilder.setExpression(expr.generateSQL(this.m_query.getDataSource().getSqlLogic(this.getQuery()), 1));
        tabExpressionBuilder.setUseQuotes(((WAQuery)this.m_query).isQuotingRequired());
        tabExpressionBuilder.setColumnGroupNodeName(bundle2.getString("AdvancedJoinDialog.ExpColsNode.txt"));
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle2.getString("AdvancedJoinDialog.ExpBuilder.Title.txt"), true, (WAPanel)tabExpressionBuilder);
        dialog.setResizable(true);
        dialog.show();
        try {
            if (dialog.getReturnValue() == 1) {
                String strExpr = tabExpressionBuilder.getExpression();
                strExpr = this.updateColumnAliasInJoin(strExpr, this.m_temp_leftTable);
                strExpr = this.updateColumnAliasInJoin(strExpr, this.m_temp_rightTable);
                Parser parse = new Parser();
                Expression expression = parse.parseExpression(this.getQuery(), strExpr);
                selectedRelationship.setComparisonDetails(expression);
                this.firePropertyChange("joins", null, this.m_joinRelationshipList);
                this._setState();
            }
        }
        catch (Throwable t) {
            this.busyOff();
            this.addInternalError(t);
        }
        this.busyOff();
        this.m_expBuilder = null;
    }

    public void onInsert() {
        this.addQueryTablesToMetadataTableList();
        this.busyOn();
        SqlTextHelper helper = null;
        try {
            JTextField invisibleHolder = new JTextField();
            helper = new SqlTextHelper((JTextComponent)invisibleHolder);
            helper.setQuery(this.getQuery());
            helper.setExpression(this.m_query, (Expression)new UnparsedExpression(""));
            ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(this.m_alColumns, this.m_alTables, true);
            tabExpressionBuilder.setExpression(helper.getWidget().getText());
            tabExpressionBuilder.setUseQuotes(((WAQuery)this.m_query).isQuotingRequired());
            tabExpressionBuilder.setColumnGroupNodeName(bundle2.getString("AdvancedJoinDialog.ExpColsNode.txt"));
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle2.getString("AdvancedJoinDialog.ExpBuilder.Title.txt"), true, (WAPanel)tabExpressionBuilder);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1 && helper != null) {
                String strExpr = tabExpressionBuilder.getExpression();
                strExpr = this.updateColumnAliasInJoin(strExpr, this.m_temp_leftTable);
                strExpr = this.updateColumnAliasInJoin(strExpr, this.m_temp_rightTable);
                helper.getWidget().setText(strExpr);
                JoinRelationship jr = new JoinRelationship(this.m_query, this.m_temp_leftTable, this.m_temp_rightTable, 4, (Object)helper.getExpression());
                this.m_joinRelationshipList.addElement(jr);
                this.m_joinList.setAllRelationships(this.m_joinRelationshipList);
                this.m_joinList.groupJoinsFromList(this.m_joinRelationshipList);
                this.firePropertyChange("joins", null, this.m_joinRelationshipList);
                this._setState();
            }
        }
        catch (Throwable t) {
            this.busyOff();
            this.addInternalError(t);
        }
        this.busyOff();
    }

    public String updateColumnAliasInJoin(String expr, Table table) {
        String tblName = table.getName();
        String alias = table.getCorrelationName();
        if (alias == null) {
            return expr;
        }
        if (alias == tblName) {
            return expr;
        }
        tblName = ((WAdminSqlLogic)this.m_query.getSqlLogic()).genIdentifier(tblName) + ".";
        int startOfTableName = expr.indexOf(tblName);
        if (startOfTableName == -1) {
            return expr;
        }
        if (startOfTableName == 0) {
            String last = expr.substring(tblName.length() - 1);
            expr = alias + last;
        } else {
            String first = expr.substring(0, startOfTableName);
            String last = expr.substring(startOfTableName + tblName.length());
            expr = first + alias + "." + last;
        }
        return expr;
    }

    protected com.sas.metadata.remote.Column getMetadataColumn(Column col) {
        com.sas.metadata.remote.Column metaCol = (com.sas.metadata.remote.Column)((PhysicalColumn)col).getDataSourceColumn().getUnderlyingColumn();
        return metaCol;
    }

    public void addQueryTablesToMetadataTableList() {
        this.m_alTables.clear();
        TableList tblList = this.getQuery().getTables();
        for (int i = 0; i < tblList.size(); ++i) {
            Table table = tblList.elementAt(i);
            this.m_alTables.add(table.getDataSourceTable().getUnderlyingTable());
        }
    }

    protected void _setState() {
        this.m_leftTable.removeAll();
        this.m_rightTable.removeAll();
        if (this.m_join == null) {
            this._setEnableAll(false);
        } else {
            Join join;
            this._setEnableAll(true);
            JPanel tempPanel = new JPanel();
            tempPanel.setBackground(SystemColor.window);
            GridBagLayout layout = new GridBagLayout();
            tempPanel.setLayout(layout);
            int index = 0;
            while (this.m_joinList != null && index < this.m_joinList.size() && (join = this.m_joinList.elementAt(index)) != this.m_join) {
                JLabel label = new JLabel(join.getTable().getDisplayName());
                this.m_temp_leftTable = join.getTable();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = index++;
                gbc.weightx = 1.0;
                gbc.anchor = 10;
                gbc.insets = new Insets(1, 4, 1, 4);
                gbc.fill = 2;
                tempPanel.setBackground(this.m_greenColor);
                layout.setConstraints(label, gbc);
                tempPanel.add(label);
            }
            JScrollPane scrollPane = new JScrollPane(tempPanel);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.m_leftTable.add(scrollPane);
            JLabel rightName = new JLabel(this.m_join.getTable().getDisplayName());
            this.m_temp_rightTable = this.m_join.getTable();
            JPanel anotherDummy = new JPanel();
            GridBagLayout dummylayout = new GridBagLayout();
            anotherDummy.setLayout(dummylayout);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.insets = new Insets(1, 4, 1, 4);
            gbc.fill = 2;
            tempPanel.setBackground(this.m_greenColor);
            dummylayout.setConstraints(rightName, gbc);
            anotherDummy.add(rightName);
            JScrollPane rightscrollPane = new JScrollPane(anotherDummy);
            rightscrollPane.setBorder(BorderFactory.createEmptyBorder());
            anotherDummy.setBackground(this.m_greenColor);
            this.m_rightTable.add("Center", rightscrollPane);
            this.m_previewPanel.doLayout();
            this.m_leftTable.validate();
            this.m_rightTable.validate();
            this.m_previewPanel.repaint();
            JoinRelationshipList relationships = this.m_join.getRelationships();
            Vector<JoinRelationship> vector = new Vector<JoinRelationship>();
            if (this.m_joinRelationshipList != null && relationships != null) {
                for (int index2 = 0; index2 < relationships.size(); ++index2) {
                    JoinRelationship relationship = relationships.elementAt(index2);
                    vector.addElement(relationship);
                }
            }
            this.m_relationshipList.setListData(vector);
            this.m_innerButton.setSelected(false);
            this.m_leftButton.setSelected(false);
            this.m_rightButton.setSelected(false);
            this.m_fullButton.setSelected(false);
            if (vector.isEmpty()) {
                this.m_bRelationshipExists = false;
                WindowUtil.setDeepEnabled((Component)this.m_typePanel, (boolean)false);
            } else {
                if (this.m_join.getJoinType() == 0) {
                    this.m_innerButton.setSelected(true);
                } else if (this.m_join.getJoinType() == 1) {
                    this.m_leftButton.setSelected(true);
                } else if (this.m_join.getJoinType() == 2) {
                    this.m_rightButton.setSelected(true);
                } else if (this.m_join.getJoinType() == 3) {
                    this.m_fullButton.setSelected(true);
                }
                this.m_bRelationshipExists = true;
                WindowUtil.setDeepEnabled((Component)this.m_typePanel, (boolean)true);
            }
        }
        this.enableRelationshipButtons();
    }

    private void enableRelationshipButtons() {
        boolean canInsert;
        boolean bEnabled = this.m_relationshipList.getSelectedIndex() > -1;
        this.m_editButton.setEnabled(bEnabled);
        this.m_deleteButton.setEnabled(bEnabled);
        boolean bl = canInsert = this.m_join != null;
        if (canInsert) {
            if (this.m_join.getJoinType() == 4) {
                canInsert = false;
            }
            if (this.m_join.getJoinType() == 5) {
                canInsert = false;
            }
        }
        this.m_insertButton.setEnabled(canInsert);
    }
}

